/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.image;

import com.jhlabs.image.PointFilter;
import java.awt.image.BufferedImage;

public class TemperatureFilter
extends PointFilter {
    private float temperature = 6650.0f;
    private float rFactor;
    private float gFactor;
    private float bFactor;
    static float[] blackBodyRGB = new float[]{1.0f, 0.0337f, 0.0f, 1.0f, 0.0592f, 0.0f, 1.0f, 0.0846f, 0.0f, 1.0f, 0.1096f, 0.0f, 1.0f, 0.1341f, 0.0f, 1.0f, 0.1578f, 0.0f, 1.0f, 0.1806f, 0.0f, 1.0f, 0.2025f, 0.0f, 1.0f, 0.2235f, 0.0f, 1.0f, 0.2434f, 0.0f, 1.0f, 0.2647f, 0.0033f, 1.0f, 0.2889f, 0.012f, 1.0f, 0.3126f, 0.0219f, 1.0f, 0.336f, 0.0331f, 1.0f, 0.3589f, 0.0454f, 1.0f, 0.3814f, 0.0588f, 1.0f, 0.4034f, 0.0734f, 1.0f, 0.425f, 0.0889f, 1.0f, 0.4461f, 0.1054f, 1.0f, 0.4668f, 0.1229f, 1.0f, 0.487f, 0.1411f, 1.0f, 0.5067f, 0.1602f, 1.0f, 0.5259f, 0.18f, 1.0f, 0.5447f, 0.2005f, 1.0f, 0.563f, 0.2216f, 1.0f, 0.5809f, 0.2433f, 1.0f, 0.5983f, 0.2655f, 1.0f, 0.6153f, 0.2881f, 1.0f, 0.6318f, 0.3112f, 1.0f, 0.648f, 0.3346f, 1.0f, 0.6636f, 0.3583f, 1.0f, 0.6789f, 0.3823f, 1.0f, 0.6938f, 0.4066f, 1.0f, 0.7083f, 0.431f, 1.0f, 0.7223f, 0.4556f, 1.0f, 0.736f, 0.4803f, 1.0f, 0.7494f, 0.5051f, 1.0f, 0.7623f, 0.5299f, 1.0f, 0.775f, 0.5548f, 1.0f, 0.7872f, 0.5797f, 1.0f, 0.7992f, 0.6045f, 1.0f, 0.8108f, 0.6293f, 1.0f, 0.8221f, 0.6541f, 1.0f, 0.833f, 0.6787f, 1.0f, 0.8437f, 0.7032f, 1.0f, 0.8541f, 0.7277f, 1.0f, 0.8642f, 0.7519f, 1.0f, 0.874f, 0.776f, 1.0f, 0.8836f, 0.8f, 1.0f, 0.8929f, 0.8238f, 1.0f, 0.9019f, 0.8473f, 1.0f, 0.9107f, 0.8707f, 1.0f, 0.9193f, 0.8939f, 1.0f, 0.9276f, 0.9168f, 1.0f, 0.9357f, 0.9396f, 1.0f, 0.9436f, 0.9621f, 1.0f, 0.9513f, 0.9844f, 0.9937f, 0.9526f, 1.0f, 0.9726f, 0.9395f, 1.0f, 0.9526f, 0.927f, 1.0f, 0.9337f, 0.915f, 1.0f, 0.9157f, 0.9035f, 1.0f, 0.8986f, 0.8925f, 1.0f, 0.8823f, 0.8819f, 1.0f, 0.8668f, 0.8718f, 1.0f, 0.852f, 0.8621f, 1.0f, 0.8379f, 0.8527f, 1.0f, 0.8244f, 0.8437f, 1.0f, 0.8115f, 0.8351f, 1.0f, 0.7992f, 0.8268f, 1.0f, 0.7874f, 0.8187f, 1.0f, 0.7761f, 0.811f, 1.0f, 0.7652f, 0.8035f, 1.0f, 0.7548f, 0.7963f, 1.0f, 0.7449f, 0.7894f, 1.0f, 0.7353f, 0.7827f, 1.0f, 0.726f, 0.7762f, 1.0f, 0.7172f, 0.7699f, 1.0f, 0.7086f, 0.7638f, 1.0f, 0.7004f, 0.7579f, 1.0f, 0.6925f, 0.7522f, 1.0f, 0.6848f, 0.7467f, 1.0f, 0.6774f, 0.7414f, 1.0f, 0.6703f, 0.7362f, 1.0f, 0.6635f, 0.7311f, 1.0f, 0.6568f, 0.7263f, 1.0f, 0.6504f, 0.7215f, 1.0f, 0.6442f, 0.7169f, 1.0f, 0.6382f, 0.7124f, 1.0f, 0.6324f, 0.7081f, 1.0f, 0.6268f, 0.7039f, 1.0f};

    public TemperatureFilter() {
        this.canFilterIndexColorModel = true;
    }

    public void setTemperature(float temperature) {
        this.temperature = temperature;
    }

    public float getTemperature() {
        return this.temperature;
    }

    public BufferedImage filter(BufferedImage src, BufferedImage dst) {
        this.temperature = Math.max(1000.0f, Math.min(10000.0f, this.temperature));
        int t = 3 * (int)((this.temperature - 1000.0f) / 100.0f);
        this.rFactor = 1.0f / blackBodyRGB[t];
        this.gFactor = 1.0f / blackBodyRGB[t + 1];
        this.bFactor = 1.0f / blackBodyRGB[t + 2];
        float m = Math.max(Math.max(this.rFactor, this.gFactor), this.bFactor);
        this.rFactor /= m;
        this.gFactor /= m;
        this.bFactor /= m;
        return super.filter(src, dst);
    }

    public void setTemperatureFromRGB(int rgb) {
        float r = rgb >> 16 & 0xFF;
        float g = rgb >> 8 & 0xFF;
        float b = rgb & 0xFF;
        float rb = r / b;
        int start = 0;
        int end = blackBodyRGB.length / 3;
        int m = (start + end) / 2;
        start = 0;
        r = blackBodyRGB.length;
        m = (start + end) / 2;
        while (end - start > 1) {
            int m3 = m * 3;
            if (blackBodyRGB[m3] / blackBodyRGB[m3 + 2] > rb) {
                start = m;
            } else {
                end = m;
            }
            m = (start + end) / 2;
        }
        this.setTemperature((float)m * 100.0f + 1000.0f);
    }

    public int filterRGB(int x, int y, int rgb) {
        int a = rgb & 0xFF000000;
        int r = rgb >> 16 & 0xFF;
        int g = rgb >> 8 & 0xFF;
        int b = rgb & 0xFF;
        r = (int)((float)r * this.rFactor);
        g = (int)((float)g * this.gFactor);
        b = (int)((float)b * this.bFactor);
        return a | r << 16 | g << 8 | b;
    }

    public String toString() {
        return "Colors/Temperature...";
    }
}

