/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common;

import bibliothek.extension.gui.dock.preference.PreferenceModel;
import bibliothek.extension.gui.dock.preference.PreferenceStorage;
import bibliothek.extension.gui.dock.theme.BubbleTheme;
import bibliothek.extension.gui.dock.theme.EclipseTheme;
import bibliothek.extension.gui.dock.theme.FlatTheme;
import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.DockTheme;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DockElement;
import bibliothek.gui.dock.DockFactory;
import bibliothek.gui.dock.FlapDockStation;
import bibliothek.gui.dock.ScreenDockStation;
import bibliothek.gui.dock.SplitDockStation;
import bibliothek.gui.dock.action.DockAction;
import bibliothek.gui.dock.common.CContentArea;
import bibliothek.gui.dock.common.CControlRegister;
import bibliothek.gui.dock.common.CExternalizeArea;
import bibliothek.gui.dock.common.CFocusHistory;
import bibliothek.gui.dock.common.CGridArea;
import bibliothek.gui.dock.common.CLocation;
import bibliothek.gui.dock.common.CMinimizeArea;
import bibliothek.gui.dock.common.CStation;
import bibliothek.gui.dock.common.CStationContainer;
import bibliothek.gui.dock.common.CWorkingArea;
import bibliothek.gui.dock.common.DefaultCFocusHistory;
import bibliothek.gui.dock.common.DestroyHook;
import bibliothek.gui.dock.common.MissingCDockableStrategy;
import bibliothek.gui.dock.common.MultipleCDockable;
import bibliothek.gui.dock.common.MultipleCDockableFactory;
import bibliothek.gui.dock.common.NullMultipleCDockableFactory;
import bibliothek.gui.dock.common.SingleCDockable;
import bibliothek.gui.dock.common.SingleCDockableFactory;
import bibliothek.gui.dock.common.action.CloseActionFactory;
import bibliothek.gui.dock.common.action.util.CDefaultDockActionDistributor;
import bibliothek.gui.dock.common.event.CControlListener;
import bibliothek.gui.dock.common.event.CDockableAdapter;
import bibliothek.gui.dock.common.event.CDockablePropertyListener;
import bibliothek.gui.dock.common.event.CDockableStateListener;
import bibliothek.gui.dock.common.event.CDoubleClickListener;
import bibliothek.gui.dock.common.event.CFocusListener;
import bibliothek.gui.dock.common.event.CKeyboardListener;
import bibliothek.gui.dock.common.event.CVetoClosingListener;
import bibliothek.gui.dock.common.event.CVetoFocusListener;
import bibliothek.gui.dock.common.event.ResizeRequestListener;
import bibliothek.gui.dock.common.group.CGroupBehavior;
import bibliothek.gui.dock.common.grouping.CGroupingBehavior;
import bibliothek.gui.dock.common.grouping.DefaultCGroupingBehavior;
import bibliothek.gui.dock.common.grouping.DockableGrouping;
import bibliothek.gui.dock.common.grouping.GroupingDockLocationListener;
import bibliothek.gui.dock.common.grouping.GroupingHistoryRewriter;
import bibliothek.gui.dock.common.intern.CControlAccess;
import bibliothek.gui.dock.common.intern.CControlFactory;
import bibliothek.gui.dock.common.intern.CDockFrontend;
import bibliothek.gui.dock.common.intern.CDockable;
import bibliothek.gui.dock.common.intern.CDockableAccess;
import bibliothek.gui.dock.common.intern.CListenerCollection;
import bibliothek.gui.dock.common.intern.CPlaceholderStrategy;
import bibliothek.gui.dock.common.intern.CancelDragAndDropOperation;
import bibliothek.gui.dock.common.intern.CommonDockable;
import bibliothek.gui.dock.common.intern.CommonMultipleDockableFactory;
import bibliothek.gui.dock.common.intern.CommonMultipleDockableLayout;
import bibliothek.gui.dock.common.intern.CommonSingleDockableFactory;
import bibliothek.gui.dock.common.intern.ControlVetoClosingListener;
import bibliothek.gui.dock.common.intern.ControlVetoFocusListener;
import bibliothek.gui.dock.common.intern.EfficientControlFactory;
import bibliothek.gui.dock.common.intern.MutableCControlRegister;
import bibliothek.gui.dock.common.intern.action.CActionImportanceOrder;
import bibliothek.gui.dock.common.intern.action.CActionOffer;
import bibliothek.gui.dock.common.intern.action.CButtonContentFilter;
import bibliothek.gui.dock.common.intern.station.CFlapLayoutManager;
import bibliothek.gui.dock.common.intern.station.CLockedResizeLayoutManager;
import bibliothek.gui.dock.common.intern.station.CScreenDockStationWindowClosingStrategy;
import bibliothek.gui.dock.common.intern.station.CommonDockStation;
import bibliothek.gui.dock.common.intern.station.CommonDockStationFactory;
import bibliothek.gui.dock.common.intern.ui.CDisablingStrategy;
import bibliothek.gui.dock.common.intern.ui.CSingleParentRemover;
import bibliothek.gui.dock.common.intern.ui.CommonSingleTabDecider;
import bibliothek.gui.dock.common.intern.ui.ExtendedModeAcceptance;
import bibliothek.gui.dock.common.intern.ui.StackableAcceptance;
import bibliothek.gui.dock.common.intern.ui.WorkingAreaAcceptance;
import bibliothek.gui.dock.common.layout.RequestDimension;
import bibliothek.gui.dock.common.mode.CLocationMode;
import bibliothek.gui.dock.common.mode.CLocationModeManager;
import bibliothek.gui.dock.common.mode.CMaximizedMode;
import bibliothek.gui.dock.common.mode.CMaximizedModeArea;
import bibliothek.gui.dock.common.mode.CStationContainerHistoryRewriter;
import bibliothek.gui.dock.common.mode.ExtendedMode;
import bibliothek.gui.dock.common.perspective.CControlPerspective;
import bibliothek.gui.dock.common.perspective.CDockablePerspective;
import bibliothek.gui.dock.common.perspective.CStackPerspective;
import bibliothek.gui.dock.common.perspective.CStationPerspective;
import bibliothek.gui.dock.common.perspective.CommonElementPerspective;
import bibliothek.gui.dock.common.perspective.DefaultMissingPerspectiveFactory;
import bibliothek.gui.dock.common.perspective.MissingPerspectiveStrategy;
import bibliothek.gui.dock.common.theme.ThemeMap;
import bibliothek.gui.dock.common.theme.eclipse.CommonEclipseThemeConnector;
import bibliothek.gui.dock.control.DockRegister;
import bibliothek.gui.dock.control.focus.DefaultFocusStrategy;
import bibliothek.gui.dock.control.focus.FocusStrategyRequest;
import bibliothek.gui.dock.disable.DisablingStrategy;
import bibliothek.gui.dock.displayer.SingleTabDecider;
import bibliothek.gui.dock.event.DockRegisterAdapter;
import bibliothek.gui.dock.event.DockableFocusEvent;
import bibliothek.gui.dock.event.DockableFocusListener;
import bibliothek.gui.dock.event.DoubleClickListener;
import bibliothek.gui.dock.event.KeyboardListener;
import bibliothek.gui.dock.facile.station.split.ConflictResolver;
import bibliothek.gui.dock.facile.station.split.DefaultConflictResolver;
import bibliothek.gui.dock.frontend.FrontendEntry;
import bibliothek.gui.dock.frontend.MissingDockableStrategy;
import bibliothek.gui.dock.layout.DockSituationIgnore;
import bibliothek.gui.dock.layout.DockableProperty;
import bibliothek.gui.dock.perspective.PerspectiveDockable;
import bibliothek.gui.dock.perspective.PerspectiveElement;
import bibliothek.gui.dock.perspective.PerspectiveStation;
import bibliothek.gui.dock.station.stack.StackDockPerspective;
import bibliothek.gui.dock.station.stack.StackDockStationFactory;
import bibliothek.gui.dock.station.stack.StackDockStationLayout;
import bibliothek.gui.dock.station.support.PlaceholderStrategy;
import bibliothek.gui.dock.support.util.ApplicationResource;
import bibliothek.gui.dock.support.util.ApplicationResourceManager;
import bibliothek.gui.dock.themes.basic.action.DockActionImportanceOrder;
import bibliothek.gui.dock.util.DirectWindowProvider;
import bibliothek.gui.dock.util.IconManager;
import bibliothek.gui.dock.util.NullWindowProvider;
import bibliothek.gui.dock.util.Priority;
import bibliothek.gui.dock.util.PropertyKey;
import bibliothek.gui.dock.util.WindowProvider;
import bibliothek.gui.dock.util.extension.Extension;
import bibliothek.gui.dock.util.extension.ExtensionManager;
import bibliothek.gui.dock.util.extension.ExtensionName;
import bibliothek.gui.dock.util.icon.DefaultIconScheme;
import bibliothek.gui.dock.util.property.ConstantPropertyFactory;
import bibliothek.gui.dock.util.text.DefaultTextScheme;
import bibliothek.util.Filter;
import bibliothek.util.Path;
import bibliothek.util.Version;
import bibliothek.util.xml.XElement;
import bibliothek.util.xml.XIO;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.JFrame;
import javax.swing.KeyStroke;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CControl {
    public static final PropertyKey<CControl> CCONTROL = new PropertyKey("ccontrol");
    public static final Path CCONTROL_EXTENSION = new Path("dock.ccontrol");
    public static final String EXTENSION_PARAM = "control";
    public static final PropertyKey<KeyStroke> KEY_MAXIMIZE_CHANGE = new PropertyKey("ccontrol.maximize_change");
    public static final PropertyKey<KeyStroke> KEY_GOTO_MAXIMIZED = new PropertyKey("ccontrol.goto_maximized");
    public static final PropertyKey<KeyStroke> KEY_GOTO_NORMALIZED = new PropertyKey("ccontrol.goto_normalized");
    public static final PropertyKey<KeyStroke> KEY_GOTO_MINIMIZED = new PropertyKey("ccontrol.goto_minimized");
    public static final PropertyKey<KeyStroke> KEY_GOTO_EXTERNALIZED = new PropertyKey("ccontrol.goto_externalized");
    public static final PropertyKey<KeyStroke> KEY_CLOSE = new PropertyKey("ccontrol.close");
    public static final PropertyKey<KeyStroke> KEY_CANCEL_OPERATION = new PropertyKey("ccontrol.cancel_dnd");
    public static final PropertyKey<ConflictResolver<RequestDimension>> RESIZE_LOCK_CONFLICT_RESOLVER = new PropertyKey("ccontrol.resize_lock_conflict_resolver", new ConstantPropertyFactory(new DefaultConflictResolver()), true);
    public static final PropertyKey<CloseActionFactory> CLOSE_ACTION_FACTORY = new PropertyKey<CloseActionFactory>("ccontrol.closeActionFactory", new ConstantPropertyFactory<CloseActionFactory>(CloseActionFactory.DEFAULT), true);
    public static final PropertyKey<CGroupingBehavior> GROUPING_BEHAVIOR = new PropertyKey<DefaultCGroupingBehavior>("ccontrol.groupingBehavior", new ConstantPropertyFactory<DefaultCGroupingBehavior>(new DefaultCGroupingBehavior()), true);
    public static final String EXTERNALIZED_STATION_ID = "external";
    public static final String CONTENT_AREA_STATIONS_ID = "ccontrol";
    private CDockFrontend frontend;
    private MissingCDockableStrategy missingStrategy = MissingCDockableStrategy.PURGE;
    private Map<CDockable, CDockableAccess> accesses = new HashMap<CDockable, CDockableAccess>();
    private CLocationModeManager locationManager;
    private CLocation defaultLocation;
    private ThemeMap themes;
    private CControlAccess access = new Access();
    private MissingPerspectiveStrategy missingPerspectiveStrategy = new DefaultMissingPerspectiveFactory();
    private ApplicationResourceManager resources = new ApplicationResourceManager();
    private List<DestroyHook> hooks = new ArrayList<DestroyHook>();
    private CControlFactory factory;
    private MutableCControlRegister register;
    private List<CControlListener> listeners = new ArrayList<CControlListener>();
    private List<ResizeRequestListener> resizeListeners = new ArrayList<ResizeRequestListener>();
    private CListenerCollection listenerCollection = new CListenerCollection();
    private PreferenceStorage preferences = new PreferenceStorage();
    private PreferenceModel preferenceModel;
    private boolean transferFocusOnMinimize = true;

    public CControl() {
        this(new NullWindowProvider());
    }

    public CControl(JFrame frame) {
        this(frame == null ? new NullWindowProvider() : new DirectWindowProvider(frame));
    }

    @Deprecated
    public CControl(boolean restrictedEnvironment) {
        this(new NullWindowProvider());
        this.getController().setRestrictedEnvironment(restrictedEnvironment);
    }

    public CControl(WindowProvider window) {
        this(window, (CControlFactory)new EfficientControlFactory());
    }

    @Deprecated
    public CControl(JFrame frame, boolean restrictedEnvironment) {
        this(frame == null ? new NullWindowProvider() : new DirectWindowProvider(frame));
        this.getController().setRestrictedEnvironment(restrictedEnvironment);
    }

    @Deprecated
    public CControl(WindowProvider window, boolean restrictedEnvironment) {
        this(window);
        this.getController().setRestrictedEnvironment(restrictedEnvironment);
    }

    public CControl(JFrame frame, CControlFactory factory) {
        this(frame == null ? new NullWindowProvider() : new DirectWindowProvider(frame), factory);
    }

    public CControl(WindowProvider window, CControlFactory factory) {
        this(window, factory, true);
    }

    protected CControl(WindowProvider window, CControlFactory factory, boolean init) {
        if (init) {
            this.init(window, factory);
        }
    }

    protected void init(WindowProvider window, CControlFactory factory) {
        if (window == null) {
            throw new IllegalArgumentException("window must not be null, however its search method may return null");
        }
        this.factory = factory;
        this.register = factory.createRegister(this);
        DockController controller = factory.createController(this);
        controller.getProperties().set(CCONTROL, this, Priority.CLIENT);
        controller.getProperties().finalize(CCONTROL);
        controller.setSingleParentRemover(new CSingleParentRemover(this));
        this.initExtensions(controller);
        this.initFocusListeners(controller);
        this.initInputListener(controller);
        this.initTransferFocusOnMinimize(controller);
        this.frontend = factory.createFrontend(this.access, controller);
        this.frontend.setOwner(window);
        this.frontend.setMissingDockableStrategy(new MissingDockableStrategy(){

            @Override
            public boolean shouldStoreHidden(String key) {
                return CControl.this.shouldStore(key);
            }

            @Override
            public boolean shouldStoreShown(String key) {
                return CControl.this.shouldStore(key);
            }

            @Override
            public <L> boolean shouldCreate(DockFactory<?, ?, L> factory, L data) {
                if (factory instanceof CommonMultipleDockableFactory && data instanceof CommonMultipleDockableLayout) {
                    return CControl.this.shouldCreate(((CommonMultipleDockableFactory)factory).getFactory(), (CommonMultipleDockableLayout)data);
                }
                return false;
            }
        });
        this.setIgnoreWorkingForEntry(true);
        this.frontend.setShowHideAction(false);
        this.frontend.getController().addActionOffer(new CActionOffer(this));
        this.frontend.getController().getRegister().addDockRegisterListener(new DockRegisterAdapter(){

            public void dockableRegistered(DockController controller, Dockable dockable) {
                if (dockable instanceof CommonDockable) {
                    CDockable cdock = ((CommonDockable)dockable).getDockable();
                    CDockableAccess access = (CDockableAccess)CControl.this.accesses.get(cdock);
                    if (access != null) {
                        access.informVisibility(true);
                    }
                    for (CControlListener listener : CControl.this.listeners()) {
                        listener.opened(CControl.this, cdock);
                    }
                }
            }

            public void dockableUnregistered(DockController controller, Dockable dockable) {
                if (dockable instanceof CommonDockable) {
                    MultipleCDockable multiple;
                    CDockable cdock = ((CommonDockable)dockable).getDockable();
                    CDockableAccess access = (CDockableAccess)CControl.this.accesses.get(cdock);
                    if (access != null) {
                        access.informVisibility(false);
                    }
                    for (CControlListener listener : CControl.this.listeners()) {
                        listener.closed(CControl.this, cdock);
                    }
                    if (cdock instanceof MultipleCDockable && (multiple = (MultipleCDockable)cdock).isRemoveOnClose()) {
                        CControl.this.removeDockable(multiple);
                    }
                }
            }
        });
        this.frontend.getController().getFocusController().addVetoListener(new ControlVetoFocusListener(this, this.listenerCollection.getVetoFocusListener()));
        this.frontend.getController().getFocusController().setStrategy(new DefaultFocusStrategy(this.frontend.getController()){

            public Component getFocusComponent(FocusStrategyRequest request) {
                Component result;
                Component mouseClicked = request.getMouseClicked();
                Dockable dockable = request.getDockable();
                if (mouseClicked != null && (mouseClicked.isFocusable() && !this.excluded(mouseClicked, request) || this.focusable(mouseClicked, request))) {
                    return mouseClicked;
                }
                if (dockable instanceof CommonDockable && (result = ((CommonDockable)dockable).getDockable().getFocusComponent()) != null) {
                    return result;
                }
                return super.getFocusComponent(request);
            }
        });
        this.frontend.addVetoableListener(new ControlVetoClosingListener(this, this.listenerCollection.getVetoClosingListener()));
        this.frontend.getController().addAcceptance(new StackableAcceptance());
        this.frontend.getController().addAcceptance(new WorkingAreaAcceptance(this.access));
        this.frontend.getController().addAcceptance(new ExtendedModeAcceptance(this.access));
        this.initFactories();
        this.themes = new ThemeMap(this);
        this.initPersistentStorage();
        this.initExtendedModes();
        this.initProperties();
        this.initIcons();
        this.initTexts();
        this.setTheme("smooth");
        controller.getExtensions().load(new ExtensionName<Object>(CCONTROL_EXTENSION, Object.class, EXTENSION_PARAM, this));
    }

    protected void initExtensions(DockController controller) {
        String[] list;
        ExtensionManager manager = controller.getExtensions();
        for (String className : list = new String[]{"glass.eclipse.CGlassExtension", "bibliothek.gui.dock.toolbar.CToolbarExtension"}) {
            try {
                Class<?> clazz = Class.forName(className);
                Object extension = clazz.newInstance();
                if (!(extension instanceof Extension)) continue;
                manager.add((Extension)extension);
            }
            catch (ClassNotFoundException clazz) {
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
    }

    private void initFocusListeners(DockController controller) {
        controller.addDockableFocusListener(new DockableFocusListener(){

            public void dockableFocused(DockableFocusEvent event) {
                CDockableAccess access;
                Dockable oldFocused = event.getOldFocusOwner();
                Dockable newFocused = event.getNewFocusOwner();
                if (oldFocused instanceof CommonDockable) {
                    CDockable oldC = ((CommonDockable)oldFocused).getDockable();
                    access = (CDockableAccess)CControl.this.accesses.get(oldC);
                    if (access != null) {
                        access.getFocusListener().focusLost(oldC);
                    }
                    CControl.this.listenerCollection.getFocusListener().focusLost(oldC);
                }
                if (newFocused instanceof CommonDockable) {
                    CDockable newC = ((CommonDockable)newFocused).getDockable();
                    access = (CDockableAccess)CControl.this.accesses.get(newC);
                    if (access != null) {
                        access.getFocusListener().focusGained(newC);
                    }
                    CControl.this.listenerCollection.getFocusListener().focusGained(newC);
                }
            }
        });
    }

    protected void initTransferFocusOnMinimize(DockController controller) {
        this.addStateListener(new CDockableAdapter(){

            public void extendedModeChanged(CDockable dockable, ExtendedMode mode) {
                if (CControl.this.transferFocusOnMinimize && mode == ExtendedMode.MINIMIZED) {
                    Dockable[] history = CControl.this.getController().getFocusHistory().getHistory();
                    for (int i = history.length - 1; i >= 0; --i) {
                        CDockable cdockable;
                        Dockable next = history[i];
                        if (!(next instanceof CommonDockable) || (cdockable = ((CommonDockable)next).getDockable()).getExtendedMode() == ExtendedMode.MINIMIZED) continue;
                        CControl.this.getController().setFocusedDockable(cdockable.intern(), true);
                        break;
                    }
                }
            }
        });
    }

    private void initInputListener(DockController controller) {
        controller.getKeyboardController().addListener(new KeyboardListener(){

            public boolean keyPressed(DockElement element, KeyEvent event) {
                if (element instanceof CommonDockable) {
                    CDockable source = ((CommonDockable)element).getDockable();
                    CDockableAccess access = (CDockableAccess)CControl.this.accesses.get(source);
                    if (access != null && access.getKeyboardListener().keyPressed(source, event)) {
                        return true;
                    }
                    return CControl.this.listenerCollection.getKeyboardListener().keyPressed(source, event);
                }
                return false;
            }

            public boolean keyReleased(DockElement element, KeyEvent event) {
                if (element instanceof CommonDockable) {
                    CDockable source = ((CommonDockable)element).getDockable();
                    CDockableAccess access = (CDockableAccess)CControl.this.accesses.get(source);
                    if (access != null && access.getKeyboardListener().keyReleased(source, event)) {
                        return true;
                    }
                    return CControl.this.listenerCollection.getKeyboardListener().keyReleased(source, event);
                }
                return false;
            }

            public boolean keyTyped(DockElement element, KeyEvent event) {
                if (element instanceof CommonDockable) {
                    CDockable source = ((CommonDockable)element).getDockable();
                    CDockableAccess access = (CDockableAccess)CControl.this.accesses.get(source);
                    if (access != null && access.getKeyboardListener().keyTyped(source, event)) {
                        return true;
                    }
                    return CControl.this.listenerCollection.getKeyboardListener().keyTyped(source, event);
                }
                return false;
            }

            public DockElement getTreeLocation() {
                return null;
            }
        });
        controller.getDoubleClickController().addListener(new DoubleClickListener(){

            public boolean process(Dockable dockable, MouseEvent event) {
                if (dockable instanceof CommonDockable) {
                    CDockable source = ((CommonDockable)dockable).getDockable();
                    CDockableAccess access = (CDockableAccess)CControl.this.accesses.get(source);
                    if (access != null && access.getDoubleClickListener().clicked(source, event)) {
                        return true;
                    }
                    return CControl.this.listenerCollection.getDoubleClickListener().clicked(source, event);
                }
                return false;
            }

            public DockElement getTreeLocation() {
                return null;
            }
        });
        this.addKeyboardListener(new CancelDragAndDropOperation(this));
    }

    private void initExtendedModes() {
        this.locationManager = new CLocationModeManager(this.access);
        CStationContainerHistoryRewriter validation = new CStationContainerHistoryRewriter(this);
        this.locationManager.setHistoryRewriter(new GroupingHistoryRewriter(this, validation));
        GroupingDockLocationListener groupingListener = new GroupingDockLocationListener(this);
        this.getController().getRegister().addDockRegisterListener(groupingListener);
        this.getController().addDockableFocusListener(groupingListener);
        this.initExternalizeArea();
    }

    protected void initExternalizeArea() {
        this.addStation(new CExternalizeArea(this, EXTERNALIZED_STATION_ID), true);
    }

    protected void initFactories() {
        CommonSingleDockableFactory backupFactory = this.register.getBackupFactory();
        this.frontend.registerFactory(backupFactory);
        this.frontend.registerBackupFactory(backupFactory);
        this.frontend.registerFactory(new StackDockStationFactory(){

            @Override
            public StackDockPerspective layoutPerspective(StackDockStationLayout layout, Map<Integer, PerspectiveDockable> children) {
                CStackPerspective stack = new CStackPerspective();
                this.layoutPerspective(stack, layout, children);
                return stack;
            }
        });
        CommonDockStationFactory stationFactory = new CommonDockStationFactory(this, null, backupFactory);
        this.frontend.registerFactory(stationFactory);
        this.frontend.registerBackupFactory(stationFactory);
    }

    protected void initProperties() {
        this.putProperty(KEY_MAXIMIZE_CHANGE, KeyStroke.getKeyStroke(77, 2));
        this.putProperty(KEY_GOTO_EXTERNALIZED, KeyStroke.getKeyStroke(69, 2));
        this.putProperty(KEY_GOTO_NORMALIZED, KeyStroke.getKeyStroke(78, 2));
        this.putProperty(KEY_CLOSE, KeyStroke.getKeyStroke(115, 2));
        this.putProperty(KEY_CANCEL_OPERATION, KeyStroke.getKeyStroke(27, 0));
        this.putProperty(SplitDockStation.LAYOUT_MANAGER, new CLockedResizeLayoutManager(this));
        this.putProperty(FlapDockStation.LAYOUT_MANAGER, new CFlapLayoutManager());
        this.putProperty(EclipseTheme.THEME_CONNECTOR, new CommonEclipseThemeConnector(this));
        this.putProperty(SingleTabDecider.SINGLE_TAB_DECIDER, new CommonSingleTabDecider(this));
        this.putProperty(PlaceholderStrategy.PLACEHOLDER_STRATEGY, new CPlaceholderStrategy(this));
        this.putProperty(BubbleTheme.ACTION_DISTRIBUTOR, new CDefaultDockActionDistributor());
        this.putProperty(FlatTheme.ACTION_DISTRIBUTOR, new CDefaultDockActionDistributor());
        this.putProperty(DockActionImportanceOrder.ORDER, new CActionImportanceOrder());
        this.putProperty(DockAction.BUTTON_CONTENT_FILTER, new CButtonContentFilter());
        this.putProperty(DisablingStrategy.STRATEGY, new CDisablingStrategy(this));
        this.putProperty(ScreenDockStation.WINDOW_CLOSING_STRATEGY, new CScreenDockStationWindowClosingStrategy());
    }

    protected void initIcons() {
        DefaultIconScheme scheme = new DefaultIconScheme(this.getController(), new DefaultIconScheme.IconResource("data/bibliothek/gui/dock/core/icons.ini", null, DockController.class.getClassLoader()), new DefaultIconScheme.IconResource("data/bibliothek/gui/dock/common/icons/icons.ini", null, CControl.class.getClassLoader()));
        scheme.link(PropertyKey.DOCKABLE_ICON, "dockable.default");
        scheme.link(PropertyKey.DOCK_STATION_ICON, "dockStation.default");
        this.getController().getIcons().setScheme(Priority.DEFAULT, scheme);
    }

    protected void initTexts() {
        this.initTexts(Locale.getDefault());
    }

    public void setLanguage(Locale locale) {
        this.initTexts(locale);
    }

    protected void initTexts(Locale locale) {
        ResourceBundle bundleCore = ResourceBundle.getBundle("data.bibliothek.gui.dock.core.locale.text", locale, DockController.class.getClassLoader());
        ResourceBundle bundleCommon = ResourceBundle.getBundle("data.bibliothek.gui.dock.common.locale.common", locale, CControl.class.getClassLoader());
        List<ResourceBundle> list = this.getController().getTexts().loadExtensionBundles(locale);
        ResourceBundle[] bundles = list.toArray(new ResourceBundle[list.size() + 2]);
        bundles[bundles.length - 2] = bundleCore;
        bundles[bundles.length - 1] = bundleCommon;
        this.getController().getTexts().setScheme(Priority.DEFAULT, new DefaultTextScheme(bundles));
    }

    protected void initPersistentStorage() {
        try {
            this.addMultipleDockableFactory("", NullMultipleCDockableFactory.NULL, false);
            this.resources.put("ccontrol.frontend", new ApplicationResource(){

                public void write(DataOutputStream out) throws IOException {
                    Version.write(out, Version.VERSION_1_1_1);
                    CControl.this.frontend.write(out);
                }

                public void read(DataInputStream in) throws IOException {
                    Version version = Version.read(in);
                    version.checkCurrent();
                    if (Version.VERSION_1_1_1.compareTo(version) > 0 && Version.VERSION_1_0_4.compareTo(version) <= 0) {
                        CControl.this.readWorkingAreas(in);
                    }
                    CControl.this.frontend.read(in);
                }

                public void writeXML(XElement element) {
                    CControl.this.frontend.writeXML(element.addElement("frontend"));
                }

                public void readXML(XElement element) {
                    CControl.this.frontend.readXML(element.getElement("frontend"));
                }
            });
            this.resources.put("ccontrol.preferences", new ApplicationResource(){

                public void read(DataInputStream in) throws IOException {
                    Version version = Version.read(in);
                    version.checkCurrent();
                    CControl.this.preferences.read(in);
                    if (CControl.this.preferenceModel != null) {
                        CControl.this.preferences.load(CControl.this.preferenceModel, false);
                        CControl.this.preferenceModel.write();
                    }
                }

                public void readXML(XElement element) {
                    CControl.this.preferences.readXML(element);
                    if (CControl.this.preferenceModel != null) {
                        CControl.this.preferences.load(CControl.this.preferenceModel, false);
                        CControl.this.preferenceModel.write();
                    }
                }

                public void write(DataOutputStream out) throws IOException {
                    if (CControl.this.preferenceModel != null) {
                        CControl.this.preferenceModel.read();
                        CControl.this.preferences.store(CControl.this.preferenceModel);
                    }
                    Version.write(out, Version.VERSION_1_0_6);
                    CControl.this.preferences.write(out);
                }

                public void writeXML(XElement element) {
                    if (CControl.this.preferenceModel != null) {
                        CControl.this.preferenceModel.read();
                        CControl.this.preferences.store(CControl.this.preferenceModel);
                    }
                    CControl.this.preferences.writeXML(element);
                }
            });
        }
        catch (IOException ex) {
            System.err.println("Non lethal IO-error:");
            ex.printStackTrace();
        }
    }

    public void addControlListener(CControlListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Listener must not be null");
        }
        this.listeners.add(listener);
    }

    public void removeControlListener(CControlListener listener) {
        this.listeners.remove(listener);
    }

    public void addFocusListener(CFocusListener listener) {
        this.listenerCollection.addFocusListener(listener);
    }

    public void removeFocusListener(CFocusListener listener) {
        this.listenerCollection.removeFocusListener(listener);
    }

    public CDockable getFocusedCDockable() {
        Dockable focused = this.getController().getFocusedDockable();
        if (focused instanceof CommonDockable) {
            return ((CommonDockable)focused).getDockable();
        }
        return null;
    }

    public CFocusHistory getFocusHistory() {
        return new DefaultCFocusHistory(this);
    }

    public void addVetoFocusListener(CVetoFocusListener listener) {
        this.listenerCollection.addVetoFocusListener(listener);
    }

    public void removeVetoFocusListener(CVetoFocusListener listener) {
        this.listenerCollection.removeVetoFocusListener(listener);
    }

    public void addStateListener(CDockableStateListener listener) {
        this.listenerCollection.addCDockableStateListener(listener);
    }

    public void removeStateListener(CDockableStateListener listener) {
        this.listenerCollection.removeCDockableStateListener(listener);
    }

    public void addPropertyListener(CDockablePropertyListener listener) {
        this.listenerCollection.addCDockablePropertyListener(listener);
    }

    public void removePropertyListener(CDockablePropertyListener listener) {
        this.listenerCollection.removeCDockablePropertyListener(listener);
    }

    public void addKeyboardListener(CKeyboardListener listener) {
        this.listenerCollection.addKeyboardListener(listener);
    }

    public void removeKeyboardListener(CKeyboardListener listener) {
        this.listenerCollection.removeKeyboardListener(listener);
    }

    public void addGlobalKeyListener(KeyListener listener) {
        this.intern().getController().getKeyboardController().addGlobalListener(listener);
    }

    public void removeGlobalKeyListener(KeyListener listener) {
        this.intern().getController().getKeyboardController().removeGlobalListener(listener);
    }

    public void addDoubleClickListener(CDoubleClickListener listener) {
        this.listenerCollection.addDoubleClickListener(listener);
    }

    public void removeDoubleClickListener(CDoubleClickListener listener) {
        this.listenerCollection.removeDoubleClickListener(listener);
    }

    public void addVetoClosingListener(CVetoClosingListener listener) {
        this.listenerCollection.addVetoClosingListener(listener);
    }

    public void removeVetoClosingListener(CVetoClosingListener listener) {
        this.listenerCollection.removeVetoClosingListener(listener);
    }

    private CControlListener[] listeners() {
        return this.listeners.toArray(new CControlListener[this.listeners.size()]);
    }

    public void setIgnoreWorkingForEntry(boolean ignore) {
        if (ignore) {
            this.frontend.setIgnoreForEntry(new DockSituationIgnore(){

                public boolean ignoreChildren(DockStation station) {
                    CStation<?> cstation = CControl.this.getStation(station);
                    if (cstation != null) {
                        return cstation.isWorkingArea();
                    }
                    return false;
                }

                public boolean ignoreChildren(PerspectiveStation station) {
                    CStationPerspective perspective;
                    if (station instanceof CommonElementPerspective && (perspective = ((CommonElementPerspective)((Object)station)).getElement().asStation()) != null) {
                        return perspective.isWorkingArea();
                    }
                    return false;
                }

                public boolean ignoreElement(DockElement element) {
                    CDockable cdockable;
                    return element instanceof CommonDockable && (cdockable = ((CommonDockable)element).getDockable()).getWorkingArea() != null;
                }

                public boolean ignoreElement(PerspectiveElement element) {
                    CDockablePerspective perspective;
                    if (element instanceof CommonElementPerspective && (perspective = ((CommonElementPerspective)element).getElement().asDockable()) != null) {
                        return perspective.getWorkingArea() != null;
                    }
                    return false;
                }
            });
        } else {
            this.frontend.setIgnoreForEntry(null);
        }
    }

    private void readWorkingAreas(DataInputStream in) throws IOException {
        int n = in.readInt();
        for (int i = 0; i < n; ++i) {
            in.readUTF();
            in.readUTF();
        }
    }

    public void destroy() {
        this.frontend.kill();
        for (DestroyHook hook : this.hooks) {
            hook.destroy();
        }
    }

    public CWorkingArea createWorkingArea(String uniqueId) {
        CWorkingArea area = new CWorkingArea(this, uniqueId);
        this.addDockable((MultipleCDockable)((Object)area));
        this.addStation(area, true);
        return area;
    }

    public CMinimizeArea createMinimizeArea(String uniqueId) {
        CMinimizeArea area = new CMinimizeArea(this, uniqueId);
        this.addStation(area, true);
        return area;
    }

    public CGridArea createGridArea(String uniqueId) {
        CGridArea area = new CGridArea(this, uniqueId);
        this.addStation(area, true);
        if (this.frontend.getDefaultStation() == null) {
            this.frontend.setDefaultStation(area.getStation());
        }
        return area;
    }

    public CContentArea createContentArea(String uniqueId) {
        return this.createContentArea(uniqueId, false);
    }

    private CContentArea createContentArea(String uniqueId, boolean isDefaultContentArea) {
        if (uniqueId == null) {
            throw new NullPointerException("uniqueId must not be null");
        }
        if (!isDefaultContentArea && uniqueId.equals(CONTENT_AREA_STATIONS_ID)) {
            throw new IllegalArgumentException("the unique identifier '" + uniqueId + "' is reserved for the default CContentArea and may not be used by the client");
        }
        CContentArea center = new CContentArea(this, uniqueId);
        if (isDefaultContentArea) {
            this.register.setDefaultContentArea(center);
        }
        this.addStationContainer(center);
        return center;
    }

    public void addStationContainer(CStationContainer container) {
        CStation<?> newDefaultStation;
        if (container == null) {
            throw new NullPointerException("container is null");
        }
        this.checkValidUniqueId(container.getUniqueId());
        DockStation defaultStation = this.frontend.getDefaultStation();
        boolean noDefaultStation = defaultStation == null || defaultStation instanceof ScreenDockStation;
        this.register.addStationContainer(container);
        if (noDefaultStation && (newDefaultStation = container.getDefaultStation()) != null) {
            this.frontend.setDefaultStation((DockStation)newDefaultStation.getStation());
        }
    }

    @Deprecated
    public void removeContentArea(CContentArea content) {
        this.removeStationContainer(content);
    }

    public void removeStationContainer(CStationContainer container) {
        if (container == null) {
            throw new NullPointerException("container must not be null");
        }
        if (this.register.getDefaultContentArea() == container) {
            throw new IllegalArgumentException("The default-contentarea can't be removed");
        }
        this.register.removeStationContainer(container);
    }

    public CControlRegister getRegister() {
        return this.register;
    }

    public List<CStationContainer> getStationContainers() {
        return this.register.getStationContainers();
    }

    public CControlFactory getFactory() {
        return this.factory;
    }

    public CLocationModeManager getLocationManager() {
        return this.locationManager;
    }

    public void addDestroyHook(DestroyHook hook) {
        if (hook == null) {
            throw new NullPointerException("hook must not be null");
        }
        this.hooks.add(hook);
    }

    public void removeDestroyHook(DestroyHook hook) {
        this.hooks.remove(hook);
    }

    public ApplicationResourceManager getResources() {
        return this.resources;
    }

    public <A> void putProperty(PropertyKey<A> key, A value) {
        this.putProperty(key, value, Priority.CLIENT);
    }

    protected <A> void putProperty(PropertyKey<A> key, A value, Priority priority) {
        this.frontend.getController().getProperties().set(key, value, priority);
    }

    public <A> A getProperty(PropertyKey<A> key) {
        return this.frontend.getController().getProperties().get(key);
    }

    public CContentArea getContentArea() {
        CContentArea content = this.register.getDefaultContentArea();
        if (content == null) {
            content = this.createContentArea(CONTENT_AREA_STATIONS_ID, true);
        }
        return content;
    }

    public void addStation(CStation<?> station) {
        this.addStation(station, true);
    }

    public void addStation(CStation<?> station, boolean root) {
        String id = station.getUniqueId();
        this.checkValidUniqueId(id);
        this.register.addStation(station);
        if (root) {
            this.frontend.addRoot(id, (DockStation)station.getStation());
        }
        station.setControlAccess(this.access);
    }

    public boolean isRootStation(CStation<?> station) {
        DockStation root = this.frontend.getRoot(station.getUniqueId());
        return root == station.getStation();
    }

    public void removeStation(CStation<?> station) {
        if (this.register.removeStation(station)) {
            this.frontend.removeRoot((DockStation)station.getStation());
            station.setControlAccess(null);
        }
    }

    public List<CStation<?>> getStations() {
        return this.register.getStations();
    }

    public CStation<?> getStation(DockStation intern) {
        if (intern instanceof CommonDockStation) {
            return ((CommonDockStation)intern).getStation();
        }
        return null;
    }

    public CStation<?> findStation(DockStation intern) {
        CStation<?> result = null;
        while (result == null && intern != null) {
            result = this.getStation(intern);
            Dockable dockable = intern.asDockable();
            if (dockable == null) {
                intern = null;
                continue;
            }
            intern = dockable.getDockParent();
        }
        return result;
    }

    public CStation<?> getStation(String id) {
        for (CStation<?> station : this.register.getStations()) {
            if (!station.getUniqueId().equals(id)) continue;
            return station;
        }
        return null;
    }

    public <S extends SingleCDockable> S addDockable(S dockable) {
        boolean alreadyKnown;
        if (dockable == null) {
            throw new NullPointerException("dockable must not be null");
        }
        this.checkValidUniqueId(dockable.getUniqueId());
        boolean bl = alreadyKnown = dockable.getControl() == this;
        if (dockable.getControl() != null && !alreadyKnown) {
            throw new IllegalArgumentException("dockable is already part of a control");
        }
        SingleCDockable preset = this.register.getSingleDockable(dockable.getUniqueId());
        if (preset != null) {
            if (preset == dockable) {
                return dockable;
            }
            throw new IllegalArgumentException("unique id '" + dockable.getUniqueId() + "' already in use for another SingleCDockable");
        }
        if (!alreadyKnown) {
            dockable.setControlAccess(this.access);
        }
        String id = this.register.toSingleId(dockable.getUniqueId());
        this.accesses.get(dockable).setUniqueId(id);
        this.frontend.addDockable(id, dockable.intern());
        this.frontend.setHideable(dockable.intern(), true);
        this.register.addSingleDockable(dockable);
        for (CControlListener listener : this.listeners()) {
            listener.added(this, dockable);
        }
        return dockable;
    }

    private void checkValidUniqueId(String id) {
        if (id == null) {
            throw new IllegalArgumentException("unique id is 'null'");
        }
        if (id.length() == 0) {
            throw new IllegalArgumentException("unique id has length of 0");
        }
        if (id.trim().length() == 0) {
            throw new IllegalArgumentException("unique id consists of whitespaces only");
        }
    }

    public SingleCDockable getSingleDockable(String id) {
        for (SingleCDockable dockable : this.register.getSingleDockables()) {
            if (!dockable.getUniqueId().equals(id)) continue;
            return dockable;
        }
        return null;
    }

    public boolean removeSingleDockable(String id) {
        for (SingleCDockable dockable : this.register.getSingleDockables()) {
            if (!dockable.getUniqueId().equals(id)) continue;
            return this.removeDockable(dockable);
        }
        return false;
    }

    public boolean removeDockable(SingleCDockable dockable) {
        if (dockable == null) {
            throw new NullPointerException("dockable must not be null");
        }
        if (dockable.getControl() == this) {
            dockable.setVisible(false);
            this.frontend.remove(dockable.intern());
            this.register.removeSingleDockable(dockable);
            dockable.setControlAccess(null);
            for (CControlListener listener : this.listeners()) {
                listener.removed(this, dockable);
            }
            return true;
        }
        return false;
    }

    public void addSingleDockableFactory(String id, SingleCDockableFactory backupFactory) {
        SingleCDockable dockable;
        this.register.getBackupFactory().add(id, backupFactory);
        String singleId = this.register.toSingleId(id);
        this.locationManager.addEmpty(singleId);
        this.frontend.addEmpty(singleId);
        FrontendEntry entry = this.frontend.getFrontendEntry(singleId);
        if (entry != null && entry.getDockable() == null && entry.isShown() && (dockable = backupFactory.createBackup(id)) != null) {
            this.addDockable((MultipleCDockable)((Object)dockable));
            if (entry.isShown() || !dockable.isCloseable()) {
                dockable.setVisible(true);
            }
        }
    }

    public void addSingleDockableFactory(Filter<String> ids, SingleCDockableFactory factory) {
        this.register.getBackupFactory().add(ids, factory);
        for (FrontendEntry entry : this.frontend.listFrontendEntries()) {
            SingleCDockable dockable;
            String id;
            if (entry.getDockable() != null || !entry.isShown() || !this.register.isSingleId(entry.getKey()) || !ids.includes(id = this.register.singleToNormalId(entry.getKey())) || (dockable = factory.createBackup(id)) == null) continue;
            this.addDockable((MultipleCDockable)((Object)dockable));
            if (!entry.isShown() && dockable.isCloseable()) continue;
            dockable.setVisible(true);
        }
    }

    public SingleCDockableFactory getSingleDockableFactory(String id) {
        return this.register.getBackupFactory().getFactory(id);
    }

    public void removeSingleDockableFactory(SingleCDockableFactory factory) {
        this.register.getBackupFactory().remove(factory);
        for (FrontendEntry entry : this.frontend.listFrontendEntries()) {
            String id;
            if (entry.getDockable() != null || !entry.isShown() || !this.register.isSingleId(entry.getKey()) || this.missingStrategy.shouldStoreSingle(id = this.register.singleToNormalId(entry.getKey()))) continue;
            this.locationManager.removeEmpty(entry.getKey());
            this.frontend.removeEmpty(entry.getKey());
        }
    }

    public void removeSingleDockableFactory(String id) {
        this.register.getBackupFactory().remove(id);
        if (!this.missingStrategy.shouldStoreSingle(id)) {
            id = this.register.toSingleId(id);
            this.locationManager.removeEmpty(id);
            this.frontend.removeEmpty(id);
        }
    }

    public <M extends MultipleCDockable> M addDockable(M dockable) {
        HashSet<String> ids = new HashSet<String>();
        MultipleCDockableFactory<?, ?> factory = dockable.getFactory();
        if (factory == null) {
            throw new IllegalArgumentException("factory of dockable must not be null");
        }
        String factoryId = this.access.getFactoryId(dockable.getFactory());
        if (factoryId == null) {
            throw new IllegalStateException("the factory for a MultipleCDockable is not registered: " + dockable.getFactory());
        }
        for (MultipleCDockable multi : this.register.getMultipleDockables()) {
            if (!factoryId.equals(this.access.getFactoryId(multi.getFactory()))) continue;
            ids.add(this.accesses.get(multi).getUniqueId());
        }
        int count = 0;
        String id = count + " " + factoryId;
        while (ids.contains(this.register.toMultiId(id))) {
            id = ++count + " " + factoryId;
        }
        return this.addDockable(id, dockable);
    }

    public <M extends MultipleCDockable> M addDockable(String uniqueId, M dockable) {
        if (dockable == null) {
            throw new NullPointerException("dockable must not be null");
        }
        this.checkValidUniqueId(uniqueId);
        String factory = this.access.getFactoryId(dockable.getFactory());
        if (factory == null) {
            throw new IllegalStateException("the factory for a MultipleCDockable is not registered: " + dockable.getFactory());
        }
        if (dockable.getControl() != null) {
            throw new IllegalStateException("dockable is already part of a control");
        }
        uniqueId = this.register.toMultiId(uniqueId);
        for (MultipleCDockable multi : this.register.getMultipleDockables()) {
            String id = this.accesses.get(multi).getUniqueId();
            if (!uniqueId.equals(id)) continue;
            throw new IllegalArgumentException("The unique identifier is already in use: " + uniqueId);
        }
        dockable.setControlAccess(this.access);
        this.accesses.get(dockable).setUniqueId(uniqueId);
        this.frontend.addDockable(uniqueId, dockable.intern());
        this.frontend.setHideable(dockable.intern(), true);
        this.register.addMultipleDockable(dockable);
        for (CControlListener listener : this.listeners()) {
            listener.added(this, dockable);
        }
        return dockable;
    }

    public void replace(MultipleCDockable oldDockable, MultipleCDockable newDockable) {
        boolean locationEmpty;
        if (oldDockable == null) {
            throw new IllegalArgumentException("old dockable must not be null");
        }
        if (newDockable == null) {
            throw new IllegalArgumentException("new dockable must not be null");
        }
        if (oldDockable.getControl() != this) {
            throw new IllegalArgumentException("old dockable not registered at this CControl");
        }
        if (newDockable.getControl() != null) {
            throw new IllegalArgumentException("new dockable alread registered at some CControl");
        }
        String id = this.accesses.get(oldDockable).getUniqueId();
        boolean frontendEmpty = this.frontend.isEmpty(id);
        if (!frontendEmpty) {
            this.frontend.addEmpty(id);
        }
        if (!(locationEmpty = this.locationManager.isEmpty(id))) {
            this.locationManager.addEmpty(id);
        }
        id = this.register.multiToNormalId(id);
        this.removeDockable(oldDockable);
        this.addDockable(id, newDockable);
        if (!frontendEmpty) {
            this.frontend.removeEmpty(id);
        }
        if (!locationEmpty) {
            this.locationManager.removeEmpty(id);
        }
    }

    public MultipleCDockable getMultipleDockable(String id) {
        id = this.register.toMultiId(id);
        for (MultipleCDockable dockable : this.register.getMultipleDockables()) {
            if (!this.accesses.get(dockable).getUniqueId().equals(id)) continue;
            return dockable;
        }
        return null;
    }

    public String getUniqueId(MultipleCDockable dockable) {
        CDockableAccess access = this.accesses.get(dockable);
        if (access == null) {
            return null;
        }
        return this.register.multiToNormalId(access.getUniqueId());
    }

    private boolean shouldStore(String id) {
        if (this.register.isSingleId(id)) {
            if (this.register.getBackupFactory().getFactory(this.register.singleToNormalId(id)) != null) {
                return true;
            }
            return this.missingStrategy.shouldStoreSingle(this.register.singleToNormalId(id));
        }
        if (this.register.isMultiId(id)) {
            return this.missingStrategy.shouldStoreMulti(this.register.multiToNormalId(id));
        }
        return false;
    }

    private String shouldStore(CDockable dockable) {
        String key = null;
        if (dockable instanceof SingleCDockable) {
            key = ((SingleCDockable)dockable).getUniqueId();
            key = this.register.toSingleId(key);
        } else if (dockable instanceof MultipleCDockable) {
            CDockableAccess access = this.accesses.get(dockable);
            if (access == null) {
                return null;
            }
            key = access.getUniqueId();
        }
        if (this.shouldStore(key)) {
            return key;
        }
        return null;
    }

    private boolean shouldCreate(MultipleCDockableFactory<?, ?> factory, CommonMultipleDockableLayout layout) {
        String uniqueId = layout.getId();
        String multiId = this.register.toMultiId(uniqueId);
        for (MultipleCDockable multi : this.register.getMultipleDockables()) {
            if (!this.accesses.get(multi).getUniqueId().equals(multiId)) continue;
            return false;
        }
        String factoryId = this.access.getFactoryId(factory);
        MultipleCDockableFactory<?, ?> normalizedFactory = factory;
        return this.missingStrategy.shouldCreate(factoryId, normalizedFactory, uniqueId, layout.getLayout());
    }

    public void removeDockable(MultipleCDockable dockable) {
        if (dockable == null) {
            throw new NullPointerException("dockable must not be null");
        }
        if (dockable.getControl() == this) {
            dockable.setVisible(false);
            this.frontend.remove(dockable.intern());
            this.register.removeMultipleDockable(dockable);
            dockable.setControlAccess(null);
            for (CControlListener listener : this.listeners()) {
                listener.removed(this, dockable);
            }
        }
    }

    public int getCDockableCount() {
        return this.register.getDockableCount();
    }

    public CDockable getCDockable(int index) {
        return this.register.getDockable(index);
    }

    public void addMultipleDockableFactory(String id, MultipleCDockableFactory<?, ?> factory) {
        this.addMultipleDockableFactory(id, factory, true);
    }

    private void addMultipleDockableFactory(String id, MultipleCDockableFactory<?, ?> factory, boolean check) {
        if (check) {
            this.checkValidUniqueId(id);
        }
        if (factory == null) {
            throw new NullPointerException("factory must not be null");
        }
        if (this.register.getCommonMultipleDockableFactory(id) != null) {
            throw new IllegalArgumentException("there is already a factory named " + id);
        }
        if (this.access.getFactoryId(factory) != null) {
            throw new IllegalArgumentException("this factory-object is already in use and cannot be added a second time");
        }
        CommonMultipleDockableFactory cfactory = new CommonMultipleDockableFactory(id, factory, this.access);
        this.register.putCommonMultipleDockableFactory(id, cfactory);
        this.frontend.registerFactory(cfactory);
    }

    public MultipleCDockableFactory<?, ?> getMultipleDockableFactory(String id) {
        return this.register.getFactory(id);
    }

    public String getFactoryId(MultipleCDockableFactory<?, ?> factory) {
        return this.access.getFactoryId(factory);
    }

    public void removeMultipleDockableFactory(String id) {
        CommonMultipleDockableFactory factory = this.register.removeCommonMultipleDockableFactory(id);
        if (factory != null) {
            this.frontend.unregisterFactory(factory);
            ArrayList<MultipleCDockable> toRemove = new ArrayList<MultipleCDockable>();
            for (MultipleCDockable dockable : this.register.getMultipleDockables()) {
                if (dockable.getFactory() != factory.getFactory()) continue;
                toRemove.add(dockable);
            }
            for (MultipleCDockable dockable : toRemove) {
                this.removeDockable(dockable);
            }
        }
    }

    public void setDefaultLocation(CLocation defaultLocation) {
        this.defaultLocation = defaultLocation;
    }

    public CLocation getDefaultLocation() {
        return this.defaultLocation;
    }

    public void setMaximizeArea(String id) {
        CMaximizedMode mode = this.locationManager.getMaximizedMode();
        CMaximizedModeArea area = (CMaximizedModeArea)mode.get(id);
        if (area == null) {
            throw new IllegalArgumentException("No area registered with key '" + id + "'");
        }
        mode.setDefaultArea(area);
    }

    public void setGroupBehavior(CGroupBehavior behavior) {
        this.locationManager.setGroupBehavior(behavior);
    }

    public CGroupBehavior getGroupBehavior() {
        return this.locationManager.getGroupBehavior();
    }

    @Deprecated
    public void setTheme(DockTheme theme) {
        this.frontend.getController().setTheme(theme);
    }

    public void setTheme(String theme) {
        this.themes.select(theme);
    }

    public ThemeMap getThemes() {
        return this.themes;
    }

    public void setMissingPerspectiveStrategy(MissingPerspectiveStrategy missingPerspectiveStrategy) {
        if (missingPerspectiveStrategy == null) {
            throw new IllegalArgumentException("strategy must not be null");
        }
        this.missingPerspectiveStrategy = missingPerspectiveStrategy;
    }

    public MissingPerspectiveStrategy getMissingPerspectiveStrategy() {
        return this.missingPerspectiveStrategy;
    }

    public CControlPerspective getPerspectives() {
        return new CControlPerspective(this.access);
    }

    public void setRootWindow(WindowProvider window) {
        this.frontend.setOwner(window);
    }

    public WindowProvider getRootWindow() {
        return this.frontend.getOwner();
    }

    public PreferenceStorage getPreferences() {
        return this.preferences;
    }

    public void setPreferenceModel(PreferenceModel preferenceModel) {
        if (this.preferenceModel != null) {
            this.preferenceModel.read();
            this.preferences.store(this.preferenceModel);
        }
        this.preferenceModel = preferenceModel;
        if (preferenceModel != null) {
            this.preferences.load(preferenceModel, false);
            preferenceModel.write();
        }
    }

    public PreferenceModel getPreferenceModel() {
        return this.preferenceModel;
    }

    public void setMissingStrategy(MissingCDockableStrategy missingStrategy) {
        this.missingStrategy = missingStrategy == null ? MissingCDockableStrategy.PURGE : missingStrategy;
    }

    public MissingCDockableStrategy getMissingStrategy() {
        return this.missingStrategy;
    }

    public void addResizeRequestListener(ResizeRequestListener listener) {
        if (listener == null) {
            throw new NullPointerException("listener must not be null");
        }
        this.resizeListeners.add(listener);
    }

    public void removeResizeRequestListener(ResizeRequestListener listener) {
        this.resizeListeners.remove(listener);
    }

    public void handleResizeRequests() {
        ResizeRequestListener[] listeners = this.resizeListeners.toArray(new ResizeRequestListener[this.resizeListeners.size()]);
        for (ResizeRequestListener listener : listeners) {
            listener.handleResizeRequest(this);
        }
        for (CDockable dockable : this.register.getDockables()) {
            dockable.getAndClearResizeRequest();
        }
    }

    public CDockFrontend intern() {
        return this.frontend;
    }

    public DockController getController() {
        return this.intern().getController();
    }

    public IconManager getIcons() {
        return this.getController().getIcons();
    }

    public void setRevertToBasicModes(boolean revert) {
        this.intern().setRevertToBasicModes(revert);
    }

    public boolean isRevertToBasicModes() {
        return this.intern().isRevertToBasicModes();
    }

    public void setTransferFocusOnMinimize(boolean transferFocusOnMinimize) {
        this.transferFocusOnMinimize = transferFocusOnMinimize;
    }

    public boolean isTransferFocusOnMinimize() {
        return this.transferFocusOnMinimize;
    }

    public void write(File file) throws IOException {
        this.getResources().writeFile(file);
    }

    public void write(DataOutputStream out) throws IOException {
        this.getResources().writeStream(out);
    }

    public void writeXML(XElement element) {
        this.getResources().writeXML(element);
    }

    public void writeXML(File file) throws IOException {
        XElement root = new XElement("root");
        this.getResources().writeXML(root);
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));
        XIO.writeUTF(root, out);
        out.close();
    }

    public void read(File file) throws IOException {
        this.getResources().readFile(file);
    }

    public void read(DataInputStream in) throws IOException {
        this.getResources().readStream(in);
    }

    public void readXML(XElement element) {
        this.getResources().readXML(element);
    }

    public void readXML(File file) throws IOException {
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
        XElement element = XIO.readUTF(in);
        in.close();
        this.readXML(element);
    }

    public String save() {
        return this.save(false);
    }

    public String save(boolean includeWorkingAreas) {
        String current = this.frontend.getCurrentSetting();
        if (current == null) {
            return null;
        }
        this.save(current, includeWorkingAreas);
        return current;
    }

    public void save(String name) {
        this.frontend.save(name);
    }

    public void save(String name, boolean includeWorkingAreas) {
        this.frontend.save(name, !includeWorkingAreas);
    }

    public void load(String name) {
        this.frontend.load(name);
    }

    public void load(String name, boolean includeWorkingAreas) {
        this.frontend.load(name, !includeWorkingAreas);
    }

    public void delete(String name) {
        this.frontend.delete(name);
    }

    public String[] layouts() {
        Set<String> settings = this.frontend.getSettings();
        return settings.toArray(new String[settings.size()]);
    }

    public String getLayout() {
        return this.frontend.getCurrentSetting();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Access
    implements CControlAccess {
        private DockAction closeAction;

        private Access() {
        }

        @Override
        public CControl getOwner() {
            return CControl.this;
        }

        @Override
        public void link(CDockable dockable, CDockableAccess access) {
            if (access == null) {
                CDockableAccess oldAccess = (CDockableAccess)CControl.this.accesses.remove(dockable);
                if (oldAccess != null) {
                    oldAccess.setUniqueId(null);
                }
                dockable.removeCDockablePropertyListener(CControl.this.listenerCollection.getCDockablePropertyListener());
                dockable.removeCDockableStateListener(CControl.this.listenerCollection.getCDockableStateListener());
            } else if (CControl.this.accesses.put(dockable, access) == null) {
                dockable.addCDockablePropertyListener(CControl.this.listenerCollection.getCDockablePropertyListener());
                dockable.addCDockableStateListener(CControl.this.listenerCollection.getCDockableStateListener());
            }
        }

        @Override
        public CDockableAccess access(CDockable dockable) {
            return (CDockableAccess)CControl.this.accesses.get(dockable);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void hide(CDockable dockable) {
            if (!dockable.isVisible()) {
                return;
            }
            DockRegister register = CControl.this.frontend.getController().getRegister();
            try {
                register.setStalled(true);
                HashMap<Dockable, ExtendedMode> nonBasic = new HashMap<Dockable, ExtendedMode>();
                for (Dockable check : CControl.this.locationManager.listDockables()) {
                    CLocationMode mode;
                    if (check == dockable.intern() || (mode = (CLocationMode)CControl.this.locationManager.getCurrentMode(check)) == null || mode.isBasicMode()) continue;
                    nonBasic.put(check, mode.getExtendedMode());
                }
                Dockable[] focusHistory = CControl.this.getController().getFocusHistory().getHistory();
                boolean changes = CControl.this.locationManager.ensureBasicModes();
                CControl.this.frontend.hide(dockable.intern());
                if (changes) {
                    for (Dockable focused : focusHistory) {
                        ExtendedMode mode = (ExtendedMode)nonBasic.get(focused);
                        if (mode == null || !CControl.this.frontend.isShown(focused) || !CControl.this.locationManager.isModeAvailable(focused, mode)) continue;
                        CControl.this.locationManager.setMode(focused, mode);
                    }
                }
            }
            finally {
                register.setStalled(false);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void show(CDockable dockable) {
            if (dockable.hasParent()) {
                return;
            }
            DockRegister register = CControl.this.frontend.getController().getRegister();
            register.setStalled(true);
            try {
                CStation<?> area;
                CLocation location = dockable.getAutoBaseLocation(true);
                CDockableAccess access = this.access(dockable);
                if (access != null) {
                    access.internalLocation(true);
                }
                if ((area = dockable.getWorkingArea()) != null && area.asDockable() != null && !area.asDockable().isVisible()) {
                    throw new IllegalStateException("A dockable that wants to be on a working-area can't be made visible unless the working-area is visible.");
                }
                if (location == null) {
                    dockable.setExtendedMode(this.findInitialMode(dockable));
                } else {
                    CControl.this.locationManager.setLocation(dockable.intern(), location);
                }
                if (!CControl.this.frontend.isShown(dockable.intern())) {
                    CControl.this.frontend.show(dockable.intern(), false);
                }
                CControl.this.locationManager.ensureValidLocation(dockable);
            }
            finally {
                register.setStalled(false);
            }
        }

        private ExtendedMode findInitialMode(CDockable dockable) {
            CGroupingBehavior groupingBehavior = CControl.this.getProperty(GROUPING_BEHAVIOR);
            DockableGrouping grouping = groupingBehavior.getGrouping(dockable.intern());
            ExtendedMode mode = null;
            if (grouping != null) {
                mode = grouping.getInitialMode(dockable.intern());
            }
            if (mode == null) {
                mode = ExtendedMode.NORMALIZED;
            }
            return mode;
        }

        @Override
        public CLocation getAutoBaseLocation(CDockable dockable, boolean noBackwardsTransformation) {
            CDockableAccess access = this.access(dockable);
            CLocation location = null;
            if (access != null) {
                location = access.internalLocation(false);
            }
            if (location == null) {
                if (CControl.this.frontend.hasLocation(dockable.intern())) {
                    FrontendEntry entry = CControl.this.frontend.getFrontendEntry(dockable.intern());
                    String root = entry.getRoot();
                    DockableProperty property = entry.getLocation();
                    CStation<?> station = CControl.this.getStation(root);
                    if (station != null) {
                        if (noBackwardsTransformation) {
                            return null;
                        }
                        location = station.getStationLocation().expandProperty(CControl.this.getController(), property);
                    }
                }
                if (location == null) {
                    CStation<?> area = dockable.getWorkingArea();
                    if (area != null) {
                        location = area.getStationLocation();
                    }
                    if (location == null) {
                        location = CControl.this.defaultLocation;
                    }
                    if (location == null && !noBackwardsTransformation) {
                        location = CControl.this.locationManager.getLocation(dockable.intern(), ExtendedMode.NORMALIZED);
                    }
                }
            }
            return location;
        }

        @Override
        public boolean isVisible(CDockable dockable) {
            return CControl.this.frontend.isShown(dockable.intern());
        }

        @Override
        public boolean hasParent(CDockable dockable) {
            if (CControl.this.frontend.isHiddenRootStation(dockable.intern())) {
                return false;
            }
            return this.isVisible(dockable);
        }

        @Override
        public String getFactoryId(MultipleCDockableFactory<?, ?> factory) {
            for (Map.Entry<String, MultipleCDockableFactory<?, ?>> entry : CControl.this.register.getFactories().entrySet()) {
                if (entry.getValue() != factory) continue;
                return entry.getKey();
            }
            return null;
        }

        @Override
        public CLocationModeManager getLocationManager() {
            return CControl.this.locationManager;
        }

        @Override
        public DockAction createCloseAction(CDockable dockable) {
            if (this.closeAction == null) {
                CloseActionFactory factory = CControl.this.getController().getProperties().get(CLOSE_ACTION_FACTORY);
                this.closeAction = factory.create(CControl.this, dockable).intern();
            }
            return this.closeAction;
        }

        @Override
        public MutableCControlRegister getRegister() {
            return CControl.this.register;
        }

        @Override
        public boolean shouldStore(String key) {
            return CControl.this.shouldStore(key);
        }

        @Override
        public String shouldStore(CDockable dockable) {
            return CControl.this.shouldStore(dockable);
        }
    }
}

