/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.behavior;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DockHierarchyLock;
import bibliothek.gui.dock.common.CControl;
import bibliothek.gui.dock.common.CGridArea;
import bibliothek.gui.dock.common.intern.CControlAccess;
import bibliothek.gui.dock.common.intern.station.CSplitDockStation;
import bibliothek.gui.dock.common.mode.station.ExternalizedCSplitDockStationHandler;
import bibliothek.gui.dock.control.DockRegister;
import bibliothek.gui.dock.event.DockRegisterAdapter;
import bibliothek.gui.dock.event.DockStationAdapter;
import bibliothek.util.Path;

public class ExternalizingCGridArea
extends CGridArea {
    public static final Path TYPE_ID = new Path("dock", "ExternalizingCGridArea");
    private boolean autoRemove = true;
    public static final String UNIQUE_ID_PREFIX = "dock.ExternalizingCGridArea.";

    public ExternalizingCGridArea(CControl control) {
        this(control, ExternalizingCGridArea.createUniqueIdentifier(control));
    }

    public ExternalizingCGridArea(CControl control, String uniqueId) {
        super(control, uniqueId);
        this.getStation().addDockStationListener(new AutoRemover());
        this.setTitleShown(true);
        this.setMaximizingArea(true);
    }

    private static String createUniqueIdentifier(CControl control) {
        String id;
        int count = 0;
        do {
            id = UNIQUE_ID_PREFIX + System.currentTimeMillis() + "." + count;
            ++count;
        } while (control.getSingleDockable(id) != null);
        return id;
    }

    protected ExternalizedCSplitDockStationHandler createSplitDockStationHandle(CControl control) {
        return new ExternalizedCSplitDockStationHandler(this, control.getLocationManager());
    }

    protected ExternalizedCSplitDockStationHandler getModeManagerHandle() {
        return (ExternalizedCSplitDockStationHandler)super.getModeManagerHandle();
    }

    protected void install(CControlAccess access) {
        super.install(access);
        access.getLocationManager().getExternalizedMode().add(this.getModeManagerHandle().asExternalized());
    }

    protected void uninstall(CControlAccess access) {
        super.uninstall(access);
        access.getLocationManager().getExternalizedMode().remove(this.getModeManagerHandle().asExternalized().getUniqueId());
    }

    public boolean isMaximizable() {
        return true;
    }

    public boolean isExternalizable() {
        return true;
    }

    public boolean isMinimizable() {
        return false;
    }

    public boolean isNormalizeable() {
        return false;
    }

    protected boolean isNormalizingArea() {
        return false;
    }

    public Path getTypeId() {
        return TYPE_ID;
    }

    public void setAutoRemove(boolean autoRemove) {
        this.autoRemove = autoRemove;
    }

    public boolean isAutoRemove() {
        return this.autoRemove;
    }

    protected void tryAutoRemove() {
        CControl control = this.getControl();
        if (control != null) {
            DockHierarchyLock lock = control.getController().getHierarchyLock();
            lock.onRelease(new Runnable(){

                public void run() {
                    ExternalizingCGridArea.this.autoRemove();
                }
            });
        }
    }

    private void autoRemove() {
        if (!this.autoRemove) {
            return;
        }
        CControl control = this.getControl();
        if (control != null) {
            DockRegister register = control.getController().getRegister();
            if (register.isStalled()) {
                register.addDockRegisterListener(new DelayedAutoRemove());
            } else {
                CSplitDockStation station = this.getStation();
                if (station.getDockableCount() == 0) {
                    DockStation parent = station.getDockParent();
                    if (parent != null) {
                        parent.drag(station);
                    }
                    control.removeDockable(this);
                    control.removeStation(this);
                }
            }
        }
    }

    private class DelayedAutoRemove
    extends DockRegisterAdapter {
        private DelayedAutoRemove() {
        }

        public void registerUnstalled(DockController controller) {
            controller.getRegister().removeDockRegisterListener(this);
            ExternalizingCGridArea.this.tryAutoRemove();
        }
    }

    private class AutoRemover
    extends DockStationAdapter {
        private AutoRemover() {
        }

        public void dockableRemoved(DockStation station, Dockable dockable) {
            if (station.getDockableCount() == 0) {
                ExternalizingCGridArea.this.tryAutoRemove();
            }
        }
    }
}

