/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.group;

import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.StackDockStation;
import bibliothek.gui.dock.common.group.CGroupBehavior;
import bibliothek.gui.dock.common.group.CGroupMovement;
import bibliothek.gui.dock.common.group.SingleGroupMovement;
import bibliothek.gui.dock.common.group.StackGroupMovement;
import bibliothek.gui.dock.common.mode.ExtendedMode;
import bibliothek.gui.dock.facile.mode.LocationMode;
import bibliothek.gui.dock.facile.mode.LocationModeManager;
import bibliothek.gui.dock.util.DockUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StackGroupBehavior
implements CGroupBehavior {
    @Override
    public CGroupMovement prepare(LocationModeManager<? extends LocationMode> manager, Dockable dockable, ExtendedMode target) {
        if (this.isGrouped(dockable, target, manager)) {
            return new StackGroupMovement((StackDockStation)dockable.getDockParent(), dockable, target);
        }
        return new SingleGroupMovement(dockable, target);
    }

    private boolean isGrouped(Dockable dockable, ExtendedMode target, LocationModeManager<?> manager) {
        DockStation parent = dockable.getDockParent();
        if (parent instanceof StackDockStation) {
            int n = parent.getDockableCount();
            for (int i = 0; i < n; ++i) {
                if (manager.isModeAvailable(parent.getDockable(i), target)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public Dockable getGroupElement(LocationModeManager<? extends LocationMode> manager, Dockable dockable, ExtendedMode mode) {
        DockStation parent = dockable.getDockParent();
        if (parent instanceof StackDockStation) {
            if (parent.asDockable().getDockParent() == null) {
                return dockable;
            }
            int n = parent.getDockableCount();
            for (int i = 0; i < n; ++i) {
                Dockable check = parent.getDockable(i);
                if (check == dockable || manager.isModeAvailable(check, mode)) continue;
                return dockable;
            }
            return (StackDockStation)parent;
        }
        return dockable;
    }

    @Override
    public Dockable getReplaceElement(LocationModeManager<? extends LocationMode> manager, Dockable old, Dockable dockable, ExtendedMode mode) {
        if (old == dockable) {
            return null;
        }
        if (!DockUtilities.isAncestor(old, dockable)) {
            return null;
        }
        DockStation station = old.asDockStation();
        if (station == null) {
            return old;
        }
        if (station.getDockableCount() == 2) {
            if (station.getDockable(0) == dockable) {
                return station.getDockable(1);
            }
            if (station.getDockable(1) == dockable) {
                return station.getDockable(0);
            }
        }
        return old;
    }

    @Override
    public boolean shouldForwardActions(LocationModeManager<? extends LocationMode> manager, DockStation station, Dockable dockable, ExtendedMode mode) {
        Dockable dockStation = station.asDockable();
        if (dockStation != null && !manager.isModeAvailable(dockStation, mode)) {
            return false;
        }
        int n = station.getDockableCount();
        for (int i = 0; i < n; ++i) {
            Dockable child = station.getDockable(i);
            if (manager.isModeAvailable(child, mode)) continue;
            return false;
        }
        return true;
    }
}

