/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.support.menu;

import bibliothek.gui.dock.support.menu.MenuPiece;
import bibliothek.gui.dock.support.menu.MenuPieceListener;
import java.awt.Component;
import java.util.List;
import javax.swing.JPopupMenu;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SeparatingMenuPiece
extends MenuPiece {
    private boolean topSeparator = false;
    private boolean bottomSeparator = false;
    private boolean emptySeparator = false;
    private Component separatorTop = null;
    private Component separatorBottom = null;
    private MenuPiece piece;
    private Listener listener = new Listener();

    public SeparatingMenuPiece() {
        this(null);
    }

    public SeparatingMenuPiece(boolean topSeparator, boolean emptySeparator, boolean bottomSeparator) {
        this(null, topSeparator, emptySeparator, bottomSeparator);
    }

    public SeparatingMenuPiece(MenuPiece piece) {
        this(piece, false, false, false);
    }

    public SeparatingMenuPiece(MenuPiece piece, boolean topSeparator, boolean emptySeparator, boolean bottomSeparator) {
        this.setPiece(piece);
        this.setTopSeparator(topSeparator);
        this.setEmptySeparator(emptySeparator);
        this.setBottomSeparator(bottomSeparator);
    }

    public MenuPiece getPiece() {
        return this.piece;
    }

    @Override
    public void bind() {
        super.bind();
        this.piece.bind();
    }

    @Override
    public void unbind() {
        super.unbind();
        this.piece.unbind();
    }

    public void setPiece(MenuPiece piece) {
        if (this.piece != piece) {
            if (this.piece != null) {
                this.listener.remove(piece, 0, piece.getItemCount());
                this.piece.setParent(null);
                piece.removeListener(this.listener);
            }
            this.piece = piece;
            if (this.piece != null) {
                piece.setParent(this);
                piece.addListener(this.listener);
                this.listener.insert(piece, 0, piece.items());
            }
        }
    }

    @Override
    public int getItemCount() {
        if (this.piece == null) {
            return this.getSeparatorCount();
        }
        return this.piece.getItemCount() + this.getSeparatorCount();
    }

    @Override
    public void fill(List<Component> items) {
        if (this.piece == null || this.piece.getItemCount() == 0) {
            if (this.emptySeparator) {
                items.add(this.getEmptySeparator());
            }
        } else {
            if (this.topSeparator) {
                items.add(this.getTopSeparator());
            }
            this.piece.fill(items);
            if (this.bottomSeparator) {
                items.add(this.getBottomSeparator());
            }
        }
    }

    protected int getSeparatorCount() {
        if (this.piece != null && this.piece.getItemCount() > 0) {
            if (this.topSeparator && this.bottomSeparator) {
                return 2;
            }
            if (this.topSeparator || this.bottomSeparator) {
                return 1;
            }
            return 0;
        }
        if (this.emptySeparator) {
            return 1;
        }
        return 0;
    }

    public boolean isBottomSeparator() {
        return this.bottomSeparator;
    }

    public void setBottomSeparator(boolean bottomSeparator) {
        if (this.bottomSeparator != bottomSeparator) {
            this.bottomSeparator = bottomSeparator;
            this.putUpSeparators();
            MenuPiece parent = this.getParent();
            if (parent != null && this.piece != null && this.piece.getItemCount() > 0) {
                if (bottomSeparator) {
                    this.fireInsert(this.getItemCount(), this.getBottomSeparator());
                } else {
                    this.fireRemove(this.getItemCount() - 1, 1);
                }
            }
        }
    }

    public boolean isEmptySeparator() {
        return this.emptySeparator;
    }

    public void setEmptySeparator(boolean emptySeparator) {
        if (this.emptySeparator != emptySeparator) {
            this.emptySeparator = emptySeparator;
            this.putUpSeparators();
            if (this.piece == null || this.piece.getItemCount() == 0) {
                if (emptySeparator) {
                    this.fireInsert(0, this.getEmptySeparator());
                } else {
                    this.fireRemove(0, 1);
                }
            }
        }
    }

    public boolean isTopSeparator() {
        return this.topSeparator;
    }

    public void setTopSeparator(boolean topSeparator) {
        if (this.topSeparator != topSeparator) {
            this.topSeparator = topSeparator;
            this.putUpSeparators();
            if (this.piece != null && this.piece.getItemCount() > 0) {
                if (topSeparator) {
                    this.fireInsert(0, this.getTopSeparator());
                } else {
                    this.fireRemove(0, 1);
                }
            }
        }
    }

    private Component getTopSeparator() {
        return this.separatorTop;
    }

    private Component getBottomSeparator() {
        return this.separatorBottom;
    }

    private Component getEmptySeparator() {
        if (this.separatorTop != null) {
            return this.separatorTop;
        }
        return this.separatorBottom;
    }

    private void putUpSeparators() {
        boolean top = this.topSeparator;
        boolean bottom = this.bottomSeparator;
        if (this.emptySeparator && !top && !bottom) {
            top = true;
        }
        if (top && this.separatorTop == null) {
            this.separatorTop = new JPopupMenu.Separator();
        } else if (!top && this.separatorTop != null) {
            this.separatorTop = null;
        }
        if (bottom && this.separatorBottom == null) {
            this.separatorBottom = new JPopupMenu.Separator();
        } else if (!top && this.separatorBottom != null) {
            this.separatorBottom = null;
        }
    }

    private class Listener
    implements MenuPieceListener {
        private Listener() {
        }

        public void insert(MenuPiece child, int index, Component ... component) {
            if (component.length > 0) {
                int count = SeparatingMenuPiece.this.piece.getItemCount() - component.length;
                if (count == 0) {
                    if (SeparatingMenuPiece.this.emptySeparator) {
                        SeparatingMenuPiece.this.fireRemove(0, 1);
                    }
                    if (SeparatingMenuPiece.this.bottomSeparator) {
                        SeparatingMenuPiece.this.fireInsert(0, SeparatingMenuPiece.this.getBottomSeparator());
                    }
                    if (SeparatingMenuPiece.this.topSeparator) {
                        SeparatingMenuPiece.this.fireInsert(0, SeparatingMenuPiece.this.getTopSeparator());
                    }
                }
                if (SeparatingMenuPiece.this.topSeparator) {
                    ++index;
                }
                SeparatingMenuPiece.this.fireInsert(index, component);
            }
        }

        public void remove(MenuPiece child, int index, int length) {
            if (length > 0) {
                if (SeparatingMenuPiece.this.topSeparator) {
                    ++index;
                }
                SeparatingMenuPiece.this.fireRemove(index, length);
                if (child.getItemCount() == 0) {
                    if (SeparatingMenuPiece.this.topSeparator && SeparatingMenuPiece.this.bottomSeparator) {
                        SeparatingMenuPiece.this.fireRemove(0, 2);
                    } else if (SeparatingMenuPiece.this.topSeparator || SeparatingMenuPiece.this.bottomSeparator) {
                        SeparatingMenuPiece.this.fireRemove(0, 1);
                    }
                    if (SeparatingMenuPiece.this.emptySeparator) {
                        SeparatingMenuPiece.this.fireInsert(0, SeparatingMenuPiece.this.getEmptySeparator());
                    }
                }
            }
        }
    }
}

