/*
 * Decompiled with CFR 0.152.
 */
package com.uploadcare.api;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import com.uploadcare.api.CopyFile;
import com.uploadcare.api.DefaultRequestHelperProvider;
import com.uploadcare.api.File;
import com.uploadcare.api.FilesQueryBuilder;
import com.uploadcare.api.Group;
import com.uploadcare.api.GroupQueryBuilder;
import com.uploadcare.api.HttpDeleteWithBody;
import com.uploadcare.api.Project;
import com.uploadcare.api.RequestHelper;
import com.uploadcare.api.RequestHelperProvider;
import com.uploadcare.api.Webhook;
import com.uploadcare.api.WebhookDataWrapper;
import com.uploadcare.data.CopyFileData;
import com.uploadcare.data.CopyOptionsData;
import com.uploadcare.data.FileData;
import com.uploadcare.data.GroupData;
import com.uploadcare.data.ProjectData;
import com.uploadcare.data.WebhookData;
import com.uploadcare.data.WebhookOptionsData;
import com.uploadcare.exceptions.UploadcareApiException;
import com.uploadcare.urls.Urls;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.util.TextUtils;

public class Client {
    private final String publicKey;
    private final String secretKey;
    private final boolean simpleAuth;
    private final CloseableHttpClient httpClient;
    private final ObjectMapper objectMapper;
    private final RequestHelperProvider requestHelperProvider;
    private final int MAX_SAVE_DELETE_BATCH_SIZE = 100;

    public Client(String publicKey, String secretKey) {
        this(publicKey, secretKey, false, null);
    }

    public Client(String publicKey, String secretKey, CloseableHttpClient httpClient) {
        this(publicKey, secretKey, false, null, httpClient);
    }

    public Client(String publicKey, String secretKey, boolean simpleAuth, RequestHelperProvider requestHelperProvider) {
        this(publicKey, secretKey, simpleAuth, requestHelperProvider, null);
    }

    public Client(String publicKey, String secretKey, boolean simpleAuth, RequestHelperProvider requestHelperProvider, CloseableHttpClient httpClient) {
        this.publicKey = publicKey;
        this.secretKey = secretKey;
        this.simpleAuth = simpleAuth;
        if (requestHelperProvider != null) {
            this.requestHelperProvider = requestHelperProvider;
            this.httpClient = null;
            this.objectMapper = null;
        } else {
            this.requestHelperProvider = new DefaultRequestHelperProvider();
            if (httpClient != null) {
                this.httpClient = httpClient;
            } else {
                PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager();
                cm.setMaxTotal(400);
                cm.setDefaultMaxPerRoute(50);
                int timeout = 300;
                RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(timeout * 1000).setConnectionRequestTimeout(timeout * 1000).setSocketTimeout(timeout * 1000).build();
                this.httpClient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)cm).setDefaultRequestConfig(requestConfig).build();
            }
            this.objectMapper = new ObjectMapper();
            this.objectMapper.setPropertyNamingStrategy(PropertyNamingStrategy.SNAKE_CASE);
            this.objectMapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        }
    }

    public static Client demoClient() {
        return new Client("demopublickey", "demosecretkey", true, null);
    }

    public static Client demoClientUploadOnly() {
        return new Client("demopublickey", null);
    }

    public String getPublicKey() {
        return this.publicKey;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public boolean isSimpleAuth() {
        return this.simpleAuth;
    }

    CloseableHttpClient getHttpClient() {
        return this.httpClient;
    }

    ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public RequestHelper getRequestHelper() {
        return this.requestHelperProvider.get(this);
    }

    public Project getProject() {
        URI url = Urls.apiProject();
        RequestHelper requestHelper = this.getRequestHelper();
        ProjectData projectData = requestHelper.executeQuery((HttpUriRequest)new HttpGet(url), true, ProjectData.class);
        return new Project(this, projectData);
    }

    public Group getGroup(String groupId) {
        URI url = Urls.apiGroup(groupId);
        RequestHelper requestHelper = this.getRequestHelper();
        GroupData groupData = requestHelper.executeQuery((HttpUriRequest)new HttpGet(url), true, GroupData.class);
        return new Group(this, groupData);
    }

    public Group getUploadedGroup(String groupId) {
        URI url = Urls.apiUploadedGroup(this.getPublicKey(), groupId);
        RequestHelper requestHelper = this.getRequestHelper();
        GroupData groupData = requestHelper.executeQuery((HttpUriRequest)new HttpGet(url), false, GroupData.class);
        return new Group(this, groupData);
    }

    public File getUploadedFile(String fileId) {
        URI url = Urls.apiUploadedFile(this.getPublicKey(), fileId);
        RequestHelper requestHelper = this.getRequestHelper();
        FileData fileData = requestHelper.executeQuery((HttpUriRequest)new HttpGet(url), false, FileData.class);
        return new File(this, fileData);
    }

    public File getFile(String fileId) {
        URI url = Urls.apiFile(fileId);
        RequestHelper requestHelper = this.getRequestHelper();
        FileData fileData = requestHelper.executeQuery((HttpUriRequest)new HttpGet(url), true, FileData.class);
        return new File(this, fileData);
    }

    public File getFileWithRekognitionInfo(String fileId) {
        URI url = Urls.getFileWithFields(fileId, "rekognition_info");
        RequestHelper requestHelper = this.getRequestHelper();
        FileData fileData = requestHelper.executeQuery((HttpUriRequest)new HttpGet(url), true, FileData.class);
        return new File(this, fileData);
    }

    public FilesQueryBuilder getFiles() {
        return new FilesQueryBuilder(this);
    }

    public GroupQueryBuilder getGroups() {
        return new GroupQueryBuilder(this);
    }

    public List<Webhook> getWebhooks() {
        ArrayList<Webhook> result = new ArrayList<Webhook>();
        URI url = Urls.apiWebhooks();
        WebhookDataWrapper dataWrapper = new WebhookDataWrapper(this);
        RequestHelper requestHelper = this.getRequestHelper();
        List webhookDataList = requestHelper.executeQuery((HttpUriRequest)new HttpGet(url), true, new TypeReference<ArrayList<WebhookData>>(){});
        for (WebhookData webhookData : webhookDataList) {
            result.add(dataWrapper.wrap(webhookData));
        }
        return result;
    }

    public void deleteFile(String fileId) {
        URI url = Urls.apiFile(fileId);
        RequestHelper requestHelper = this.getRequestHelper();
        requestHelper.executeCommand((HttpUriRequest)new HttpDelete(url), true);
    }

    public void deleteWebhook(URI targetUrl) {
        WebhookOptionsData tempWebhookData = new WebhookOptionsData();
        tempWebhookData.targetUrl = targetUrl;
        String requestBodyContent = this.trySerializeRequestBodyContent(tempWebhookData);
        StringEntity requestEntity = new StringEntity(requestBodyContent, ContentType.APPLICATION_JSON);
        URI url = Urls.apiDeleteWebhook();
        HttpDeleteWithBody request = new HttpDeleteWithBody(url);
        request.setEntity((HttpEntity)requestEntity);
        RequestHelper requestHelper = this.getRequestHelper();
        requestHelper.executeCommand((HttpUriRequest)request, true, DigestUtils.md5Hex((String)requestBodyContent));
    }

    public void deleteFiles(List<String> fileIds) {
        if (fileIds.size() <= 100) {
            URI url = Urls.apiFilesBatch();
            RequestHelper requestHelper = this.getRequestHelper();
            String requestBodyContent = this.trySerializeRequestBodyContent(fileIds);
            StringEntity requestEntity = new StringEntity(requestBodyContent, ContentType.APPLICATION_JSON);
            HttpDeleteWithBody request = new HttpDeleteWithBody(url);
            request.setEntity((HttpEntity)requestEntity);
            requestHelper.executeCommand((HttpUriRequest)request, true, DigestUtils.md5Hex((String)requestBodyContent));
        } else {
            this.executeSaveDeleteBatchCommand(false, fileIds);
        }
    }

    public Group createGroup(List<String> fileIds) {
        return this.createGroupSigned(fileIds, null, null, null);
    }

    public Group createGroup(List<String> fileIds, String callback) {
        return this.createGroupSigned(fileIds, callback, null, null);
    }

    public Group createGroupSigned(List<String> fileIds, String callback, String signature, String expire) {
        MultipartEntityBuilder entityBuilder = MultipartEntityBuilder.create();
        entityBuilder.addTextBody("pub_key", this.getPublicKey());
        if (callback != null) {
            entityBuilder.addTextBody("callback", callback);
        }
        if (!TextUtils.isEmpty((CharSequence)signature) && !TextUtils.isEmpty((CharSequence)expire)) {
            entityBuilder.addTextBody("signature", signature);
            entityBuilder.addTextBody("expire", expire);
        }
        for (int i = 0; i < fileIds.size(); ++i) {
            entityBuilder.addTextBody("files[" + i + "]", fileIds.get(i));
        }
        URI createUrl = Urls.apiCreateGroup();
        HttpPost createRequest = new HttpPost(createUrl);
        createRequest.setEntity(entityBuilder.build());
        GroupData groupData = this.getRequestHelper().executeQuery((HttpUriRequest)createRequest, false, GroupData.class);
        return new Group(this, groupData);
    }

    public Webhook createWebhook(URI targetUrl, String event, boolean isActive) {
        WebhookOptionsData tempWebhookData = new WebhookOptionsData();
        tempWebhookData.targetUrl = targetUrl;
        tempWebhookData.event = event;
        tempWebhookData.isActive = isActive;
        String requestBodyContent = this.trySerializeRequestBodyContent(tempWebhookData);
        StringEntity requestEntity = new StringEntity(requestBodyContent, ContentType.APPLICATION_JSON);
        URI url = Urls.apiWebhooks();
        HttpPost request = new HttpPost(url);
        request.setEntity((HttpEntity)requestEntity);
        RequestHelper requestHelper = this.getRequestHelper();
        WebhookData webhookData = requestHelper.executeQuery((HttpUriRequest)request, true, WebhookData.class, DigestUtils.md5Hex((String)requestBodyContent));
        return new Webhook(this, webhookData);
    }

    public Webhook updateWebhook(int webhookId, URI targetUrl, String event, Boolean isActive) {
        WebhookOptionsData tempWebhookData = new WebhookOptionsData();
        tempWebhookData.targetUrl = targetUrl;
        tempWebhookData.event = event;
        tempWebhookData.isActive = isActive;
        String requestBodyContent = this.trySerializeRequestBodyContent(tempWebhookData);
        StringEntity requestEntity = new StringEntity(requestBodyContent, ContentType.APPLICATION_JSON);
        URI url = Urls.apiWebhook(webhookId);
        HttpPut request = new HttpPut(url);
        request.setEntity((HttpEntity)requestEntity);
        RequestHelper requestHelper = this.getRequestHelper();
        WebhookData webhookData = requestHelper.executeQuery((HttpUriRequest)request, true, WebhookData.class, DigestUtils.md5Hex((String)requestBodyContent));
        return new Webhook(this, webhookData);
    }

    public void saveFile(String fileId) {
        URI url = Urls.apiFileStorage(fileId);
        RequestHelper requestHelper = this.getRequestHelper();
        requestHelper.executeCommand((HttpUriRequest)new HttpPut(url), true);
    }

    public void saveGroup(String groupId) {
        URI url = Urls.apiGroupStorage(groupId);
        RequestHelper requestHelper = this.getRequestHelper();
        requestHelper.executeCommand((HttpUriRequest)new HttpPut(url), true);
    }

    public void saveFiles(List<String> fileIds) {
        if (fileIds.size() <= 100) {
            URI url = Urls.apiFilesBatch();
            RequestHelper requestHelper = this.getRequestHelper();
            String requestBodyContent = this.trySerializeRequestBodyContent(fileIds);
            StringEntity requestEntity = new StringEntity(requestBodyContent, ContentType.APPLICATION_JSON);
            HttpPut request = new HttpPut(url);
            request.setEntity((HttpEntity)requestEntity);
            requestHelper.executeCommand((HttpUriRequest)request, true, DigestUtils.md5Hex((String)requestBodyContent));
        } else {
            this.executeSaveDeleteBatchCommand(true, fileIds);
        }
    }

    public void close() {
        if (this.httpClient != null) {
            try {
                this.httpClient.close();
            }
            catch (IOException e) {
                throw new UploadcareApiException("Error during closing CloseableHttpClient", e);
            }
        }
    }

    @Deprecated
    public CopyFile copyFile(String source, String storage) {
        if (storage != null && !storage.isEmpty()) {
            return this.copyFileRemoteStorage(source, storage, true, null);
        }
        return this.copyFileLocalStorage(source, true);
    }

    public CopyFile copyFileLocalStorage(String source, Boolean store) {
        CopyOptionsData copyOptionsData = new CopyOptionsData();
        copyOptionsData.source = source;
        copyOptionsData.store = store;
        String requestBodyContent = this.trySerializeRequestBodyContent(copyOptionsData);
        StringEntity requestEntity = new StringEntity(requestBodyContent, ContentType.APPLICATION_JSON);
        RequestHelper requestHelper = this.getRequestHelper();
        HttpPost request = new HttpPost(Urls.apiFileLocalCopy());
        request.setEntity((HttpEntity)requestEntity);
        CopyFileData copyFileData = requestHelper.executeQuery((HttpUriRequest)request, true, CopyFileData.class, DigestUtils.md5Hex((String)requestBodyContent));
        return new CopyFile(this, copyFileData);
    }

    public CopyFile copyFileRemoteStorage(String source, String target, Boolean makePublic, String pattern) {
        CopyOptionsData copyOptionsData = new CopyOptionsData();
        copyOptionsData.source = source;
        copyOptionsData.target = target;
        copyOptionsData.makePublic = makePublic;
        copyOptionsData.pattern = pattern;
        String requestBodyContent = this.trySerializeRequestBodyContent(copyOptionsData);
        StringEntity requestEntity = new StringEntity(requestBodyContent, ContentType.APPLICATION_JSON);
        RequestHelper requestHelper = this.getRequestHelper();
        HttpPost request = new HttpPost(Urls.apiFileRemoteCopy());
        request.setEntity((HttpEntity)requestEntity);
        CopyFileData copyFileData = requestHelper.executeQuery((HttpUriRequest)request, true, CopyFileData.class, DigestUtils.md5Hex((String)requestBodyContent));
        return new CopyFile(this, copyFileData);
    }

    private void executeSaveDeleteBatchCommand(boolean save, List<String> fileIds) {
        URI url = Urls.apiFilesBatch();
        for (int offset = 0; offset < fileIds.size(); offset += 100) {
            int endIndex = offset + 100;
            if (endIndex > fileIds.size()) {
                endIndex = fileIds.size();
            }
            Object request = save ? new HttpPut(url) : new HttpDeleteWithBody(url);
            List<String> ids = fileIds.subList(offset, endIndex);
            String requestBodyContent = this.trySerializeRequestBodyContent(ids);
            StringEntity requestEntity = new StringEntity(requestBodyContent, ContentType.APPLICATION_JSON);
            request.setEntity((HttpEntity)requestEntity);
            RequestHelper requestHelper = this.getRequestHelper();
            requestHelper.executeCommand((HttpUriRequest)request, true, DigestUtils.md5Hex((String)requestBodyContent));
        }
    }

    private String trySerializeRequestBodyContent(Object object) {
        String requestBodyContent = null;
        try {
            requestBodyContent = this.getObjectMapper().writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            throw new UploadcareApiException("Error input arguments", e);
        }
        return requestBodyContent;
    }
}

