/*
 * Decompiled with CFR 0.152.
 */
package com.uploadcare.api;

import com.uploadcare.api.Client;
import com.uploadcare.api.File;
import com.uploadcare.data.CopyFileData;
import com.uploadcare.data.FileData;
import com.uploadcare.exceptions.UploadcareApiException;
import java.io.IOException;
import java.net.URI;

public class CopyFile {
    private final Client client;
    private final CopyFileData copyFileData;

    CopyFile(Client client, CopyFileData copyFileData) {
        this.client = client;
        this.copyFileData = copyFileData;
    }

    public CopyFileType getType() {
        return this.copyFileData.type;
    }

    public File getFile() {
        if (this.getType() != CopyFileType.FILE) {
            return null;
        }
        try {
            FileData fileData = (FileData)this.client.getObjectMapper().readValue(this.copyFileData.result, FileData.class);
            return new File(this.client, fileData);
        }
        catch (IOException e) {
            throw new UploadcareApiException("Error parsing copy result File", e);
        }
    }

    public URI getUri() {
        if (this.getType() != CopyFileType.URL) {
            return null;
        }
        try {
            return (URI)this.client.getObjectMapper().readValue(this.copyFileData.result, URI.class);
        }
        catch (IOException e) {
            throw new UploadcareApiException("Error parsing copy result URI", e);
        }
    }

    public String toString() {
        return "CopyFile{copyFileData=" + this.copyFileData + '}';
    }

    public static enum CopyFileType {
        URL,
        FILE;

    }
}

