/*
 * Decompiled with CFR 0.152.
 */
package com.uploadcare.api;

import com.uploadcare.api.Client;
import com.uploadcare.api.Group;
import com.uploadcare.api.GroupDataWrapper;
import com.uploadcare.api.PaginatedQueryBuilder;
import com.uploadcare.api.RequestHelper;
import com.uploadcare.data.GroupPageData;
import com.uploadcare.urls.FilesFromParameter;
import com.uploadcare.urls.FilesOrderParameter;
import com.uploadcare.urls.UrlParameter;
import com.uploadcare.urls.Urls;
import java.net.URI;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class GroupQueryBuilder
implements PaginatedQueryBuilder<Group> {
    private final Client client;
    private final List<UrlParameter> parameters = new ArrayList<UrlParameter>();

    public GroupQueryBuilder(Client client) {
        this.client = client;
    }

    public GroupQueryBuilder from(Date from) {
        this.parameters.add(new FilesFromParameter(from));
        return this;
    }

    public GroupQueryBuilder ordering(UrlParameter.Order order) {
        this.parameters.add(new FilesOrderParameter(order));
        return this;
    }

    @Override
    public Iterable<Group> asIterable() {
        URI url = Urls.apiGroups();
        RequestHelper requestHelper = this.client.getRequestHelper();
        GroupDataWrapper dataWrapper = new GroupDataWrapper(this.client);
        return requestHelper.executePaginatedQuery(url, this.parameters, true, GroupPageData.class, dataWrapper);
    }

    @Override
    public List<Group> asList() {
        ArrayList<Group> groups = new ArrayList<Group>();
        for (Group group : this.asIterable()) {
            groups.add(group);
        }
        return groups;
    }
}

