/*
 * Decompiled with CFR 0.152.
 */
package com.uploadcare.api;

import com.uploadcare.api.Client;
import com.uploadcare.data.WebhookData;
import java.net.URI;
import java.util.Date;

public class Webhook {
    private final Client client;
    private final WebhookData webhookData;

    public Webhook(Client client, WebhookData webhookData) {
        this.client = client;
        this.webhookData = webhookData;
    }

    public int getId() {
        return this.webhookData.id;
    }

    public String getEvent() {
        return this.webhookData.event;
    }

    public URI getTargetUrl() {
        return this.webhookData.targetUrl;
    }

    public int getProjectId() {
        return this.webhookData.project;
    }

    public boolean isActive() {
        return this.webhookData.isActive;
    }

    public Date getCreateDate() {
        return this.webhookData.created;
    }

    public Date getUpdateDate() {
        return this.webhookData.updated;
    }

    public Webhook update(URI targetUrl) {
        return this.client.updateWebhook(this.getId(), targetUrl, null, null);
    }

    public Webhook update(String event) {
        return this.client.updateWebhook(this.getId(), null, event, null);
    }

    public Webhook update(Boolean isActive) {
        return this.client.updateWebhook(this.getId(), null, null, isActive);
    }

    public Webhook update(URI targetUrl, String event, Boolean isActive) {
        return this.client.updateWebhook(this.getId(), targetUrl, event, isActive);
    }

    public void delete() {
        this.client.deleteWebhook(this.getTargetUrl());
    }

    public String toString() {
        return "Webhook{webhookData=" + this.webhookData + '}';
    }
}

