/*
 * Decompiled with CFR 0.152.
 */
package com.uploadcare.upload;

import com.uploadcare.api.Client;
import com.uploadcare.api.RequestHelper;
import com.uploadcare.data.UploadBaseData;
import com.uploadcare.data.UploadMultipartCompleteData;
import com.uploadcare.data.UploadMultipartStartData;
import com.uploadcare.upload.UploadFailureException;
import com.uploadcare.upload.Uploader;
import com.uploadcare.urls.Urls;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Arrays;
import org.apache.commons.io.FileUtils;
import org.apache.http.client.entity.EntityBuilder;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ByteArrayBody;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.util.TextUtils;

public class FileUploader
implements Uploader {
    private final Client client;
    private final File file;
    private final InputStream stream;
    private final byte[] bytes;
    private final String filename;
    private String store = "auto";
    private String signature = null;
    private String expire = null;
    private File temporaryFile = null;
    private static final long MIN_MULTIPART_SIZE = 0xA00000L;
    private static final int CHUNK_SIZE = 0x500000;

    public FileUploader(Client client, File file) {
        this.client = client;
        this.file = file;
        this.stream = null;
        this.bytes = null;
        this.filename = null;
    }

    public FileUploader(Client client, byte[] bytes, String filename) {
        this.client = client;
        this.file = null;
        this.stream = null;
        this.bytes = bytes;
        this.filename = filename;
    }

    public FileUploader(Client client, InputStream stream, String filename) {
        this.client = client;
        this.file = null;
        this.stream = stream;
        this.bytes = null;
        this.filename = filename;
    }

    @Override
    public com.uploadcare.api.File upload() throws UploadFailureException {
        String contentType;
        long size;
        String name;
        if (this.file != null) {
            name = this.file.getName();
            size = this.file.length();
            contentType = RequestHelper.getMimeType(name);
        } else if (this.stream != null && this.filename != null) {
            try {
                this.temporaryFile = this.generateTemporaryFile(this.stream, this.filename);
            }
            catch (IOException e) {
                throw new UploadFailureException(e);
            }
            name = this.filename;
            size = this.temporaryFile.length();
            contentType = RequestHelper.getMimeType(name);
        } else if (this.bytes != null && this.filename != null) {
            name = this.filename;
            size = this.bytes.length;
            contentType = RequestHelper.getMimeType(name);
        } else {
            throw new UploadFailureException(new IllegalArgumentException());
        }
        if (size > 0xA00000L) {
            return this.multipartUpload(name, size, contentType);
        }
        return this.directUpload(name, contentType);
    }

    @Override
    public FileUploader store(boolean store) {
        this.store = store ? String.valueOf(1) : String.valueOf(0);
        return this;
    }

    public FileUploader signedUpload(String signature, String expire) {
        this.signature = signature;
        this.expire = expire;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private com.uploadcare.api.File directUpload(String name, String contentType) throws UploadFailureException {
        URI uploadUrl = Urls.uploadBase();
        HttpPost request = new HttpPost(uploadUrl);
        MultipartEntityBuilder entityBuilder = MultipartEntityBuilder.create();
        entityBuilder.addTextBody("UPLOADCARE_PUB_KEY", this.client.getPublicKey());
        entityBuilder.addTextBody("UPLOADCARE_STORE", this.store);
        if (!TextUtils.isEmpty((CharSequence)this.signature) && !TextUtils.isEmpty((CharSequence)this.expire)) {
            entityBuilder.addTextBody("signature", this.signature);
            entityBuilder.addTextBody("expire", this.expire);
        }
        if (this.file != null) {
            entityBuilder.addPart("file", (ContentBody)new FileBody(this.file, ContentType.create((String)contentType), name));
        } else if (this.temporaryFile != null) {
            entityBuilder.addPart("file", (ContentBody)new FileBody(this.temporaryFile, ContentType.create((String)contentType), name));
        } else if (this.bytes != null) {
            entityBuilder.addPart("file", (ContentBody)new ByteArrayBody(this.bytes, ContentType.create((String)contentType), name));
        }
        request.setEntity(entityBuilder.build());
        String fileId = null;
        try {
            fileId = this.client.getRequestHelper().executeQuery((HttpUriRequest)request, (boolean)false, UploadBaseData.class).file;
        }
        finally {
            if (this.temporaryFile != null) {
                this.temporaryFile.delete();
            }
        }
        if (this.client.getSecretKey() != null) {
            return this.client.getFile(fileId);
        }
        return this.client.getUploadedFile(fileId);
    }

    private com.uploadcare.api.File multipartUpload(String name, long size, String contentType) throws UploadFailureException {
        UploadMultipartStartData multipartData = this.startMultipartUpload(name, size, contentType);
        try {
            this.uploadParts(multipartData, name, contentType);
        }
        catch (IOException e) {
            throw new UploadFailureException(e);
        }
        finally {
            if (this.temporaryFile != null) {
                this.temporaryFile.delete();
            }
        }
        UploadMultipartCompleteData multipartComplete = this.completeMultipartUpload(multipartData.uuid);
        if (this.client.getSecretKey() != null) {
            return this.client.getFile(multipartComplete.uuid);
        }
        return this.client.getUploadedFile(multipartComplete.uuid);
    }

    private UploadMultipartStartData startMultipartUpload(String name, long size, String contentType) {
        MultipartEntityBuilder entityBuilder = MultipartEntityBuilder.create();
        entityBuilder.addTextBody("UPLOADCARE_PUB_KEY", this.client.getPublicKey());
        entityBuilder.addTextBody("UPLOADCARE_STORE", this.store);
        if (!TextUtils.isEmpty((CharSequence)this.signature) && !TextUtils.isEmpty((CharSequence)this.expire)) {
            entityBuilder.addTextBody("signature", this.signature);
            entityBuilder.addTextBody("expire", this.expire);
        }
        entityBuilder.addTextBody("filename", name);
        entityBuilder.addTextBody("size", String.valueOf(size));
        entityBuilder.addTextBody("content_type", contentType);
        URI uploadUrl = Urls.uploadMultipartStart();
        HttpPost request = new HttpPost(uploadUrl);
        request.setEntity(entityBuilder.build());
        return this.client.getRequestHelper().executeQuery((HttpUriRequest)request, false, UploadMultipartStartData.class);
    }

    private UploadMultipartCompleteData completeMultipartUpload(String uuid) {
        MultipartEntityBuilder entityBuilder = MultipartEntityBuilder.create();
        entityBuilder.addTextBody("UPLOADCARE_PUB_KEY", this.client.getPublicKey());
        entityBuilder.addTextBody("uuid", uuid);
        URI uploadUrl = Urls.uploadMultipartComplete();
        HttpPost request = new HttpPost(uploadUrl);
        request.setEntity(entityBuilder.build());
        return this.client.getRequestHelper().executeQuery((HttpUriRequest)request, false, UploadMultipartCompleteData.class);
    }

    private void partRequest(String partUrl, byte[] bytes, String contentType) {
        URI uploadUrl = Urls.uploadMultipartPart(partUrl);
        HttpPut request = new HttpPut(uploadUrl);
        EntityBuilder entityBuilder = EntityBuilder.create();
        entityBuilder.setBinary(bytes);
        entityBuilder.setContentType(ContentType.create((String)contentType));
        request.setEntity(entityBuilder.build());
        this.client.getRequestHelper().executeCommand((HttpUriRequest)request, false);
    }

    private void uploadParts(UploadMultipartStartData multipartData, String name, String contentType) throws IOException {
        InputStream is = null;
        if (this.file != null) {
            is = new FileInputStream(this.file);
        } else if (this.temporaryFile != null) {
            is = new FileInputStream(this.temporaryFile);
        } else if (this.bytes != null) {
            is = new ByteArrayInputStream(this.bytes);
        }
        if (is == null) {
            throw new IOException();
        }
        byte[] buffer = new byte[0x500000];
        int i = 0;
        int read = 0;
        while ((read = is.read(buffer)) > 0) {
            byte[] bytes = Arrays.copyOf(buffer, read);
            String partUrl = multipartData.parts.get(i);
            this.partRequest(partUrl, bytes, contentType);
            ++i;
        }
        is.close();
    }

    private File generateTemporaryFile(InputStream inputStream, String name) throws IOException {
        File tempFile = File.createTempFile("temp_upload_file", null);
        FileUtils.copyInputStreamToFile((InputStream)inputStream, (File)tempFile);
        return tempFile;
    }
}

