/*
 * Decompiled with CFR 0.152.
 */
package com.uploadcare.urls;

import com.uploadcare.urls.CdnPathBuilder;
import com.uploadcare.urls.UrlUtils;
import java.net.URI;
import org.apache.http.client.utils.URIBuilder;

public class Urls {
    public static final String API_BASE = "https://api.uploadcare.com";
    private static final String CDN_BASE = "https://ucarecdn.com";
    private static final String UPLOAD_BASE = "https://upload.uploadcare.com";

    public static URI apiProject() {
        return URI.create("https://api.uploadcare.com/project/");
    }

    public static URI apiGroup(String groupId) {
        return URI.create("https://api.uploadcare.com/groups/" + groupId + "/");
    }

    public static URI apiUploadedGroup(String publicKey, String groupId) {
        URIBuilder builder = new URIBuilder(URI.create(UPLOAD_BASE));
        builder.setPath("/group/info/").setParameter("pub_key", publicKey).setParameter("group_id", groupId);
        return UrlUtils.trustedBuild(builder);
    }

    public static URI apiUploadedFile(String publicKey, String fileId) {
        URIBuilder builder = new URIBuilder(URI.create(UPLOAD_BASE));
        builder.setPath("/info/").setParameter("pub_key", publicKey).setParameter("file_id", fileId);
        return UrlUtils.trustedBuild(builder);
    }

    public static URI apiFile(String fileId) {
        return URI.create("https://api.uploadcare.com/files/" + fileId + "/");
    }

    public static URI getFileWithFields(String fileId, String fields) {
        URIBuilder builder = new URIBuilder(URI.create(API_BASE));
        builder.setPath("/files/" + fileId + "/").setParameter("add_fields", fields);
        return UrlUtils.trustedBuild(builder);
    }

    public static URI apiFileStorage(String fileId) {
        return URI.create("https://api.uploadcare.com/files/" + fileId + "/storage/");
    }

    public static URI apiFiles() {
        return URI.create("https://api.uploadcare.com/files/");
    }

    public static URI apiFileLocalCopy() {
        return URI.create("https://api.uploadcare.com/files/local_copy/");
    }

    public static URI apiFileRemoteCopy() {
        return URI.create("https://api.uploadcare.com/files/remote_copy/");
    }

    public static URI apiFilesBatch() {
        return URI.create("https://api.uploadcare.com/files/storage/");
    }

    public static URI apiCreateGroup() {
        return URI.create("https://upload.uploadcare.com/group/");
    }

    public static URI apiGroups() {
        return URI.create("https://api.uploadcare.com/groups/");
    }

    public static URI apiGroupStorage(String groupId) {
        return URI.create("https://api.uploadcare.com/groups/" + groupId + "/storage/");
    }

    public static URI apiWebhooks() {
        return URI.create("https://api.uploadcare.com/webhooks/");
    }

    public static URI apiWebhook(int webhookId) {
        return URI.create("https://api.uploadcare.com/webhooks/" + webhookId + "/");
    }

    public static URI apiDeleteWebhook() {
        return URI.create("https://api.uploadcare.com/webhooks/unsubscribe/");
    }

    public static URI cdn(CdnPathBuilder builder) {
        return URI.create(CDN_BASE + builder.build());
    }

    public static URI uploadBase() {
        return URI.create("https://upload.uploadcare.com/base/");
    }

    public static URI uploadFromUrl() {
        return URI.create("https://upload.uploadcare.com/from_url/");
    }

    public static URI uploadFromUrlStatus(String token) {
        URIBuilder builder = new URIBuilder(URI.create(UPLOAD_BASE));
        builder.setPath("/from_url/status/").setParameter("token", token);
        return UrlUtils.trustedBuild(builder);
    }

    public static URI uploadMultipartStart() {
        return URI.create("https://upload.uploadcare.com/multipart/start/");
    }

    public static URI uploadMultipartPart(String preSignedPartUrl) {
        return URI.create(preSignedPartUrl);
    }

    public static URI uploadMultipartComplete() {
        return URI.create("https://upload.uploadcare.com/multipart/complete/");
    }
}

