/*
 * Decompiled with CFR 0.152.
 */
package RDP_Util.viewer.FileMng;

import RDP_Util.main;
import RDP_Util.utilities.FileUtility;
import RDP_Util.viewer.Recorder;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.LayoutStyle;
import javax.swing.SwingWorker;

public class FileTransGUI
extends JFrame {
    private Recorder recorder;
    private boolean canceled = false;
    private boolean done = false;
    private File[] files;
    private long index = 0L;
    private long count = 0L;
    private long size = 0L;
    private long startedAt = 0L;
    private long duration = 0L;
    private long speed = 0L;
    private float leftEstim = 0.0f;
    private float totalEstim = 0.0f;
    private SwingWorker sendingWorker = new SwingWorker(){

        protected Object doInBackground() throws Exception {
            ((FileTransGUI)FileTransGUI.this).recorder.fileManager.SendFiles(FileTransGUI.this, FileTransGUI.this.files);
            throw new UnsupportedOperationException("Not supported yet.");
        }

        protected void done() {
            FileTransGUI.this.Done();
        }
    };
    private SwingWorker receivingWorker = new SwingWorker(){

        protected Object doInBackground() throws Exception {
            ((FileTransGUI)FileTransGUI.this).recorder.fileManager.ReceiveFiles(FileTransGUI.this, FileTransGUI.this.files);
            throw new UnsupportedOperationException("Not supported yet.");
        }

        protected void done() {
            FileTransGUI.this.Done();
        }
    };
    private JButton jButtonClose;
    private JLabel jLabel1;
    private JLabel jLabelCurrentFile;
    private JLabel jLabelDuration;
    private JLabel jLabelFileCount;
    private JLabel jLabelSpeed;
    private JLabel jLabelTotalSize;
    private JPanel jPanel1;
    private JProgressBar jProgressBar1;

    public FileTransGUI(Recorder recorder) {
        this.recorder = recorder;
        this.initComponents();
        this.setVisible(true);
        this.startedAt = System.currentTimeMillis();
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jProgressBar1 = new JProgressBar();
        this.jLabel1 = new JLabel();
        this.jLabelCurrentFile = new JLabel();
        this.jLabelFileCount = new JLabel();
        this.jLabelTotalSize = new JLabel();
        this.jLabelSpeed = new JLabel();
        this.jLabelDuration = new JLabel();
        this.jButtonClose = new JButton();
        this.setDefaultCloseOperation(0);
        this.setTitle("File Transmission");
        this.setIconImage(new ImageIcon(main.IDLE_ICON).getImage());
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                FileTransGUI.this.formWindowClosing(evt);
            }
        });
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(""));
        this.jProgressBar1.setMaximumSize(new Dimension(150, 20));
        this.jProgressBar1.setMinimumSize(new Dimension(150, 20));
        this.jProgressBar1.setPreferredSize(new Dimension(150, 20));
        this.jProgressBar1.setStringPainted(true);
        this.jLabel1.setText("Current file:");
        this.jLabelFileCount.setText("0 file(s)");
        this.jLabelTotalSize.setText("0 KB");
        this.jLabelSpeed.setText("0 KB/S");
        this.jLabelDuration.setText("0 Seconds");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabelDuration).addComponent(this.jLabel1)).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(jPanel1Layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabelCurrentFile, -2, 314, -2)).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jLabelSpeed).addGap(105, 105, 105))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 83, Short.MAX_VALUE).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabelFileCount).addComponent(this.jLabelTotalSize)).addGap(7, 7, 7)).addGroup(jPanel1Layout.createSequentialGroup().addGap(18, 18, 18).addComponent(this.jProgressBar1, -2, 471, -2))).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jLabel1, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jLabelCurrentFile, GroupLayout.Alignment.LEADING, -1, 14, Short.MAX_VALUE)).addComponent(this.jLabelFileCount, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jProgressBar1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabelDuration).addComponent(this.jLabelSpeed).addComponent(this.jLabelTotalSize)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jButtonClose.setText("Cancel");
        this.jButtonClose.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FileTransGUI.this.jButtonCloseActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jButtonClose).addComponent(this.jPanel1, -2, 518, -2)).addGap(19, 19, 19)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jButtonClose).addContainerGap()));
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds((screenSize.width - 555) / 2, (screenSize.height - 170) / 2, 555, 170);
    }

    private void jButtonCloseActionPerformed(ActionEvent evt) {
        if (this.done) {
            this.dispose();
        } else if (JOptionPane.showConfirmDialog(this, "Stop file transmission ?", "Confirm Dialog", 0, 2) == 0) {
            this.canceled = true;
            this.dispose();
        }
    }

    private void formWindowClosing(WindowEvent evt) {
        if (evt.getID() == 201) {
            this.jButtonCloseActionPerformed(null);
        } else {
            super.processWindowEvent(evt);
        }
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public void Done() {
        this.done = true;
        this.jButtonClose.setText("Close");
        this.setTitle("File Transmission [Done !! ]");
    }

    public void ReceiveFiles(ArrayList arrayList) {
        this.setTitle("File Transmission [Receiving ...]");
        this.recorder.fileManager.setServerDownloadingFolder(arrayList.get(0).toString());
        this.recorder.fileManager.setDownloadingFolder(FileUtility.getCurrentDirectory());
        this.files = (File[])arrayList.get(1);
        this.count = this.files.length;
        this.receivingWorker.execute();
    }

    public void SendFiles(File[] _files) {
        this.setTitle("File Transmission [Sending ...]");
        this.recorder.fileManager.setUploadingFolder(_files[0].getParent() + File.separatorChar);
        this.files = FileUtility.getAllFiles(_files);
        this.count = this.files.length;
        this.sendingWorker.execute();
    }

    public void setCurrentFile(String filename) {
        this.jLabelCurrentFile.setText(filename);
    }

    public void updateData(long size) {
        this.size = size;
        ++this.index;
        this.duration = System.currentTimeMillis() - this.startedAt;
        this.speed = size / (this.duration + 1L);
        this.leftEstim = (float)this.duration / (float)this.index;
        this.totalEstim = this.leftEstim * (float)this.count;
        this.jLabelFileCount.setText(String.valueOf(this.index) + "/" + String.valueOf(this.count) + " file(s)");
        this.jLabelTotalSize.setText(String.valueOf(size / 1000L) + " KB");
        this.jLabelDuration.setText(String.valueOf(this.duration / 1000L) + " Seconds");
        this.jLabelSpeed.setText(String.valueOf(this.speed) + " KB/S");
        this.jProgressBar1.setMaximum((int)this.totalEstim);
        this.jProgressBar1.setValue((int)(this.leftEstim * (float)this.index));
    }
}

