/*
 * Decompiled with CFR 0.152.
 */
package RDP_Util.viewer;

import RDP_Util.ConnectionInfos;
import RDP_Util.HostProperties;
import RDP_Util.utilities.ClipbrdUtility;
import RDP_Util.utilities.InetAdrUtility;
import RDP_Util.utilities.ZipUtility;
import RDP_Util.viewer.FileMng.FileManager;
import RDP_Util.viewer.FileMng.FileTransGUI;
import RDP_Util.viewer.ScreenPlayer;
import RDP_Util.viewer.ViewerData;
import RDP_Util.viewer.ViewerGUI;
import RDP_Util.viewer.rmi.Viewer;
import java.awt.Rectangle;
import java.io.File;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.swing.ImageIcon;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Recorder
extends Thread {
    private boolean recording = false;
    private boolean viewOnly = false;
    private boolean pause = false;
    public Viewer viewer;
    public ViewerGUI viewerGUI;
    public ScreenPlayer screenPlayer;
    public ClipbrdUtility clipbrdUtility;
    public ViewerData viewerData;
    public FileManager fileManager;
    public ConnectionInfos connectionInfos;

    public Recorder(Viewer viewer) {
        this.viewer = viewer;
        this.start();
        this.clipbrdUtility = new ClipbrdUtility();
        this.fileManager = new FileManager(this);
        this.connectionInfos = new ConnectionInfos(false);
        this.viewerData = new ViewerData(InetAdrUtility.getLocalAdr());
        this.screenPlayer = new ScreenPlayer(this);
        this.viewerGUI = new ViewerGUI(this);
    }

    @Override
    public void run() {
        block0: while (true) {
            this.Wait();
            while (true) {
                if (!this.recording || this.pause) continue block0;
                this.viewer.sendData();
                this.viewer.recieveData();
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Wait() {
        try {
            Recorder recorder = this;
            synchronized (recorder) {
                this.wait();
            }
        }
        catch (Exception e) {
            e.getStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void Notify() {
        try {
            Recorder recorder = this;
            synchronized (recorder) {
                this.notify();
            }
        }
        catch (Exception e) {
            e.getStackTrace();
        }
    }

    public void Stop() {
        this.recording = false;
        this.pause = true;
        this.viewOnly = false;
        this.clipbrdUtility.removeFlavorListener();
        this.screenPlayer.removeAdapters();
        this.screenPlayer.clearScreen();
        if (this.viewerGUI.isFullScreenMode()) {
            this.viewerGUI.changeFullScreenMode();
        }
        this.viewerData.setScreenRect(new Rectangle(0, 0, 0, 0));
        this.viewer.disconnect();
    }

    public void Start() {
        if (!this.viewer.isConnected() && this.viewer.connect() == -1) {
            return;
        }
        this.viewer.updateOptions();
        this.connectionInfos.init();
        this.clipbrdUtility.addFlavorListener();
        this.screenPlayer.addAdapters();
        this.recording = true;
        this.pause = false;
        this.viewOnly = false;
        this.Notify();
    }

    public boolean isRecording() {
        return this.recording;
    }

    public boolean isPaused() {
        return this.pause;
    }

    public void setPause(boolean bool) {
        this.pause = bool;
        if (this.pause) {
            this.screenPlayer.removeAdapters();
        } else {
            if (this.recording && !this.viewOnly) {
                this.screenPlayer.addAdapters();
            }
            if (this.recording) {
                this.Notify();
            }
        }
    }

    public void setViewOnly(boolean bool) {
        this.viewOnly = bool;
        if (this.viewOnly) {
            this.screenPlayer.removeAdapters();
        } else if (this.recording && !this.pause) {
            this.screenPlayer.addAdapters();
        }
    }

    public boolean isViewOnly() {
        return this.viewOnly;
    }

    public ArrayList<Object> getViewerData() {
        ArrayList<Object> data = new ArrayList<Object>();
        data.add(Float.valueOf(this.viewerData.getScreenScale()));
        data.add(this.viewerData.getScreenRect());
        data.add(this.viewerData.getCompressionLevel());
        data.add(this.viewerData.isDataCompressionEnabled());
        data.add(Float.valueOf(this.viewerData.getImageQuality()));
        data.add(this.viewerData.getColorQuality());
        data.add(this.viewerData.isClipboardTransferEnabled());
        data.add(this.viewerData.getInetAddress());
        return data;
    }

    public void updateAllData(ArrayList objects) {
        this.screenPlayer.UpdateScreen((byte[])objects.get(0));
        Object object = null;
        try {
            byte[] data = (byte[])objects.get(1);
            object = this.viewerData.isDataCompressionEnabled() ? ZipUtility.decompressObject(data) : ZipUtility.byteArraytoObject(data);
            this.updataData((ArrayList)object);
        }
        catch (Exception e) {
            e.getStackTrace();
        }
    }

    public void updataData(ArrayList objects) {
        for (int i = 0; i < objects.size(); ++i) {
            Object obj = objects.get(i);
            if (obj instanceof Rectangle) {
                this.viewerData.setScreenRect((Rectangle)obj);
                continue;
            }
            if (obj instanceof String) {
                this.clipbrdUtility.setTextToClipboard((String)obj);
                continue;
            }
            if (obj instanceof ImageIcon) {
                this.clipbrdUtility.setImageToClipboard((ImageIcon)obj);
                continue;
            }
            if (obj instanceof File) {
                File[] files = this.fileManager.getFiles();
                if (files.length == 0) {
                    return;
                }
                new FileTransGUI(this).SendFiles(files);
                continue;
            }
            if (obj instanceof ArrayList) {
                new FileTransGUI(this).ReceiveFiles((ArrayList)obj);
                continue;
            }
            if (!(obj instanceof Hashtable)) continue;
            HostProperties.displayRemoteProperties((Hashtable)obj);
        }
    }
}

