/*
 * Decompiled with CFR 0.152.
 */
package RDP_Util.viewer;

import RDP_Util.AboutGUI;
import RDP_Util.SysTray;
import RDP_Util.main;
import RDP_Util.viewer.Config;
import RDP_Util.viewer.Recorder;
import java.awt.Dimension;
import java.awt.GraphicsDevice;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Hashtable;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ViewerGUI
extends JFrame {
    private final byte COLOR_FULL = 0;
    private final byte COLOR_16_BIT = 1;
    private final byte COLOR_256 = (byte)2;
    private final byte COLOR_GRAY = (byte)3;
    private boolean fullScreenMode = false;
    private Recorder recorder;
    private JButton jBtnAbout;
    private JButton jBtnClose;
    private JButton jBtnConnectionInfos;
    private JButton jBtnFileTransfer;
    private JButton jBtnFullNormal;
    public JButton jBtnPartialComplete;
    private JButton jBtnServerProps;
    private JButton jBtnStartStop;
    private JButton jBtnViewCtrl;
    private JCheckBox jCheckBoxCQ;
    private JCheckBox jCheckBoxClipTrans;
    private JCheckBox jCheckBoxDC;
    private JComboBox jComboBoxCL;
    private JComboBox jComboBoxColorQuality;
    private JComboBox jComboBoxSc;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JMenuItem jMenuItemReceiveFiles;
    private JMenuItem jMenuItemSendFiles;
    private JPopupMenu jPopupMenuFileTranfer;
    private JScrollPane jScrollPane1;
    private JToolBar.Separator jSeparator1;
    private JToolBar.Separator jSeparator10;
    private JToolBar.Separator jSeparator11;
    private JToolBar.Separator jSeparator12;
    private JToolBar.Separator jSeparator4;
    private JToolBar.Separator jSeparator5;
    private JToolBar.Separator jSeparator6;
    private JToolBar.Separator jSeparator7;
    private JToolBar.Separator jSeparator9;
    private JSlider jSlider1;
    private JToggleButton jToggleBtnPauseResume;
    private JToolBar jToolBar1;

    public ViewerGUI(Recorder recorder) {
        this.recorder = recorder;
        this.initComponents();
        this.jScrollPane1.setViewportView(recorder.screenPlayer);
        this.setVisible(true);
    }

    public void Start() {
        this.jBtnStartStopActionPerformed(null);
    }

    private void initComponents() {
        this.jPopupMenuFileTranfer = new JPopupMenu();
        this.jMenuItemSendFiles = new JMenuItem();
        this.jMenuItemReceiveFiles = new JMenuItem();
        this.jToolBar1 = new JToolBar();
        this.jBtnStartStop = new JButton();
        this.jToggleBtnPauseResume = new JToggleButton();
        this.jBtnViewCtrl = new JButton();
        this.jSeparator1 = new JToolBar.Separator();
        this.jBtnFullNormal = new JButton();
        this.jBtnPartialComplete = new JButton();
        this.jSeparator9 = new JToolBar.Separator();
        this.jLabel2 = new JLabel();
        this.jComboBoxSc = new JComboBox();
        this.jSeparator7 = new JToolBar.Separator();
        this.jLabel3 = new JLabel();
        this.jCheckBoxDC = new JCheckBox();
        this.jComboBoxCL = new JComboBox();
        this.jSeparator4 = new JToolBar.Separator();
        this.jLabel4 = new JLabel();
        this.jCheckBoxCQ = new JCheckBox();
        this.jSlider1 = new JSlider();
        this.jSeparator11 = new JToolBar.Separator();
        this.jLabel1 = new JLabel();
        this.jComboBoxColorQuality = new JComboBox();
        this.jSeparator5 = new JToolBar.Separator();
        this.jLabel5 = new JLabel();
        this.jCheckBoxClipTrans = new JCheckBox();
        this.jBtnFileTransfer = new JButton();
        this.jSeparator6 = new JToolBar.Separator();
        this.jBtnConnectionInfos = new JButton();
        this.jBtnServerProps = new JButton();
        this.jSeparator12 = new JToolBar.Separator();
        this.jBtnAbout = new JButton();
        this.jBtnClose = new JButton();
        this.jSeparator10 = new JToolBar.Separator();
        this.jScrollPane1 = new JScrollPane();
        this.jMenuItemSendFiles.setText("Send files");
        this.jMenuItemSendFiles.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ViewerGUI.this.jMenuItemSendFilesActionPerformed(evt);
            }
        });
        this.jPopupMenuFileTranfer.add(this.jMenuItemSendFiles);
        this.jMenuItemReceiveFiles.setText("Receive files");
        this.jMenuItemReceiveFiles.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ViewerGUI.this.jMenuItemReceiveFilesActionPerformed(evt);
            }
        });
        this.jPopupMenuFileTranfer.add(this.jMenuItemReceiveFiles);
        this.setDefaultCloseOperation(0);
        this.setTitle(" jrdesktop Viewer");
        this.setIconImage(new ImageIcon(main.WAIT_ICON).getImage());
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                ViewerGUI.this.formWindowClosing(evt);
            }
        });
        this.jToolBar1.setFloatable(false);
        this.jToolBar1.setAlignmentY(0.5f);
        this.jToolBar1.setMaximumSize(new Dimension(713, 35));
        this.jBtnStartStop.setIcon(new ImageIcon(this.getClass().getResource("/jrdesktop/images/player_stop.png")));
        this.jBtnStartStop.setToolTipText("Start/Stop recording");
        this.jBtnStartStop.setFocusable(false);
        this.jBtnStartStop.setHorizontalTextPosition(0);
        this.jBtnStartStop.setVerticalTextPosition(3);
        this.jBtnStartStop.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ViewerGUI.this.jBtnStartStopActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jBtnStartStop);
        this.jToggleBtnPauseResume.setIcon(new ImageIcon(this.getClass().getResource("/jrdesktop/images/player_pause.png")));
        this.jToggleBtnPauseResume.setToolTipText("Pause/Resume recording");
        this.jToggleBtnPauseResume.setFocusable(false);
        this.jToggleBtnPauseResume.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ViewerGUI.this.jToggleBtnPauseResumeActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jToggleBtnPauseResume);
        this.jBtnViewCtrl.setIcon(new ImageIcon(this.getClass().getResource("/jrdesktop/images/locked_inputs.png")));
        this.jBtnViewCtrl.setToolTipText("View only / Full control");
        this.jBtnViewCtrl.setFocusable(false);
        this.jBtnViewCtrl.setHorizontalTextPosition(0);
        this.jBtnViewCtrl.setVerticalTextPosition(3);
        this.jBtnViewCtrl.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ViewerGUI.this.jBtnViewCtrlActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jBtnViewCtrl);
        this.jToolBar1.add(this.jSeparator1);
        this.jBtnFullNormal.setIcon(new ImageIcon(this.getClass().getResource("/jrdesktop/images/view_fullscreen.png")));
        this.jBtnFullNormal.setToolTipText("Full / Normal screen");
        this.jBtnFullNormal.setFocusable(false);
        this.jBtnFullNormal.setHorizontalTextPosition(0);
        this.jBtnFullNormal.setVerticalTextPosition(3);
        this.jBtnFullNormal.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ViewerGUI.this.jBtnFullNormalActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jBtnFullNormal);
        this.jBtnPartialComplete.setIcon(new ImageIcon(this.getClass().getResource("/jrdesktop/images/custom_screen.png")));
        this.jBtnPartialComplete.setToolTipText("Custom / Default screen");
        this.jBtnPartialComplete.setFocusable(false);
        this.jBtnPartialComplete.setHorizontalTextPosition(0);
        this.jBtnPartialComplete.setVerticalTextPosition(3);
        this.jBtnPartialComplete.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ViewerGUI.this.jBtnPartialCompleteActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jBtnPartialComplete);
        this.jToolBar1.add(this.jSeparator9);
        this.jLabel2.setIcon(new ImageIcon(this.getClass().getResource("/jrdesktop/images/scale.png")));
        this.jLabel2.setText(" ");
        this.jLabel2.setToolTipText("Screen zoom ");
        this.jLabel2.setFocusable(false);
        this.jToolBar1.add(this.jLabel2);
        this.jComboBoxSc.setModel(new DefaultComboBoxModel<String>(new String[]{"25", "50", "75", "100", "125", "150", "200"}));
        this.jComboBoxSc.setSelectedIndex(3);
        this.jComboBoxSc.setToolTipText("Change screen zoom");
        this.jComboBoxSc.setFocusable(false);
        this.jComboBoxSc.setMaximumSize(new Dimension(55, 20));
        this.jComboBoxSc.setMinimumSize(new Dimension(55, 20));
        this.jComboBoxSc.setPreferredSize(new Dimension(55, 20));
        this.jComboBoxSc.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                ViewerGUI.this.jComboBoxScItemStateChanged(evt);
            }
        });
        this.jToolBar1.add(this.jComboBoxSc);
        this.jToolBar1.add(this.jSeparator7);
        this.jLabel3.setIcon(new ImageIcon(this.getClass().getResource("/jrdesktop/images/compress.png")));
        this.jLabel3.setToolTipText("Data compression");
        this.jLabel3.setFocusable(false);
        this.jToolBar1.add(this.jLabel3);
        this.jCheckBoxDC.setSelected(true);
        this.jCheckBoxDC.setToolTipText("Enable/Disable Data compression");
        this.jCheckBoxDC.setFocusable(false);
        this.jCheckBoxDC.setHorizontalAlignment(11);
        this.jCheckBoxDC.setHorizontalTextPosition(2);
        this.jCheckBoxDC.setVerticalTextPosition(3);
        this.jCheckBoxDC.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ViewerGUI.this.jCheckBoxDCActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jCheckBoxDC);
        this.jComboBoxCL.setModel(new DefaultComboBoxModel<String>(new String[]{"Best", "Default", "Fastest", "Store"}));
        this.jComboBoxCL.setSelectedIndex(1);
        this.jComboBoxCL.setToolTipText("Change compression level");
        this.jComboBoxCL.setFocusable(false);
        this.jComboBoxCL.setMaximumSize(new Dimension(85, 20));
        this.jComboBoxCL.setMinimumSize(new Dimension(85, 20));
        this.jComboBoxCL.setPreferredSize(new Dimension(85, 20));
        this.jComboBoxCL.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                ViewerGUI.this.jComboBoxCLItemStateChanged(evt);
            }
        });
        this.jToolBar1.add(this.jComboBoxCL);
        this.jToolBar1.add(this.jSeparator4);
        this.jLabel4.setIcon(new ImageIcon(this.getClass().getResource("/jrdesktop/images/jpeg.png")));
        this.jLabel4.setToolTipText("JPEG image quality");
        this.jLabel4.setFocusable(false);
        this.jToolBar1.add(this.jLabel4);
        this.jCheckBoxCQ.setToolTipText("Enable/Disable JPEG image quality");
        this.jCheckBoxCQ.setFocusable(false);
        this.jCheckBoxCQ.setHorizontalTextPosition(2);
        this.jCheckBoxCQ.setVerticalTextPosition(3);
        this.jCheckBoxCQ.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ViewerGUI.this.jCheckBoxCQActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jCheckBoxCQ);
        this.jSlider1.setMajorTickSpacing(1);
        this.jSlider1.setMaximum(10);
        this.jSlider1.setMinorTickSpacing(1);
        this.jSlider1.setPaintTicks(true);
        this.jSlider1.setToolTipText("Change JPEG image quality");
        this.jSlider1.setValue(7);
        this.jSlider1.setEnabled(false);
        this.jSlider1.setFocusable(false);
        this.jSlider1.setMaximumSize(new Dimension(100, 33));
        this.jSlider1.setMinimumSize(new Dimension(100, 33));
        this.jSlider1.setPreferredSize(new Dimension(100, 33));
        this.jSlider1.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                ViewerGUI.this.jSlider1StateChanged(evt);
            }
        });
        this.jToolBar1.add(this.jSlider1);
        this.jToolBar1.add(this.jSeparator11);
        this.jLabel1.setIcon(new ImageIcon(this.getClass().getResource("/jrdesktop/images/colors.png")));
        this.jLabel1.setText(" ");
        this.jLabel1.setToolTipText("Color quality");
        this.jLabel1.setFocusable(false);
        this.jToolBar1.add(this.jLabel1);
        this.jComboBoxColorQuality.setModel(new DefaultComboBoxModel<String>(new String[]{"Full colors", "16 bit colors", "256 colors", "Gray color"}));
        this.jComboBoxColorQuality.setToolTipText("Change color quality");
        this.jComboBoxColorQuality.setFocusable(false);
        this.jComboBoxColorQuality.setLightWeightPopupEnabled(false);
        this.jComboBoxColorQuality.setMaximumSize(new Dimension(105, 20));
        this.jComboBoxColorQuality.setMinimumSize(new Dimension(105, 20));
        this.jComboBoxColorQuality.setPreferredSize(new Dimension(105, 20));
        this.jComboBoxColorQuality.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                ViewerGUI.this.jComboBoxColorQualityItemStateChanged(evt);
            }
        });
        this.jToolBar1.add(this.jComboBoxColorQuality);
        this.jToolBar1.add(this.jSeparator5);
        this.jLabel5.setIcon(new ImageIcon(this.getClass().getResource("/jrdesktop/images/clip_trans.png")));
        this.jLabel5.setToolTipText("Clipboard tranfer");
        this.jLabel5.setFocusable(false);
        this.jToolBar1.add(this.jLabel5);
        this.jCheckBoxClipTrans.setSelected(true);
        this.jCheckBoxClipTrans.setToolTipText("Enable/Disable Clipboard transfer");
        this.jCheckBoxClipTrans.setFocusable(false);
        this.jCheckBoxClipTrans.setHorizontalTextPosition(2);
        this.jCheckBoxClipTrans.setVerticalTextPosition(3);
        this.jCheckBoxClipTrans.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ViewerGUI.this.jCheckBoxClipTransActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jCheckBoxClipTrans);
        this.jBtnFileTransfer.setIcon(new ImageIcon(this.getClass().getResource("/jrdesktop/images/file_trans.png")));
        this.jBtnFileTransfer.setToolTipText("File transfer");
        this.jBtnFileTransfer.setFocusable(false);
        this.jBtnFileTransfer.setHorizontalTextPosition(0);
        this.jBtnFileTransfer.setVerticalTextPosition(3);
        this.jBtnFileTransfer.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ViewerGUI.this.jBtnFileTransferActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jBtnFileTransfer);
        this.jToolBar1.add(this.jSeparator6);
        this.jBtnConnectionInfos.setIcon(new ImageIcon(this.getClass().getResource("/jrdesktop/images/info.png")));
        this.jBtnConnectionInfos.setToolTipText("Connection infos");
        this.jBtnConnectionInfos.setFocusable(false);
        this.jBtnConnectionInfos.setHorizontalTextPosition(0);
        this.jBtnConnectionInfos.setVerticalTextPosition(3);
        this.jBtnConnectionInfos.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ViewerGUI.this.jBtnConnectionInfosActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jBtnConnectionInfos);
        this.jBtnServerProps.setIcon(new ImageIcon(this.getClass().getResource("/jrdesktop/images/props.png")));
        this.jBtnServerProps.setToolTipText("Server properties");
        this.jBtnServerProps.setFocusable(false);
        this.jBtnServerProps.setHorizontalTextPosition(0);
        this.jBtnServerProps.setVerticalTextPosition(3);
        this.jBtnServerProps.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ViewerGUI.this.jBtnServerPropsActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jBtnServerProps);
        this.jToolBar1.add(this.jSeparator12);
        this.jBtnAbout.setIcon(new ImageIcon(this.getClass().getResource("/jrdesktop/images/about.png")));
        this.jBtnAbout.setToolTipText("About jrdesktop");
        this.jBtnAbout.setFocusable(false);
        this.jBtnAbout.setHorizontalTextPosition(0);
        this.jBtnAbout.setVerticalTextPosition(3);
        this.jBtnAbout.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ViewerGUI.this.jBtnAboutActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jBtnAbout);
        this.jBtnClose.setIcon(new ImageIcon(this.getClass().getResource("/jrdesktop/images/exit.png")));
        this.jBtnClose.setToolTipText("Exit viewer");
        this.jBtnClose.setFocusable(false);
        this.jBtnClose.setHorizontalTextPosition(0);
        this.jBtnClose.setVerticalTextPosition(3);
        this.jBtnClose.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ViewerGUI.this.jBtnCloseActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jBtnClose);
        this.jToolBar1.add(this.jSeparator10);
        this.jScrollPane1.setFocusable(false);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jToolBar1, -1, 892, Short.MAX_VALUE).addComponent(this.jScrollPane1, -1, 892, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jToolBar1, -2, 25, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 435, Short.MAX_VALUE)));
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds((screenSize.width - 900) / 2, (screenSize.height - 500) / 2, 900, 500);
    }

    private void jBtnStartStopActionPerformed(ActionEvent evt) {
        if (this.recorder.isRecording()) {
            this.recorder.Stop();
        } else {
            this.recorder.Start();
        }
        if (this.recorder.isRecording()) {
            this.setIconImage(new ImageIcon(main.ALIVE_ICON).getImage());
            this.jBtnStartStop.setIcon(new ImageIcon(main.STOP_ICON));
            this.setTitle("jrdesktop Viewer [" + Config.server_address + "]");
        } else {
            this.setTitle("jrdesktop Viewer");
            this.setIconImage(new ImageIcon(main.WAIT_ICON).getImage());
            this.jBtnStartStop.setIcon(new ImageIcon(main.START_ICON));
            this.jToggleBtnPauseResume.setSelected(false);
            this.jBtnViewCtrl.setIcon(new ImageIcon(main.LOCKED_INPUTS_ICON));
            this.jBtnFullNormal.setIcon(new ImageIcon(main.FULL_SCREEN_ICON));
            this.jBtnPartialComplete.setIcon(new ImageIcon(main.CUSTOM_SCREEN_ICON));
        }
    }

    private void jBtnViewCtrlActionPerformed(ActionEvent evt) {
        this.recorder.setViewOnly(!this.recorder.isViewOnly());
        if (this.recorder.isViewOnly()) {
            this.jBtnViewCtrl.setIcon(new ImageIcon(main.INPUTS_ICON));
        } else {
            this.jBtnViewCtrl.setIcon(new ImageIcon(main.LOCKED_INPUTS_ICON));
        }
    }

    private void jBtnFullNormalActionPerformed(ActionEvent evt) {
        this.changeFullScreenMode();
    }

    private void jBtnPartialCompleteActionPerformed(ActionEvent evt) {
        if (this.recorder.isRecording()) {
            if (this.recorder.screenPlayer.isPartialScreenMode()) {
                this.jBtnPartialComplete.setIcon(new ImageIcon(main.CUSTOM_SCREEN_ICON));
                this.recorder.screenPlayer.stopSelectingMode();
            } else {
                this.recorder.screenPlayer.startSelectingMode();
            }
        }
    }

    private void jSlider1StateChanged(ChangeEvent evt) {
        if (this.jSlider1.getValueIsAdjusting()) {
            this.recorder.viewerData.setImageQuality((float)this.jSlider1.getValue() / 10.0f);
            if (this.recorder.isRecording()) {
                this.recorder.viewer.updateOptions();
            }
        }
    }

    private void jCheckBoxCQActionPerformed(ActionEvent evt) {
        this.jSlider1.setEnabled(this.jCheckBoxCQ.isSelected());
        if (!this.jCheckBoxCQ.isSelected()) {
            this.recorder.viewerData.setImageQuality(-1.0f);
        } else {
            this.recorder.viewerData.setImageQuality((float)this.jSlider1.getValue() / 10.0f);
        }
        if (this.recorder.isRecording()) {
            this.recorder.viewer.updateOptions();
        }
    }

    private void jBtnAboutActionPerformed(ActionEvent evt) {
        AboutGUI.main(null);
    }

    private void jComboBoxColorQualityItemStateChanged(ItemEvent evt) {
        this.setColorQuality(this.jComboBoxColorQuality.getSelectedIndex());
    }

    private void formWindowClosing(WindowEvent evt) {
        if (evt.getID() == 201) {
            this.jBtnCloseActionPerformed(null);
        } else {
            super.processWindowEvent(evt);
        }
    }

    private void jCheckBoxDCActionPerformed(ActionEvent evt) {
        this.jComboBoxCL.setEnabled(this.jCheckBoxDC.isSelected());
        this.recorder.viewerData.setDataCompression(this.jCheckBoxDC.isSelected());
        if (this.recorder.isRecording()) {
            this.recorder.viewer.updateOptions();
        }
    }

    private void jComboBoxScItemStateChanged(ItemEvent evt) {
        this.recorder.viewerData.setScreenScale(Float.valueOf(this.jComboBoxSc.getSelectedItem().toString()).floatValue() / 100.0f);
        if (this.recorder.isRecording()) {
            this.recorder.viewer.updateOptions();
        }
    }

    private void jComboBoxCLItemStateChanged(ItemEvent evt) {
        this.setCompressionLevel(this.jComboBoxCL.getSelectedIndex());
    }

    private void jCheckBoxClipTransActionPerformed(ActionEvent evt) {
        this.setClipboardTransfer(this.jCheckBoxClipTrans.isSelected());
    }

    private void jBtnFileTransferActionPerformed(ActionEvent evt) {
        this.jPopupMenuFileTranfer.show(this.jBtnFileTransfer, 15, 15);
    }

    private void jMenuItemSendFilesActionPerformed(ActionEvent evt) {
        if (!this.recorder.isRecording()) {
            return;
        }
        File[] files = this.recorder.clipbrdUtility.getFiles();
        if (files.length == 0) {
            JOptionPane.showMessageDialog(this, "No file in clipboard !!", "Information", 1);
            return;
        }
        this.recorder.fileManager.setFiles(files);
        this.recorder.viewer.AddObject(new File("."));
    }

    private void jMenuItemReceiveFilesActionPerformed(ActionEvent evt) {
        if (!this.recorder.isRecording()) {
            return;
        }
        this.recorder.viewer.AddObject(new File(".."));
    }

    private void jBtnServerPropsActionPerformed(ActionEvent evt) {
        if (!this.recorder.isRecording()) {
            return;
        }
        this.recorder.viewer.AddObject(new Hashtable(0));
    }

    private void jBtnConnectionInfosActionPerformed(ActionEvent evt) {
        if (!this.recorder.isRecording()) {
            return;
        }
        this.recorder.connectionInfos.display();
    }

    private void jToggleBtnPauseResumeActionPerformed(ActionEvent evt) {
        if (this.recorder.isRecording()) {
            this.recorder.setPause(!this.recorder.isPaused());
            if (this.recorder.isPaused()) {
                this.jToggleBtnPauseResume.setSelected(true);
            } else {
                this.jToggleBtnPauseResume.setSelected(false);
            }
        }
    }

    private void jBtnCloseActionPerformed(ActionEvent evt) {
        if (JOptionPane.showConfirmDialog(null, "Exit Viewer ?", "Confirm Dialog", 2) == 0) {
            if (this.recorder.isRecording()) {
                this.recorder.viewer.Stop();
            }
            if (SysTray.isSupported()) {
                this.dispose();
            } else {
                main.exit();
            }
        }
    }

    public boolean isFullScreenMode() {
        return this.fullScreenMode;
    }

    public void changeFullScreenMode() {
        GraphicsDevice device = this.getGraphicsConfiguration().getDevice();
        if (!device.isFullScreenSupported()) {
            return;
        }
        boolean bl = this.fullScreenMode = !this.fullScreenMode;
        if (this.fullScreenMode) {
            this.dispose();
            this.setUndecorated(true);
            device.setFullScreenWindow(this);
            this.setVisible(true);
            this.jBtnFullNormal.setIcon(new ImageIcon(main.NORMAL_SCREEN_ICON));
        } else {
            this.dispose();
            this.setUndecorated(false);
            device.setFullScreenWindow(null);
            this.setVisible(true);
            this.jBtnFullNormal.setIcon(new ImageIcon(main.FULL_SCREEN_ICON));
        }
    }

    public void setColorQuality(int colorQuality) {
        switch (colorQuality) {
            case 0: {
                colorQuality = 2;
                break;
            }
            case 1: {
                colorQuality = 9;
                break;
            }
            case 2: {
                colorQuality = 13;
                break;
            }
            case 3: {
                colorQuality = 10;
            }
        }
        this.recorder.viewerData.setColorQuality(colorQuality);
        if (this.recorder.isRecording()) {
            this.recorder.viewer.updateOptions();
        }
    }

    public void setCompressionLevel(int index) {
        int level = -1;
        switch (index) {
            case 0: {
                level = 9;
                break;
            }
            case 1: {
                level = -1;
                break;
            }
            case 2: {
                level = 1;
                break;
            }
            case 3: {
                level = 0;
            }
        }
        this.recorder.viewerData.setCompressionLevel(level);
        if (this.recorder.isRecording()) {
            this.recorder.viewer.updateOptions();
        }
    }

    public void setClipboardTransfer(boolean bool) {
        this.recorder.viewerData.setClipboardTransfer(bool);
        if (bool) {
            this.recorder.clipbrdUtility.addFlavorListener();
        } else {
            this.recorder.clipbrdUtility.removeFlavorListener();
        }
        if (this.recorder.isRecording()) {
            this.recorder.viewer.updateOptions();
        }
    }
}

