/*
 * Decompiled with CFR 0.152.
 */
package org.sportdata.setppsanda.anzeige.beans;

import de.schlichtherle.license.CipherParam;
import de.schlichtherle.license.KeyStoreParam;
import de.schlichtherle.license.LicenseContent;
import de.schlichtherle.license.LicenseManager;
import de.schlichtherle.license.LicenseParam;
import java.awt.Point;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.TreeMap;
import java.util.prefs.Preferences;
import javax.swing.UIManager;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.ServletHandler;
import org.sportdata.setppsanda.anzeige.Anzeige;
import org.sportdata.setppsanda.anzeige.beans.ScoringAuthObject;
import org.sportdata.setppsanda.anzeige.beans.ScoringObject;
import org.sportdata.setppsanda.anzeige.components.ProtestComponent;
import org.sportdata.setppsanda.anzeige.components.RefereePointsWindow;
import org.sportdata.setppsanda.anzeige.matchtime.MatchtimeHelper;
import org.sportdata.setppsanda.anzeige.properties.helper.AnzeigePropertiesHelper;
import org.sportdata.setppsanda.anzeige.ressource.AnzeigeResource;
import org.sportdata.setppsanda.anzeige.utils.FehlerFenster;
import org.sportdata.setppsanda.anzeige.utils.HostName;
import org.sportdata.setppsanda.anzeige.utils.LicenseHelper;
import org.sportdata.setppsanda.anzeige.utils.Passwort;
import org.sportdata.setppsanda.server.servlet.ScoringAuthServlet;
import org.sportdata.setppsanda.server.servlet.ScoringCheckstatusServlet;
import org.sportdata.setppsanda.server.servlet.ScoringServlet;
import org.sportdata.setppsanda.swing.components.FadeMessagePopup;

public class AnzeigeMaster {
    private static AnzeigeMaster anzmaster;
    private Properties anzeigeprops = new Properties();
    private LicenseParam licenceParam;
    private LicenseManager licenseManager;
    private LicenseContent licenseContent;
    public static final String SUBJECT = "SET POINT PANEL SANDA";
    private static ResourceBundle resourceBundle;
    private String langueage = "";
    private Server server;
    private Anzeige anzeige;
    private int pin = -1;
    private TreeMap<String, ScoringAuthObject> referees = new TreeMap();
    private int SERVER_PORT = 8080;
    private TreeMap<Integer, ScoringObject> refereesPoints = new TreeMap();
    private boolean decisionmode = false;
    private RefereePointsWindow refereePointsWindow;
    private Point refereeWindowLocation;
    private FadeMessagePopup fadmspopred;
    private FadeMessagePopup fadmspopblue;
    private FadeMessagePopup fadmspopgeneral;
    private TreeMap<Integer, String> wintypes = new TreeMap();
    private ProtestComponent protestclock;
    private HashMap<Integer, Integer> matchtime = new HashMap();
    private Object ath1;
    private Object ath2;
    private Object club1;
    private Object club2;
    private Object nat1;
    private Object nat2;
    private Object cat;
    private LicenseContent templicensecontent;
    private int lastwintypeselected = -1;
    private boolean isembedded = false;
    private String weighta = "";
    private String weightb = "";

    static {
        resourceBundle = ResourceBundle.getBundle("languages.english_ppwakolc");
    }

    public AnzeigeMaster(boolean isembedded) {
        anzmaster = this;
        this.isembedded = isembedded;
        anzmaster.loadProps();
        anzmaster.initLicenseParam();
        anzmaster.initLicenseManager();
        anzmaster.initLicenseContent();
        anzmaster.checkLicense();
        anzmaster.initLanguage();
        anzmaster.startJettyServer();
        anzmaster.generateRandomPin();
        anzmaster.loadRefereesFromProps();
    }

    public AnzeigeMaster(Properties anzeigeprops, Server server, int port, LicenseContent templicensecontent) {
        anzmaster = this;
        this.isembedded = true;
        this.server = server;
        this.SERVER_PORT = port;
        this.templicensecontent = templicensecontent;
        anzmaster.setAnzeigeprops(anzeigeprops);
        anzmaster.initLicenseParam();
        anzmaster.initLicenseManager();
        anzmaster.initLicenseContent();
        anzmaster.checkLicense();
        anzmaster.initLanguage();
        anzmaster.startJettyServer();
        anzmaster.generateRandomPin();
        anzmaster.loadRefereesFromProps();
    }

    public static AnzeigeMaster getInstance() {
        return anzmaster;
    }

    public LicenseContent getTemplicensecontent() {
        return this.templicensecontent;
    }

    public void setTemplicensecontent(LicenseContent templicensecontent) {
        this.templicensecontent = templicensecontent;
    }

    public Properties getAnzeigeprops() {
        return this.anzeigeprops;
    }

    public void initLanguage() {
        this.setLangueage(AnzeigePropertiesHelper.getLanguage());
    }

    public void setAnzeigeprops(Properties wkvprops) {
        this.anzeigeprops = wkvprops;
    }

    public void loadProps() {
        try {
            FileInputStream fis = new FileInputStream("props/set.properties");
            this.anzeigeprops.load(fis);
            fis.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            AnzeigePropertiesHelper.setDefaults();
        }
    }

    public void saveProps() {
        try {
            FileOutputStream fos = new FileOutputStream("props/set.properties");
            this.anzeigeprops.store(fos, "set main properties");
            fos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initLicenseParam() {
        this.licenceParam = new LicenseParam(){
            KeyStoreParam a = new KeyStoreParam(){

                @Override
                public InputStream getStream() throws IOException {
                    String resourceName = "/keystore/publicSETCerts.store";
                    InputStream in = this.getClass().getResourceAsStream("/keystore/publicSETCerts.store");
                    if (in == null) {
                        throw new FileNotFoundException("/keystore/publicSETCerts.store");
                    }
                    return in;
                }

                @Override
                public String getAlias() {
                    return Passwort.deobfuscate("1y7v1yte1sho1u2w1thh1th51u2e1shu1yt81y83");
                }

                @Override
                public String getStorePwd() {
                    return Passwort.deobfuscate("1ym71wmh1jda1vgf1jg01wnp1ym7");
                }

                @Override
                public String getKeyPwd() {
                    return null;
                }
            };
            CipherParam b = new CipherParam(){

                @Override
                public String getKeyPwd() {
                    return Passwort.deobfuscate("1x111saj1y0s19q71y0y1sar1x1l");
                }
            };

            @Override
            public String getSubject() {
                return AnzeigeMaster.SUBJECT;
            }

            @Override
            public Preferences getPreferences() {
                return Preferences.userRoot().node("/set/pointpanelsanda");
            }

            @Override
            public KeyStoreParam getKeyStoreParam() {
                return this.a;
            }

            @Override
            public CipherParam getCipherParam() {
                return this.b;
            }
        };
    }

    private void initLicenseManager() {
        this.licenseManager = new LicenseManager(AnzeigeMaster.getInstance().getLicenceParam());
    }

    public void initLicenseContent() {
        try {
            this.licenseContent = AnzeigeMaster.getInstance().getLicenseManager().verify();
            if (AnzeigeMaster.getInstance().getLicenseContent() != null && LicenseHelper.LBL.containsKey(Passwort.obfuscate(AnzeigeMaster.getInstance().getLicenseContent().getHolder().toString().substring(AnzeigeMaster.getInstance().getLicenseContent().getHolder().toString().indexOf("=") + 1)))) {
                LicenseHelper.deleteLicense();
                AnzeigeMaster.getInstance().initLicenseManager();
                this.licenseContent = AnzeigeMaster.getInstance().getLicenseManager().verify();
            }
        }
        catch (Exception e) {
            this.licenseContent = null;
        }
    }

    public void checkLicense() {
        if (AnzeigeMaster.getInstance().getLicenseContent() == null) {
            // empty if block
        }
    }

    public LicenseParam getLicenceParam() {
        return this.licenceParam;
    }

    public void setLicenceParam(LicenseParam licenceParam) {
        this.licenceParam = licenceParam;
    }

    public LicenseManager getLicenseManager() {
        return this.licenseManager;
    }

    public void setLicenseManager(LicenseManager licenseManager) {
        this.licenseManager = licenseManager;
    }

    public LicenseContent getLicenseContent() {
        if (this.licenseContent == null && this.templicensecontent != null) {
            return this.templicensecontent;
        }
        return this.licenseContent;
    }

    public void setLicenseContent(LicenseContent licenseContent) {
        this.licenseContent = licenseContent;
    }

    public String getLangueage() {
        return this.langueage;
    }

    public void setLangueage(String langueage) {
        if (langueage != null && !langueage.equals("")) {
            this.langueage = langueage;
            this.actualizeResourceBundle();
            UIManager.put("OptionPane.cancelButtonText", AnzeigeResource.getResourceString("logon.button.cancel"));
            UIManager.put("OptionPane.noButtonText", AnzeigeResource.getResourceString("general.no"));
            UIManager.put("OptionPane.okButtonText", AnzeigeResource.getResourceString("general.ok"));
            UIManager.put("OptionPane.yesButtonText", AnzeigeResource.getResourceString("general.yes"));
        }
    }

    public ResourceBundle getResourceBundle() {
        try {
            if (resourceBundle == null) {
                this.actualizeResourceBundle();
            }
        }
        catch (MissingResourceException x) {
            resourceBundle = null;
        }
        return resourceBundle;
    }

    public void setResourceBundle(ResourceBundle resourceBundle) {
        AnzeigeMaster.resourceBundle = resourceBundle;
    }

    private void actualizeResourceBundle() {
        if (AnzeigeMaster.getInstance().getLangueage().equals("deutsch")) {
            resourceBundle = ResourceBundle.getBundle("languages.deutsch_ppwakolc");
        }
        if (AnzeigeMaster.getInstance().getLangueage().equals("english")) {
            resourceBundle = ResourceBundle.getBundle("languages.english_ppwakolc");
        }
        if (AnzeigeMaster.getInstance().getLangueage().equals("czech")) {
            resourceBundle = ResourceBundle.getBundle("languages.czech_ppwakolc");
        }
        if (AnzeigeMaster.getInstance().getLangueage().equals("francais")) {
            resourceBundle = ResourceBundle.getBundle("languages.francais_ppwakolc");
        }
        if (AnzeigeMaster.getInstance().getLangueage().equals("francais")) {
            resourceBundle = ResourceBundle.getBundle("languages.francais_ppwakolc");
        }
        if (AnzeigeMaster.getInstance().getLangueage().equals("turkce")) {
            resourceBundle = ResourceBundle.getBundle("languages.turkce_ppwakolc");
        }
        if (AnzeigeMaster.getInstance().getLangueage().equals("magyar")) {
            resourceBundle = ResourceBundle.getBundle("languages.magyar_ppwakolc");
        }
        if (AnzeigeMaster.getInstance().getLangueage().equals("italiano")) {
            resourceBundle = ResourceBundle.getBundle("languages.italiano_ppwakolc");
        }
        if (AnzeigeMaster.getInstance().getLangueage().equals("russian")) {
            resourceBundle = ResourceBundle.getBundle("languages.russian_ppwakolc");
        }
        if (AnzeigeMaster.getInstance().getLangueage().equals("nederlandse")) {
            resourceBundle = ResourceBundle.getBundle("languages.nederlandse_ppwakolc");
        }
        if (AnzeigeMaster.getInstance().getLangueage().equals("\u4e2d\u6587")) {
            resourceBundle = ResourceBundle.getBundle("languages.chinese_ppwakolc");
        }
        if (AnzeigeMaster.getInstance().getLangueage().equals("\u03b5\u03bb\u03bb\u03b7\u03bd\u03b9\u03ba\u03ac")) {
            resourceBundle = ResourceBundle.getBundle("languages.greek_ppwakolc");
        }
        if (AnzeigeMaster.getInstance().getLangueage().equals("espanol")) {
            resourceBundle = ResourceBundle.getBundle("languages.espanol_ppwakolc");
        }
        if (AnzeigeMaster.getInstance().getLangueage().equals("dansk")) {
            resourceBundle = ResourceBundle.getBundle("languages.danish_ppwakolc");
        }
        if (AnzeigeMaster.getInstance().getLangueage().equals("portugu\u00eas")) {
            resourceBundle = ResourceBundle.getBundle("languages.portuguese_pp");
        }
        if (AnzeigeMaster.getInstance().getLangueage().equals("c\u0440\u043f\u0441\u043a\u0438")) {
            resourceBundle = ResourceBundle.getBundle("languages.serbian_pp");
        }
        if (AnzeigeMaster.getInstance().getLangueage().equals("\u0641\u0627\u0631\u0633\u06cc")) {
            resourceBundle = ResourceBundle.getBundle("languages.persian_pp");
        }
        if (AnzeigeMaster.getInstance().getLangueage().equals("\u0639\u0631\u0628\u0649")) {
            resourceBundle = ResourceBundle.getBundle("languages.arabic_pp");
        }
        if (AnzeigeMaster.getInstance().getLangueage().equals("rom\u00e2n\u0103")) {
            resourceBundle = ResourceBundle.getBundle("languages.romana_pp");
        }
    }

    public Anzeige getAnzeige() {
        return this.anzeige;
    }

    public void setAnzeige(Anzeige anzeige) {
        this.anzeige = anzeige;
    }

    public void startJettyServer() {
        try {
            if (!this.isJettyServerRunning()) {
                this.server = new Server(this.SERVER_PORT);
                ServletHandler handler = new ServletHandler();
                this.server.setHandler((Handler)handler);
                handler.addServletWithMapping(ScoringServlet.class, "/ppsanda/scoring");
                handler.addServletWithMapping(ScoringAuthServlet.class, "/ppsanda/scoringAuth");
                handler.addServletWithMapping(ScoringCheckstatusServlet.class, "/ppsanda/scoringCheckStatus");
                this.server.start();
            } else {
                System.out.println(String.valueOf(this.getClass()) + ": Webserver is already running! Do not start another server.");
            }
        }
        catch (Exception e) {
            new FehlerFenster("Local Server Error: " + e.getMessage());
        }
    }

    public boolean isJettyServerRunning() {
        return this.server != null && this.server.isRunning();
    }

    public void stopJettyServer() {
        if (this.isJettyServerRunning()) {
            try {
                System.out.println("Stopping Webserver...");
                if (this.server.isRunning()) {
                    this.server.stop();
                }
                this.server = null;
            }
            catch (Exception e) {
                System.out.println("Error: " + e.getMessage());
            }
        }
    }

    public String getServletScoringUrlIP() {
        return "http://" + HostName.getIP() + ":" + this.SERVER_PORT + "/ppsanda/scoring";
    }

    public String getServletScoringUrlHostname() {
        return "http://" + HostName.getHostname() + ":" + this.SERVER_PORT + "/ppsanda/scoring";
    }

    public String getServletScoringAuthUrlIP() {
        return "http://" + HostName.getIP() + ":" + this.SERVER_PORT + "/ppsanda/scoringAuth";
    }

    public String getServletScoringAuthUrlHostname() {
        return "http://" + HostName.getHostname() + ":" + this.SERVER_PORT + "/ppsanda/scoringAuth";
    }

    public String getServletScoringCheckStatusUrlIP() {
        return "http://" + HostName.getIP() + ":" + this.SERVER_PORT + "/ppsanda/scoringCheckStatus?pptime=" + Calendar.getInstance().getTimeInMillis();
    }

    public String getServletScoringCheckStatusUrlHostname() {
        return "http://" + HostName.getHostname() + ":" + this.SERVER_PORT + "/ppsanda/scoringCheckStatus?pptime=" + Calendar.getInstance().getTimeInMillis();
    }

    public int generateRandomPin() {
        this.pin = (int)(Math.random() * 9999.0) + 1000;
        return this.pin;
    }

    public int getPin() {
        return this.pin;
    }

    public void setPin(int pin) {
        this.pin = pin;
    }

    public TreeMap<String, ScoringAuthObject> getReferees() {
        return this.referees;
    }

    public void setReferees(TreeMap<String, ScoringAuthObject> referees) {
        this.referees = referees;
    }

    public boolean hasAssignedReferee(String refnr) {
        for (String imei : this.referees.keySet()) {
            if (!this.referees.get(imei).isIsassigned() || !this.referees.get(imei).getRefnr().equals(refnr)) continue;
            return true;
        }
        return false;
    }

    public boolean hasImeiReferee(String imei, String refnr) {
        return this.referees.containsKey(imei) && this.referees.get(imei).getRefnr().equals(refnr);
    }

    public boolean hasAssignedImeiReferee(String imei, String refnr) {
        return this.referees.containsKey(imei) && this.referees.get(imei).isIsassigned() && this.referees.get(imei).getRefnr().equals(refnr);
    }

    public void addReferee(ScoringAuthObject sao) {
        this.referees.put(sao.getImei(), sao);
        this.saveRefereesToProps();
    }

    public void removeReferee(String imei) {
        this.referees.remove(imei);
        this.saveRefereesToProps();
    }

    public void loadRefereesFromProps() {
        if (!AnzeigePropertiesHelper.getPpsetscoringappdevice().trim().equals("")) {
            try {
                String[] refprops = AnzeigePropertiesHelper.getPpsetscoringappdevice().split(";");
                int i = 0;
                while (i < refprops.length) {
                    String[] refprop = refprops[i].split(",");
                    ScoringAuthObject sao = new ScoringAuthObject();
                    sao.setImei(refprop[0]);
                    sao.setRefnr(refprop[1]);
                    if (refprop[2].equals("true")) {
                        sao.setIsassigned(true);
                    } else {
                        sao.setIsassigned(false);
                    }
                    this.referees.put(sao.getImei(), sao);
                    ++i;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void saveRefereesToProps() {
        Object refprops = "";
        Iterator<String> refs = this.referees.keySet().iterator();
        int count = 0;
        while (refs.hasNext()) {
            String imei = refs.next();
            ScoringAuthObject sao = this.referees.get(imei);
            if (count > 0) {
                refprops = (String)refprops + ";";
            }
            refprops = (String)refprops + sao.getImei() + "," + sao.getRefnr() + "," + sao.isIsassigned();
            ++count;
        }
        AnzeigePropertiesHelper.setPpsetscoringappdevice((String)refprops);
        AnzeigePropertiesHelper.saveAnzeigeProps();
    }

    public void printRefereesList() {
        System.out.println("Referees APP Device List: " + this.referees.size());
        System.out.println("------------------------------------------");
        for (String imei : this.referees.keySet()) {
            System.out.println("IMEI: " + imei + " RefereeNr: " + this.referees.get(imei).getRefnr() + " IsAssigned: " + this.referees.get(imei).isIsassigned());
        }
        System.out.println("------------------------------------------");
    }

    public TreeMap<Integer, ScoringObject> getRefereesPoints() {
        return this.refereesPoints;
    }

    public void setRefereesPoints(TreeMap<Integer, ScoringObject> refereesPoints) {
        this.refereesPoints = refereesPoints;
    }

    public void showRefereePointsWindow() {
        if (this.refereePointsWindow != null) {
            this.refereePointsWindow.close();
        }
        this.refereePointsWindow = new RefereePointsWindow();
        this.refereePointsWindow.checkPoints();
        if (this.refereeWindowLocation != null) {
            this.refereePointsWindow.setLocation(this.refereeWindowLocation);
        }
        this.refereePointsWindow.setVisible(true);
        this.refereePointsWindow.toFront();
    }

    public boolean isDecisionmode() {
        return this.decisionmode;
    }

    public void setDecisionmode(boolean decisionmode) {
        this.decisionmode = decisionmode;
    }

    public void showFadeMessagePopupRed(String text) {
        if (this.fadmspopred == null) {
            this.fadmspopred = new FadeMessagePopup(10);
        }
        this.fadmspopred.setText(text);
        this.fadmspopred.startFading();
    }

    public void showFadeMessagePopupBlue(String text) {
        if (this.fadmspopblue == null) {
            this.fadmspopblue = new FadeMessagePopup(65);
        }
        this.fadmspopblue.setText(text);
        this.fadmspopblue.startFading();
    }

    public void showFadeMessagePopupGeneral(String text) {
        if (this.fadmspopgeneral == null) {
            this.fadmspopgeneral = new FadeMessagePopup(300);
        }
        this.fadmspopgeneral.setText(text);
        this.fadmspopgeneral.simplyShow();
    }

    public void hideFadeMessagePopupGeneral() {
        if (this.fadmspopgeneral != null) {
            this.fadmspopgeneral.simplyHide();
        }
    }

    public TreeMap<Integer, String> getWintypes() {
        return this.wintypes;
    }

    public void setWintypes(TreeMap<Integer, String> wintypes) {
        this.wintypes = wintypes;
    }

    public int getWintypeID(int index) {
        Iterator<Integer> it = this.getWintypes().keySet().iterator();
        int count = 0;
        while (it.hasNext()) {
            int id = it.next();
            if (count == index) {
                return id;
            }
            ++count;
        }
        return -1;
    }

    public String getWintypeText(int index) {
        Iterator<Integer> it = this.getWintypes().keySet().iterator();
        int count = 0;
        while (it.hasNext()) {
            int id = it.next();
            if (count == index) {
                return this.getWintypes().get(id);
            }
            ++count;
        }
        return "";
    }

    public boolean hasWinTypes() {
        return this.getWintypes().size() > 0;
    }

    public ProtestComponent getProtestclock() {
        return this.protestclock;
    }

    public void setProtestclock(ProtestComponent protestclock) {
        this.protestclock = protestclock;
    }

    public void showProtestWindow(int x, int y, String reftext) {
        if (this.protestclock != null) {
            this.protestclock.closeWindow();
        }
        this.protestclock = new ProtestComponent();
        this.protestclock.setValueText(reftext);
        this.protestclock.setLocation(x, y);
        this.protestclock.setFullScreen();
        this.protestclock.setVisible(true);
    }

    public void closeProtestWindow() {
        if (this.protestclock != null) {
            this.protestclock.closeWindow();
        }
    }

    public Point getRefereeWindowLocation() {
        return this.refereeWindowLocation;
    }

    public void setRefereeWindowLocation(Point refereeWindowLocation) {
        this.refereeWindowLocation = refereeWindowLocation;
    }

    public void resetMatchtime() {
        this.matchtime.clear();
    }

    public void setMatchtimeRound(int round, int seconds) {
        int time = MatchtimeHelper.getMatchtime() - seconds;
        this.matchtime.put(round, time);
    }

    public int getMatchtime() {
        int totalmatchtime = 0;
        for (int round : this.matchtime.keySet()) {
            totalmatchtime += this.matchtime.get(round).intValue();
        }
        return totalmatchtime;
    }

    public Object getAth1() {
        return this.ath1;
    }

    public void setAth1(Object ath1) {
        this.ath1 = ath1;
    }

    public Object getAth2() {
        return this.ath2;
    }

    public void setAth2(Object ath2) {
        this.ath2 = ath2;
    }

    public Object getClub1() {
        return this.club1;
    }

    public void setClub1(Object club1) {
        this.club1 = club1;
    }

    public Object getClub2() {
        return this.club2;
    }

    public void setClub2(Object club2) {
        this.club2 = club2;
    }

    public Object getNat1() {
        return this.nat1;
    }

    public void setNat1(Object nat1) {
        this.nat1 = nat1;
    }

    public Object getNat2() {
        return this.nat2;
    }

    public void setNat2(Object nat2) {
        this.nat2 = nat2;
    }

    public Object getCat() {
        return this.cat;
    }

    public void setCat(Object cat) {
        this.cat = cat;
    }

    public void setMatchtime(HashMap<Integer, Integer> matchtime) {
        this.matchtime = matchtime;
    }

    public int getLastwintypeselected() {
        return this.lastwintypeselected;
    }

    public void setLastwintypeselected(int lastwintypeselected) {
        this.lastwintypeselected = lastwintypeselected;
    }

    public boolean isIsembedded() {
        return this.isembedded;
    }

    public void setIsembedded(boolean isembedded) {
        this.isembedded = isembedded;
    }

    public String getWeighta() {
        return this.weighta;
    }

    public void setWeighta(String weighta) {
        this.weighta = weighta;
    }

    public String getWeightb() {
        return this.weightb;
    }

    public void setWeightb(String weightb) {
        this.weightb = weightb;
    }
}

