/*
 * Decompiled with CFR 0.152.
 */
package org.sportdata.setppsanda.anzeige.circlejabel;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.JLabel;

public class JCircleLabelRoundedEdgeRezizeFont
extends JLabel {
    private static final long serialVersionUID = 9209804819474648252L;
    public static final int MIN_FONT_SIZE = 1;
    public static final int MAX_FONT_SIZE = 100;

    public JCircleLabelRoundedEdgeRezizeFont(String text) {
        super(text);
        this.init();
    }

    protected void init() {
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                JCircleLabelRoundedEdgeRezizeFont.this.adaptLabelFont(JCircleLabelRoundedEdgeRezizeFont.this);
            }
        });
    }

    @Override
    public void paintComponent(Graphics g) {
        int width = this.getWidth();
        int height = this.getHeight();
        super.paintComponent(g);
        Dimension arcs = new Dimension(height / 2, height / 2);
        Graphics2D graphics = (Graphics2D)g;
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics.setColor(this.getBackground());
        graphics.fillRoundRect(0, 0, width - 1, height - 1, arcs.width, arcs.height);
        graphics.setColor(this.getBackground());
        graphics.drawRoundRect(0, 0, width - 1, height - 1, arcs.width, arcs.height);
        super.paintComponent(g);
    }

    protected void adaptLabelFont(JLabel l) {
        Font f = l.getFont();
        int maxHeight = l.getHeight();
        int maxWidth = l.getWidth();
        int fontHeight = 1;
        int fontWidth = 1;
        int fontSize = 1;
        while (fontHeight < maxHeight && fontWidth < maxWidth && fontSize < 100) {
            l.setFont(l.getFont().deriveFont((float)fontSize));
            fontHeight = l.getFontMetrics(l.getFont()).getHeight();
            fontWidth = l.getFontMetrics(l.getFont()).stringWidth(l.getText());
            ++fontSize;
        }
        this.setFont(f.deriveFont(f.getStyle(), fontSize + fontSize / 2));
        this.repaint();
    }
}

