/*
 * Decompiled with CFR 0.152.
 */
package de.brendamour.jpasskit;

import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import de.brendamour.jpasskit.IPKBuilder;
import de.brendamour.jpasskit.IPKValidateable;
import de.brendamour.jpasskit.PKLocation;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.builder.ToStringBuilder;

@JsonPOJOBuilder(withPrefix="")
public class PKLocationBuilder
implements IPKValidateable,
IPKBuilder<PKLocation> {
    private PKLocation location = new PKLocation();

    protected PKLocationBuilder() {
    }

    public PKLocationBuilder of(PKLocation source) {
        if (source != null) {
            this.location = source.clone();
        }
        return this;
    }

    public PKLocationBuilder latitude(double latitude) {
        this.location.latitude = latitude;
        return this;
    }

    public PKLocationBuilder longitude(double longitude) {
        this.location.longitude = longitude;
        return this;
    }

    public PKLocationBuilder altitude(Double altitude) {
        this.location.altitude = altitude;
        return this;
    }

    public PKLocationBuilder relevantText(String relevantText) {
        this.location.relevantText = relevantText;
        return this;
    }

    @Override
    public boolean isValid() {
        return this.getValidationErrors().isEmpty();
    }

    @Override
    public List<String> getValidationErrors() {
        if (this.location.longitude == 0.0 || this.location.latitude == 0.0) {
            return Collections.singletonList("Not all required Fields are set: longitude, latitude");
        }
        return Collections.emptyList();
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    @Override
    public PKLocation build() {
        return this.location;
    }
}

