/*
 * Decompiled with CFR 0.152.
 */
package de.brendamour.jpasskit.util;

import de.brendamour.jpasskit.IPKBuilder;
import de.brendamour.jpasskit.PKBarcode;
import de.brendamour.jpasskit.PKBarcodeBuilder;
import de.brendamour.jpasskit.PKBeacon;
import de.brendamour.jpasskit.PKBeaconBuilder;
import de.brendamour.jpasskit.PKField;
import de.brendamour.jpasskit.PKFieldBuilder;
import de.brendamour.jpasskit.PKLocation;
import de.brendamour.jpasskit.PKLocationBuilder;
import de.brendamour.jpasskit.PWAssociatedApp;
import de.brendamour.jpasskit.PWAssociatedAppBuilder;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;
import java.util.stream.Collectors;

public class BuilderUtils {
    public static <T, B extends IPKBuilder<T>> List<T> buildAll(List<B> builders) {
        if (BuilderUtils.isEmpty(builders)) {
            return Collections.emptyList();
        }
        return builders.stream().map(IPKBuilder::build).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
    }

    public static List<PKFieldBuilder> toFieldBuilderList(List<PKField> fields) {
        return BuilderUtils.toBuilderList(fields, PKField::builder);
    }

    public static List<PKBeaconBuilder> toBeaconBuilderList(List<PKBeacon> beacons) {
        return BuilderUtils.toBuilderList(beacons, PKBeacon::builder);
    }

    public static List<PKBarcodeBuilder> toBarcodeBuilderList(List<PKBarcode> barcodes) {
        return BuilderUtils.toBuilderList(barcodes, PKBarcode::builder);
    }

    public static List<PKLocationBuilder> toLocationBuilderList(List<PKLocation> locations) {
        return BuilderUtils.toBuilderList(locations, PKLocation::builder);
    }

    public static List<PWAssociatedAppBuilder> toAssociatedAppBuilderList(List<PWAssociatedApp> associatedApps) {
        return BuilderUtils.toBuilderList(associatedApps, PWAssociatedApp::builder);
    }

    public static <T, B extends IPKBuilder<T>> List<B> toBuilderList(List<T> entities, Function<T, B> toBuilder) {
        if (BuilderUtils.isEmpty(entities)) {
            return Collections.emptyList();
        }
        return entities.stream().map(toBuilder).collect(Collectors.toCollection(CopyOnWriteArrayList::new));
    }

    public static boolean isEmpty(Collection<?> coll) {
        return coll == null || coll.isEmpty();
    }
}

