/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.openformula.ui.model2;

import java.util.ArrayList;
import org.pentaho.openformula.ui.model2.FormulaClosingParenthesisElement;
import org.pentaho.openformula.ui.model2.FormulaDocument;
import org.pentaho.openformula.ui.model2.FormulaElement;
import org.pentaho.openformula.ui.model2.FormulaFunctionElement;
import org.pentaho.openformula.ui.model2.FormulaNumberElement;
import org.pentaho.openformula.ui.model2.FormulaOpenParenthesisElement;
import org.pentaho.openformula.ui.model2.FormulaOperatorElement;
import org.pentaho.openformula.ui.model2.FormulaSemicolonElement;
import org.pentaho.openformula.ui.model2.FormulaTextElement;

public class FormulaParser {
    private FormulaParser() {
    }

    public static FormulaElement[] parseText(FormulaDocument doc, String text) {
        String formulaText = text;
        if (!text.startsWith("=")) {
            formulaText = "=" + text;
        }
        Tokenizer strtok = new Tokenizer(formulaText.toCharArray());
        ArrayList<FormulaElement> elements = new ArrayList<FormulaElement>();
        while (strtok.hasNext()) {
            String nextToken = strtok.next();
            char ttype = strtok.getToken();
            if (ttype != '\u0000') {
                if ('(' == ttype) {
                    elements.add(new FormulaOpenParenthesisElement(doc, doc.getRootElement()));
                    continue;
                }
                if (')' == ttype) {
                    elements.add(new FormulaClosingParenthesisElement(doc, doc.getRootElement()));
                    continue;
                }
                if (';' == ttype) {
                    elements.add(new FormulaSemicolonElement(doc, doc.getRootElement()));
                    continue;
                }
                elements.add(new FormulaOperatorElement(doc, doc.getRootElement(), String.valueOf(ttype)));
                continue;
            }
            elements.add(new FormulaTextElement(doc, doc.getRootElement(), nextToken));
        }
        return elements.toArray(new FormulaElement[elements.size()]);
    }

    public static FormulaElement[] normalizeDocument(FormulaDocument document, FormulaElement[] elements) {
        int i;
        if (elements.length == 0) {
            return elements;
        }
        ArrayList<FormulaElement> mergedList = new ArrayList<FormulaElement>(elements.length);
        int startElementIdx = -1;
        for (int i2 = 0; i2 < elements.length; ++i2) {
            FormulaElement element = elements[i2];
            if (element instanceof FormulaTextElement) {
                if (startElementIdx >= 0) continue;
                startElementIdx = i2;
                continue;
            }
            if (startElementIdx >= 0) {
                if (i2 - 1 == startElementIdx) {
                    mergedList.add(elements[i2 - 1]);
                } else {
                    StringBuffer buffer = new StringBuffer(100);
                    for (int t = startElementIdx; t < i2; ++t) {
                        buffer.append(elements[t].getText());
                    }
                    mergedList.add(new FormulaTextElement(document, document.getRootElement(), buffer.toString()));
                }
                startElementIdx = -1;
            }
            mergedList.add(element);
        }
        if (startElementIdx != -1) {
            if (elements.length - 1 == startElementIdx) {
                mergedList.add(elements[elements.length - 1]);
            } else {
                StringBuffer buffer = new StringBuffer(100);
                for (int t = startElementIdx; t < elements.length; ++t) {
                    buffer.append(elements[t].getText());
                }
                mergedList.add(new FormulaTextElement(document, document.getRootElement(), buffer.toString()));
            }
        }
        FormulaElement[] mergedValues = mergedList.toArray(new FormulaElement[mergedList.size()]);
        mergedList.clear();
        for (i = 0; i < mergedValues.length - 1; ++i) {
            FormulaElement mergedValue = mergedValues[i];
            FormulaElement nextValue = mergedValues[i + 1];
            if (!(nextValue instanceof FormulaOpenParenthesisElement)) {
                mergedList.add(mergedValue);
                continue;
            }
            String buffer = mergedValue.getText();
            int startIdx = FormulaParser.findFunctionNameStart(buffer);
            if (startIdx == -1) {
                mergedList.add(mergedValue);
                continue;
            }
            if (startIdx != 0) {
                String text = buffer.substring(0, startIdx);
                if (text.trim().length() == 0) {
                    mergedList.add(new FormulaFunctionElement(document, document.getRootElement(), buffer));
                    continue;
                }
                mergedList.add(new FormulaTextElement(document, document.getRootElement(), text));
            }
            mergedList.add(new FormulaFunctionElement(document, document.getRootElement(), buffer.substring(startIdx)));
        }
        mergedList.add(mergedValues[mergedValues.length - 1]);
        for (i = 0; i < mergedList.size(); ++i) {
            FormulaElement element = (FormulaElement)mergedList.get(i);
            if (!(element instanceof FormulaTextElement)) continue;
            try {
                Double.parseDouble(element.getText().trim());
                mergedList.set(i, new FormulaNumberElement(document, document.getRootElement(), element.getText()));
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return mergedList.toArray(new FormulaElement[mergedList.size()]);
    }

    public static void print(FormulaElement[] formulaElements) {
        for (int i = 0; i < formulaElements.length; ++i) {
            FormulaElement element = formulaElements[i];
            System.out.println(i + " Name=" + element.getName() + "; Text='" + element.getText() + '\'');
        }
    }

    private static int findFunctionNameStart(String buffer) {
        int length;
        for (length = buffer.length() - 1; length >= 0 && Character.isWhitespace(buffer.charAt(length)); --length) {
        }
        if (length == -1) {
            return -1;
        }
        for (int i = length - 1; i >= 0; --i) {
            char c = buffer.charAt(i);
            if (Character.isLetter(c) || Character.isDigit(c) || '.' == c) continue;
            return i + 1;
        }
        return 0;
    }

    private static class Tokenizer {
        private char[] data;
        private int position;
        private StringBuffer buffer;
        private char token;

        private Tokenizer(char[] data) {
            this.data = data;
            this.position = 0;
            this.buffer = new StringBuffer(data.length);
        }

        public char getToken() {
            return this.token;
        }

        public boolean hasNext() {
            return this.position < this.data.length;
        }

        public String next() {
            boolean inQuoting;
            this.token = '\u0000';
            char c = this.data[this.position];
            if (this.isToken(c)) {
                ++this.position;
                this.token = c;
                return String.valueOf(c);
            }
            this.buffer.delete(0, this.buffer.length());
            this.buffer.append(c);
            ++this.position;
            boolean bl = inQuoting = '\"' == c;
            while (this.position < this.data.length) {
                char c2 = this.data[this.position];
                if (!inQuoting && this.isToken(c2)) {
                    return this.buffer.toString();
                }
                if (c2 == '\"') {
                    inQuoting = !inQuoting;
                }
                this.buffer.append(c2);
                ++this.position;
            }
            return this.buffer.toString();
        }

        private boolean isToken(char c) {
            if (c == '(') {
                return true;
            }
            if (c == ')') {
                return true;
            }
            if (c == '+') {
                return true;
            }
            if (c == '-') {
                return true;
            }
            if (c == '*') {
                return true;
            }
            if (c == '/') {
                return true;
            }
            if (c == '%') {
                return true;
            }
            if (c == '&') {
                return true;
            }
            if (c == ';') {
                return true;
            }
            return c == '=';
        }
    }
}

