/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.alpn.client;

import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import javax.net.ssl.SSLEngine;
import org.eclipse.jetty.alpn.ALPN;
import org.eclipse.jetty.io.ClientConnectionFactory;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.NegotiatingClientConnection;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class ALPNClientConnection
extends NegotiatingClientConnection
implements ALPN.ClientProvider {
    private static final Logger LOG = Log.getLogger(ALPNClientConnection.class);
    private final List<String> protocols;

    public ALPNClientConnection(EndPoint endPoint, Executor executor, ClientConnectionFactory connectionFactory, SSLEngine sslEngine, Map<String, Object> context, List<String> protocols) {
        super(endPoint, executor, sslEngine, connectionFactory, context);
        this.protocols = protocols;
        ALPN.put((SSLEngine)sslEngine, (ALPN.Provider)this);
    }

    public void unsupported() {
        ALPN.remove((SSLEngine)this.getSSLEngine());
        this.completed();
    }

    public List<String> protocols() {
        return this.protocols;
    }

    public void selected(String protocol) {
        if (this.protocols.contains(protocol)) {
            ALPN.remove((SSLEngine)this.getSSLEngine());
            this.completed();
        } else {
            LOG.info("Could not negotiate protocol: server [{}] - client {}", protocol, this.protocols);
            this.close();
        }
    }

    @Override
    public void close() {
        ALPN.remove((SSLEngine)this.getSSLEngine());
        super.close();
    }
}

