/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpDestination;
import org.eclipse.jetty.client.HttpExchange;
import org.eclipse.jetty.client.HttpRequest;
import org.eclipse.jetty.client.Origin;
import org.eclipse.jetty.client.SendFailure;
import org.eclipse.jetty.client.api.Connection;
import org.eclipse.jetty.util.Promise;

public abstract class MultiplexHttpDestination<C extends Connection>
extends HttpDestination
implements Promise<Connection> {
    private final AtomicReference<ConnectState> connect = new AtomicReference<ConnectState>(ConnectState.DISCONNECTED);
    private final AtomicInteger requestsPerConnection = new AtomicInteger();
    private int maxRequestsPerConnection = 1024;
    private C connection;

    protected MultiplexHttpDestination(HttpClient client, Origin origin) {
        super(client, origin);
    }

    public int getMaxRequestsPerConnection() {
        return this.maxRequestsPerConnection;
    }

    public void setMaxRequestsPerConnection(int maxRequestsPerConnection) {
        this.maxRequestsPerConnection = maxRequestsPerConnection;
    }

    @Override
    public void send() {
        block5: while (true) {
            ConnectState current = this.connect.get();
            switch (current) {
                case DISCONNECTED: {
                    if (!this.connect.compareAndSet(current, ConnectState.CONNECTING)) continue block5;
                    this.newConnection(this);
                    return;
                }
                case CONNECTING: {
                    return;
                }
                case CONNECTED: {
                    if (this.process(this.connection)) continue block5;
                    return;
                }
                default: {
                    this.abort(new IllegalStateException("Invalid connection state " + (Object)((Object)current)));
                    return;
                }
            }
        }
    }

    @Override
    public void succeeded(Connection result) {
        this.connection = result;
        Connection connection = this.connection;
        if (this.connect.compareAndSet(ConnectState.CONNECTING, ConnectState.CONNECTED)) {
            this.send();
        } else {
            connection.close();
            this.failed(new IllegalStateException("Invalid connection state " + this.connect));
        }
    }

    @Override
    public void failed(Throwable x) {
        this.connect.set(ConnectState.DISCONNECTED);
        this.abort(x);
    }

    protected boolean process(C connection) {
        int max;
        int next;
        int count;
        do {
            max = this.getMaxRequestsPerConnection();
            count = this.requestsPerConnection.get();
            next = count + 1;
            if (next <= max) continue;
            return false;
        } while (!this.requestsPerConnection.compareAndSet(count, next));
        HttpExchange exchange = this.getHttpExchanges().poll();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Processing {}/{} {} on {}", next, max, exchange, connection);
        }
        if (exchange == null) {
            this.requestsPerConnection.decrementAndGet();
            return false;
        }
        HttpRequest request = exchange.getRequest();
        Throwable cause = request.getAbortCause();
        if (cause != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Aborted before processing {}: {}", exchange, cause);
            }
            exchange.abort(cause);
            this.requestsPerConnection.decrementAndGet();
        } else {
            SendFailure result = this.send(connection, exchange);
            if (result != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Send failed {} for {}", result, exchange);
                }
                if (result.retry && this.enqueue(this.getHttpExchanges(), exchange)) {
                    return true;
                }
                request.abort(result.failure);
            }
        }
        return this.getHttpExchanges().peek() != null;
    }

    @Override
    public void release(Connection connection) {
        this.requestsPerConnection.decrementAndGet();
        this.send();
    }

    @Override
    public void close() {
        super.close();
        C connection = this.connection;
        if (connection != null) {
            connection.close();
        }
    }

    @Override
    public void close(Connection connection) {
        block1: {
            ConnectState current;
            super.close(connection);
            while (!this.connect.compareAndSet(current = this.connect.get(), ConnectState.DISCONNECTED)) {
            }
            if (!this.getHttpClient().isRemoveIdleDestinations()) break block1;
            this.getHttpClient().removeDestination(this);
        }
    }

    protected abstract SendFailure send(C var1, HttpExchange var2);

    private static enum ConnectState {
        DISCONNECTED,
        CONNECTING,
        CONNECTED;

    }
}

