/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.rewrite.handler;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.rewrite.handler.Rule;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.util.ArrayUtil;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class RuleContainer
extends Rule {
    public static final String ORIGINAL_QUERYSTRING_ATTRIBUTE_SUFFIX = ".QUERYSTRING";
    private static final Logger LOG = Log.getLogger(RuleContainer.class);
    protected Rule[] _rules;
    protected String _originalPathAttribute;
    protected String _originalQueryStringAttribute;
    protected boolean _rewriteRequestURI = true;
    protected boolean _rewritePathInfo = true;

    public Rule[] getRules() {
        return this._rules;
    }

    public void setRules(Rule[] rules) {
        this._rules = rules;
    }

    public void addRule(Rule rule) {
        this._rules = ArrayUtil.addToArray(this._rules, rule, Rule.class);
    }

    public boolean isRewriteRequestURI() {
        return this._rewriteRequestURI;
    }

    public void setRewriteRequestURI(boolean rewriteRequestURI) {
        this._rewriteRequestURI = rewriteRequestURI;
    }

    public boolean isRewritePathInfo() {
        return this._rewritePathInfo;
    }

    public void setRewritePathInfo(boolean rewritePathInfo) {
        this._rewritePathInfo = rewritePathInfo;
    }

    public String getOriginalPathAttribute() {
        return this._originalPathAttribute;
    }

    public void setOriginalPathAttribute(String originalPathAttribte) {
        this._originalPathAttribute = originalPathAttribte;
        this._originalQueryStringAttribute = originalPathAttribte + ORIGINAL_QUERYSTRING_ATTRIBUTE_SUFFIX;
    }

    @Override
    public String matchAndApply(String target, HttpServletRequest request, HttpServletResponse response) throws IOException {
        return this.apply(target, request, response);
    }

    protected String apply(String target, HttpServletRequest request, HttpServletResponse response) throws IOException {
        boolean original_set = this._originalPathAttribute == null;
        target = URIUtil.compactPath(target);
        for (Rule rule : this._rules) {
            String applied = rule.matchAndApply(target, request, response);
            if (applied == null) continue;
            applied = URIUtil.compactPath(applied);
            LOG.debug("applied {}", rule);
            LOG.debug("rewrote {} to {}", target, applied);
            if (!original_set) {
                original_set = true;
                request.setAttribute(this._originalPathAttribute, target);
                String query = request.getQueryString();
                if (query != null) {
                    request.setAttribute(this._originalQueryStringAttribute, query);
                }
            }
            if (this._rewriteRequestURI) {
                String encoded = URIUtil.encodePath(applied);
                if (rule instanceof Rule.ApplyURI) {
                    ((Rule.ApplyURI)((Object)rule)).applyURI((Request)request, ((Request)request).getRequestURI(), encoded);
                } else {
                    ((Request)request).setURIPathQuery(encoded);
                }
            }
            if (this._rewritePathInfo) {
                ((Request)request).setPathInfo(applied);
            }
            target = applied;
            if (rule.isHandling()) {
                LOG.debug("handling {}", rule);
                Request.getBaseRequest(request).setHandled(true);
            }
            if (!rule.isTerminating()) continue;
            LOG.debug("terminating {}", rule);
            break;
        }
        return target;
    }
}

