/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.security.jaspi.modules;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.message.AuthException;
import javax.security.auth.message.AuthStatus;
import javax.security.auth.message.MessageInfo;
import javax.security.auth.message.MessagePolicy;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.security.jaspi.modules.BaseAuthModule;
import org.eclipse.jetty.util.B64Code;
import org.eclipse.jetty.util.QuotedStringTokenizer;
import org.eclipse.jetty.util.TypeUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.security.Credential;

@Deprecated
public class DigestAuthModule
extends BaseAuthModule {
    private static final Logger LOG = Log.getLogger(DigestAuthModule.class);
    protected long maxNonceAge = 0L;
    protected long nonceSecret = (long)this.hashCode() ^ System.currentTimeMillis();
    protected boolean useStale = false;
    private String realmName;
    private static final String REALM_KEY = "org.eclipse.jetty.security.jaspi.modules.RealmName";

    public DigestAuthModule() {
    }

    public DigestAuthModule(CallbackHandler callbackHandler, String realmName) {
        super(callbackHandler);
        this.realmName = realmName;
    }

    @Override
    public void initialize(MessagePolicy requestPolicy, MessagePolicy responsePolicy, CallbackHandler handler, Map options) throws AuthException {
        super.initialize(requestPolicy, responsePolicy, handler, options);
        this.realmName = (String)options.get(REALM_KEY);
    }

    @Override
    public AuthStatus validateRequest(MessageInfo messageInfo, Subject clientSubject, Subject serviceSubject) throws AuthException {
        HttpServletRequest request = (HttpServletRequest)messageInfo.getRequestMessage();
        HttpServletResponse response = (HttpServletResponse)messageInfo.getResponseMessage();
        String credentials = request.getHeader(HttpHeader.AUTHORIZATION.asString());
        try {
            boolean stale = false;
            long timestamp = System.currentTimeMillis();
            if (credentials != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Credentials: " + credentials, new Object[0]);
                }
                QuotedStringTokenizer tokenizer = new QuotedStringTokenizer(credentials, "=, ", true, false);
                Digest digest = new Digest(request.getMethod());
                String last = null;
                String name = null;
                block8: while (tokenizer.hasMoreTokens()) {
                    String tok = tokenizer.nextToken();
                    char c = tok.length() == 1 ? tok.charAt(0) : (char)'\u0000';
                    switch (c) {
                        case '=': {
                            name = last;
                            last = tok;
                            continue block8;
                        }
                        case ',': {
                            name = null;
                        }
                        case ' ': {
                            continue block8;
                        }
                    }
                    last = tok;
                    if (name == null) continue;
                    if ("username".equalsIgnoreCase(name)) {
                        digest.username = tok;
                        continue;
                    }
                    if ("realm".equalsIgnoreCase(name)) {
                        digest.realm = tok;
                        continue;
                    }
                    if ("nonce".equalsIgnoreCase(name)) {
                        digest.nonce = tok;
                        continue;
                    }
                    if ("nc".equalsIgnoreCase(name)) {
                        digest.nc = tok;
                        continue;
                    }
                    if ("cnonce".equalsIgnoreCase(name)) {
                        digest.cnonce = tok;
                        continue;
                    }
                    if ("qop".equalsIgnoreCase(name)) {
                        digest.qop = tok;
                        continue;
                    }
                    if ("uri".equalsIgnoreCase(name)) {
                        digest.uri = tok;
                        continue;
                    }
                    if (!"response".equalsIgnoreCase(name)) continue;
                    digest.response = tok;
                }
                int n = this.checkNonce(digest.nonce, timestamp);
                if (n > 0) {
                    if (this.login(clientSubject, digest.username, digest, "DIGEST", messageInfo)) {
                        return AuthStatus.SUCCESS;
                    }
                } else if (n == 0) {
                    stale = true;
                }
            }
            if (!this.isMandatory(messageInfo)) {
                return AuthStatus.SUCCESS;
            }
            String domain = request.getContextPath();
            if (domain == null) {
                domain = "/";
            }
            response.setHeader(HttpHeader.WWW_AUTHENTICATE.asString(), "Digest realm=\"" + this.realmName + "\", domain=\"" + domain + "\", nonce=\"" + this.newNonce(timestamp) + "\", algorithm=MD5, qop=\"auth\"" + (this.useStale ? " stale=" + stale : ""));
            response.sendError(401);
            return AuthStatus.SEND_CONTINUE;
        }
        catch (IOException e) {
            throw new AuthException(e.getMessage());
        }
        catch (UnsupportedCallbackException e) {
            throw new AuthException(e.getMessage());
        }
    }

    public String newNonce(long ts) {
        long sk = this.nonceSecret;
        byte[] nounce = new byte[24];
        for (int i = 0; i < 8; ++i) {
            nounce[i] = (byte)(ts & 0xFFL);
            ts >>= 8;
            nounce[8 + i] = (byte)(sk & 0xFFL);
            sk >>= 8;
        }
        byte[] hash = null;
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.reset();
            md.update(nounce, 0, 16);
            hash = md.digest();
        }
        catch (Exception e) {
            LOG.warn(e);
        }
        for (int i = 0; i < hash.length; ++i) {
            nounce[8 + i] = hash[i];
            if (i == 23) break;
        }
        return new String(B64Code.encode(nounce));
    }

    public int checkNonce(String nonce, long timestamp) {
        try {
            byte[] n = B64Code.decode(nonce.toCharArray());
            if (n.length != 24) {
                return -1;
            }
            long ts = 0L;
            long sk = this.nonceSecret;
            byte[] n2 = new byte[16];
            System.arraycopy(n, 0, n2, 0, 8);
            for (int i = 0; i < 8; ++i) {
                n2[8 + i] = (byte)(sk & 0xFFL);
                sk >>= 8;
                ts = (ts << 8) + (0xFFL & (long)n[7 - i]);
            }
            long age = timestamp - ts;
            if (LOG.isDebugEnabled()) {
                LOG.debug("age=" + age, new Object[0]);
            }
            byte[] hash = null;
            try {
                MessageDigest md = MessageDigest.getInstance("MD5");
                md.reset();
                md.update(n2, 0, 16);
                hash = md.digest();
            }
            catch (Exception e) {
                LOG.warn(e);
            }
            for (int i = 0; i < 16; ++i) {
                if (n[i + 8] == hash[i]) continue;
                return -1;
            }
            if (this.maxNonceAge > 0L && (age < 0L || age > this.maxNonceAge)) {
                return 0;
            }
            return 1;
        }
        catch (Exception e) {
            LOG.ignore(e);
            return -1;
        }
    }

    private static class Digest
    extends Credential {
        private static final long serialVersionUID = -1866670896275159116L;
        String method = null;
        String username = null;
        String realm = null;
        String nonce = null;
        String nc = null;
        String cnonce = null;
        String qop = null;
        String uri = null;
        String response = null;

        Digest(String m) {
            this.method = m;
        }

        @Override
        public boolean check(Object credentials) {
            String password = credentials instanceof String ? (String)credentials : credentials.toString();
            try {
                byte[] ha1;
                MessageDigest md = MessageDigest.getInstance("MD5");
                if (credentials instanceof Credential.MD5) {
                    ha1 = ((Credential.MD5)credentials).getDigest();
                } else {
                    md.update(this.username.getBytes(StandardCharsets.ISO_8859_1));
                    md.update((byte)58);
                    md.update(this.realm.getBytes(StandardCharsets.ISO_8859_1));
                    md.update((byte)58);
                    md.update(password.getBytes(StandardCharsets.ISO_8859_1));
                    ha1 = md.digest();
                }
                md.reset();
                md.update(this.method.getBytes(StandardCharsets.ISO_8859_1));
                md.update((byte)58);
                md.update(this.uri.getBytes(StandardCharsets.ISO_8859_1));
                byte[] ha2 = md.digest();
                md.update(TypeUtil.toString(ha1, 16).getBytes(StandardCharsets.ISO_8859_1));
                md.update((byte)58);
                md.update(this.nonce.getBytes(StandardCharsets.ISO_8859_1));
                md.update((byte)58);
                md.update(this.nc.getBytes(StandardCharsets.ISO_8859_1));
                md.update((byte)58);
                md.update(this.cnonce.getBytes(StandardCharsets.ISO_8859_1));
                md.update((byte)58);
                md.update(this.qop.getBytes(StandardCharsets.ISO_8859_1));
                md.update((byte)58);
                md.update(TypeUtil.toString(ha2, 16).getBytes(StandardCharsets.ISO_8859_1));
                byte[] digest = md.digest();
                return TypeUtil.toString(digest, 16).equalsIgnoreCase(this.response);
            }
            catch (Exception e) {
                LOG.warn(e);
                return false;
            }
        }

        public String toString() {
            return this.username + "," + this.response;
        }
    }
}

