/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.client;

import java.io.IOException;
import java.net.CookieStore;
import java.net.SocketAddress;
import java.net.URI;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.MappedByteBufferPool;
import org.eclipse.jetty.util.DecoratedObjectFactory;
import org.eclipse.jetty.util.HttpCookieStore;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ScheduledExecutorScheduler;
import org.eclipse.jetty.util.thread.Scheduler;
import org.eclipse.jetty.util.thread.ShutdownThread;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.WebSocketPolicy;
import org.eclipse.jetty.websocket.api.extensions.ExtensionConfig;
import org.eclipse.jetty.websocket.api.extensions.ExtensionFactory;
import org.eclipse.jetty.websocket.client.ClientUpgradeRequest;
import org.eclipse.jetty.websocket.client.io.ConnectPromise;
import org.eclipse.jetty.websocket.client.io.ConnectionManager;
import org.eclipse.jetty.websocket.client.io.UpgradeListener;
import org.eclipse.jetty.websocket.client.masks.Masker;
import org.eclipse.jetty.websocket.client.masks.RandomMasker;
import org.eclipse.jetty.websocket.common.SessionFactory;
import org.eclipse.jetty.websocket.common.WebSocketSession;
import org.eclipse.jetty.websocket.common.WebSocketSessionFactory;
import org.eclipse.jetty.websocket.common.events.EventDriver;
import org.eclipse.jetty.websocket.common.events.EventDriverFactory;
import org.eclipse.jetty.websocket.common.extensions.WebSocketExtensionFactory;
import org.eclipse.jetty.websocket.common.scopes.WebSocketContainerScope;

public class WebSocketClient
extends ContainerLifeCycle
implements WebSocketContainerScope {
    private static final Logger LOG = Log.getLogger(WebSocketClient.class);
    private final WebSocketPolicy policy = WebSocketPolicy.newClientPolicy();
    private final SslContextFactory sslContextFactory;
    private final WebSocketExtensionFactory extensionRegistry;
    private boolean daemon = false;
    private EventDriverFactory eventDriverFactory;
    private SessionFactory sessionFactory;
    private ByteBufferPool bufferPool;
    private Executor executor;
    private DecoratedObjectFactory objectFactory;
    private Scheduler scheduler;
    private CookieStore cookieStore;
    private ConnectionManager connectionManager;
    private Masker masker;
    private SocketAddress bindAddress;
    private long connectTimeout = 15000L;
    private boolean dispatchIO = true;

    public WebSocketClient() {
        this((SslContextFactory)null, null);
    }

    public WebSocketClient(Executor executor) {
        this(null, executor);
    }

    public WebSocketClient(ByteBufferPool bufferPool) {
        this(null, null, bufferPool);
    }

    public WebSocketClient(SslContextFactory sslContextFactory) {
        this(sslContextFactory, null);
    }

    public WebSocketClient(SslContextFactory sslContextFactory, Executor executor) {
        this(sslContextFactory, executor, new MappedByteBufferPool());
    }

    public WebSocketClient(WebSocketContainerScope scope) {
        this(scope.getSslContextFactory(), scope.getExecutor(), scope.getBufferPool(), scope.getObjectFactory());
    }

    public WebSocketClient(WebSocketContainerScope scope, SslContextFactory sslContextFactory) {
        this(sslContextFactory, scope.getExecutor(), scope.getBufferPool(), scope.getObjectFactory());
    }

    public WebSocketClient(SslContextFactory sslContextFactory, Executor executor, ByteBufferPool bufferPool) {
        this(sslContextFactory, executor, bufferPool, new DecoratedObjectFactory());
    }

    public WebSocketClient(SslContextFactory sslContextFactory, Executor executor, ByteBufferPool bufferPool, DecoratedObjectFactory objectFactory) {
        this.executor = executor;
        this.sslContextFactory = sslContextFactory;
        this.bufferPool = bufferPool;
        this.objectFactory = objectFactory;
        this.extensionRegistry = new WebSocketExtensionFactory(this);
        this.masker = new RandomMasker();
        this.eventDriverFactory = new EventDriverFactory(this.policy);
        this.addBean(this.executor);
        this.addBean(this.sslContextFactory);
        this.addBean(this.bufferPool);
    }

    public Future<Session> connect(Object websocket, URI toUri) throws IOException {
        ClientUpgradeRequest request = new ClientUpgradeRequest(toUri);
        request.setRequestURI(toUri);
        request.setCookiesFrom(this.cookieStore);
        return this.connect(websocket, toUri, request);
    }

    public Future<Session> connect(Object websocket, URI toUri, ClientUpgradeRequest request) throws IOException {
        return this.connect(websocket, toUri, request, null);
    }

    public Future<Session> connect(Object websocket, URI toUri, ClientUpgradeRequest request, UpgradeListener upgradeListener) throws IOException {
        if (!this.isStarted()) {
            throw new IllegalStateException(WebSocketClient.class.getSimpleName() + "@" + this.hashCode() + " is not started");
        }
        if (!toUri.isAbsolute()) {
            throw new IllegalArgumentException("WebSocket URI must be absolute");
        }
        if (StringUtil.isBlank(toUri.getScheme())) {
            throw new IllegalArgumentException("WebSocket URI must include a scheme");
        }
        String scheme = toUri.getScheme().toLowerCase(Locale.ENGLISH);
        if (!"ws".equals(scheme) && !"wss".equals(scheme)) {
            throw new IllegalArgumentException("WebSocket URI scheme only supports [ws] and [wss], not [" + scheme + "]");
        }
        request.setRequestURI(toUri);
        request.setCookiesFrom(this.cookieStore);
        for (ExtensionConfig reqExt : request.getExtensions()) {
            if (this.extensionRegistry.isAvailable(reqExt.getName())) continue;
            throw new IllegalArgumentException("Requested extension [" + reqExt.getName() + "] is not installed");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("connect websocket {} to {}", websocket, toUri);
        }
        this.initializeClient();
        ConnectionManager manager = this.getConnectionManager();
        EventDriver driver = null;
        driver = websocket instanceof EventDriver ? (EventDriver)websocket : this.eventDriverFactory.wrap(websocket);
        if (driver == null) {
            throw new IllegalStateException("Unable to identify as websocket object: " + websocket.getClass().getName());
        }
        ConnectPromise promise = manager.connect(this, driver, request);
        if (upgradeListener != null) {
            promise.setUpgradeListener(upgradeListener);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Connect Promise: {}", promise);
        }
        this.executor.execute(promise);
        return promise;
    }

    @Override
    protected void doStart() throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Starting {}", this);
        }
        if (this.sslContextFactory != null) {
            this.addBean(this.sslContextFactory);
        }
        String name = WebSocketClient.class.getSimpleName() + "@" + this.hashCode();
        if (this.bufferPool == null) {
            this.bufferPool = new MappedByteBufferPool();
        }
        this.addBean(this.bufferPool);
        if (this.scheduler == null) {
            this.scheduler = new ScheduledExecutorScheduler(name + "-scheduler", this.daemon);
        }
        this.addBean(this.scheduler);
        if (this.cookieStore == null) {
            this.cookieStore = new HttpCookieStore.Empty();
        }
        if (this.sessionFactory == null) {
            this.sessionFactory = new WebSocketSessionFactory(this);
        }
        if (this.objectFactory == null) {
            this.objectFactory = new DecoratedObjectFactory();
        }
        super.doStart();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Started {}", this);
        }
    }

    @Override
    protected void doStop() throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Stopping {}", this);
        }
        if (ShutdownThread.isRegistered(this)) {
            ShutdownThread.deregister(this);
        }
        if (this.cookieStore != null) {
            this.cookieStore.removeAll();
            this.cookieStore = null;
        }
        super.doStop();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Stopped {}", this);
        }
    }

    public boolean isDispatchIO() {
        return this.dispatchIO;
    }

    public long getAsyncWriteTimeout() {
        return this.policy.getAsyncWriteTimeout();
    }

    public SocketAddress getBindAddress() {
        return this.bindAddress;
    }

    @Override
    public ByteBufferPool getBufferPool() {
        return this.bufferPool;
    }

    public ConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    public long getConnectTimeout() {
        return this.connectTimeout;
    }

    public CookieStore getCookieStore() {
        return this.cookieStore;
    }

    public EventDriverFactory getEventDriverFactory() {
        return this.eventDriverFactory;
    }

    @Override
    public Executor getExecutor() {
        return this.executor;
    }

    public ExtensionFactory getExtensionFactory() {
        return this.extensionRegistry;
    }

    public Masker getMasker() {
        return this.masker;
    }

    public int getMaxBinaryMessageBufferSize() {
        return this.policy.getMaxBinaryMessageBufferSize();
    }

    public long getMaxBinaryMessageSize() {
        return this.policy.getMaxBinaryMessageSize();
    }

    public long getMaxIdleTimeout() {
        return this.policy.getIdleTimeout();
    }

    public int getMaxTextMessageBufferSize() {
        return this.policy.getMaxTextMessageBufferSize();
    }

    public long getMaxTextMessageSize() {
        return this.policy.getMaxTextMessageSize();
    }

    @Override
    public DecoratedObjectFactory getObjectFactory() {
        return this.objectFactory;
    }

    public Set<WebSocketSession> getOpenSessions() {
        return Collections.unmodifiableSet(new HashSet<WebSocketSession>(this.getBeans(WebSocketSession.class)));
    }

    @Override
    public WebSocketPolicy getPolicy() {
        return this.policy;
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    @Override
    public SslContextFactory getSslContextFactory() {
        return this.sslContextFactory;
    }

    private synchronized void initializeClient() throws IOException {
        if (!ShutdownThread.isRegistered(this)) {
            ShutdownThread.register(this);
        }
        if (this.executor == null) {
            QueuedThreadPool threadPool = new QueuedThreadPool();
            String name = WebSocketClient.class.getSimpleName() + "@" + this.hashCode();
            threadPool.setName(name);
            threadPool.setDaemon(this.daemon);
            this.executor = threadPool;
            this.addManaged(threadPool);
        } else {
            this.addBean((Object)this.executor, false);
        }
        if (this.connectionManager == null) {
            this.connectionManager = this.newConnectionManager();
            this.addManaged(this.connectionManager);
        }
    }

    protected ConnectionManager newConnectionManager() {
        return new ConnectionManager(this);
    }

    @Override
    public void onSessionClosed(WebSocketSession session) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Session Closed: {}", session);
        }
        this.removeBean(session);
    }

    @Override
    public void onSessionOpened(WebSocketSession session) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Session Opened: {}", session);
        }
        this.addManaged(session);
    }

    public void setAsyncWriteTimeout(long ms) {
        this.policy.setAsyncWriteTimeout(ms);
    }

    @Deprecated
    public void setBindAdddress(SocketAddress bindAddress) {
        this.setBindAddress(bindAddress);
    }

    public void setBindAddress(SocketAddress bindAddress) {
        this.bindAddress = bindAddress;
    }

    public void setBufferPool(ByteBufferPool bufferPool) {
        this.bufferPool = bufferPool;
    }

    public void setConnectTimeout(long ms) {
        if (ms < 0L) {
            throw new IllegalStateException("Connect Timeout cannot be negative");
        }
        this.connectTimeout = ms;
    }

    public void setCookieStore(CookieStore cookieStore) {
        this.cookieStore = cookieStore;
    }

    public void setDaemon(boolean daemon) {
        this.daemon = daemon;
    }

    public void setDispatchIO(boolean dispatchIO) {
        this.dispatchIO = dispatchIO;
    }

    public void setEventDriverFactory(EventDriverFactory factory) {
        this.eventDriverFactory = factory;
    }

    public void setExecutor(Executor executor) {
        this.updateBean(this.executor, executor);
        this.executor = executor;
    }

    public void setMasker(Masker masker) {
        this.masker = masker;
    }

    public void setMaxBinaryMessageBufferSize(int max) {
        this.policy.setMaxBinaryMessageBufferSize(max);
    }

    public void setMaxIdleTimeout(long ms) {
        this.policy.setIdleTimeout(ms);
    }

    public void setMaxTextMessageBufferSize(int max) {
        this.policy.setMaxTextMessageBufferSize(max);
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    @Override
    public void dump(Appendable out, String indent) throws IOException {
        this.dumpThis(out);
        WebSocketClient.dump(out, indent, this.getOpenSessions());
    }
}

