/*
 * Decompiled with CFR 0.152.
 */
package org.sportdata.set.billing.utils;

import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Document;
import com.itextpdf.text.Font;
import com.itextpdf.text.FontFactory;
import com.itextpdf.text.Image;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.FontSelector;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.sportdata.set.W.a.b;
import org.sportdata.set.an.b.aj;
import org.sportdata.set.billing.beans.BillingBean;
import org.sportdata.set.billing.beans.ProductBean;
import org.sportdata.set.g.v;

public class InvoiceGenerator {
    public static boolean makePDF(File fileName, BillingBean data) {
        List<ProductBean> products = data.getProducts();
        Date curDate = new Date();
        SimpleDateFormat format = new SimpleDateFormat("dd-MM-yyy");
        String date = format.format(curDate);
        try {
            File billinglogo;
            String waehrung = aj.a(v.a().o()).a();
            FileOutputStream file = new FileOutputStream(fileName);
            Document document = new Document();
            PdfWriter.getInstance(document, file);
            BaseFont base = BaseFont.createFont("fonts/ARIALUNI.TTF", "Identity-H", true);
            Font font = new Font(base, 15.0f, 0);
            Font fontbig = new Font(base, 20.0f, 0);
            Image image = null;
            if (!b.x().equals("") && (billinglogo = new File(b.x())).exists()) {
                image = Image.getInstance("file:" + b.x());
                image.scaleAbsolute(540.0f, 72.0f);
            }
            if (image == null) {
                image = Image.getInstance("file:images/billing-logo.jpg");
                image.scaleAbsolute(540.0f, 72.0f);
            }
            PdfPTable irdTable = new PdfPTable(2);
            irdTable.addCell(InvoiceGenerator.getIRDCell("Invoice No"));
            irdTable.addCell(InvoiceGenerator.getIRDCell("Invoice Date"));
            irdTable.addCell(InvoiceGenerator.getIRDCell(data.getInvoiceNumber()));
            irdTable.addCell(InvoiceGenerator.getIRDCell(date));
            PdfPTable irhTable = new PdfPTable(3);
            irhTable.setWidthPercentage(100.0f);
            irhTable.addCell(InvoiceGenerator.getIRHCell("", 2, font));
            irhTable.addCell(InvoiceGenerator.getIRHCell("", 2, font));
            irhTable.addCell(InvoiceGenerator.getIRHCell("Invoice", 2, font));
            irhTable.addCell(InvoiceGenerator.getIRHCell("", 2, font));
            irhTable.addCell(InvoiceGenerator.getIRHCell("", 2, font));
            PdfPCell invoiceTable = new PdfPCell(irdTable);
            invoiceTable.setBorder(0);
            irhTable.addCell(invoiceTable);
            FontSelector fs = new FontSelector();
            fs.addFont(font);
            Phrase bill = fs.process("Bill To");
            Paragraph name = new Paragraph(data.getCustomerName(), font);
            name.setIndentationLeft(20.0f);
            Paragraph contact = new Paragraph(data.getCustomerContact(), font);
            contact.setIndentationLeft(20.0f);
            Paragraph address = new Paragraph(data.getCustomerAddress(), font);
            address.setIndentationLeft(20.0f);
            PdfPTable billTable = new PdfPTable(6);
            billTable.setWidthPercentage(100.0f);
            billTable.setWidths(new float[]{1.0f, 2.0f, 5.0f, 2.0f, 1.0f, 2.0f});
            billTable.setSpacingBefore(30.0f);
            billTable.addCell(InvoiceGenerator.getBillHeaderCell("Index", font));
            billTable.addCell(InvoiceGenerator.getBillHeaderCell("Item", font));
            billTable.addCell(InvoiceGenerator.getBillHeaderCell("Description", font));
            billTable.addCell(InvoiceGenerator.getBillHeaderCell("Unit Price", font));
            billTable.addCell(InvoiceGenerator.getBillHeaderCell("Qty", font));
            billTable.addCell(InvoiceGenerator.getBillHeaderCell("Amount", font));
            int i2 = 0;
            while (i2 < products.size()) {
                billTable.addCell(InvoiceGenerator.getBillRowCell("" + (i2 + 1)));
                billTable.addCell(InvoiceGenerator.getBillRowCell(products.get(i2).getType()));
                billTable.addCell(InvoiceGenerator.getBillRowCell(products.get(i2).getProductDescription()));
                billTable.addCell(InvoiceGenerator.getBillRowCell(products.get(i2).getUnitPrice() + " " + waehrung));
                billTable.addCell(InvoiceGenerator.getBillRowCell("" + products.get(i2).getNoOfUnits()));
                billTable.addCell(InvoiceGenerator.getBillRowCell(products.get(i2).getTotalCost() + " " + waehrung));
                ++i2;
            }
            int j2 = 0;
            while (j2 < 15 - products.size()) {
                billTable.addCell(InvoiceGenerator.getBillRowCell(" "));
                billTable.addCell(InvoiceGenerator.getBillRowCell(""));
                billTable.addCell(InvoiceGenerator.getBillRowCell(""));
                billTable.addCell(InvoiceGenerator.getBillRowCell(""));
                billTable.addCell(InvoiceGenerator.getBillRowCell(""));
                billTable.addCell(InvoiceGenerator.getBillRowCell(""));
                ++j2;
            }
            PdfPTable validity = new PdfPTable(1);
            validity.setWidthPercentage(100.0f);
            validity.addCell(InvoiceGenerator.getValidityCell(" ", font));
            PdfPCell summaryL = new PdfPCell(validity);
            summaryL.setColspan(3);
            summaryL.setPadding(1.0f);
            billTable.addCell(summaryL);
            PdfPTable accounts = new PdfPTable(2);
            accounts.setWidthPercentage(100.0f);
            accounts.addCell(InvoiceGenerator.getAccountsCell("Subtotal", font));
            accounts.addCell(InvoiceGenerator.getAccountsCellR(data.getSubTotalPrice() + " " + waehrung));
            accounts.addCell(InvoiceGenerator.getAccountsCell("Discount (" + data.getDiscount() + "%)", font));
            accounts.addCell(InvoiceGenerator.getAccountsCellR(data.getDiscountPrice() + " " + waehrung));
            accounts.addCell(InvoiceGenerator.getAccountsCell("Tax (" + data.getTax() + "%)", font));
            accounts.addCell(InvoiceGenerator.getAccountsCellR(data.getTaxPrice() + " " + waehrung));
            accounts.addCell(InvoiceGenerator.getAccountsCell("Total", font));
            accounts.addCell(InvoiceGenerator.getAccountsCellR(data.getTotalPrice() + " " + waehrung));
            PdfPCell summaryR = new PdfPCell(accounts);
            summaryR.setColspan(3);
            billTable.addCell(summaryR);
            PdfPTable describer = new PdfPTable(1);
            describer.setWidthPercentage(100.0f);
            describer.addCell(InvoiceGenerator.getdescCell(" ", font));
            describer.addCell(v.a().c() + ", " + v.a().h());
            document.open();
            document.add(image);
            document.add(irhTable);
            document.add(bill);
            document.add(name);
            document.add(contact);
            document.add(address);
            document.add(billTable);
            document.add(describer);
            document.close();
            ((OutputStream)file).close();
            return true;
        }
        catch (Exception e2) {
            e2.printStackTrace();
            return false;
        }
    }

    public static PdfPCell getIRHCell(String text, int alignment, Font font) {
        FontSelector fs = new FontSelector();
        fs.addFont(font);
        Phrase phrase = fs.process(text);
        PdfPCell cell = new PdfPCell(phrase);
        cell.setPadding(5.0f);
        cell.setHorizontalAlignment(alignment);
        cell.setBorder(0);
        return cell;
    }

    public static PdfPCell getIRDCell(String text) {
        PdfPCell cell = new PdfPCell(new Paragraph(text));
        cell.setHorizontalAlignment(1);
        cell.setPadding(5.0f);
        cell.setBorderColor(BaseColor.LIGHT_GRAY);
        return cell;
    }

    public static PdfPCell getBillHeaderCell(String text, Font font) {
        FontSelector fs = new FontSelector();
        font.setColor(BaseColor.GRAY);
        fs.addFont(font);
        Phrase phrase = fs.process(text);
        PdfPCell cell = new PdfPCell(phrase);
        cell.setHorizontalAlignment(1);
        cell.setPadding(5.0f);
        return cell;
    }

    public static PdfPCell getBillRowCell(String text) {
        PdfPCell cell = new PdfPCell(new Paragraph(text));
        cell.setHorizontalAlignment(1);
        cell.setPadding(5.0f);
        cell.setBorderWidthBottom(0.0f);
        cell.setBorderWidthTop(0.0f);
        return cell;
    }

    public static PdfPCell getBillFooterCell(String text) {
        PdfPCell cell = new PdfPCell(new Paragraph(text));
        cell.setHorizontalAlignment(1);
        cell.setPadding(5.0f);
        cell.setBorderWidthBottom(0.0f);
        cell.setBorderWidthTop(0.0f);
        return cell;
    }

    public static PdfPCell getValidityCell(String text, Font font) {
        FontSelector fs = new FontSelector();
        font.setColor(BaseColor.GRAY);
        fs.addFont(font);
        Phrase phrase = fs.process(text);
        PdfPCell cell = new PdfPCell(phrase);
        cell.setBorder(0);
        return cell;
    }

    public static PdfPCell getAccountsCell(String text, Font font) {
        FontSelector fs = new FontSelector();
        fs.addFont(font);
        Phrase phrase = fs.process(text);
        PdfPCell cell = new PdfPCell(phrase);
        cell.setBorderWidthRight(0.0f);
        cell.setBorderWidthTop(0.0f);
        cell.setPadding(5.0f);
        return cell;
    }

    public static PdfPCell getAccountsCellR(String text) {
        FontSelector fs = new FontSelector();
        Font font = FontFactory.getFont("Helvetica", 10.0f);
        fs.addFont(font);
        Phrase phrase = fs.process(text);
        PdfPCell cell = new PdfPCell(phrase);
        cell.setBorderWidthLeft(0.0f);
        cell.setBorderWidthTop(0.0f);
        cell.setHorizontalAlignment(2);
        cell.setPadding(5.0f);
        cell.setPaddingRight(20.0f);
        return cell;
    }

    public static PdfPCell getdescCell(String text, Font font) {
        FontSelector fs = new FontSelector();
        font.setColor(BaseColor.GRAY);
        fs.addFont(font);
        Phrase phrase = fs.process(text);
        PdfPCell cell = new PdfPCell(phrase);
        cell.setHorizontalAlignment(1);
        cell.setBorder(0);
        return cell;
    }
}

