/*
 * Decompiled with CFR 0.152.
 */
package org.sportdata.set.extension.dtm.beans;

import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.Calendar;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import org.sportdata.set.extension.dtm.beans.DTMBean;
import org.sportdata.set.extension.dtm.controller.DTMController;
import org.sportdata.set.extension.dtm.internal.beans.DTMMaster;
import org.sportdata.set.extension.dtm.jfxtras.internal.scene.control.skin.agenda.base24hour.AppointmentRegularBodyPane;
import org.sportdata.set.extension.dtm.jfxtras.scene.control.agenda.Agenda;
import org.sportdata.set.extension.dtm.util.DTMUtil;
import org.sportdata.set.extension.dtm.util.TimestampUtil;

public class TimetableBean
extends DTMBean
implements Agenda.Appointment {
    private int id;
    private int vernr;
    private Date date;
    private int tatamis;
    private int knr;
    private String catname;
    private String sex;
    private int type;
    private int tatami;
    private int pool;
    private int pools;
    private int entries;
    private int fighttime;
    private boolean edited;
    private String color;
    private Timestamp starttime;
    private Timestamp endtime;
    private String comment;
    private int matchnumber = 0;
    private final ObjectProperty<AppointmentRegularBodyPane> regularBodyPaneProperty = new SimpleObjectProperty((Object)this, "regularBodyPane");
    private final ObjectProperty<Calendar> startTimeObjectProperty = new SimpleObjectProperty((Object)this, "startTime");
    private final ObjectProperty<Calendar> endTimeObjectProperty = new SimpleObjectProperty((Object)this, "endTime");
    private final ObjectProperty<LocalDateTime> startLocalDateTime = new SimpleObjectProperty((Object)this, "startLocalDateTime");
    private final ObjectProperty<LocalDateTime> endLocalDateTimeProperty = new SimpleObjectProperty((Object)this, "endLocalDateTimeProperty");
    private final ObjectProperty<Boolean> wholeDayObjectProperty = new SimpleObjectProperty((Object)this, "wholeDay", (Object)false);
    private final ObjectProperty<String> summaryObjectProperty = new SimpleObjectProperty((Object)this, "summary");
    private final ObjectProperty<String> descriptionObjectProperty = new SimpleObjectProperty((Object)this, "description");
    private final ObjectProperty<String> locationObjectProperty = new SimpleObjectProperty((Object)this, "location");
    private final ObjectProperty<Agenda.AppointmentGroup> appointmentGroupObjectProperty = new SimpleObjectProperty((Object)this, "appointmentGroup");

    public TimetableBean() {
    }

    public TimetableBean(int id, int vernr, Date date, int tatamis, int knr, String catname, String sex, int type, int tatami, int pool, int pools, int entries, int fighttime, boolean edited, String color, Timestamp starttime, Timestamp endtime, String comment, DTMController controller, int matchnumber) {
        this.id = id;
        this.vernr = vernr;
        this.date = date;
        this.tatamis = tatamis;
        this.knr = knr;
        this.catname = catname;
        this.sex = sex;
        this.type = type;
        this.tatami = tatami;
        this.pool = pool;
        this.pools = pools;
        this.entries = entries;
        this.fighttime = fighttime;
        this.edited = edited;
        this.color = color;
        this.starttime = starttime;
        this.endtime = endtime;
        this.comment = comment;
        this.matchnumber = matchnumber;
        this.setController(controller);
        if (id != 0) {
            this.setStartLocalDateTime(DTMUtil.getFakeLocalDateTime(tatami, starttime.toLocalDateTime(), DTMMaster.getInstance().getEvent()));
            this.setEndLocalDateTime(DTMUtil.getFakeLocalDateTime(tatami, endtime.toLocalDateTime(), DTMMaster.getInstance().getEvent()));
            this.setDescription(starttime.toString() + " - " + endtime.toString() + "(Duration: " + this.getFormattedCatDuration() + ", Matchtime: " + fighttime + ")");
        }
        this.setWholeDay(false);
        this.setLocation("Match Area: " + tatami);
        this.setAppointmentGroup(new Agenda.AppointmentGroupImpl().withStyleClass(color));
    }

    public int compareTo(Object bean) {
        if (this.getStarttime().before(((TimetableBean)bean).getStarttime())) {
            return 1;
        }
        if (this.getStarttime() == ((TimetableBean)bean).getStarttime()) {
            return 0;
        }
        return -1;
    }

    @Override
    public PreparedStatement insertStmt(Connection conn) {
        this.pstmt = null;
        int edited = this.isEdited() ? 1 : 0;
        String pstmtString = "INSERT INTO timetable (vernr,date,tatamis,knr,catname,sex,type,tatami,pool,pools,entries,fighttime,edited,color,starttime,endtime,comment,matchnumber) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?);";
        try {
            this.pstmt = conn.prepareStatement(pstmtString);
            this.pstmt.setInt(1, this.getVernr());
            this.pstmt.setDate(2, this.getDate());
            this.pstmt.setInt(3, this.getTatamis());
            this.pstmt.setInt(4, this.getKnr());
            this.pstmt.setString(5, this.getCatname());
            this.pstmt.setString(6, this.getSex());
            this.pstmt.setInt(7, this.getType());
            this.pstmt.setInt(8, this.getTatami());
            this.pstmt.setInt(9, this.getPool());
            this.pstmt.setInt(10, this.getPools());
            this.pstmt.setInt(11, this.getEntries());
            this.pstmt.setInt(12, this.getFighttime());
            this.pstmt.setInt(13, edited);
            this.pstmt.setString(14, this.getColor());
            this.pstmt.setTimestamp(15, this.getStarttime());
            this.pstmt.setTimestamp(16, this.getEndtime());
            this.pstmt.setString(17, this.getComment());
            this.pstmt.setInt(18, this.getMatchnumber());
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return this.pstmt;
    }

    @Override
    public PreparedStatement updateStmt(Connection conn) {
        this.pstmt = null;
        int edited = this.isEdited() ? 1 : 0;
        String pstmtString = "UPDATE timetable SET vernr = ?,date = ?, tatamis = ?,knr = ?,catname = ?,sex = ?,type = ?,tatami = ?,pool = ?,pools = ?,entries = ?,fighttime = ?,edited = ?,color = ?,starttime = ?,endtime = ?,comment = ?, matchnumber = ? WHERE id = ?;";
        try {
            this.pstmt = conn.prepareStatement(pstmtString);
            this.pstmt.setInt(1, this.getVernr());
            this.pstmt.setDate(2, this.getDate());
            this.pstmt.setInt(3, this.getTatamis());
            this.pstmt.setInt(4, this.getKnr());
            this.pstmt.setString(5, this.getCatname());
            this.pstmt.setString(6, this.getSex());
            this.pstmt.setInt(7, this.getType());
            this.pstmt.setInt(8, this.getTatami());
            this.pstmt.setInt(9, this.getPool());
            this.pstmt.setInt(10, this.getPools());
            this.pstmt.setInt(11, this.getEntries());
            this.pstmt.setInt(12, this.getFighttime());
            this.pstmt.setInt(13, edited);
            this.pstmt.setString(14, this.getColor());
            this.pstmt.setTimestamp(15, this.getStarttime());
            this.pstmt.setTimestamp(16, this.getEndtime());
            this.pstmt.setString(17, this.getComment());
            this.pstmt.setInt(18, this.getMatchnumber());
            this.pstmt.setInt(19, this.getId());
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return this.pstmt;
    }

    @Override
    public PreparedStatement deleteStmt(Connection conn) {
        this.pstmt = null;
        String pstmtString = "DELETE FROM timetable WHERE id = ?;";
        try {
            this.pstmt = conn.prepareStatement(pstmtString);
            this.pstmt.setInt(1, this.getId());
        }
        catch (SQLException e2) {
            e2.printStackTrace();
        }
        return this.pstmt;
    }

    @Override
    public String getInsertString() {
        int edited = this.isEdited() ? 1 : 0;
        return "INSERT INTO timetable (vernr,date,tatamis,knr,catname,sex,type,tatami,pool,pools,entries,fighttime,edited,color,starttime,endtime,comment,matchnumber) VALUES (" + this.getVernr() + ",'" + String.valueOf(this.getDate()) + "'," + this.getTatamis() + "," + this.getKnr() + ",'" + this.getCatname() + "','" + this.getSex() + "'," + this.getType() + "," + this.getTatami() + "," + this.getPool() + "," + this.getPools() + "," + this.getEntries() + "," + this.getFighttime() + "," + edited + ",'" + this.getColor() + "','" + String.valueOf(this.getStarttime()) + "','" + String.valueOf(this.getEndtime()) + "','" + this.getComment() + "','" + this.getMatchnumber() + "');";
    }

    @Override
    public String getUpdateString() {
        int edited = this.isEdited() ? 1 : 0;
        return "UPDATE timetable SET vernr = " + this.getVernr() + ",date = '" + String.valueOf(this.getDate()) + "', tatamis = " + this.getTatamis() + ",knr = " + this.getKnr() + ",catname = '" + this.getCatname() + "',sex = '" + this.getSex() + "',type = " + this.getType() + ",tatami = " + this.getTatami() + ",pool = " + this.getPool() + ",pools = " + this.getPools() + ",entries = " + this.getEntries() + ",fighttime = " + this.getFighttime() + ",edited = " + edited + ",color = '" + this.getColor() + "',starttime = '" + String.valueOf(this.getStarttime()) + "',endtime = '" + String.valueOf(this.getEndtime()) + "',comment = '" + this.getComment() + "',matchnumber = '" + this.getMatchnumber() + "' WHERE id = " + this.getId() + ";";
    }

    @Override
    public String getDeleteString() {
        return "DELETE FROM timetable WHERE id = " + this.getId() + ";";
    }

    public ObjectProperty<AppointmentRegularBodyPane> regularBodyPaneProperty() {
        return this.regularBodyPaneProperty;
    }

    public AppointmentRegularBodyPane getRegularBodyPane() {
        return (AppointmentRegularBodyPane)((Object)this.regularBodyPaneProperty.getValue());
    }

    public void setRegularBodyPane(AppointmentRegularBodyPane value) {
        this.regularBodyPaneProperty.setValue((Object)value);
    }

    public TimetableBean withRegularBodyPane(AppointmentRegularBodyPane value) {
        this.setRegularBodyPane(value);
        return this;
    }

    public ObjectProperty<Calendar> startTimeProperty() {
        return this.startTimeObjectProperty;
    }

    public Calendar getStartTime() {
        return (Calendar)this.startTimeObjectProperty.getValue();
    }

    public void setStartTime(Calendar value) {
        this.startTimeObjectProperty.setValue((Object)value);
    }

    public TimetableBean withStartTime(Calendar value) {
        this.setStartTime(value);
        return this;
    }

    public ObjectProperty<Calendar> endTimeProperty() {
        return this.endTimeObjectProperty;
    }

    public Calendar getEndTime() {
        return (Calendar)this.endTimeObjectProperty.getValue();
    }

    public void setEndTime(Calendar value) {
        this.endTimeObjectProperty.setValue((Object)value);
    }

    public TimetableBean withEndTime(Calendar value) {
        this.setEndTime(value);
        return this;
    }

    public ObjectProperty<LocalDateTime> startLocalDateTime() {
        return this.startLocalDateTime;
    }

    @Override
    public LocalDateTime getStartLocalDateTime() {
        return (LocalDateTime)this.startLocalDateTime.getValue();
    }

    @Override
    public void setStartLocalDateTime(LocalDateTime value) {
        this.startLocalDateTime.setValue((Object)value);
        if (this.getDate() != null) {
            LocalDateTime realValue = DTMUtil.getRealLocalDateTime(DTMUtil.asLocalDate(this.getDate()), value, DTMMaster.getInstance().getEvent());
            this.setTatami(DTMUtil.getAreaNumber(DTMUtil.asLocalDate(this.getDate()), value.toLocalDate(), DTMMaster.getInstance().getEvent()));
            this.setStarttime(Timestamp.valueOf(realValue));
        }
    }

    public TimetableBean withStartLocalDateTime(LocalDateTime value) {
        this.setStartLocalDateTime(value);
        return this;
    }

    public ObjectProperty<LocalDateTime> endLocalDateTimeProperty() {
        return this.endLocalDateTimeProperty;
    }

    @Override
    public LocalDateTime getEndLocalDateTime() {
        return (LocalDateTime)this.endLocalDateTimeProperty.getValue();
    }

    @Override
    public void setEndLocalDateTime(LocalDateTime value) {
        this.endLocalDateTimeProperty.setValue((Object)value);
        if (this.getDate() != null) {
            if (this.startLocalDateTime != null && ((LocalDateTime)this.endLocalDateTimeProperty.getValue()).getDayOfYear() > ((LocalDateTime)this.startLocalDateTime.getValue()).getDayOfYear()) {
                value = LocalDateTime.of(((LocalDateTime)this.startLocalDateTime.getValue()).getYear(), ((LocalDateTime)this.startLocalDateTime.getValue()).getMonth(), ((LocalDateTime)this.startLocalDateTime.getValue()).getDayOfMonth(), 23, 55);
                this.endLocalDateTimeProperty.setValue((Object)value);
            }
            LocalDateTime realValue = DTMUtil.getRealLocalDateTime(DTMUtil.asLocalDate(this.getDate()), value, DTMMaster.getInstance().getEvent());
            this.setTatami(DTMUtil.getAreaNumber(DTMUtil.asLocalDate(this.getDate()), value.toLocalDate(), DTMMaster.getInstance().getEvent()));
            if (this.getTatami() == 0) {
                this.setTatami(1);
            }
            this.setEndtime(Timestamp.valueOf(realValue));
        }
    }

    public TimetableBean withEndLocalDateTime(LocalDateTime value) {
        this.setEndLocalDateTime(value);
        return this;
    }

    public ObjectProperty<Boolean> wholeDayProperty() {
        return this.wholeDayObjectProperty;
    }

    @Override
    public Boolean isWholeDay() {
        return (Boolean)this.wholeDayObjectProperty.getValue();
    }

    @Override
    public void setWholeDay(Boolean value) {
        this.wholeDayObjectProperty.setValue((Object)value);
    }

    public TimetableBean withWholeDay(Boolean value) {
        this.setWholeDay(value);
        return this;
    }

    public ObjectProperty<String> summaryProperty() {
        return this.summaryObjectProperty;
    }

    @Override
    public String getSummary() {
        if (this.type != 5) {
            String edt = this.edited ? " (edited)" : "";
            return this.catname + " (" + this.entries + ")\n" + TimestampUtil.getHoursAndMinutes(this.starttime) + " - " + TimestampUtil.getHoursAndMinutes(this.endtime) + " (" + this.getFormattedCatDuration() + ")" + edt + "\nMatchtime: " + DTMUtil.getFormattedTimeHHMMSS(this.fighttime);
        }
        return this.comment + "\n" + TimestampUtil.getHoursAndMinutes(this.starttime) + " - " + TimestampUtil.getHoursAndMinutes(this.endtime) + " (" + this.getFormattedCatDuration() + ")";
    }

    @Override
    public void setSummary(String value) {
        this.summaryObjectProperty.setValue((Object)value);
    }

    public TimetableBean withSummary(String value) {
        this.setSummary(value);
        return this;
    }

    public ObjectProperty<String> descriptionProperty() {
        return this.descriptionObjectProperty;
    }

    @Override
    public String getDescription() {
        return (String)this.descriptionObjectProperty.getValue();
    }

    @Override
    public void setDescription(String value) {
        this.descriptionObjectProperty.setValue((Object)value);
    }

    public TimetableBean withDescription(String value) {
        this.setDescription(value);
        return this;
    }

    public ObjectProperty<String> locationProperty() {
        return this.locationObjectProperty;
    }

    @Override
    public String getLocation() {
        return (String)this.locationObjectProperty.getValue();
    }

    @Override
    public void setLocation(String value) {
        this.locationObjectProperty.setValue((Object)value);
    }

    public TimetableBean withLocation(String value) {
        this.setLocation(value);
        return this;
    }

    public ObjectProperty<Agenda.AppointmentGroup> appointmentGroupProperty() {
        return this.appointmentGroupObjectProperty;
    }

    @Override
    public Agenda.AppointmentGroup getAppointmentGroup() {
        return (Agenda.AppointmentGroup)this.appointmentGroupObjectProperty.getValue();
    }

    @Override
    public void setAppointmentGroup(Agenda.AppointmentGroup value) {
        this.appointmentGroupObjectProperty.setValue((Object)value);
    }

    public TimetableBean withAppointmentGroup(Agenda.AppointmentGroup value) {
        this.setAppointmentGroup(value);
        return this;
    }

    public String toString() {
        if (this.getType() == 5) {
            return this.comment;
        }
        return this.catname;
    }

    public int getCatDuration() {
        return (int)(this.endtime.getTime() - this.starttime.getTime()) / 1000;
    }

    public String getFormattedCatDuration() {
        int seconds = this.getCatDuration();
        int hours = seconds / 3600;
        int remainder = seconds % 3600;
        int minutes = remainder / 60;
        int secs = remainder % 60;
        return (hours < 10 ? "0" : "") + hours + ":" + (minutes < 10 ? "0" : "") + minutes;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public int getVernr() {
        return this.vernr;
    }

    public void setVernr(int vernr) {
        this.vernr = vernr;
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public int getTatamis() {
        return this.tatamis;
    }

    public void setTatamis(int tatamis) {
        this.tatamis = tatamis;
    }

    public int getKnr() {
        return this.knr;
    }

    public void setKnr(int knr) {
        this.knr = knr;
    }

    public int getTatami() {
        return this.tatami;
    }

    public void setTatami(int tatami) {
        this.tatami = tatami;
    }

    public int getFighttime() {
        return this.fighttime;
    }

    public void setFighttime(int fighttime) {
        this.fighttime = fighttime;
    }

    public Timestamp getStarttime() {
        return this.starttime;
    }

    public void setStarttime(Timestamp starttime) {
        this.starttime = starttime;
    }

    public Timestamp getEndtime() {
        return this.endtime;
    }

    public void setEndtime(Timestamp endtime) {
        this.endtime = endtime;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getCatname() {
        if (this.catname == null) {
            return "";
        }
        return this.catname;
    }

    public void setCatname(String catname) {
        this.catname = catname;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public int getPools() {
        return this.pools;
    }

    public void setPools(int pools) {
        this.pools = pools;
    }

    public int getPool() {
        return this.pool;
    }

    public void setPool(int pool) {
        this.pool = pool;
    }

    public String getSex() {
        return this.sex;
    }

    public void setSex(String sex) {
        this.sex = sex;
    }

    public int getEntries() {
        return this.entries;
    }

    public void setEntries(int entries) {
        this.entries = entries;
    }

    public boolean isEdited() {
        return this.edited;
    }

    public void setEdited(boolean edited) {
        this.edited = edited;
    }

    public String getColor() {
        return this.color;
    }

    public void setColor(String color) {
        this.color = color;
    }

    public int getMatchnumber() {
        return this.matchnumber;
    }

    public void setMatchnumber(int matchnumber) {
        this.matchnumber = matchnumber;
    }
}

