/*
 * Decompiled with CFR 0.152.
 */
package org.sportdata.set.extension.dtm.controller;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.TreeMap;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import org.sportdata.set.extension.dtm.beans.DTMBean;
import org.sportdata.set.extension.dtm.beans.Event;
import org.sportdata.set.extension.dtm.internal.beans.DTMMaster;
import org.sportdata.set.extension.dtm.model.DTMModel;
import org.sportdata.set.extension.dtm.view.DTMView;

public class DTMController {
    protected FileHandler fileHandler;
    protected ConsoleHandler consoleHandler;
    protected Logger log = Logger.getLogger(DTMController.class.getName());
    public DTMModel db;
    public DTMView view;
    public Event event = new Event();

    public DTMController() {
        ConsoleHandler handler = new ConsoleHandler();
        handler.setFormatter(new SimpleFormatter());
        handler.setLevel(Level.ALL);
        this.log.addHandler(handler);
    }

    public void updateBean(DTMBean bean) {
        try {
            this.db.executeStatement(bean.updateStmt(this.db.getConnection()), bean.getUpdateString());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void insertBean(DTMBean bean) {
        try {
            this.db.executeStatement(bean.insertStmt(this.db.getConnection()), bean.getInsertString());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void deleteBean(DTMBean bean) {
        try {
            this.db.executeStatement(bean.deleteStmt(this.db.getConnection()), bean.getDeleteString());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void updateDay(TreeMap day) {
        if (this.view.viewIsClosed.booleanValue()) {
            return;
        }
        ArrayList<String> batchSequence = new ArrayList<String>();
        DTMBean currentBean = null;
        DTMBean oldBean = null;
        Object batchStmt = null;
        Boolean operationDone = false;
        for (Object i2 : day.keySet()) {
            currentBean = (DTMBean)i2;
            if (currentBean.equals(oldBean)) continue;
            if (currentBean != null) {
                batchSequence.add(currentBean.getUpdateString());
            }
            oldBean = currentBean;
        }
        try {
            this.db.executeBatch((String[])batchSequence.toArray());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void updateBeans(DTMBean[] beans) {
        if (this.view.viewIsClosed.booleanValue()) {
            return;
        }
        ArrayList<String> batchSequence = new ArrayList<String>();
        DTMBean oldBean = null;
        DTMBean[] dTMBeanArray = beans;
        int n2 = beans.length;
        int n3 = 0;
        while (n3 < n2) {
            DTMBean bean = dTMBeanArray[n3];
            if (!bean.equals(oldBean)) {
                if (bean != null) {
                    batchSequence.add(bean.getUpdateString());
                }
                oldBean = bean;
            }
            ++n3;
        }
        try {
            this.db.executeBatch((String[])batchSequence.toArray());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void connectDB(String url, String user, String psw) {
        this.db = new DTMModel(this.view);
        this.db.connect(url, user, psw);
    }

    public void connectDB() {
        this.db = new DTMModel(this.view);
        this.db.connect();
    }

    public void connectDB(Connection conn) {
        this.db = new DTMModel(conn, this.view);
    }

    public void connectDB(DTMController controller) {
        this.db = new DTMModel(controller.db.connection, this.view);
    }

    protected void initLogger(String filename, String classname) {
        this.log = DTMMaster.getInstance().getLogger();
    }

    public DTMController getInstance() {
        return this;
    }

    public DTMModel getDb() {
        return this.db;
    }

    public void setDb(DTMModel db) {
        this.db = db;
    }
}

