/*
 * Decompiled with CFR 0.152.
 */
package org.sportdata.set.extension.dtm.controller;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.ResourceBundle;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableMap;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ColorPicker;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeTableCell;
import javafx.scene.control.TreeTableColumn;
import javafx.scene.control.TreeTableView;
import javafx.scene.image.ImageView;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.stage.Stage;
import javafx.util.Callback;
import jfxtras.scene.control.LocalTimeTextField;
import org.sportdata.set.extension.dtm.beans.CategoryTreeBean;
import org.sportdata.set.extension.dtm.beans.DefaultBean;
import org.sportdata.set.extension.dtm.beans.Event;
import org.sportdata.set.extension.dtm.controller.DTMController;
import org.sportdata.set.extension.dtm.controller.DTMSettingsController;
import org.sportdata.set.extension.dtm.controller.DefaultsController;
import org.sportdata.set.extension.dtm.internal.ressource.DTMResource;
import org.sportdata.set.extension.dtm.view.DTMDialog;
import org.sportdata.set.extension.dtm.view.DTMSettings;

public class DTMLoadSettingsController
extends DTMController {
    public DTMSettings view = null;
    public Stage stageRef;
    @FXML
    private ResourceBundle resources;
    @FXML
    private URL location;
    @FXML
    private Button btnClose;
    @FXML
    private TreeTableView<DefaultBean> treeView;
    @FXML
    private LocalTimeTextField matchtimeSelector;
    @FXML
    private Label lbColor;
    @FXML
    private MenuItem miCollapseAll;
    @FXML
    private Label lbMatchtime;
    @FXML
    private MenuItem miExpandAll;
    @FXML
    private Button btnLoad;
    @FXML
    private Button btnSelectAll;
    @FXML
    private Button btnDeselectAll;
    @FXML
    private HBox hBox;
    @FXML
    private ContextMenu contextMenu;
    @FXML
    private ColorPicker colorPicker;
    @FXML
    private GridPane gridPane;
    @FXML
    private Button btnReset;
    @FXML
    private TreeTableColumn<DefaultBean, String> colCategory;
    @FXML
    private TreeTableColumn<DefaultBean, String> colMatchtime;
    @FXML
    private TreeTableColumn<DefaultBean, String> colColor;
    @FXML
    private TreeTableColumn<DefaultBean, String> colDelete;
    @FXML
    private TreeTableColumn<DefaultBean, String> colLoadCheckbox;
    boolean changesPending = false;
    private DefaultsController defaultsController = new DefaultsController();
    private ObservableMap<String, DefaultBean> defaults = FXCollections.observableMap(new HashMap());
    private HashMap<DefaultBean, String> defaultsReverse = new HashMap();
    private HashMap<String, DefaultBean> defaultsToLoad = new HashMap();
    private Event sourceEvent;
    private Event event;
    public DTMController sourceController;

    @FXML
    void load(ActionEvent event) {
        TreeItem r2 = this.treeView.getRoot();
        if (((CheckBox)((DefaultBean)r2.getValue()).getCbLoad().get()).isVisible() && ((CheckBox)((DefaultBean)r2.getValue()).getCbLoad().get()).isSelected()) {
            this.defaultsToLoad.put(this.defaultsReverse.get(r2.getValue()), (DefaultBean)r2.getValue());
        }
        for (TreeItem ti : this.treeView.getRoot().getChildren()) {
            if (((CheckBox)((DefaultBean)ti.getValue()).getCbLoad().get()).isVisible() && ((CheckBox)((DefaultBean)ti.getValue()).getCbLoad().get()).isSelected()) {
                this.defaultsToLoad.put(this.defaultsReverse.get(ti.getValue()), (DefaultBean)ti.getValue());
            }
            for (TreeItem ti2 : ti.getChildren()) {
                if (((CheckBox)((DefaultBean)ti2.getValue()).getCbLoad().get()).isVisible() && ((CheckBox)((DefaultBean)ti2.getValue()).getCbLoad().get()).isSelected()) {
                    this.defaultsToLoad.put(this.defaultsReverse.get(ti2.getValue()), (DefaultBean)ti2.getValue());
                }
                for (TreeItem ti3 : ti2.getChildren()) {
                    if (!((CheckBox)((DefaultBean)ti3.getValue()).getCbLoad().get()).isVisible() || !((CheckBox)((DefaultBean)ti3.getValue()).getCbLoad().get()).isSelected()) continue;
                    this.defaultsToLoad.put(this.defaultsReverse.get(ti3.getValue()), (DefaultBean)ti3.getValue());
                }
            }
        }
        if (this.defaultsToLoad.isEmpty()) {
            DTMDialog.inform(this.view.stageRef, DTMResource.getResourceString("settings.dialog.load.nothingselected"));
            return;
        }
        if (((DTMSettingsController)this.sourceController).updateDefaultsFromLoad(this.defaultsToLoad)) {
            this.defaults.clear();
            this.defaultsReverse.clear();
            this.defaultsToLoad.clear();
            this.stageRef.close();
        } else {
            this.defaults.clear();
            this.defaultsReverse.clear();
            this.defaultsToLoad.clear();
        }
    }

    @FXML
    void close(ActionEvent event) {
        this.view.stageRef.close();
    }

    @FXML
    void reset(ActionEvent event) {
    }

    @FXML
    void expandAll(ActionEvent event) {
        for (TreeItem ti : this.treeView.getRoot().getChildren()) {
            ti.setExpanded(true);
            for (TreeItem ti2 : ti.getChildren()) {
                ti2.setExpanded(true);
            }
        }
    }

    @FXML
    void collapseAll(ActionEvent event) {
        for (TreeItem ti : this.treeView.getRoot().getChildren()) {
            ti.setExpanded(false);
            for (TreeItem ti2 : ti.getChildren()) {
                ti2.setExpanded(false);
            }
        }
    }

    @FXML
    void selectAll(ActionEvent event) {
        if (((CheckBox)((DefaultBean)this.treeView.getRoot().getValue()).getCbLoad().get()).isVisible()) {
            ((CheckBox)((DefaultBean)this.treeView.getRoot().getValue()).getCbLoad().get()).selectedProperty().set(true);
        }
        for (TreeItem ti : this.treeView.getRoot().getChildren()) {
            if (((CheckBox)((DefaultBean)ti.getValue()).getCbLoad().get()).isVisible()) {
                ((CheckBox)((DefaultBean)ti.getValue()).getCbLoad().get()).selectedProperty().set(true);
            }
            for (TreeItem ti2 : ti.getChildren()) {
                if (((CheckBox)((DefaultBean)ti2.getValue()).getCbLoad().get()).isVisible()) {
                    ((CheckBox)((DefaultBean)ti2.getValue()).getCbLoad().get()).selectedProperty().set(true);
                }
                for (TreeItem ti3 : ti2.getChildren()) {
                    if (!((CheckBox)((DefaultBean)ti3.getValue()).getCbLoad().get()).isVisible()) continue;
                    ((CheckBox)((DefaultBean)ti3.getValue()).getCbLoad().get()).selectedProperty().set(true);
                }
            }
        }
    }

    @FXML
    void deselectAll(ActionEvent event) {
        if (((CheckBox)((DefaultBean)this.treeView.getRoot().getValue()).getCbLoad().get()).isVisible()) {
            ((CheckBox)((DefaultBean)this.treeView.getRoot().getValue()).getCbLoad().get()).selectedProperty().set(false);
        }
        for (TreeItem ti : this.treeView.getRoot().getChildren()) {
            if (((CheckBox)((DefaultBean)ti.getValue()).getCbLoad().get()).isVisible()) {
                ((CheckBox)((DefaultBean)ti.getValue()).getCbLoad().get()).selectedProperty().set(false);
            }
            for (TreeItem ti2 : ti.getChildren()) {
                if (((CheckBox)((DefaultBean)ti2.getValue()).getCbLoad().get()).isVisible()) {
                    ((CheckBox)((DefaultBean)ti2.getValue()).getCbLoad().get()).selectedProperty().set(false);
                }
                for (TreeItem ti3 : ti2.getChildren()) {
                    if (!((CheckBox)((DefaultBean)ti3.getValue()).getCbLoad().get()).isVisible()) continue;
                    ((CheckBox)((DefaultBean)ti3.getValue()).getCbLoad().get()).selectedProperty().set(false);
                }
            }
        }
    }

    @FXML
    void initialize() {
        assert (this.btnClose != null) : "fx:id=\"btnClose\" was not injected: check your FXML file 'dtm2_settings.fxml'.";
        assert (this.treeView != null) : "fx:id=\"treeView\" was not injected: check your FXML file 'dtm2_settings.fxml'.";
        assert (this.matchtimeSelector != null) : "fx:id=\"matchtimeSelector\" was not injected: check your FXML file 'dtm2_settings.fxml'.";
        assert (this.lbColor != null) : "fx:id=\"lbColor\" was not injected: check your FXML file 'dtm2_settings.fxml'.";
        assert (this.miCollapseAll != null) : "fx:id=\"miCollapseAll\" was not injected: check your FXML file 'dtm2_settings.fxml'.";
        assert (this.lbMatchtime != null) : "fx:id=\"lbMatchtime\" was not injected: check your FXML file 'dtm2_settings.fxml'.";
        assert (this.miExpandAll != null) : "fx:id=\"miExpandAll\" was not injected: check your FXML file 'dtm2_settings.fxml'.";
        assert (this.btnLoad != null) : "fx:id=\"btnLoad\" was not injected: check your FXML file 'dtm2_settings.fxml'.";
        assert (this.btnSelectAll != null) : "fx:id=\"btnSelectAll\" was not injected: check your FXML file 'dtm2_settings.fxml'.";
        assert (this.btnDeselectAll != null) : "fx:id=\"btnSelectAll\" was not injected: check your FXML file 'dtm2_settings.fxml'.";
        assert (this.hBox != null) : "fx:id=\"hBox\" was not injected: check your FXML file 'dtm2_settings.fxml'.";
        assert (this.contextMenu != null) : "fx:id=\"contextMenu\" was not injected: check your FXML file 'dtm2_settings.fxml'.";
        assert (this.colorPicker != null) : "fx:id=\"colorPicker\" was not injected: check your FXML file 'dtm2_settings.fxml'.";
        assert (this.gridPane != null) : "fx:id=\"gridPane\" was not injected: check your FXML file 'dtm2_settings.fxml'.";
        assert (this.btnReset != null) : "fx:id=\"btnReset\" was not injected: check your FXML file 'dtm2_settings.fxml'.";
        assert (this.colLoadCheckbox != null) : "fx:id=\"colLoadCheckbox\" was not injected: check your FXML file 'dtm2_settings.fxml'.";
        this.miExpandAll.setGraphic((Node)new ImageView("/org/sportdata/set/extension/dtm/view/images/expandall.png"));
        this.miCollapseAll.setGraphic((Node)new ImageView("/org/sportdata/set/extension/dtm/view/images/collapseall.png"));
        this.btnSelectAll.setGraphic((Node)new ImageView("/org/sportdata/set/extension/dtm/view/images/new/checked.png"));
        this.btnDeselectAll.setGraphic((Node)new ImageView("/org/sportdata/set/extension/dtm/view/images/new/unchecked.png"));
        this.btnLoad.setGraphic((Node)new ImageView("/org/sportdata/set/extension/dtm/view/images/new/load.png"));
        this.miExpandAll.setText(DTMResource.getResourceString("settings.menubutton.expandall"));
        this.miCollapseAll.setText(DTMResource.getResourceString("settings.menubutton.collapseall"));
        this.btnLoad.setText(DTMResource.getResourceString("general.load"));
        this.btnSelectAll.setText(DTMResource.getResourceString("settings.menubutton.selectall"));
        this.btnDeselectAll.setText(DTMResource.getResourceString("settings.menubutton.deselectall"));
        this.colCategory.setText(DTMResource.getResourceString("settings.colhead.category"));
        this.colDelete.setText(DTMResource.getResourceString("settings.colhead.delete"));
        this.colMatchtime.setText(DTMResource.getResourceString("settings.colhead.matchtime"));
        this.colColor.setText(DTMResource.getResourceString("settings.colhead.color"));
        this.colLoadCheckbox.setText(DTMResource.getResourceString("settings.colhead.load"));
    }

    public void setup() {
        this.defaultsController.connectDB(this.sourceController);
        this.defaults = this.defaultsController.getFighttimeDefaultsForLoadSettings(this.event.getVernr());
    }

    public void setupCatTreeView(ArrayList<CategoryTreeBean> cats) {
        this.setupCatTreeViewColumns();
        TreeItem root = new TreeItem();
        DefaultBean defBean = (DefaultBean)this.defaults.get((Object)"allcategories");
        if (defBean != null) {
            root.setValue((Object)defBean);
        } else {
            DefaultBean defBeanNew = new DefaultBean(0, this.sourceEvent.getVernr(), "", "", "", 0, "", this.defaultsController, true);
            root.setValue((Object)defBeanNew);
        }
        this.defaultsReverse.put((DefaultBean)root.getValue(), "allcategories");
        root.setExpanded(true);
        this.treeView.setRoot(root);
        TreeItem individual = new TreeItem();
        DefaultBean individualDef = (DefaultBean)this.defaults.get((Object)"individual");
        if (individualDef == null) {
            individualDef = new DefaultBean(0, this.sourceEvent.getVernr(), "i", "", "", 0, "", this.defaultsController, true);
        }
        individual.setValue((Object)individualDef);
        this.defaultsReverse.put((DefaultBean)individual.getValue(), "individual");
        individual.setExpanded(false);
        TreeItem team = new TreeItem();
        DefaultBean teamDef = (DefaultBean)this.defaults.get((Object)"team");
        if (teamDef == null) {
            teamDef = new DefaultBean(0, this.sourceEvent.getVernr(), "t", "", "", 0, "", this.defaultsController, true);
        }
        team.setValue((Object)teamDef);
        this.defaultsReverse.put(teamDef, "team");
        team.setExpanded(false);
        TreeItem individualmale = new TreeItem();
        DefaultBean individualmaleDef = (DefaultBean)this.defaults.get((Object)"individualmale");
        if (individualmaleDef == null) {
            individualmaleDef = new DefaultBean(0, this.sourceEvent.getVernr(), "i", "m", "", 0, "", this.defaultsController, true);
        }
        individualmale.setValue((Object)individualmaleDef);
        this.defaultsReverse.put(individualmaleDef, "individualmale");
        individualmale.setExpanded(false);
        TreeItem individualfemale = new TreeItem();
        DefaultBean individualfemaleDef = (DefaultBean)this.defaults.get((Object)"individualfemale");
        if (individualfemaleDef == null) {
            individualfemaleDef = new DefaultBean(0, this.sourceEvent.getVernr(), "i", "f", "", 0, "", this.defaultsController, true);
        }
        individualfemale.setValue((Object)individualfemaleDef);
        this.defaultsReverse.put(individualfemaleDef, "individualfemale");
        individualfemale.setExpanded(false);
        TreeItem individualmixed = new TreeItem();
        DefaultBean individualmixedDef = (DefaultBean)this.defaults.get((Object)"individualmixed");
        if (individualmixedDef == null) {
            individualmixedDef = new DefaultBean(0, this.sourceEvent.getVernr(), "i", "x", "", 0, "", this.defaultsController, true);
        }
        individualmixed.setValue((Object)individualmixedDef);
        this.defaultsReverse.put(individualmixedDef, "individualmixed");
        individualmixed.setExpanded(false);
        TreeItem teammale = new TreeItem();
        DefaultBean teammaleDef = (DefaultBean)this.defaults.get((Object)"teammale");
        if (teammaleDef == null) {
            teammaleDef = new DefaultBean(0, this.sourceEvent.getVernr(), "t", "m", "", 0, "", this.defaultsController, true);
        }
        teammale.setValue((Object)teammaleDef);
        this.defaultsReverse.put(teammaleDef, "teammale");
        teammale.setExpanded(false);
        TreeItem teamfemale = new TreeItem();
        DefaultBean teamfemaleDef = (DefaultBean)this.defaults.get((Object)"teamfemale");
        if (teamfemaleDef == null) {
            teamfemaleDef = new DefaultBean(0, this.sourceEvent.getVernr(), "t", "f", "", 0, "", this.defaultsController, true);
        }
        teamfemale.setValue((Object)teamfemaleDef);
        this.defaultsReverse.put(teamfemaleDef, "teamfemale");
        teamfemale.setExpanded(false);
        TreeItem teammixed = new TreeItem();
        DefaultBean teammixedDef = (DefaultBean)this.defaults.get((Object)"teammixed");
        if (teammixedDef == null) {
            teammixedDef = new DefaultBean(0, this.sourceEvent.getVernr(), "t", "x", "", 0, "", this.defaultsController, true);
        }
        teammixed.setValue((Object)teammixedDef);
        this.defaultsReverse.put(teammixedDef, "teammixed");
        teammixed.setExpanded(false);
        for (CategoryTreeBean i2 : cats) {
            if (i2.getType() != 0) continue;
            TreeItem ti = null;
            if (this.defaults.get((Object)i2.getKatbez()) == null) continue;
            ti = new TreeItem();
            DefaultBean dBean = (DefaultBean)this.defaults.get((Object)i2.getKatbez());
            ti.setValue((Object)dBean);
            this.defaultsReverse.put(dBean, i2.getKatbez());
            if (i2.getSex().toLowerCase().equals("m") && i2.getTeam().toLowerCase().equals("")) {
                individualmale.getChildren().add((Object)ti);
                continue;
            }
            if (i2.getSex().toLowerCase().equals("f") && i2.getTeam().toLowerCase().equals("")) {
                individualfemale.getChildren().add((Object)ti);
                continue;
            }
            if ((i2.getSex().toLowerCase().equals("") || i2.getSex().toLowerCase() == null) && i2.getTeam().toLowerCase().equals("")) {
                individualmixed.getChildren().add((Object)ti);
                continue;
            }
            if (i2.getSex().toLowerCase().equals("m") && i2.getTeam().toLowerCase().equals("t")) {
                teammale.getChildren().add((Object)ti);
                continue;
            }
            if (i2.getSex().toLowerCase().equals("f") && i2.getTeam().toLowerCase().equals("t")) {
                teamfemale.getChildren().add((Object)ti);
                continue;
            }
            if (!i2.getSex().toLowerCase().equals("") && i2.getSex().toLowerCase() != null || !i2.getTeam().toLowerCase().equals("t")) continue;
            teammixed.getChildren().add((Object)ti);
        }
        individual.getChildren().add((Object)individualmale);
        individual.getChildren().add((Object)individualfemale);
        individual.getChildren().add((Object)individualmixed);
        team.getChildren().add((Object)teammale);
        team.getChildren().add((Object)teamfemale);
        team.getChildren().add((Object)teammixed);
        root.getChildren().add((Object)individual);
        root.getChildren().add((Object)team);
    }

    private void setupCatTreeViewColumns() {
        this.colCategory.setCellValueFactory((Callback)new Callback<TreeTableColumn.CellDataFeatures<DefaultBean, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TreeTableColumn.CellDataFeatures<DefaultBean, String> param) {
                Object s2 = "";
                DefaultBean bean = (DefaultBean)param.getValue().getValue();
                switch (bean.priority()) {
                    case 1: {
                        s2 = bean.getCatname();
                        break;
                    }
                    case 3: {
                        s2 = DTMLoadSettingsController.this.defaultsController.getFullString(bean.getType()) + DTMLoadSettingsController.this.defaultsController.getFullString(bean.getSex());
                        break;
                    }
                    case 4: {
                        s2 = DTMLoadSettingsController.this.defaultsController.getFullString(bean.getType());
                        break;
                    }
                    case 5: {
                        s2 = "allcategories";
                    }
                }
                return new ReadOnlyStringWrapper((String)s2);
            }
        });
        this.colCategory.setCellFactory((Callback)new Callback<TreeTableColumn<DefaultBean, String>, TreeTableCell<DefaultBean, String>>(){

            public TreeTableCell<DefaultBean, String> call(TreeTableColumn<DefaultBean, String> param) {
                TreeTableCell<DefaultBean, String> cell = new TreeTableCell<DefaultBean, String>(){

                    protected void updateItem(String t2, boolean bln) {
                        super.updateItem((Object)t2, bln);
                        if (!bln) {
                            if (t2.equals("individual") || t2.equals("team") || t2.equals("individualmale") || t2.equals("individualfemale") || t2.equals("individualmixed") || t2.equals("teammale") || t2.equals("teamfemale") || t2.equals("teammixed") || t2.equals("allcategories")) {
                                this.setText(DTMResource.getResourceString("settings.tree." + t2));
                                this.setStyle("-fx-font-weight: bold;");
                            } else {
                                this.setText(t2);
                                this.setStyle("-fx-font-weight: normal;");
                            }
                        }
                    }
                };
                return cell;
            }
        });
        this.colMatchtime.setCellFactory((Callback)new Callback<TreeTableColumn<DefaultBean, String>, TreeTableCell<DefaultBean, String>>(){

            public TreeTableCell<DefaultBean, String> call(TreeTableColumn<DefaultBean, String> param) {
                TreeTableCell<DefaultBean, String> cell = new TreeTableCell<DefaultBean, String>(){

                    protected void updateItem(String t2, boolean empty) {
                        super.updateItem((Object)t2, empty);
                        if (empty) {
                            this.setGraphic(null);
                        } else if (this.getTreeTableRow().getItem() != null) {
                            this.setGraphic((Node)((DefaultBean)this.getTreeTableRow().getItem()).getLocalTimeTextField().get());
                        }
                    }
                };
                return cell;
            }
        });
        this.colColor.setCellFactory((Callback)new Callback<TreeTableColumn<DefaultBean, String>, TreeTableCell<DefaultBean, String>>(){

            public TreeTableCell<DefaultBean, String> call(TreeTableColumn<DefaultBean, String> param) {
                TreeTableCell<DefaultBean, String> cell = new TreeTableCell<DefaultBean, String>(){

                    protected void updateItem(String t2, boolean empty) {
                        super.updateItem((Object)t2, empty);
                        if (empty) {
                            this.setGraphic(null);
                        } else if (this.getTreeTableRow().getItem() != null) {
                            this.setGraphic((Node)((DefaultBean)this.getTreeTableRow().getItem()).getColorPicker().get());
                        }
                    }
                };
                return cell;
            }
        });
        this.colDelete.setCellFactory((Callback)new Callback<TreeTableColumn<DefaultBean, String>, TreeTableCell<DefaultBean, String>>(){

            public TreeTableCell<DefaultBean, String> call(TreeTableColumn<DefaultBean, String> param) {
                TreeTableCell<DefaultBean, String> cell = new TreeTableCell<DefaultBean, String>(){

                    protected void updateItem(String t2, boolean empty) {
                        super.updateItem((Object)t2, empty);
                        if (empty) {
                            this.setGraphic(null);
                        } else if (this.getTreeTableRow().getItem() != null) {
                            this.setGraphic((Node)((DefaultBean)this.getTreeTableRow().getItem()).getDeleteImageViewButton().get());
                        }
                    }
                };
                return cell;
            }
        });
        this.colLoadCheckbox.setCellFactory((Callback)new Callback<TreeTableColumn<DefaultBean, String>, TreeTableCell<DefaultBean, String>>(){

            public TreeTableCell<DefaultBean, String> call(TreeTableColumn<DefaultBean, String> param) {
                TreeTableCell<DefaultBean, String> cell = new TreeTableCell<DefaultBean, String>(){

                    protected void updateItem(String t2, boolean empty) {
                        super.updateItem((Object)t2, empty);
                        if (empty) {
                            this.setGraphic(null);
                        } else if (this.getTreeTableRow().getItem() != null) {
                            this.setGraphic((Node)((DefaultBean)this.getTreeTableRow().getItem()).getCbLoad().get());
                        }
                    }
                };
                return cell;
            }
        });
    }

    public boolean isChangesPending() {
        return this.changesPending;
    }

    public void setChangesPending(boolean changesPending) {
        this.changesPending = changesPending;
    }

    public DefaultsController getFighttimeController() {
        return this.defaultsController;
    }

    public void setFighttimeController(DefaultsController fighttimeController) {
        this.defaultsController = fighttimeController;
    }

    public ObservableMap<String, DefaultBean> getFighttimeDefaults() {
        return this.defaults;
    }

    public void setFighttimeDefaults(ObservableMap<String, DefaultBean> fighttimeDefaults) {
        this.defaults = fighttimeDefaults;
    }

    public Event getSourceEvent() {
        return this.sourceEvent;
    }

    public void setSourceEvent(Event event) {
        this.sourceEvent = event;
    }

    public Event getEvent() {
        return this.event;
    }

    public void setEvent(Event event) {
        this.event = event;
    }

    public DTMController getSourceController() {
        return this.sourceController;
    }

    public void setSourceController(DTMController sourceController) {
        this.sourceController = sourceController;
    }
}

