/*
 * Decompiled with CFR 0.152.
 */
package org.sportdata.set.extension.dtm.controller;

import java.net.URL;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.ResourceBundle;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableMap;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ColorPicker;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TitledPane;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeTableCell;
import javafx.scene.control.TreeTableColumn;
import javafx.scene.control.TreeTableView;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.paint.Color;
import javafx.util.Callback;
import org.sportdata.set.extension.dtm.beans.CategoryTreeBean;
import org.sportdata.set.extension.dtm.beans.DefaultBean;
import org.sportdata.set.extension.dtm.beans.Event;
import org.sportdata.set.extension.dtm.beans.TimetableBean;
import org.sportdata.set.extension.dtm.controller.DTMController;
import org.sportdata.set.extension.dtm.controller.DefaultsController;
import org.sportdata.set.extension.dtm.internal.ressource.DTMResource;
import org.sportdata.set.extension.dtm.jfxtras.scene.control.DTMLocalTimeTextField;
import org.sportdata.set.extension.dtm.jfxtras.scene.control.agenda.Agenda;
import org.sportdata.set.extension.dtm.view.DTMDialog;
import org.sportdata.set.extension.dtm.view.DTMSettings;
import org.sportdata.set.extension.dtm.view.FXMLDTM2Controller;
import org.sportdata.set.extension.dtm.view.LoadSettingsEventSelection;

public class DTMSettingsController
extends DTMController {
    public DTMSettings view = null;
    @FXML
    private ResourceBundle resources;
    @FXML
    private URL location;
    @FXML
    private Button btnClose;
    @FXML
    private TreeTableView<DefaultBean> treeView;
    @FXML
    private DTMLocalTimeTextField matchtimeSelector;
    @FXML
    private Label lbColor;
    @FXML
    private MenuItem miCollapseAll;
    @FXML
    private Label lbMatchtime;
    @FXML
    private MenuItem miExpandAll;
    @FXML
    private Button btnUpdateColors;
    @FXML
    private Button btnLoadSettings;
    @FXML
    private HBox hBox;
    @FXML
    private ContextMenu contextMenu;
    @FXML
    private MenuItem miLoadSettings;
    @FXML
    private ColorPicker colorPicker;
    @FXML
    private GridPane gridPane;
    @FXML
    private TitledPane titledPane;
    @FXML
    private Button btnReset;
    @FXML
    private TreeTableColumn<DefaultBean, String> colCategory;
    @FXML
    private TreeTableColumn<DefaultBean, String> colMatchtime;
    @FXML
    private TreeTableColumn<DefaultBean, String> colColor;
    @FXML
    private TreeTableColumn<DefaultBean, String> colDelete;
    boolean changesPending = false;
    private DefaultsController fighttimeController;
    private ObservableMap<String, DefaultBean> defaults;
    private Event event;
    private ObservableMap<CategoryTreeBean, TimetableBean> timetableMap;
    private Agenda agenda;
    private ArrayList eventsData;
    public FXMLDTM2Controller fXMLDTM2Controller;
    private ArrayList<CategoryTreeBean> categories;

    @FXML
    void updateColors(ActionEvent event) {
        this.fXMLDTM2Controller.updateMatchtimeDefaults();
        for (CategoryTreeBean c2 : this.timetableMap.keySet()) {
            TimetableBean currentBean = (TimetableBean)this.timetableMap.get((Object)c2);
            if (currentBean.getType() == 5) continue;
            String color = this.fighttimeController.findColorForCategoryTreeBean(this.defaults, c2);
            currentBean.setColor(color);
            currentBean.getAppointmentGroup().setStyleClass(color);
            currentBean.update();
        }
        this.fXMLDTM2Controller.refreshCurrentSkin();
    }

    @FXML
    void close(ActionEvent event) {
        this.fXMLDTM2Controller.updateMatchtimeDefaults();
        this.view.stageRef.close();
    }

    @FXML
    void reset(ActionEvent event) {
    }

    @FXML
    void expandAll(ActionEvent event) {
        for (TreeItem ti : this.treeView.getRoot().getChildren()) {
            ti.setExpanded(true);
            for (TreeItem ti2 : ti.getChildren()) {
                ti2.setExpanded(true);
            }
        }
    }

    @FXML
    void collapseAll(ActionEvent event) {
        for (TreeItem ti : this.treeView.getRoot().getChildren()) {
            ti.setExpanded(false);
            for (TreeItem ti2 : ti.getChildren()) {
                ti2.setExpanded(false);
            }
        }
    }

    @FXML
    void resetAll(ActionEvent event) {
    }

    @FXML
    void loadSettings(ActionEvent event) {
        this.fXMLDTM2Controller.updateMatchtimeDefaults();
        new LoadSettingsEventSelection(this.eventsData, this.view, this.categories).start(this.view.stageRef);
    }

    @FXML
    void initialize() {
        assert (this.btnClose != null) : "fx:id=\"btnClose\" was not injected: check your FXML file 'dtm2_settings.fxml'.";
        assert (this.treeView != null) : "fx:id=\"treeView\" was not injected: check your FXML file 'dtm2_settings.fxml'.";
        assert (this.matchtimeSelector != null) : "fx:id=\"matchtimeSelector\" was not injected: check your FXML file 'dtm2_settings.fxml'.";
        assert (this.lbColor != null) : "fx:id=\"lbColor\" was not injected: check your FXML file 'dtm2_settings.fxml'.";
        assert (this.miCollapseAll != null) : "fx:id=\"miCollapseAll\" was not injected: check your FXML file 'dtm2_settings.fxml'.";
        assert (this.lbMatchtime != null) : "fx:id=\"lbMatchtime\" was not injected: check your FXML file 'dtm2_settings.fxml'.";
        assert (this.miExpandAll != null) : "fx:id=\"miExpandAll\" was not injected: check your FXML file 'dtm2_settings.fxml'.";
        assert (this.btnUpdateColors != null) : "fx:id=\"btnUpdateColors\" was not injected: check your FXML file 'dtm2_settings.fxml'.";
        assert (this.btnLoadSettings != null) : "fx:id=\"btnLoadSettings\" was not injected: check your FXML file 'dtm2_settings.fxml'.";
        assert (this.hBox != null) : "fx:id=\"hBox\" was not injected: check your FXML file 'dtm2_settings.fxml'.";
        assert (this.contextMenu != null) : "fx:id=\"contextMenu\" was not injected: check your FXML file 'dtm2_settings.fxml'.";
        assert (this.miLoadSettings != null) : "fx:id=\"miLoadSettings\" was not injected: check your FXML file 'dtm2_settings.fxml'.";
        assert (this.colorPicker != null) : "fx:id=\"colorPicker\" was not injected: check your FXML file 'dtm2_settings.fxml'.";
        assert (this.gridPane != null) : "fx:id=\"gridPane\" was not injected: check your FXML file 'dtm2_settings.fxml'.";
        assert (this.titledPane != null) : "fx:id=\"titledPane\" was not injected: check your FXML file 'dtm2_settings.fxml'.";
        assert (this.btnReset != null) : "fx:id=\"btnReset\" was not injected: check your FXML file 'dtm2_settings.fxml'.";
        Image imageDelete = new Image(this.getClass().getResourceAsStream("/org/sportdata/set/extension/dtm/view/images/mop0b.gif"));
        ImageView imgViewDelete = new ImageView(imageDelete);
        this.btnReset.setGraphic((Node)imgViewDelete);
        this.titledPane.setText(DTMResource.getResourceString("settings.multiedit.title"));
        this.lbMatchtime.setText(DTMResource.getResourceString("settings.colhead.matchtime"));
        this.lbColor.setText(DTMResource.getResourceString("settings.colhead.color"));
        this.btnReset.setText(DTMResource.getResourceString("settings.colhead.delete"));
        this.miExpandAll.setGraphic((Node)new ImageView("/org/sportdata/set/extension/dtm/view/images/expandall.png"));
        this.miCollapseAll.setGraphic((Node)new ImageView("/org/sportdata/set/extension/dtm/view/images/collapseall.png"));
        this.miLoadSettings.setGraphic((Node)new ImageView("/org/sportdata/set/extension/dtm/view/images/new/load.png"));
        this.miLoadSettings.setText(DTMResource.getResourceString("settings.menubutton.loadprevevents"));
        this.miExpandAll.setText(DTMResource.getResourceString("settings.menubutton.expandall"));
        this.miCollapseAll.setText(DTMResource.getResourceString("settings.menubutton.collapseall"));
        this.btnUpdateColors.setText(DTMResource.getResourceString("settings.updatecolors"));
        this.btnLoadSettings.setText(DTMResource.getResourceString("settings.menubutton.loadprevevents"));
        this.colCategory.setText(DTMResource.getResourceString("settings.colhead.category"));
        this.colDelete.setText(DTMResource.getResourceString("settings.colhead.delete"));
        this.colMatchtime.setText(DTMResource.getResourceString("settings.colhead.matchtime"));
        this.colColor.setText(DTMResource.getResourceString("settings.colhead.color"));
        this.matchtimeSelector.setDateTimeFormatter(DateTimeFormatter.ofPattern("HH:mm:ss"));
        this.matchtimeSelector.setDisable(true);
        this.colorPicker.setDisable(true);
        this.btnReset.setDisable(true);
        this.treeView.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.treeView.getSelectionModel().getSelectedItems().addListener((ListChangeListener)new ListChangeListener<TreeItem<DefaultBean>>(){

            public void onChanged(ListChangeListener.Change<? extends TreeItem<DefaultBean>> c2) {
                if (DTMSettingsController.this.treeView.getSelectionModel().getSelectedItems().isEmpty() || DTMSettingsController.this.treeView.getSelectionModel().getSelectedItems().size() == 1) {
                    DTMSettingsController.this.matchtimeSelector.setDisable(true);
                    DTMSettingsController.this.colorPicker.setDisable(true);
                    DTMSettingsController.this.btnReset.setDisable(true);
                } else {
                    DTMSettingsController.this.matchtimeSelector.setDisable(false);
                    DTMSettingsController.this.colorPicker.setDisable(false);
                    DTMSettingsController.this.btnReset.setDisable(false);
                    for (TreeItem treeItem : DTMSettingsController.this.treeView.getSelectionModel().getSelectedItems()) {
                        DefaultBean d2 = (DefaultBean)treeItem.getValue();
                        System.out.println(d2.getCatname());
                    }
                }
            }
        });
        this.matchtimeSelector.localTimeProperty().addListener((ChangeListener)new ChangeListener<LocalTime>(){

            public void changed(ObservableValue<? extends LocalTime> observable, LocalTime oldValue, LocalTime newValue) {
                for (TreeItem treeItem : DTMSettingsController.this.treeView.getSelectionModel().getSelectedItems()) {
                    DefaultBean d2 = (DefaultBean)treeItem.getValue();
                    ((DTMLocalTimeTextField)((Object)d2.getLocalTimeTextField().get())).setLocalTime(newValue);
                }
            }
        });
        this.colorPicker.valueProperty().addListener((ChangeListener)new ChangeListener<Color>(){

            public void changed(ObservableValue<? extends Color> observable, Color oldValue, Color newValue) {
                for (TreeItem treeItem : DTMSettingsController.this.treeView.getSelectionModel().getSelectedItems()) {
                    DefaultBean d2 = (DefaultBean)treeItem.getValue();
                    ((ColorPicker)d2.getColorPicker().get()).setValue((Object)newValue);
                    d2.handleColorChange();
                }
            }
        });
        this.btnReset.setOnMouseClicked(mouseEvent -> {
            for (TreeItem treeItem : this.treeView.getSelectionModel().getSelectedItems()) {
                DefaultBean d2 = (DefaultBean)treeItem.getValue();
                d2.handleDeleteButtonClick();
            }
        });
    }

    public void setupCatTreeView(ArrayList<CategoryTreeBean> cats) {
        this.categories = cats;
        this.setupCatTreeViewColumns();
        TreeItem root = new TreeItem();
        DefaultBean defBean = (DefaultBean)this.defaults.get((Object)"allcategories");
        if (defBean != null) {
            root.setValue((Object)defBean);
        } else {
            DefaultBean defBeanNew = new DefaultBean(0, this.event.getVernr(), "", "", "", 0, "", this.fighttimeController);
            root.setValue((Object)defBeanNew);
        }
        root.setExpanded(true);
        this.treeView.setRoot(root);
        TreeItem individual = new TreeItem();
        DefaultBean individualDef = (DefaultBean)this.defaults.get((Object)"individual");
        if (individualDef == null) {
            individualDef = new DefaultBean(0, this.event.getVernr(), "i", "", "", 0, "", this.fighttimeController);
        }
        individual.setValue((Object)individualDef);
        individual.setExpanded(false);
        TreeItem team = new TreeItem();
        DefaultBean teamDef = (DefaultBean)this.defaults.get((Object)"team");
        if (teamDef == null) {
            teamDef = new DefaultBean(0, this.event.getVernr(), "t", "", "", 0, "", this.fighttimeController);
        }
        team.setValue((Object)teamDef);
        team.setExpanded(false);
        TreeItem individualmale = new TreeItem();
        DefaultBean individualmaleDef = (DefaultBean)this.defaults.get((Object)"individualmale");
        if (individualmaleDef == null) {
            individualmaleDef = new DefaultBean(0, this.event.getVernr(), "i", "m", "", 0, "", this.fighttimeController);
        }
        individualmale.setValue((Object)individualmaleDef);
        individualmale.setExpanded(false);
        TreeItem individualfemale = new TreeItem();
        DefaultBean individualfemaleDef = (DefaultBean)this.defaults.get((Object)"individualfemale");
        if (individualfemaleDef == null) {
            individualfemaleDef = new DefaultBean(0, this.event.getVernr(), "i", "f", "", 0, "", this.fighttimeController);
        }
        individualfemale.setValue((Object)individualfemaleDef);
        individualfemale.setExpanded(false);
        TreeItem individualmixed = new TreeItem();
        DefaultBean individualmixedDef = (DefaultBean)this.defaults.get((Object)"individualmixed");
        if (individualmixedDef == null) {
            individualmixedDef = new DefaultBean(0, this.event.getVernr(), "i", "x", "", 0, "", this.fighttimeController);
        }
        individualmixed.setValue((Object)individualmixedDef);
        individualmixed.setExpanded(false);
        TreeItem teammale = new TreeItem();
        DefaultBean teammaleDef = (DefaultBean)this.defaults.get((Object)"teammale");
        if (teammaleDef == null) {
            teammaleDef = new DefaultBean(0, this.event.getVernr(), "t", "m", "", 0, "", this.fighttimeController);
        }
        teammale.setValue((Object)teammaleDef);
        teammale.setExpanded(false);
        TreeItem teamfemale = new TreeItem();
        DefaultBean teamfemaleDef = (DefaultBean)this.defaults.get((Object)"teamfemale");
        if (teamfemaleDef == null) {
            teamfemaleDef = new DefaultBean(0, this.event.getVernr(), "t", "f", "", 0, "", this.fighttimeController);
        }
        teamfemale.setValue((Object)teamfemaleDef);
        teamfemale.setExpanded(false);
        TreeItem teammixed = new TreeItem();
        DefaultBean teammixedDef = (DefaultBean)this.defaults.get((Object)"teammixed");
        if (teammixedDef == null) {
            teammixedDef = new DefaultBean(0, this.event.getVernr(), "t", "x", "", 0, "", this.fighttimeController);
        }
        teammixed.setValue((Object)teammixedDef);
        teammixed.setExpanded(false);
        for (CategoryTreeBean i2 : cats) {
            if (i2.getType() != 0) continue;
            TreeItem ti = new TreeItem();
            DefaultBean dBean = this.defaults.get((Object)i2.getKatbez()) == null ? new DefaultBean(0, this.event.getVernr(), "", "", i2.getKatbez(), 0, "", this.fighttimeController) : (DefaultBean)this.defaults.get((Object)i2.getKatbez());
            ti.setValue((Object)dBean);
            if (i2.getSex().toLowerCase().equals("m") && i2.getTeam().toLowerCase().equals("")) {
                individualmale.getChildren().add((Object)ti);
                continue;
            }
            if (i2.getSex().toLowerCase().equals("f") && i2.getTeam().toLowerCase().equals("")) {
                individualfemale.getChildren().add((Object)ti);
                continue;
            }
            if ((i2.getSex().toLowerCase().equals("") || i2.getSex().toLowerCase() == null) && i2.getTeam().toLowerCase().equals("")) {
                individualmixed.getChildren().add((Object)ti);
                continue;
            }
            if (i2.getSex().toLowerCase().equals("m") && i2.getTeam().toLowerCase().equals("t")) {
                teammale.getChildren().add((Object)ti);
                continue;
            }
            if (i2.getSex().toLowerCase().equals("f") && i2.getTeam().toLowerCase().equals("t")) {
                teamfemale.getChildren().add((Object)ti);
                continue;
            }
            if (!i2.getSex().toLowerCase().equals("") && i2.getSex().toLowerCase() != null || !i2.getTeam().toLowerCase().equals("t")) continue;
            teammixed.getChildren().add((Object)ti);
        }
        individual.getChildren().add((Object)individualmale);
        individual.getChildren().add((Object)individualfemale);
        individual.getChildren().add((Object)individualmixed);
        team.getChildren().add((Object)teammale);
        team.getChildren().add((Object)teamfemale);
        team.getChildren().add((Object)teammixed);
        root.getChildren().add((Object)individual);
        root.getChildren().add((Object)team);
    }

    public boolean updateDefaultsFromLoad(HashMap<String, DefaultBean> defaultsFromLoad) {
        if (DTMDialog.confirm(this.view.stageRef, DTMResource.getResourceString("settings.dialog.load.override")).booleanValue()) {
            block0: for (String key : defaultsFromLoad.keySet()) {
                DefaultBean loadedDefault = defaultsFromLoad.get(key);
                TreeItem r2 = this.treeView.getRoot();
                if (((DefaultBean)r2.getValue()).matches(loadedDefault)) {
                    this.updateSingleDefaultbean((DefaultBean)r2.getValue(), loadedDefault);
                    break;
                }
                block1: for (TreeItem ti : this.treeView.getRoot().getChildren()) {
                    if (((DefaultBean)ti.getValue()).matches(loadedDefault)) {
                        this.updateSingleDefaultbean((DefaultBean)ti.getValue(), loadedDefault);
                        continue block0;
                    }
                    block2: for (TreeItem ti2 : ti.getChildren()) {
                        if (((DefaultBean)ti2.getValue()).matches(loadedDefault)) {
                            this.updateSingleDefaultbean((DefaultBean)ti2.getValue(), loadedDefault);
                            continue block1;
                        }
                        for (TreeItem ti3 : ti2.getChildren()) {
                            if (!((DefaultBean)ti3.getValue()).matches(loadedDefault)) continue;
                            this.updateSingleDefaultbean((DefaultBean)ti3.getValue(), loadedDefault);
                            continue block2;
                        }
                    }
                }
            }
            return true;
        }
        return false;
    }

    private void updateSingleDefaultbean(DefaultBean origDefault, DefaultBean newDefault) {
        origDefault.manualColorUpdate((Color)((ColorPicker)newDefault.getColorPicker().get()).getValue());
        ((ColorPicker)origDefault.getColorPicker().get()).setValue((Object)((Color)((ColorPicker)newDefault.getColorPicker().get()).getValue()));
        ((DTMLocalTimeTextField)((Object)origDefault.getLocalTimeTextField().get())).setLocalTime(((DTMLocalTimeTextField)((Object)newDefault.getLocalTimeTextField().get())).getLocalTime());
    }

    private void setupCatTreeViewColumns() {
        this.colCategory.setCellValueFactory((Callback)new Callback<TreeTableColumn.CellDataFeatures<DefaultBean, String>, ObservableValue<String>>(){

            public ObservableValue<String> call(TreeTableColumn.CellDataFeatures<DefaultBean, String> param) {
                Object s2 = "";
                DefaultBean bean = (DefaultBean)param.getValue().getValue();
                switch (bean.priority()) {
                    case 1: {
                        s2 = bean.getCatname();
                        break;
                    }
                    case 3: {
                        s2 = DTMSettingsController.this.fighttimeController.getFullString(bean.getType()) + DTMSettingsController.this.fighttimeController.getFullString(bean.getSex());
                        break;
                    }
                    case 4: {
                        s2 = DTMSettingsController.this.fighttimeController.getFullString(bean.getType());
                        break;
                    }
                    case 5: {
                        s2 = "allcategories";
                    }
                }
                return new ReadOnlyStringWrapper((String)s2);
            }
        });
        this.colCategory.setCellFactory((Callback)new Callback<TreeTableColumn<DefaultBean, String>, TreeTableCell<DefaultBean, String>>(){

            public TreeTableCell<DefaultBean, String> call(TreeTableColumn<DefaultBean, String> param) {
                TreeTableCell<DefaultBean, String> cell = new TreeTableCell<DefaultBean, String>(){

                    protected void updateItem(String t2, boolean bln) {
                        super.updateItem((Object)t2, bln);
                        if (!bln) {
                            if (t2.equals("individual") || t2.equals("team") || t2.equals("individualmale") || t2.equals("individualfemale") || t2.equals("individualmixed") || t2.equals("teammale") || t2.equals("teamfemale") || t2.equals("teammixed") || t2.equals("allcategories")) {
                                this.setText(DTMResource.getResourceString("settings.tree." + t2));
                                this.setStyle("-fx-font-weight: bold;");
                            } else {
                                this.setText(t2);
                                this.setStyle("-fx-font-weight: normal;");
                            }
                        }
                    }
                };
                return cell;
            }
        });
        this.colMatchtime.setCellFactory((Callback)new Callback<TreeTableColumn<DefaultBean, String>, TreeTableCell<DefaultBean, String>>(){

            public TreeTableCell<DefaultBean, String> call(TreeTableColumn<DefaultBean, String> param) {
                TreeTableCell<DefaultBean, String> cell = new TreeTableCell<DefaultBean, String>(){

                    protected void updateItem(String t2, boolean empty) {
                        super.updateItem((Object)t2, empty);
                        if (empty) {
                            this.setGraphic(null);
                        } else if (this.getTreeTableRow().getItem() != null) {
                            this.setGraphic((Node)((DefaultBean)this.getTreeTableRow().getItem()).getLocalTimeTextField().get());
                        }
                    }
                };
                return cell;
            }
        });
        this.colColor.setCellFactory((Callback)new Callback<TreeTableColumn<DefaultBean, String>, TreeTableCell<DefaultBean, String>>(){

            public TreeTableCell<DefaultBean, String> call(TreeTableColumn<DefaultBean, String> param) {
                TreeTableCell<DefaultBean, String> cell = new TreeTableCell<DefaultBean, String>(){

                    protected void updateItem(String t2, boolean empty) {
                        super.updateItem((Object)t2, empty);
                        if (empty) {
                            this.setGraphic(null);
                        } else if (this.getTreeTableRow().getItem() != null) {
                            this.setGraphic((Node)((DefaultBean)this.getTreeTableRow().getItem()).getColorPicker().get());
                        }
                    }
                };
                return cell;
            }
        });
        this.colDelete.setCellFactory((Callback)new Callback<TreeTableColumn<DefaultBean, String>, TreeTableCell<DefaultBean, String>>(){

            public TreeTableCell<DefaultBean, String> call(TreeTableColumn<DefaultBean, String> param) {
                TreeTableCell<DefaultBean, String> cell = new TreeTableCell<DefaultBean, String>(){

                    protected void updateItem(String t2, boolean empty) {
                        super.updateItem((Object)t2, empty);
                        if (empty) {
                            this.setGraphic(null);
                        } else if (this.getTreeTableRow().getItem() != null) {
                            this.setGraphic((Node)((DefaultBean)this.getTreeTableRow().getItem()).getDeleteImageViewButton().get());
                        }
                    }
                };
                return cell;
            }
        });
    }

    public Agenda getAgenda() {
        return this.agenda;
    }

    public void setAgenda(Agenda agenda) {
        this.agenda = agenda;
    }

    public ObservableMap<CategoryTreeBean, TimetableBean> getTimetableMap() {
        return this.timetableMap;
    }

    public void setTimetableMap(ObservableMap<CategoryTreeBean, TimetableBean> timetableMap) {
        this.timetableMap = timetableMap;
    }

    public boolean isChangesPending() {
        return this.changesPending;
    }

    public void setChangesPending(boolean changesPending) {
        this.changesPending = changesPending;
    }

    public DefaultsController getFighttimeController() {
        return this.fighttimeController;
    }

    public void setFighttimeController(DefaultsController fighttimeController) {
        this.fighttimeController = fighttimeController;
    }

    public ObservableMap<String, DefaultBean> getDefaults() {
        return this.defaults;
    }

    public void setDefaults(ObservableMap<String, DefaultBean> fighttimeDefaults) {
        this.defaults = fighttimeDefaults;
    }

    public Event getEvent() {
        return this.event;
    }

    public void setEvent(Event event) {
        this.event = event;
    }

    public ArrayList getEventsData() {
        return this.eventsData;
    }

    public void setEventsData(ArrayList eventsData) {
        this.eventsData = eventsData;
    }

    public FXMLDTM2Controller getfXMLDTM2Controller() {
        return this.fXMLDTM2Controller;
    }

    public void setfXMLDTM2Controller(FXMLDTM2Controller fXMLDTM2Controller) {
        this.fXMLDTM2Controller = fXMLDTM2Controller;
    }
}

