/*
 * Decompiled with CFR 0.152.
 */
package org.sportdata.set.extension.dtm.controller;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableMap;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ColorPicker;
import org.sportdata.set.extension.dtm.beans.CategoryTreeBean;
import org.sportdata.set.extension.dtm.beans.DefaultBean;
import org.sportdata.set.extension.dtm.controller.DTMController;
import org.sportdata.set.extension.dtm.jfxtras.scene.control.DTMLocalTimeTextField;
import org.sportdata.set.extension.dtm.view.DTMSettings;

public class DefaultsController
extends DTMController {
    public ObservableMap<String, DefaultBean> getFighttimeDefaults(Integer vernr) {
        HashMap<Object, DefaultBean> map = new HashMap<Object, DefaultBean>();
        String stmtString = "SELECT * FROM dtmdefaults WHERE vernr = " + String.valueOf(vernr);
        ResultSet rs = this.db.executeString(stmtString);
        try {
            while (rs.next()) {
                DefaultBean bean = new DefaultBean(rs.getInt("id"), rs.getInt("vernr"), rs.getString("type"), rs.getString("sex"), rs.getString("catname"), rs.getInt("fighttime"), rs.getString("color"), this);
                if (bean.priority() == 1) {
                    if (map.containsKey(bean.getCatname())) {
                        this.log.severe("Duplicate FighttimeDefault bean detected! Id: " + bean.getId());
                    }
                    map.put(bean.getCatname(), bean);
                    continue;
                }
                if (bean.priority() == 3) {
                    if (map.containsKey(this.getFullString(bean.getType().toLowerCase()) + this.getFullString(bean.getSex().toLowerCase()))) {
                        this.log.severe("Duplicate FighttimeDefault bean detected! Id: " + bean.getId());
                    }
                    map.put(this.getFullString(bean.getType().toLowerCase()) + this.getFullString(bean.getSex().toLowerCase()), bean);
                    continue;
                }
                if (bean.priority() == 4) {
                    if (map.containsKey(this.getFullString(bean.getType().toLowerCase()))) {
                        this.log.severe("Duplicate FighttimeDefault bean detected! Id: " + bean.getId());
                    }
                    map.put(this.getFullString(bean.getType().toLowerCase()), bean);
                    continue;
                }
                if (bean.priority() == 5) {
                    if (map.containsKey("allcategories")) {
                        this.log.severe("Duplicate FighttimeDefault bean detected! Id: " + bean.getId());
                    }
                    map.put("allcategories", bean);
                    continue;
                }
                this.log.severe("FighttimeDefault bean is invalid! No priority found.");
            }
        }
        catch (SQLException e2) {
            e2.printStackTrace();
        }
        return FXCollections.observableMap(map);
    }

    public ObservableMap<String, DefaultBean> getFighttimeDefaultsForLoadSettings(int vernr) {
        ObservableMap<String, DefaultBean> map = this.getFighttimeDefaults(vernr);
        for (Object key : map.keySet()) {
            DefaultBean bean = (DefaultBean)map.get(key);
            bean.setCbLoad((SimpleObjectProperty<CheckBox>)new SimpleObjectProperty((Object)new CheckBox()));
            ((Button)bean.getDeleteImageViewButton().getValue()).visibleProperty().set(false);
            ((ColorPicker)bean.getColorPicker().getValue()).disableProperty().set(true);
            ((DTMLocalTimeTextField)((Object)bean.getLocalTimeTextField().getValue())).disableProperty().set(true);
        }
        return map;
    }

    public String buildKeyCategoryTreeBean(CategoryTreeBean category) {
        String type = category.getTeam() != null && category.getTeam().toLowerCase().equals("t") ? "team" : "individual";
        return type + this.getFullString(category.getSex().toLowerCase());
    }

    public DefaultBean findDefaultBeanForCategoryTreeBean(ObservableMap<String, DefaultBean> map, CategoryTreeBean category) {
        String priority1Key = category.getOrigkatbez();
        String priority3Key = this.buildKeyCategoryTreeBean(category);
        String priority4Key = "individual";
        if (category.getTeam().equals("t")) {
            priority4Key = "team";
        }
        String priority5Key = "allcategories";
        if (map.get((Object)priority1Key) != null) {
            return (DefaultBean)map.get((Object)priority1Key);
        }
        if (map.get((Object)priority3Key) != null) {
            return (DefaultBean)map.get((Object)priority3Key);
        }
        if (map.get((Object)priority4Key) != null) {
            return (DefaultBean)map.get((Object)priority4Key);
        }
        if (map.get((Object)priority5Key) != null) {
            return (DefaultBean)map.get((Object)priority5Key);
        }
        return null;
    }

    public Integer findFighttimeForCategoryTreeBean(ObservableMap<String, DefaultBean> fighttimeDefaults, CategoryTreeBean category) {
        String priority1Key = category.getOrigkatbez();
        String priority3Key = this.buildKeyCategoryTreeBean(category);
        String priority4Key = "individual";
        if (category.getTeam().equals("t")) {
            priority4Key = "team";
        }
        String priority5Key = "allcategories";
        priority1Key = category.getType() != 0 ? category.getOrigkatbez() : category.getKatbez();
        if (fighttimeDefaults.get((Object)priority1Key) != null && ((DefaultBean)fighttimeDefaults.get((Object)priority1Key)).getFighttime() != 0) {
            return ((DefaultBean)fighttimeDefaults.get((Object)priority1Key)).getFighttime();
        }
        if (fighttimeDefaults.get((Object)priority3Key) != null && ((DefaultBean)fighttimeDefaults.get((Object)priority3Key)).getFighttime() != 0) {
            return ((DefaultBean)fighttimeDefaults.get((Object)priority3Key)).getFighttime();
        }
        if (fighttimeDefaults.get((Object)priority4Key) != null && ((DefaultBean)fighttimeDefaults.get((Object)priority4Key)).getFighttime() != 0) {
            return ((DefaultBean)fighttimeDefaults.get((Object)priority4Key)).getFighttime();
        }
        if (fighttimeDefaults.get((Object)priority5Key) != null && ((DefaultBean)fighttimeDefaults.get((Object)priority5Key)).getFighttime() != 0) {
            return ((DefaultBean)fighttimeDefaults.get((Object)priority5Key)).getFighttime();
        }
        return DTMSettings.FIGHTTIME_ALLCATEGORIES;
    }

    public String findColorForCategoryTreeBean(ObservableMap<String, DefaultBean> defaults, CategoryTreeBean category) {
        String priority1Key = category.getOrigkatbez();
        String priority3Key = this.buildKeyCategoryTreeBean(category);
        String priority4Key = "individual";
        if (category.getTeam().equals("t")) {
            priority4Key = "team";
        }
        String priority5Key = "allcategories";
        priority1Key = category.getType() != 0 ? category.getOrigkatbez() : category.getKatbez();
        if (defaults.get((Object)priority1Key) != null && !((DefaultBean)defaults.get((Object)priority1Key)).getColor().equals("")) {
            return ((DefaultBean)defaults.get((Object)priority1Key)).getColor();
        }
        if (defaults.get((Object)priority3Key) != null && !((DefaultBean)defaults.get((Object)priority3Key)).getColor().equals("")) {
            return ((DefaultBean)defaults.get((Object)priority3Key)).getColor();
        }
        if (defaults.get((Object)priority4Key) != null && !((DefaultBean)defaults.get((Object)priority4Key)).getColor().equals("")) {
            return ((DefaultBean)defaults.get((Object)priority4Key)).getColor();
        }
        if (defaults.get((Object)priority5Key) != null && !((DefaultBean)defaults.get((Object)priority5Key)).getColor().equals("")) {
            return ((DefaultBean)defaults.get((Object)priority5Key)).getColor();
        }
        if (category.getSex().equals("m")) {
            return DTMSettings.COLOR_MALE;
        }
        if (category.getSex().equals("f")) {
            return DTMSettings.COLOR_FEMALE;
        }
        return DTMSettings.COLOR_MIXED;
    }

    public Integer containsBean(DefaultBean bean) {
        Object stmt = "";
        if (bean.priority() == 1) {
            stmt = "select id from dtmdefaults where vernr = '" + bean.getVernr() + "' and catname = '" + bean.getCatname() + "';";
        } else if (bean.priority() == 3) {
            stmt = "select id from dtmdefaults where vernr = '" + bean.getVernr() + "' and type = '" + bean.getType() + "' and sex = '" + bean.getSex() + "' and catname = '';";
        } else if (bean.priority() == 4) {
            stmt = "select id from dtmdefaults where vernr = '" + bean.getVernr() + "' and type = '" + bean.getType() + "' and sex = ''  and catname = '';";
        } else if (bean.priority() == 5) {
            stmt = "select id from dtmdefaults where vernr = '" + bean.getVernr() + "' and type = '' and sex = '' and catname= '';";
        } else {
            this.log.severe("FighttimeDefault bean is invalid! No priority found.");
        }
        ResultSet rs = this.db.executeString((String)stmt);
        try {
            if (rs.next()) {
                return rs.getInt("id");
            }
        }
        catch (SQLException e2) {
            e2.printStackTrace();
        }
        return -1;
    }

    public void deleteAll(Integer vernr) {
        String stmt = "delete from dtmdefaults where vernr = '" + String.valueOf(vernr) + "';";
        try {
            this.db.executeString(stmt);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public String getFullString(String s2) {
        if (s2.equals("m")) {
            return "male";
        }
        if (s2.equals("f")) {
            return "female";
        }
        if (s2.equals("x") || s2.equals("")) {
            return "mixed";
        }
        if (s2.equals("t")) {
            return "team";
        }
        if (s2.equals("i")) {
            return "individual";
        }
        return null;
    }

    public Integer getLastId() {
        Integer lastID = 0;
        ResultSet rs = this.db.executeString("SELECT MAX(id) FROM dtmdefaults");
        try {
            if (rs.next()) {
                lastID = rs.getInt(1);
                return lastID;
            }
        }
        catch (SQLException e2) {
            e2.printStackTrace();
        }
        this.log.severe("No lastID found!");
        return lastID;
    }
}

