/*
 * Decompiled with CFR 0.152.
 */
package org.sportdata.set.extension.dtm.internal.beans;

import de.schlichtherle.license.CipherParam;
import de.schlichtherle.license.KeyStoreParam;
import de.schlichtherle.license.LicenseContent;
import de.schlichtherle.license.LicenseManager;
import de.schlichtherle.license.LicenseParam;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.MissingResourceException;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import org.sportdata.set.W.a.a;
import org.sportdata.set.extension.dtm.beans.Event;
import org.sportdata.set.extension.dtm.internal.license.LicenseHelper;
import org.sportdata.set.extension.dtm.internal.log.DTMLogFormatter;
import org.sportdata.set.extension.dtm.internal.properties.helper.DTMPropertiesHelper;
import org.sportdata.set.g.v;
import org.sportdata.set.user.Passwort;

public class DTMMaster {
    private static DTMMaster dtmmaster;
    private a dtmprops = new a();
    private LicenseParam licenceParam;
    private LicenseManager licenseManager;
    private LicenseContent licenseContent;
    public static final String SUBJECT = "SET DTM";
    private static ResourceBundle resourceBundle;
    private String langueage = "";
    private Logger logger;
    private boolean dtmRunning = false;
    private boolean calculatorRunning = false;
    private Event event;
    private ArrayList<Integer> fightmatchnumberchange = new ArrayList();
    private boolean fightmatchnumberchangeall = false;
    private LicenseContent templicensecontent;

    static {
        resourceBundle = ResourceBundle.getBundle("languages.english_dtm");
    }

    public DTMMaster() {
        dtmmaster = this;
        dtmmaster.loadProps();
        dtmmaster.initLicenseParam();
        dtmmaster.initLicenseManager();
        dtmmaster.initLicenseContent();
        dtmmaster.initLanguage();
        dtmmaster.initLogger();
        dtmmaster.initEvent();
    }

    public DTMMaster(a dtmprops, LicenseContent templicensecontent) {
        dtmmaster = this;
        this.templicensecontent = templicensecontent;
        dtmmaster.setDtmprops(dtmprops);
        dtmmaster.initLicenseParam();
        dtmmaster.initLicenseManager();
        dtmmaster.initLicenseContent();
        dtmmaster.initLanguage();
        dtmmaster.initLogger();
        dtmmaster.initEvent();
    }

    public static DTMMaster getInstance() {
        return dtmmaster;
    }

    public void setTempLicense(LicenseContent templicensecontent) {
        this.templicensecontent = templicensecontent;
    }

    public void initLogger() {
        try {
            this.logger = Logger.getLogger(DTMMaster.class.getName());
            FileHandler file = new FileHandler("log/dtm.log", 1000000, 10, true);
            this.logger.addHandler(file);
            Handler[] handlers = this.logger.getHandlers();
            int i2 = 0;
            while (i2 < handlers.length) {
                handlers[i2].setFormatter(new DTMLogFormatter());
                ++i2;
            }
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public Properties getDtmprops() {
        return this.dtmprops;
    }

    public void initLanguage() {
        this.setLangueage(DTMPropertiesHelper.getLanguage());
    }

    public void setDtmprops(a wkvprops) {
        this.dtmprops = wkvprops;
    }

    public void loadProps() {
        try {
            FileInputStream fis = new FileInputStream("props/set.properties");
            this.dtmprops.load(fis);
            fis.close();
        }
        catch (Exception e2) {
            e2.printStackTrace();
            DTMPropertiesHelper.setDefaults();
        }
    }

    public void saveProps() {
        try {
            FileOutputStream fos = new FileOutputStream("props/set.properties");
            this.dtmprops.store(fos, "set main properties");
            fos.close();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    private void initLicenseParam() {
        this.licenceParam = new LicenseParam(){
            KeyStoreParam publicKeyStoreParam = new KeyStoreParam(){

                public InputStream getStream() throws IOException {
                    String resourceName = "/keystore/publicSETCerts.store";
                    InputStream in = this.getClass().getResourceAsStream("/keystore/publicSETCerts.store");
                    if (in == null) {
                        throw new FileNotFoundException("/keystore/publicSETCerts.store");
                    }
                    return in;
                }

                public String getAlias() {
                    return Passwort.d("1y7v1yte1sho1u2w1thh1th51u2e1shu1yt81y83");
                }

                public String getStorePwd() {
                    return Passwort.d("1ym71wmh1jda1vgf1jg01wnp1ym7");
                }

                public String getKeyPwd() {
                    return null;
                }
            };
            CipherParam cipherParam = new CipherParam(){

                public String getKeyPwd() {
                    return Passwort.d("1x111saj1y0s19q71y0y1sar1x1l");
                }
            };

            public String getSubject() {
                return DTMMaster.SUBJECT;
            }

            public Preferences getPreferences() {
                return Preferences.userRoot().node("/set/dtm");
            }

            public KeyStoreParam getKeyStoreParam() {
                return this.publicKeyStoreParam;
            }

            public CipherParam getCipherParam() {
                return this.cipherParam;
            }
        };
    }

    private void initLicenseManager() {
        this.licenseManager = new LicenseManager(DTMMaster.getInstance().getLicenceParam());
    }

    public void initLicenseContent() {
        try {
            this.licenseContent = DTMMaster.getInstance().getLicenseManager().verify();
            if (DTMMaster.getInstance().getLicenseContent() != null && LicenseHelper.LBL.containsKey(Passwort.c(DTMMaster.getInstance().getLicenseContent().getHolder().toString().substring(DTMMaster.getInstance().getLicenseContent().getHolder().toString().indexOf("=") + 1)))) {
                LicenseHelper.deleteLicense();
                DTMMaster.getInstance().initLicenseManager();
                this.licenseContent = DTMMaster.getInstance().getLicenseManager().verify();
            }
        }
        catch (Exception e2) {
            this.licenseContent = null;
        }
    }

    public void checkLicense() {
        DTMMaster.getInstance().getLicenseContent();
    }

    public LicenseParam getLicenceParam() {
        return this.licenceParam;
    }

    public void setLicenceParam(LicenseParam licenceParam) {
        this.licenceParam = licenceParam;
    }

    public LicenseManager getLicenseManager() {
        return this.licenseManager;
    }

    public void setLicenseManager(LicenseManager licenseManager) {
        this.licenseManager = licenseManager;
    }

    public LicenseContent getLicenseContent() {
        if (this.templicensecontent != null) {
            return this.templicensecontent;
        }
        return this.licenseContent;
    }

    public void setLicenseContent(LicenseContent licenseContent) {
        this.licenseContent = licenseContent;
    }

    public String getLangueage() {
        return this.langueage;
    }

    public void setLangueage(String langueage) {
        if (langueage != null && !langueage.equals("")) {
            this.langueage = langueage;
            this.actualizeResourceBundle();
        }
    }

    public ResourceBundle getResourceBundle() {
        try {
            if (resourceBundle == null) {
                this.actualizeResourceBundle();
            }
        }
        catch (MissingResourceException x2) {
            resourceBundle = null;
        }
        return resourceBundle;
    }

    public void setResourceBundle(ResourceBundle resourceBundle) {
        DTMMaster.resourceBundle = resourceBundle;
    }

    private void actualizeResourceBundle() {
        if (DTMMaster.getInstance().getLangueage().equals("deutsch")) {
            resourceBundle = ResourceBundle.getBundle("languages.deutsch_dtm");
        }
        if (DTMMaster.getInstance().getLangueage().equals("english")) {
            resourceBundle = ResourceBundle.getBundle("languages.english_dtm");
        }
        if (DTMMaster.getInstance().getLangueage().equals("czech")) {
            resourceBundle = ResourceBundle.getBundle("languages.czech_dtm");
        }
        if (DTMMaster.getInstance().getLangueage().equals("\u03b5\u03bb\u03bb\u03b7\u03bd\u03b9\u03ba\u03ac")) {
            resourceBundle = ResourceBundle.getBundle("languages.greek_dtm");
        }
        if (DTMMaster.getInstance().getLangueage().equals("francais")) {
            resourceBundle = ResourceBundle.getBundle("languages.francais_dtm");
        }
        if (DTMMaster.getInstance().getLangueage().equals("turkce")) {
            resourceBundle = ResourceBundle.getBundle("languages.turkce_dtm");
        }
        if (DTMMaster.getInstance().getLangueage().equals("magyar")) {
            resourceBundle = ResourceBundle.getBundle("languages.magyar_dtm");
        }
        if (DTMMaster.getInstance().getLangueage().equals("italiano")) {
            resourceBundle = ResourceBundle.getBundle("languages.italiano_dtm");
        }
        if (DTMMaster.getInstance().getLangueage().equals("russian")) {
            resourceBundle = ResourceBundle.getBundle("languages.russian_dtm");
        }
        if (DTMMaster.getInstance().getLangueage().equals("nederlandse")) {
            resourceBundle = ResourceBundle.getBundle("languages.nederlandse_dtm");
        }
        if (DTMMaster.getInstance().getLangueage().equals("\u4e2d\u6587")) {
            resourceBundle = ResourceBundle.getBundle("languages.chinese_dtm");
        }
        if (DTMMaster.getInstance().getLangueage().equals("espanol")) {
            resourceBundle = ResourceBundle.getBundle("languages.espanol_dtm");
        }
        if (DTMMaster.getInstance().getLangueage().equals("dansk")) {
            resourceBundle = ResourceBundle.getBundle("languages.danish_dtm");
        }
        if (DTMMaster.getInstance().getLangueage().equals("portugu\u00eas")) {
            resourceBundle = ResourceBundle.getBundle("languages.portuguese_dtm");
        }
        if (DTMMaster.getInstance().getLangueage().equals("c\u0440\u043f\u0441\u043a\u0438")) {
            resourceBundle = ResourceBundle.getBundle("languages.serbian_dtm");
        }
        if (DTMMaster.getInstance().getLangueage().equals("\u0641\u0627\u0631\u0633\u06cc")) {
            resourceBundle = ResourceBundle.getBundle("languages.persian_dtm");
        }
        if (DTMMaster.getInstance().getLangueage().equals("\u0639\u0631\u0628\u0649")) {
            resourceBundle = ResourceBundle.getBundle("languages.arabic_dtm");
        }
        if (DTMMaster.getInstance().getLangueage().equals("rom\u00e2n\u0103")) {
            resourceBundle = ResourceBundle.getBundle("languages.romana_dtm");
        }
    }

    public boolean isDtmRunning() {
        return this.dtmRunning;
    }

    public void setDtmRunning(boolean dtmRunning) {
        this.dtmRunning = dtmRunning;
    }

    public boolean isCalculatorRunning() {
        return this.calculatorRunning;
    }

    public void setCalculatorRunning(boolean calculatorRunning) {
        this.calculatorRunning = calculatorRunning;
    }

    public Event getEvent() {
        return this.event;
    }

    public void setEvent(Event event) {
        this.event = event;
    }

    public void initEvent() {
        Event event = new Event();
        event.setVernr(v.a().k());
        event.setBezeichnung(v.a().c());
        event.setBisdatum(v.a().r());
        event.setVerdatum(v.a().h());
        this.setEvent(event);
    }

    public ArrayList<Integer> getFightmatchnumberchange() {
        return this.fightmatchnumberchange;
    }

    public void setFightmatchnumberchange(ArrayList<Integer> fightmatchnumberchange) {
        this.fightmatchnumberchange = fightmatchnumberchange;
    }

    public boolean isFightmatchnumberchangeall() {
        return this.fightmatchnumberchangeall;
    }

    public void setFightmatchnumberchangeall(boolean fightmatchnumberchangeall) {
        this.fightmatchnumberchangeall = fightmatchnumberchangeall;
    }

    public LicenseContent getTemplicensecontent() {
        return this.templicensecontent;
    }

    public void setTemplicensecontent(LicenseContent templicensecontent) {
        this.templicensecontent = templicensecontent;
    }
}

