/*
 * Decompiled with CFR 0.152.
 */
package org.sportdata.set.extension.dtm.internal.live;

import java.awt.Cursor;
import java.net.URL;
import java.net.URLEncoder;
import org.sportdata.set.extension.dtm.internal.live.DTMLiveUtils;
import org.sportdata.set.g.h.a;
import org.sportdata.set.g.v;
import org.sportdata.set.md5.c;
import org.sportdata.set.p.c.b;
import org.sportdata.set.q.h;

public class DTMLiveUploader
implements Runnable {
    private b info;
    private boolean showinfofenster = true;
    private boolean keepRunning = true;
    private String lastreadtime = "";

    public DTMLiveUploader() {
        this.initUploader();
    }

    public DTMLiveUploader(boolean showinfofenster) {
        this.showinfofenster = showinfofenster;
        this.initUploader();
    }

    private void initUploader() {
        if (this.showinfofenster) {
            this.info = new b();
        }
        if (this.showinfofenster) {
            this.info.setCursor(new Cursor(3));
        }
        if (this.showinfofenster) {
            this.info.setTitle("Synchronizing DTM Live information for Event");
        }
        if (this.showinfofenster) {
            this.info.b("-> " + org.sportdata.set.ad.a.a("general.process.running.wait") + "\n");
        }
        a.a().B().info("Synchronizing DTM Live information for Event: " + v.a().c());
        if (this.showinfofenster) {
            this.info.b("Synchronizing DTM Live information for Event: " + v.a().c() + "\n");
        }
        this.lastreadtime = org.sportdata.set.utils.e.a.b("yyyy-MM-dd HH:mm:ss");
        if (this.showinfofenster) {
            this.info.b("Init Synchronisation Time: " + this.lastreadtime + "\n");
        }
        if (this.showinfofenster) {
            this.info.b("Try to connect to sportdata.org...\n");
        }
    }

    @Override
    public void run() {
        while (this.keepRunning) {
            try {
                if (this.showinfofenster && !this.info.isVisible()) {
                    this.stopDTMLiveSync();
                    break;
                }
                this.sendDTMLiveInfo();
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
            try {
                DTMLiveUtils.clearDTMLiveHashMap();
            }
            catch (Exception e1) {
                // empty catch block
            }
            try {
                Thread.sleep(50000L);
            }
            catch (InterruptedException x2) {
                x2.printStackTrace();
            }
        }
        if (this.showinfofenster) {
            this.info.b("Stopped sending SET DTM Live information!\n");
        }
        if (this.showinfofenster) {
            this.info.i();
        }
        if (this.showinfofenster) {
            this.info.setCursor(new Cursor(0));
        }
        a.a().B().info("Stopped sending SET DTM Live information!");
    }

    public void sendDTMLiveInfo() {
        block10: {
            try {
                String xmldata = DTMLiveUtils.generateXML();
                xmldata = xmldata.replace("+", "&#43;");
                this.lastreadtime = org.sportdata.set.utils.e.a.b("yyyy-MM-dd HH:mm:ss");
                if (this.showinfofenster) {
                    this.info.b("Last Synctime: " + this.lastreadtime + "\n");
                }
                if (this.showinfofenster) {
                    this.info.b("-> " + org.sportdata.set.ad.a.a("dtm.upload.upload.xml") + "...\n");
                }
                String response = this.uploadXMLData(xmldata, new URL(h.z()));
                if (this.showinfofenster) {
                    this.info.b("Response: " + response + "\n");
                }
                if (this.showinfofenster) {
                    this.info.b("Send DTM Live Update Request...\n");
                }
                this.generateDTMLiveOnline(new URL(h.A()));
                if (this.showinfofenster) {
                    this.info.b("Send DTM Live Generate Json Request for App...\n");
                }
                this.generateDTMLiveOnlineJson(new URL(h.O()));
            }
            catch (Exception e2) {
                e2.printStackTrace();
                if (this.showinfofenster) {
                    this.info.b("-> " + org.sportdata.set.ad.a.a("dtm.upload.error.file") + "\n");
                }
                if (this.showinfofenster) {
                    new org.sportdata.set.utils.f.b(org.sportdata.set.ad.a.a("dtm.upload.error.file"));
                }
                if (this.showinfofenster) {
                    this.info.i();
                }
                if (!this.showinfofenster) break block10;
                this.info.setCursor(new Cursor(0));
            }
        }
    }

    public String uploadXMLData(String xmldata, URL url) {
        String response = "";
        try {
            Object data = "";
            data = (String)data + "&" + URLEncoder.encode("verid", "UTF-8") + "=" + URLEncoder.encode("" + v.a().k(), "UTF-8");
            data = (String)data + "&" + URLEncoder.encode("control", "UTF-8") + "=" + URLEncoder.encode(c.a(v.a().g() + "_" + v.a().k()), "UTF-8");
            data = (String)data + "&" + URLEncoder.encode("verdate", "UTF-8") + "=" + URLEncoder.encode(v.a().h(), "UTF-8");
            data = (String)data + "&" + URLEncoder.encode("filedata", "UTF-8") + "=" + URLEncoder.encode(xmldata, "UTF-8");
            org.sportdata.set.S.a con = new org.sportdata.set.S.a(url);
            con.a((String)data);
            response = con.b().trim();
            a.a().B().info(response);
            con = null;
        }
        catch (Exception e2) {
            a.a().B().info(org.sportdata.set.ad.a.a("dtm.upload.error.file"));
            response = org.sportdata.set.ad.a.a("dtm.upload.error.file");
            Object con = null;
        }
        return response;
    }

    public void generateDTMLiveOnline(URL url) {
        String response = "";
        try {
            Object data = "";
            data = (String)data + "&" + URLEncoder.encode("verid", "UTF-8") + "=" + URLEncoder.encode("" + v.a().k(), "UTF-8");
            data = (String)data + "&" + URLEncoder.encode("control", "UTF-8") + "=" + URLEncoder.encode(c.a(v.a().g() + "_" + v.a().k()), "UTF-8");
            data = (String)data + "&" + URLEncoder.encode("verdate", "UTF-8") + "=" + URLEncoder.encode(v.a().h(), "UTF-8");
            org.sportdata.set.S.a con = new org.sportdata.set.S.a(url);
            con.a((String)data);
            response = con.b().trim();
            if (this.showinfofenster) {
                this.info.b("Response: " + response + "\n");
            }
            a.a().B().info(response);
            con = null;
        }
        catch (Exception e2) {
            Object con = null;
            e2.printStackTrace();
        }
    }

    public void generateDTMLiveOnlineJson(URL url) {
        String response = "";
        try {
            Object data = "";
            data = (String)data + "&" + URLEncoder.encode("verid", "UTF-8") + "=" + URLEncoder.encode("" + v.a().k(), "UTF-8");
            data = (String)data + "&" + URLEncoder.encode("control", "UTF-8") + "=" + URLEncoder.encode(c.a(v.a().g() + "_" + v.a().k()), "UTF-8");
            data = (String)data + "&" + URLEncoder.encode("verdate", "UTF-8") + "=" + URLEncoder.encode(v.a().h(), "UTF-8");
            org.sportdata.set.S.a con = new org.sportdata.set.S.a(url);
            con.a((String)data);
            response = con.b().trim();
            if (this.showinfofenster) {
                this.info.b("Response: " + response + "\n");
            }
            a.a().B().info(response);
            con = null;
        }
        catch (Exception e2) {
            Object con = null;
            e2.printStackTrace();
        }
    }

    public void stopDTMLiveSync() {
        this.keepRunning = false;
        this.cleanUp();
        if (this.showinfofenster) {
            this.info.i();
        }
        if (this.showinfofenster) {
            this.info.setCursor(new Cursor(0));
        }
    }

    public void cleanUp() {
    }

    public void closeWindow() {
        try {
            if (this.showinfofenster) {
                this.info.setVisible(false);
            }
            if (this.showinfofenster) {
                this.info.dispose();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

