/*
 * Decompiled with CFR 0.152.
 */
package org.sportdata.set.extension.dtm.jfxtras.internal.scene.control.skin;

import java.text.DateFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.Property;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.SkinBase;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.stage.Popup;
import jfxtras.scene.control.ImageViewButton;
import jfxtras.util.NodeUtil;
import org.sportdata.set.extension.dtm.internal.ressource.DTMResource;
import org.sportdata.set.extension.dtm.jfxtras.internal.scene.control.skin.DTMCalendarTimePickerSkin;
import org.sportdata.set.extension.dtm.jfxtras.scene.control.DTMCalendarTimePicker;
import org.sportdata.set.extension.dtm.jfxtras.scene.control.DTMCalendarTimeTextField;

public class DTMCalendarTimeTextFieldSkin
extends SkinBase<DTMCalendarTimeTextField> {
    private TextField textField = null;
    private ImageView imageView = null;
    private GridPane gridPane = null;
    private DTMCalendarTimePicker calendarTimePicker = null;
    private Popup popup = null;
    private DTMCalendarTimePicker calendarPicker = null;

    public DTMCalendarTimeTextFieldSkin(DTMCalendarTimeTextField control) {
        super((Control)control);
        this.construct();
    }

    private void construct() {
        this.createNodes();
        ((DTMCalendarTimeTextField)this.getSkinnable()).calendarProperty().addListener(observable -> this.refreshValue());
        ((DTMCalendarTimeTextField)this.getSkinnable()).dateFormatProperty().addListener(observable -> this.refreshValue());
        this.refreshValue();
        this.initFocusSimulation();
        ((DTMCalendarTimeTextField)this.getSkinnable()).pickerShowingProperty().addListener((observable, oldValue, showing) -> {
            if (showing.booleanValue()) {
                this.showPopup();
            } else if (this.popup != null) {
                this.popup.hide();
            }
        });
    }

    private void refreshValue() {
        Calendar c2 = ((DTMCalendarTimeTextField)this.getSkinnable()).getCalendar();
        String s2 = c2 == null ? "" : ((DTMCalendarTimeTextField)this.getSkinnable()).getDateFormat().format(c2.getTime());
        this.textField.setText(s2);
    }

    private void initFocusSimulation() {
        ((DTMCalendarTimeTextField)this.getSkinnable()).focusedProperty().addListener((observable, wasFocused, isFocused) -> {
            if (isFocused.booleanValue()) {
                Platform.runLater(() -> this.textField.requestFocus());
            }
        });
    }

    private void createNodes() {
        this.textField = new TextField();
        this.textField.focusedProperty().addListener(new InvalidationListener(){

            public void invalidated(Observable arg0) {
                if (!DTMCalendarTimeTextFieldSkin.this.textField.isFocused()) {
                    DTMCalendarTimeTextFieldSkin.this.parse();
                }
            }
        });
        this.textField.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent evt) {
                DTMCalendarTimeTextFieldSkin.this.parse();
            }
        });
        this.textField.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent keyEvent) {
                if (keyEvent.getCode() == KeyCode.UP || keyEvent.getCode() == KeyCode.DOWN) {
                    DTMCalendarTimeTextFieldSkin.this.parse();
                    Calendar lCalendar = (Calendar)((DTMCalendarTimeTextField)DTMCalendarTimeTextFieldSkin.this.getSkinnable()).getCalendar().clone();
                    if (keyEvent.isControlDown()) {
                        lCalendar.add(11, keyEvent.getCode() == KeyCode.UP ? 1 : -1);
                    } else {
                        lCalendar.add(12, keyEvent.getCode() == KeyCode.UP ? ((DTMCalendarTimeTextField)DTMCalendarTimeTextFieldSkin.this.getSkinnable()).getMinuteStep() : -1 * ((DTMCalendarTimeTextField)DTMCalendarTimeTextFieldSkin.this.getSkinnable()).getMinuteStep());
                    }
                    ((DTMCalendarTimeTextField)DTMCalendarTimeTextFieldSkin.this.getSkinnable()).setCalendar(DTMCalendarTimePickerSkin.blockMinutesToStep(lCalendar, ((DTMCalendarTimeTextField)DTMCalendarTimeTextFieldSkin.this.getSkinnable()).getMinuteStep()));
                }
            }
        });
        this.textField.tooltipProperty().bindBidirectional((Property)((DTMCalendarTimeTextField)this.getSkinnable()).tooltipProperty());
        if (((DTMCalendarTimeTextField)this.getSkinnable()).getTooltip() == null) {
            ((DTMCalendarTimeTextField)this.getSkinnable()).setTooltip(new Tooltip(DTMResource.getResourceString("settings.matchtime.tooltip")));
        }
        this.textField.promptTextProperty().bind(((DTMCalendarTimeTextField)this.getSkinnable()).promptTextProperty());
        this.imageView = new ImageViewButton();
        this.imageView.getStyleClass().add((Object)"icon");
        this.imageView.setPickOnBounds(true);
        this.imageView.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent evt) {
                if (DTMCalendarTimeTextFieldSkin.this.textField.focusedProperty().get()) {
                    DTMCalendarTimeTextFieldSkin.this.parse();
                }
                ((DTMCalendarTimeTextField)DTMCalendarTimeTextFieldSkin.this.getSkinnable()).setPickerShowing(true);
            }
        });
        this.gridPane = new GridPane();
        this.gridPane.setHgap(3.0);
        this.gridPane.add((Node)this.textField, 0, 0);
        this.gridPane.add((Node)this.imageView, 1, 0);
        ColumnConstraints column0 = new ColumnConstraints(100.0, 10.0, Double.MAX_VALUE);
        column0.setHgrow(Priority.ALWAYS);
        this.gridPane.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{column0});
        ((DTMCalendarTimeTextField)this.getSkinnable()).getStyleClass().add((Object)((Object)((Object)this)).getClass().getSimpleName());
        this.getChildren().add((Object)this.gridPane);
        this.calendarTimePicker = new DTMCalendarTimePicker();
        Bindings.bindBidirectional(this.calendarTimePicker.minuteStepProperty(), ((DTMCalendarTimeTextField)this.getSkinnable()).minuteStepProperty());
        Bindings.bindBidirectional(this.calendarTimePicker.secondStepProperty(), ((DTMCalendarTimeTextField)this.getSkinnable()).secondStepProperty());
    }

    private void parse() {
        block17: {
            try {
                String lText = this.textField.getText();
                lText = lText.trim();
                if (lText.length() == 0) {
                    ((DTMCalendarTimeTextField)this.getSkinnable()).setCalendar(null);
                    return;
                }
                if (lText.startsWith("-") || lText.startsWith("+")) {
                    if (lText.startsWith("+")) {
                        lText = lText.substring(1);
                    }
                    int lUnit = 5;
                    if (lText.toLowerCase().endsWith("m")) {
                        lText = lText.substring(0, lText.length() - 1);
                        lUnit = 12;
                    }
                    if (lText.toLowerCase().endsWith("h")) {
                        lText = lText.substring(0, lText.length() - 1);
                        lUnit = 11;
                    }
                    int lDelta = Integer.parseInt(lText);
                    Calendar lCalendar = (Calendar)((DTMCalendarTimeTextField)this.getSkinnable()).getCalendar().clone();
                    lCalendar.add(lUnit, lDelta);
                    ((DTMCalendarTimeTextField)this.getSkinnable()).setCalendar(DTMCalendarTimePickerSkin.blockMinutesToStep(lCalendar, ((DTMCalendarTimeTextField)this.getSkinnable()).getMinuteStep()));
                    break block17;
                }
                if (lText.equals("#")) {
                    ((DTMCalendarTimeTextField)this.getSkinnable()).setCalendar(DTMCalendarTimePickerSkin.blockMinutesToStep(Calendar.getInstance(((DTMCalendarTimeTextField)this.getSkinnable()).getLocale()), ((DTMCalendarTimeTextField)this.getSkinnable()).getMinuteStep()));
                    break block17;
                }
                try {
                    Calendar lCalendar = ((DTMCalendarTimeTextField)this.getSkinnable()).getCalendar();
                    Date lDate = null;
                    for (DateFormat lDateFormat : ((DTMCalendarTimeTextField)this.getSkinnable()).getDateFormats()) {
                        try {
                            if (lText.indexOf(":") == lText.lastIndexOf(":")) {
                                lDate = lDateFormat.parse("00:" + lText);
                                break;
                            }
                            lDate = lDateFormat.parse(lText);
                            break;
                        }
                        catch (ParseException parseException) {
                            // empty catch block
                        }
                    }
                    if (lDate == null) {
                        lDate = lText.indexOf(":") == lText.lastIndexOf(":") ? ((DTMCalendarTimeTextField)this.getSkinnable()).getDateFormat().parse("00:" + lText) : ((DTMCalendarTimeTextField)this.getSkinnable()).getDateFormat().parse(lText);
                    }
                    lCalendar = Calendar.getInstance(((DTMCalendarTimeTextField)this.getSkinnable()).getLocale());
                    lCalendar.setTime(lDate);
                    ((DTMCalendarTimeTextField)this.getSkinnable()).setCalendar(lCalendar);
                }
                finally {
                    this.refreshValue();
                }
            }
            catch (Throwable t2) {
                if (((DTMCalendarTimeTextField)this.getSkinnable()).getParseErrorCallback() != null) {
                    ((DTMCalendarTimeTextField)this.getSkinnable()).getParseErrorCallback().call((Object)t2);
                }
                t2.printStackTrace();
            }
        }
    }

    private void setupPopup() {
        this.popup = new Popup();
        this.popup.setAutoFix(true);
        this.popup.setAutoHide(true);
        this.popup.setHideOnEscape(true);
        BorderPane lBorderPane = new BorderPane(){

            public String getUserAgentStylesheet() {
                return ((DTMCalendarTimeTextField)DTMCalendarTimeTextFieldSkin.this.getSkinnable()).getUserAgentStylesheet();
            }
        };
        lBorderPane.getStyleClass().add((Object)(((Object)((Object)this)).getClass().getSimpleName() + "_popup"));
        lBorderPane.setCenter((Node)this.calendarTimePicker);
        ImageViewButton lImageView = new ImageViewButton();
        lImageView.getStyleClass().addAll((Object[])new String[]{"close-icon"});
        lImageView.setPickOnBounds(true);
        lImageView.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent evt) {
                DTMCalendarTimeTextFieldSkin.this.popup.hide();
                DTMCalendarTimeTextFieldSkin.this.popup = null;
                ((DTMCalendarTimeTextField)DTMCalendarTimeTextFieldSkin.this.getSkinnable()).calendarProperty().set((Object)((Calendar)DTMCalendarTimeTextFieldSkin.this.calendarTimePicker.calendarProperty().get()));
            }
        });
        lBorderPane.rightProperty().set((Object)lImageView);
        this.popup.getContent().add((Object)lBorderPane);
        this.popup.setOnShown(event -> ((DTMCalendarTimePickerSkin)this.calendarTimePicker.getSkin()).labelDateFormatProperty().set((Object)((DTMCalendarTimeTextField)this.getSkinnable()).getDateFormat()));
        this.popup.showingProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean showing) {
                ((DTMCalendarTimeTextField)DTMCalendarTimeTextFieldSkin.this.getSkinnable()).setPickerShowing(showing);
                if (!showing.booleanValue()) {
                    DTMCalendarTimeTextFieldSkin.this.popup.showingProperty().removeListener((ChangeListener)this);
                    DTMCalendarTimeTextFieldSkin.this.popup = null;
                }
            }
        });
    }

    private void showPopup() {
        if (this.popup == null) {
            this.setupPopup();
        }
        this.calendarTimePicker.calendarProperty().set((Object)((Calendar)((DTMCalendarTimeTextField)this.getSkinnable()).calendarProperty().get()));
        this.popup.show((Node)this.textField, NodeUtil.screenX((Node)this.getSkinnable()), NodeUtil.screenY((Node)this.getSkinnable()) + this.textField.getHeight());
    }
}

