/*
 * Decompiled with CFR 0.152.
 */
package org.sportdata.set.extension.dtm.jfxtras.internal.scene.control.skin.agenda.base24hour;

import java.text.SimpleDateFormat;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.FormatStyle;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.collections.WeakListChangeListener;
import javafx.geometry.Bounds;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.ScrollBar;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.SkinBase;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.Pane;
import javafx.scene.shape.Rectangle;
import org.sportdata.set.extension.dtm.beans.Event;
import org.sportdata.set.extension.dtm.beans.TimetableBean;
import org.sportdata.set.extension.dtm.internal.ressource.DTMResource;
import org.sportdata.set.extension.dtm.jfxtras.internal.scene.control.skin.agenda.AgendaSkin;
import org.sportdata.set.extension.dtm.jfxtras.internal.scene.control.skin.agenda.AllAppointments;
import org.sportdata.set.extension.dtm.jfxtras.internal.scene.control.skin.agenda.base24hour.DayBodyPane;
import org.sportdata.set.extension.dtm.jfxtras.internal.scene.control.skin.agenda.base24hour.DayHeaderPane;
import org.sportdata.set.extension.dtm.jfxtras.internal.scene.control.skin.agenda.base24hour.LayoutHelp;
import org.sportdata.set.extension.dtm.jfxtras.internal.scene.control.skin.agenda.base24hour.TimeScale24Hour;
import org.sportdata.set.extension.dtm.jfxtras.scene.control.agenda.Agenda;
import org.sportdata.set.extension.dtm.util.DTMUtil;

public abstract class AgendaSkinTimeScale24HourAbstract
extends SkinBase<Agenda>
implements AgendaSkin {
    protected final Agenda control;
    protected Event event;
    protected int matchAreas;
    protected LocalDate date;
    AllAppointments appointments = null;
    private InvalidationListener localeInvalidationListener = new InvalidationListener(){

        public void invalidated(Observable arg0) {
            AgendaSkinTimeScale24HourAbstract.this.refresh();
        }
    };
    private InvalidationListener displayedDateTimeInvalidationListener = new InvalidationListener(){

        public void invalidated(Observable arg0) {
            AgendaSkinTimeScale24HourAbstract.this.assignDateToDayAndHeaderPanes();
            AgendaSkinTimeScale24HourAbstract.this.scrollWeekpaneToShowDisplayedTime();
        }
    };
    private ListChangeListener<Agenda.Appointment> appointmentsListChangeListener = new ListChangeListener<Agenda.Appointment>(){

        public void onChanged(ListChangeListener.Change<? extends Agenda.Appointment> changes) {
        }
    };
    private BorderPane borderPane = null;
    private WeekHeaderPane weekHeaderPane = null;
    private ScrollPane weekScrollPane = null;
    private WeekBodyPane weekBodyPane = null;
    final Rectangle nowLine = new Rectangle(0.0, 0.0, 0.0, 0.0);
    private LayoutHelp layoutHelp = new LayoutHelp((Agenda)this.getSkinnable(), this);

    public AgendaSkinTimeScale24HourAbstract(Agenda control) {
        super((Control)control);
        this.control = control;
        this.construct();
    }

    public AgendaSkinTimeScale24HourAbstract(Agenda control, Event event) {
        super((Control)control);
        this.control = control;
        this.event = event;
        this.construct();
    }

    public AgendaSkinTimeScale24HourAbstract(Agenda control, Event event, int matchAreas) {
        super((Control)control);
        this.control = control;
        this.event = event;
        this.matchAreas = matchAreas;
        this.construct();
    }

    public AgendaSkinTimeScale24HourAbstract(Agenda control, Event event, int matchAreas, LocalDate date) {
        super((Control)control);
        this.control = control;
        this.event = event;
        this.matchAreas = matchAreas;
        this.date = date;
        this.construct();
    }

    private void construct() {
        this.appointments = new AllAppointments(((Agenda)this.getSkinnable()).appointments());
        this.createNodes();
        ((Agenda)this.getSkinnable()).localeProperty().addListener((InvalidationListener)new WeakInvalidationListener(this.localeInvalidationListener));
        ((Agenda)this.getSkinnable()).displayedLocalDateTime().addListener((InvalidationListener)new WeakInvalidationListener(this.displayedDateTimeInvalidationListener));
        ((Agenda)this.getSkinnable()).appointments().addListener((ListChangeListener)new WeakListChangeListener(this.appointmentsListChangeListener));
        ((Agenda)this.getSkinnable()).layoutHelp = this.layoutHelp;
        if (this.layoutHelp.skinnable.selectedAppointments().isEmpty()) {
            this.refresh();
        } else {
            this.refresh((TimetableBean)this.layoutHelp.skinnable.selectedAppointments().get(0));
        }
    }

    protected void reconstruct() {
        this.weekBodyPane.reconstruct();
        this.weekHeaderPane.reconstruct();
        this.refresh();
    }

    public void dispose() {
        ((Agenda)this.getSkinnable()).localeProperty().removeListener(this.localeInvalidationListener);
        ((Agenda)this.getSkinnable()).displayedLocalDateTime().removeListener(this.displayedDateTimeInvalidationListener);
        ((Agenda)this.getSkinnable()).appointments().removeListener(this.appointmentsListChangeListener);
        this.appointmentsListChangeListener = null;
        this.displayedDateTimeInvalidationListener = null;
        this.localeInvalidationListener = null;
        this.appointments.dispose();
        this.appointments = null;
    }

    private void assignDateToDayAndHeaderPanes() {
        int i2 = 0;
        List<LocalDate> lLocalDates = this.determineDisplayedLocalDates();
        for (LocalDate lLocalDate : lLocalDates) {
            DayBodyPane lDayPane = this.weekBodyPane.dayBodyPanes.get(i2);
            lDayPane.localDateObjectProperty.set((Object)lLocalDate);
            DayHeaderPane lDayHeaderPane = this.weekHeaderPane.dayHeaderPanes.get(i2);
            lDayHeaderPane.localDateObjectProperty.set((Object)lLocalDate);
            ++i2;
        }
        LocalDate lStartLocalDate = lLocalDates.get(0);
        LocalDate lEndLocalDate = lLocalDates.get(lLocalDates.size() - 1);
        if (((Agenda)this.getSkinnable()).getLocalDateTimeRangeCallback() != null) {
            Agenda.LocalDateTimeRange lRange = new Agenda.LocalDateTimeRange(lStartLocalDate.atStartOfDay(), lEndLocalDate.plusDays(1L).atStartOfDay());
            ((Agenda)this.getSkinnable()).getLocalDateTimeRangeCallback().call((Object)lRange);
        }
    }

    private void refreshLocale() {
        String lWeekendOrWeekday;
        Locale locale = ((Agenda)this.getSkinnable()).getLocale();
        this.layoutHelp.dayOfWeekDateFormat = new SimpleDateFormat("E", locale);
        this.layoutHelp.dayOfWeekDateTimeFormatter = new DateTimeFormatterBuilder().appendPattern("E").toFormatter(locale);
        this.layoutHelp.dateFormat = (SimpleDateFormat)SimpleDateFormat.getDateInstance(3, locale);
        this.layoutHelp.dateDateTimeFormatter = new DateTimeFormatterBuilder().appendLocalized(FormatStyle.SHORT, null).toFormatter(locale);
        for (DayBodyPane lDayBodyPane : this.weekBodyPane.dayBodyPanes) {
            lWeekendOrWeekday = this.isWeekend((LocalDate)lDayBodyPane.localDateObjectProperty.get()) ? "weekend" : "weekday";
            lDayBodyPane.getStyleClass().removeAll((Object[])new String[]{"weekend", "weekday"});
            lDayBodyPane.getStyleClass().add((Object)lWeekendOrWeekday);
        }
        for (DayHeaderPane lDayHeaderPane : this.weekHeaderPane.dayHeaderPanes) {
            lWeekendOrWeekday = this.isWeekend((LocalDate)lDayHeaderPane.localDateObjectProperty.get()) ? "weekend" : "weekday";
            lDayHeaderPane.getStyleClass().removeAll((Object[])new String[]{"weekend", "weekday"});
            lDayHeaderPane.getStyleClass().add((Object)lWeekendOrWeekday);
        }
    }

    @Override
    public void setupAppointments() {
        for (DayBodyPane lDay : this.weekBodyPane.dayBodyPanes) {
            lDay.setupAppointments();
        }
        this.calculateSizes();
    }

    public void setupAppointments(TimetableBean bean) {
        for (DayBodyPane lDay : this.weekBodyPane.dayBodyPanes) {
            lDay.setupAppointments(bean);
        }
        this.calculateSizes();
    }

    private void scrollWeekpaneToShowDisplayedTime() {
        LocalDateTime lDisplayedLocalDateTime = (LocalDateTime)((Agenda)this.getSkinnable()).displayedLocalDateTime().get();
        double lOffsetInMinutes = lDisplayedLocalDateTime.getHour() * 60 + lDisplayedLocalDateTime.getMinute();
        double lScrollRange = this.weekScrollPane.getVmax() - this.weekScrollPane.getVmin();
        double lValue = lScrollRange * lOffsetInMinutes / 1440.0;
        this.weekScrollPane.setVvalue(lValue);
    }

    @Override
    public void refresh() {
        this.assignDateToDayAndHeaderPanes();
        this.setupAppointments();
    }

    public void refresh(TimetableBean bean) {
        this.assignDateToDayAndHeaderPanes();
        this.setupAppointments(bean);
    }

    private void createNodes() {
        this.getChildren().clear();
        this.borderPane = new BorderPane();
        this.borderPane.prefWidthProperty().bind((ObservableValue)((Agenda)this.getSkinnable()).widthProperty());
        this.borderPane.prefHeightProperty().bind((ObservableValue)((Agenda)this.getSkinnable()).heightProperty());
        this.getChildren().add((Object)this.borderPane);
        this.weekBodyPane = new WeekBodyPane();
        this.weekScrollPane = new ScrollPane();
        this.weekScrollPane.setContent((Node)this.weekBodyPane);
        this.weekScrollPane.setHbarPolicy(ScrollPane.ScrollBarPolicy.NEVER);
        this.weekScrollPane.setVbarPolicy(ScrollPane.ScrollBarPolicy.ALWAYS);
        this.weekScrollPane.setFitToWidth(true);
        this.weekScrollPane.setPannable(false);
        this.borderPane.setCenter((Node)this.weekScrollPane);
        this.weekScrollPane.viewportBoundsProperty().addListener(observable -> this.calculateSizes());
        this.weekHeaderPane = new WeekHeaderPane(this.weekBodyPane);
        this.weekHeaderPane.setTranslateX(1.0);
        this.borderPane.setTop((Node)this.weekHeaderPane);
        this.getChildren().remove((Object)this.borderPane);
        this.layoutHelp.dragPane.getChildren().add((Object)this.borderPane);
        this.getChildren().add((Object)this.layoutHelp.dragPane);
        ((Agenda)this.getSkinnable()).getStyleClass().add((Object)this.getClass().getSimpleName());
    }

    protected abstract List<LocalDate> determineDisplayedLocalDates();

    private boolean isWeekend(LocalDate localDate) {
        return localDate.getDayOfWeek() == DayOfWeek.SATURDAY || localDate.getDayOfWeek() == DayOfWeek.SUNDAY;
    }

    private void calculateSizes() {
        int lMaxOfWholeDayAppointments = 0;
        this.layoutHelp.highestNumberOfWholedayAppointmentsProperty.set(lMaxOfWholeDayAppointments);
        if (this.weekScrollPane.viewportBoundsProperty().get() != null) {
            this.layoutHelp.dayWidthProperty.set((((Bounds)this.weekScrollPane.viewportBoundsProperty().get()).getWidth() - this.layoutHelp.timeWidthProperty.get()) / (double)this.determineDisplayedLocalDates().size());
        }
        double lScrollbarSize = new ScrollBar().getWidth();
        int cellSizeMultiplikator = DTMUtil.getCellSize(this.layoutHelp.skinnable.controller.cellSizeMode);
        this.layoutHelp.hourHeighProperty.set(this.layoutHelp.textHeightProperty.get() * (double)cellSizeMultiplikator + 10.0);
        if (this.weekScrollPane.viewportBoundsProperty().get() != null && ((Bounds)this.weekScrollPane.viewportBoundsProperty().get()).getHeight() - lScrollbarSize > this.layoutHelp.hourHeighProperty.get() * 24.0) {
            this.layoutHelp.hourHeighProperty.set((((Bounds)this.weekScrollPane.viewportBoundsProperty().get()).getHeight() - lScrollbarSize) / 24.0);
        }
    }

    @Override
    public LocalDateTime convertClickInSceneToDateTime(double x2, double y2) {
        LocalDateTime lLocalDateTime;
        for (DayBodyPane lDayPane : this.weekBodyPane.dayBodyPanes) {
            lLocalDateTime = lDayPane.convertClickInSceneToDateTime(x2, y2);
            if (lLocalDateTime == null) continue;
            return lLocalDateTime;
        }
        for (DayHeaderPane lDayHeaderPane : this.weekHeaderPane.dayHeaderPanes) {
            lLocalDateTime = lDayHeaderPane.convertClickInSceneToDateTime(x2, y2);
            if (lLocalDateTime == null) continue;
            return lLocalDateTime;
        }
        return null;
    }

    class WeekBodyPane
    extends Pane {
        final List<DayBodyPane> dayBodyPanes = new ArrayList<DayBodyPane>();

        public WeekBodyPane() {
            this.getStyleClass().add((Object)"Week");
            this.construct();
        }

        private void construct() {
            this.getChildren().add((Object)new TimeScale24Hour(this, AgendaSkinTimeScale24HourAbstract.this.layoutHelp));
            int i2 = 0;
            for (LocalDate localDate : AgendaSkinTimeScale24HourAbstract.this.determineDisplayedLocalDates()) {
                DayBodyPane lDayPane = new DayBodyPane(localDate, AgendaSkinTimeScale24HourAbstract.this.appointments, AgendaSkinTimeScale24HourAbstract.this.layoutHelp);
                lDayPane.layoutXProperty().bind((ObservableValue)AgendaSkinTimeScale24HourAbstract.this.layoutHelp.dayWidthProperty.multiply(i2).add((ObservableNumberValue)AgendaSkinTimeScale24HourAbstract.this.layoutHelp.dayFirstColumnXProperty));
                lDayPane.layoutYProperty().set(0.0);
                lDayPane.prefWidthProperty().bind((ObservableValue)AgendaSkinTimeScale24HourAbstract.this.layoutHelp.dayWidthProperty);
                lDayPane.prefHeightProperty().bind((ObservableValue)AgendaSkinTimeScale24HourAbstract.this.layoutHelp.dayHeightProperty);
                this.getChildren().add((Object)lDayPane);
                this.dayBodyPanes.add(lDayPane);
                localDate = localDate.plusDays(1L);
                ++i2;
            }
        }

        void reconstruct() {
            this.dayBodyPanes.clear();
            this.getChildren().clear();
            this.construct();
        }
    }

    class WeekHeaderPane
    extends Pane {
        final List<DayHeaderPane> dayHeaderPanes = new ArrayList<DayHeaderPane>();

        public WeekHeaderPane(WeekBodyPane weekBodyPane) {
            this.construct();
        }

        private void construct() {
            int i2 = 1;
            for (DayBodyPane dayBodyPane : AgendaSkinTimeScale24HourAbstract.this.weekBodyPane.dayBodyPanes) {
                DayHeaderPane lDayHeader = new DayHeaderPane((LocalDate)dayBodyPane.localDateObjectProperty.get(), AgendaSkinTimeScale24HourAbstract.this.appointments, AgendaSkinTimeScale24HourAbstract.this.layoutHelp, DTMResource.getResourceString("general.tatami") + " " + i2);
                lDayHeader.layoutXProperty().bind((ObservableValue)dayBodyPane.layoutXProperty());
                lDayHeader.layoutYProperty().set(0.0);
                lDayHeader.prefWidthProperty().bind((ObservableValue)dayBodyPane.prefWidthProperty());
                lDayHeader.prefHeightProperty().bind((ObservableValue)this.heightProperty());
                this.getChildren().add((Object)lDayHeader);
                this.dayHeaderPanes.add(lDayHeader);
                ++i2;
            }
            this.prefWidthProperty().bind((ObservableValue)AgendaSkinTimeScale24HourAbstract.this.weekBodyPane.widthProperty());
            this.prefHeightProperty().bind((ObservableValue)AgendaSkinTimeScale24HourAbstract.this.layoutHelp.headerHeightProperty);
        }

        private void reconstruct() {
            this.dayHeaderPanes.clear();
            this.getChildren().clear();
            this.construct();
        }
    }
}

