/*
 * Decompiled with CFR 0.152.
 */
package org.sportdata.set.extension.dtm.jfxtras.internal.scene.control.skin.agenda.base24hour;

import java.time.LocalDateTime;
import java.time.LocalTime;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WeakChangeListener;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ColorPicker;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Text;
import javafx.stage.Popup;
import javafx.util.Callback;
import jfxtras.scene.control.ImageViewButton;
import jfxtras.scene.control.LocalTimePicker;
import jfxtras.util.NodeUtil;
import org.sportdata.set.W.a.b;
import org.sportdata.set.extension.dtm.beans.TimetableBean;
import org.sportdata.set.extension.dtm.jfxtras.internal.scene.control.skin.agenda.base24hour.LayoutHelp;
import org.sportdata.set.extension.dtm.jfxtras.scene.control.agenda.Agenda;

public class AppointmentMenu
extends Rectangle {
    final Pane pane;
    final TimetableBean appointment;
    final LayoutHelp layoutHelp;
    final ColorPicker cp;
    private Popup popup;
    private ImageViewButton closeIconImageView = null;
    private LocalTimePicker startTextField = null;
    private LocalTimePicker endTextField = null;
    private CheckBox wholedayCheckBox = null;
    private TextField summaryTextField = null;
    private TextField locationTextField = null;
    private ImageViewButton deleteImageViewButton = null;
    private ImageViewButton copyImageViewButton = null;
    private ImageViewButton pasteImageViewButton = null;
    private ImageViewButton cutImageViewButton = null;
    private ImageViewButton actionImageViewButton = null;

    public AppointmentMenu(Pane pane, TimetableBean appointment, LayoutHelp layoutHelp) {
        this.pane = pane;
        this.appointment = appointment;
        this.layoutHelp = layoutHelp;
        this.cp = new ColorPicker();
        this.setX(NodeUtil.snapXY((double)layoutHelp.paddingProperty.get()));
        this.setY(NodeUtil.snapXY((double)layoutHelp.paddingProperty.get()));
        this.setWidth(6.0);
        this.setHeight(3.0);
        this.getStyleClass().add((Object)"MenuIcon");
        layoutHelp.setupMouseOverAsBusy((Node)this);
        this.setupMouseClick();
    }

    private void setupMouseClick() {
        this.setOnMouseClicked(mouseEvent -> {
            if (!mouseEvent.getButton().equals((Object)MouseButton.SECONDARY)) {
                this.showMenu((MouseEvent)mouseEvent);
            }
        });
    }

    public void showMenu(MouseEvent mouseEvent) {
        Callback<Agenda.Appointment, Void> lEditCallback = this.layoutHelp.skinnable.getEditAppointmentCallback();
        if (lEditCallback != null) {
            lEditCallback.call((Object)this.appointment);
            return;
        }
        if (this.popup != null && this.popup.isShowing()) {
            return;
        }
        this.popup = new Popup();
        this.popup.setAutoFix(true);
        this.popup.setAutoHide(true);
        this.popup.setHideOnEscape(true);
        this.popup.setOnHidden(windowEvent -> this.layoutHelp.skinnable.controller.refreshCurrentSkin(this.appointment));
        BorderPane lBorderPane = new BorderPane(){

            public String getUserAgentStylesheet() {
                return AppointmentMenu.this.layoutHelp.skinnable.getUserAgentStylesheet();
            }
        };
        lBorderPane.getStyleClass().add((Object)(((Object)((Object)this.layoutHelp.skinnable)).getClass().getSimpleName() + "Popup"));
        this.popup.getContent().add((Object)lBorderPane);
        lBorderPane.setRight((Node)this.createCloseIcon());
        VBox lVBox = new VBox(this.layoutHelp.paddingProperty.get());
        lBorderPane.setCenter((Node)lVBox);
        Text starttext = new Text("Starttime");
        Text endtext = new Text("Endtime");
        Text itemnametext = new Text("Item name:");
        Text locationtext = new Text("Location:");
        Text actionstext = new Text("Actions:");
        Text colortext = new Text("Color:");
        if (b.cP().equals("true") && b.i().equals("Nimbus")) {
            starttext.setStyle("-fx-fill:WHITE;");
            endtext.setStyle("-fx-fill:WHITE;");
            itemnametext.setStyle("-fx-fill:WHITE;");
            locationtext.setStyle("-fx-fill:WHITE;");
            actionstext.setStyle("-fx-fill:WHITE;");
            colortext.setStyle("-fx-fill:WHITE;");
        }
        lVBox.getChildren().add((Object)starttext);
        lVBox.getChildren().add((Object)this.createStartTextField());
        lVBox.getChildren().add((Object)endtext);
        lVBox.getChildren().add((Object)this.createEndTextField());
        lVBox.getChildren().add((Object)itemnametext);
        lVBox.getChildren().add((Object)this.createCatNameTextField());
        lVBox.getChildren().add((Object)locationtext);
        lVBox.getChildren().add((Object)this.createLocationTextField());
        lVBox.getChildren().add((Object)actionstext);
        lVBox.getChildren().add((Object)this.createActions());
        lVBox.getChildren().add((Object)colortext);
        lVBox.getChildren().add((Object)this.createAppointmentColorPicker());
        this.popup.show((Node)this.pane, NodeUtil.screenX((Node)this.pane), NodeUtil.screenY((Node)this.pane));
    }

    private ImageViewButton createCloseIcon() {
        this.closeIconImageView = new ImageViewButton();
        this.closeIconImageView.getStyleClass().add((Object)"close-icon");
        this.closeIconImageView.setPickOnBounds(true);
        this.closeIconImageView.setOnMouseClicked(mouseEvent2 -> this.popup.hide());
        return this.closeIconImageView;
    }

    private LocalTimePicker createStartTextField() {
        this.startTextField = new LocalTimePicker();
        this.startTextField.setLocale(this.layoutHelp.skinnable.getLocale());
        this.startTextField.setLocalTime(this.appointment.getStartLocalDateTime().toLocalTime());
        this.startTextField.setMinuteStep(Integer.valueOf(this.layoutHelp.skinnable.controller.cellSizeMode));
        this.startTextField.localTimeProperty().addListener((ChangeListener)new ChangeListener<LocalTime>(){

            public void changed(ObservableValue<? extends LocalTime> observable, LocalTime oldValue, LocalTime newValue) {
                LocalDateTime oldStart = AppointmentMenu.this.appointment.getStartLocalDateTime();
                boolean oldEdited = AppointmentMenu.this.appointment.isEdited();
                AppointmentMenu.this.appointment.setStartLocalDateTime(((LocalDateTime)AppointmentMenu.this.appointment.startLocalDateTime().get()).with(newValue));
                if (!AppointmentMenu.this.layoutHelp.skinnable.controller.overlapConfirmed(AppointmentMenu.this.appointment)) {
                    AppointmentMenu.this.appointment.setStartLocalDateTime(oldStart);
                    AppointmentMenu.this.appointment.setEdited(oldEdited);
                    AppointmentMenu.this.layoutHelp.skinnable.controller.refreshCurrentSkin(AppointmentMenu.this.appointment);
                } else {
                    AppointmentMenu.this.appointment.setEdited(true);
                    AppointmentMenu.this.appointment.update();
                }
            }
        });
        return this.startTextField;
    }

    private LocalTimePicker createEndTextField() {
        this.endTextField = new LocalTimePicker();
        this.endTextField.setLocale(this.layoutHelp.skinnable.getLocale());
        this.endTextField.setLocalTime(this.appointment.getEndLocalDateTime().toLocalTime());
        this.endTextField.setVisible(this.appointment.getEndLocalDateTime() != null);
        this.endTextField.setMinuteStep(Integer.valueOf(this.layoutHelp.skinnable.controller.cellSizeMode));
        this.endTextField.localTimeProperty().addListener((ChangeListener)new ChangeListener<LocalTime>(){

            public void changed(ObservableValue<? extends LocalTime> observable, LocalTime oldValue, LocalTime newValue) {
                LocalDateTime oldEnd = AppointmentMenu.this.appointment.getEndLocalDateTime();
                boolean oldEdited = AppointmentMenu.this.appointment.isEdited();
                AppointmentMenu.this.appointment.setEndLocalDateTime(((LocalDateTime)AppointmentMenu.this.appointment.endLocalDateTimeProperty().get()).with(newValue));
                if (!AppointmentMenu.this.layoutHelp.skinnable.controller.overlapConfirmed(AppointmentMenu.this.appointment)) {
                    AppointmentMenu.this.appointment.setEndLocalDateTime(oldEnd);
                    AppointmentMenu.this.appointment.setEdited(oldEdited);
                    AppointmentMenu.this.layoutHelp.skinnable.controller.refreshCurrentSkin(AppointmentMenu.this.appointment);
                } else {
                    AppointmentMenu.this.appointment.setEdited(true);
                    AppointmentMenu.this.appointment.update();
                }
                AppointmentMenu.this.appointment.update();
            }
        });
        return this.endTextField;
    }

    private TextField createCatNameTextField() {
        this.summaryTextField = new TextField();
        if (this.appointment.getType() != 5) {
            this.summaryTextField.setText(this.appointment.getCatname());
        } else {
            this.summaryTextField.setText(this.appointment.getComment());
        }
        this.summaryTextField.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                if (AppointmentMenu.this.appointment.getType() == 5) {
                    AppointmentMenu.this.appointment.setCatname("");
                    AppointmentMenu.this.appointment.setComment(newValue);
                    if (!newValue.equals(oldValue)) {
                        AppointmentMenu.this.appointment.setEdited(true);
                    }
                    AppointmentMenu.this.appointment.update();
                }
            }
        });
        if (this.appointment.getType() != 5) {
            this.summaryTextField.setEditable(false);
        }
        return this.summaryTextField;
    }

    private TextField createLocationTextField() {
        this.locationTextField = new TextField();
        this.locationTextField.setText(this.appointment.getLocation() == null ? "" : this.appointment.getLocation());
        this.locationTextField.textProperty().addListener((ChangeListener)new WeakChangeListener((observable, oldValue, newValue) -> this.appointment.setLocation((String)newValue)));
        this.locationTextField.setEditable(false);
        return this.locationTextField;
    }

    private HBox createActions() {
        HBox lHBox = new HBox();
        this.copyImageViewButton = this.createActionButton("copy-icon", "Copy");
        this.copyImageViewButton.setOnMouseClicked(mouseEvent -> {
            this.popup.hide();
            this.layoutHelp.skinnable.controller.copy(this.appointment);
        });
        this.copyImageViewButton.disableProperty().bind((ObservableValue)this.layoutHelp.skinnable.controller.getCopy().disabledProperty());
        lHBox.getChildren().add((Object)this.copyImageViewButton);
        this.cutImageViewButton = this.createActionButton("cut-icon", "Cut");
        this.cutImageViewButton.setOnMouseClicked(mouseEvent -> {
            this.popup.hide();
            this.layoutHelp.skinnable.controller.cut(this.appointment);
            this.appointment.delete();
        });
        this.cutImageViewButton.disableProperty().bind((ObservableValue)this.layoutHelp.skinnable.controller.getCut().disabledProperty());
        lHBox.getChildren().add((Object)this.cutImageViewButton);
        this.pasteImageViewButton = this.createActionButton("paste-icon", "Paste");
        this.pasteImageViewButton.setOnMouseClicked(mouseEvent -> {
            this.popup.hide();
            this.layoutHelp.skinnable.controller.paste();
        });
        this.pasteImageViewButton.disableProperty().bind((ObservableValue)this.layoutHelp.skinnable.controller.getPaste().disabledProperty());
        lHBox.getChildren().add((Object)this.pasteImageViewButton);
        this.deleteImageViewButton = this.createActionButton("delete-icon", "Delete");
        this.deleteImageViewButton.setOnMouseClicked(mouseEvent -> {
            this.popup.hide();
            this.layoutHelp.skinnable.controller.delete(this.appointment);
        });
        this.deleteImageViewButton.disableProperty().bind((ObservableValue)this.layoutHelp.skinnable.controller.getDelete().disabledProperty());
        lHBox.getChildren().add((Object)this.deleteImageViewButton);
        if (this.layoutHelp.skinnable.getActionCallback() != null) {
            this.actionImageViewButton = this.createActionButton("action-icon", "Action");
            this.actionImageViewButton.setOnMouseClicked(mouseEvent -> {
                this.popup.hide();
                this.layoutHelp.skinnable.getActionCallback().call((Object)this.appointment);
            });
            lHBox.getChildren().add((Object)this.actionImageViewButton);
        }
        return lHBox;
    }

    private ImageViewButton createActionButton(String styleClass, String tooltipText) {
        ImageViewButton lImageViewButton = new ImageViewButton();
        lImageViewButton.getStyleClass().add((Object)styleClass);
        lImageViewButton.setPickOnBounds(true);
        Tooltip.install((Node)lImageViewButton, (Tooltip)new Tooltip(tooltipText));
        return lImageViewButton;
    }

    private ColorPicker createAppointmentColorPicker() {
        this.cp.setValue((Object)Color.valueOf((String)this.appointment.getAppointmentGroup().getStyleClass()));
        this.cp.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                event.consume();
                String newColor = ((Color)AppointmentMenu.this.cp.getValue()).toString().replace("0x", "#").substring(0, ((Color)AppointmentMenu.this.cp.getValue()).toString().length() - 3);
                AppointmentMenu.this.appointment.getAppointmentGroup().setStyleClass(newColor);
                AppointmentMenu.this.appointment.setColor(newColor);
                AppointmentMenu.this.appointment.update();
            }
        });
        return this.cp;
    }
}

