/*
 * Decompiled with CFR 0.152.
 */
package org.sportdata.set.extension.dtm.jfxtras.internal.scene.control.skin.agenda.base24hour;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.control.TreeItem;
import javafx.scene.input.Dragboard;
import javafx.scene.input.TransferMode;
import javafx.scene.layout.Pane;
import javafx.scene.shape.Rectangle;
import javafx.util.Callback;
import jfxtras.util.NodeUtil;
import org.sportdata.set.extension.dtm.beans.CategoryTreeBean;
import org.sportdata.set.extension.dtm.beans.TimetableBean;
import org.sportdata.set.extension.dtm.internal.beans.DTMMaster;
import org.sportdata.set.extension.dtm.jfxtras.internal.scene.control.skin.agenda.AllAppointments;
import org.sportdata.set.extension.dtm.jfxtras.internal.scene.control.skin.agenda.base24hour.AppointmentAbstractTrackedPane;
import org.sportdata.set.extension.dtm.jfxtras.internal.scene.control.skin.agenda.base24hour.AppointmentRegularBodyPane;
import org.sportdata.set.extension.dtm.jfxtras.internal.scene.control.skin.agenda.base24hour.AppointmentTaskBodyPane;
import org.sportdata.set.extension.dtm.jfxtras.internal.scene.control.skin.agenda.base24hour.AppointmentWholedayBodyPane;
import org.sportdata.set.extension.dtm.jfxtras.internal.scene.control.skin.agenda.base24hour.LayoutHelp;
import org.sportdata.set.extension.dtm.jfxtras.scene.control.agenda.Agenda;
import org.sportdata.set.extension.dtm.util.DTMUtil;

class DayBodyPane
extends Pane {
    public int cellSize;
    final ObjectProperty<LocalDate> localDateObjectProperty = new SimpleObjectProperty((Object)this, "localDate");
    final AllAppointments allAppointments;
    final LayoutHelp layoutHelp;
    private Rectangle resizeRectangle = null;
    private Rectangle currentPositionRectangle = null;
    private boolean dragged = false;
    final List<AppointmentAbstractTrackedPane> trackedAppointmentBodyPanes = new ArrayList<AppointmentAbstractTrackedPane>();
    private final List<Agenda.Appointment> wholedayAppointments = new ArrayList<Agenda.Appointment>();
    private final List<AppointmentWholedayBodyPane> wholedayAppointmentBodyPanes = new ArrayList<AppointmentWholedayBodyPane>();
    private final List<Agenda.Appointment> taskAppointments = new ArrayList<Agenda.Appointment>();
    private final List<AppointmentTaskBodyPane> taskAppointmentBodyPanes = new ArrayList<AppointmentTaskBodyPane>();
    private final List<Agenda.Appointment> regularAppointments = new ArrayList<Agenda.Appointment>();
    private final List<AppointmentRegularBodyPane> regularAppointmentBodyPanes = new ArrayList<AppointmentRegularBodyPane>();
    private ArrayList<AppointmentRegularBodyPane> toDeleteTmp = new ArrayList();

    public DayBodyPane(LocalDate localDate, AllAppointments allAppointments, LayoutHelp layoutHints) {
        this.localDateObjectProperty.set((Object)localDate);
        this.allAppointments = allAppointments;
        this.layoutHelp = layoutHints;
        this.construct();
    }

    private void construct() {
        this.cellSize = this.layoutHelp.skinnable.controller.cellSizeMode;
        this.getStyleClass().add((Object)"Day");
        this.setId("DayBodyPane" + String.valueOf(this.localDateObjectProperty.get()));
        this.allAppointments.addOnChangeListener(() -> {
            if (this.layoutHelp.skinnable.selectedAppointments().isEmpty()) {
                this.setupAppointments(null);
            } else {
                this.setupAppointments((TimetableBean)this.layoutHelp.skinnable.selectedAppointments().get(0));
            }
        });
        this.setupAppointments();
        this.widthProperty().addListener(observable -> this.relayout());
        this.heightProperty().addListener(observable -> this.relayout());
        this.setupMouseDrag();
        this.localDateObjectProperty.addListener(observable -> this.setId("DayBody" + String.valueOf(this.localDateObjectProperty.get())));
        this.setId("DayBody" + String.valueOf(this.localDateObjectProperty.get()));
        this.layoutHelp.skinnable.emptyFieldRectangle().addListener((ChangeListener)new ChangeListener<Rectangle>(){

            public void changed(ObservableValue<? extends Rectangle> observable, Rectangle oldValue, Rectangle newValue) {
                if (newValue != DayBodyPane.this.currentPositionRectangle) {
                    DayBodyPane.this.getChildren().remove((Object)DayBodyPane.this.currentPositionRectangle);
                }
            }
        });
    }

    private void setupMouseDrag() {
        this.setOnDragOver(event -> {
            if (event.getGestureSource() != this && event.getDragboard().hasString()) {
                TreeItem<CategoryTreeBean> ti = this.layoutHelp.skinnable.controller.getCatTreeItem(event.getDragboard().getString());
                CategoryTreeBean c2 = (CategoryTreeBean)ti.getValue();
                for (CategoryTreeBean cb : this.layoutHelp.skinnable.controller.categoryTreeBeanToTimetableBeanMap.keySet()) {
                    Agenda.Appointment a2 = (Agenda.Appointment)this.layoutHelp.skinnable.controller.categoryTreeBeanToTimetableBeanMap.get((Object)cb);
                    if (((TimetableBean)a2).getCatname().equals(event.getDragboard().getString()) || ((TimetableBean)a2).getCatname().equals(c2.getOrigkatbez())) {
                        return;
                    }
                    for (TreeItem t2 : ti.getChildren()) {
                        if (!((TimetableBean)a2).getCatname().equals(((CategoryTreeBean)t2.getValue()).getKatbez())) continue;
                        return;
                    }
                }
                event.acceptTransferModes(new TransferMode[]{TransferMode.MOVE});
            }
            event.consume();
        });
        this.setOnDragDropped(event -> {
            this.layoutHelp.skinnable.setCurrentArea(DTMUtil.getAreaNumber(this.layoutHelp.skinnable.controller.getDays().getLocalDate(), (LocalDate)this.localDateObjectProperty.getValue(), DTMMaster.getInstance().getEvent()));
            Dragboard db = event.getDragboard();
            boolean success = false;
            if (db.hasString()) {
                TimetableBean item = null;
                if (this.layoutHelp.skinnable.newItemCallbackProperty().get() != null) {
                    double lY = NodeUtil.snapXY((double)(event.getScreenY() - NodeUtil.screenY((Node)this)));
                    this.resizeRectangle = new Rectangle(0.0, lY, this.layoutHelp.dayWidthProperty.get(), 10.0);
                    LocalDateTime lStartDateTime = ((LocalDate)this.localDateObjectProperty.get()).atStartOfDay();
                    lStartDateTime = lStartDateTime.plusSeconds((int)(this.resizeRectangle.getY() * this.layoutHelp.durationInMSPerPixelProperty.get() / 1000.0));
                    lStartDateTime = this.layoutHelp.roundTimeUp(lStartDateTime, this.cellSize);
                    this.layoutHelp.skinnable.controller.dragDroppedItem = item = (TimetableBean)((Callback)this.layoutHelp.skinnable.newItemCallbackProperty().get()).call((Object)new Agenda.LocalDateTimeRange(lStartDateTime, this.layoutHelp.roundTimeToNearestMinutes(lStartDateTime.plusSeconds(this.layoutHelp.skinnable.controller.currentSelectedCategoryTreeBean.getMatches() * this.layoutHelp.skinnable.controller.fighttimeController.findFighttimeForCategoryTreeBean(this.layoutHelp.skinnable.controller.fighttimeDefaults, this.layoutHelp.skinnable.controller.currentSelectedCategoryTreeBean)), this.cellSize)));
                    this.layoutHelp.skinnable.controller.add(item);
                }
                success = true;
            }
            event.setDropCompleted(success);
            event.consume();
        });
        this.setOnMousePressed(mouseEvent -> {
            if (this.layoutHelp.skinnable.newAppointmentCallbackProperty().get() == null) {
                return;
            }
            this.resizeRectangle = this.currentPositionRectangle;
            this.getChildren().remove((Object)this.currentPositionRectangle);
            this.setCursor(Cursor.V_RESIZE);
            double lY = NodeUtil.snapXY((double)(mouseEvent.getScreenY() - NodeUtil.screenY((Node)this)));
            LocalDateTime clickStartDateTime = ((LocalDate)this.localDateObjectProperty.get()).atStartOfDay().plusSeconds((int)(lY * this.layoutHelp.durationInMSPerPixelProperty.get() / 1000.0));
            LocalDateTime cellStartDateTime = this.layoutHelp.roundTimeUp(clickStartDateTime, this.cellSize);
            int lStartOffsetInMinutes = cellStartDateTime.getHour() * 60 + cellStartDateTime.getMinute();
            double upY = this.layoutHelp.dayHeightProperty.get() / 1440.0 * (double)lStartOffsetInMinutes;
            int emptyRectSize = this.cellSize * 60000;
            if (this.resizeRectangle == null) {
                this.resizeRectangle = new Rectangle(0.0, upY, this.layoutHelp.dayWidthProperty.get(), (double)emptyRectSize / this.layoutHelp.durationInMSPerPixelProperty.get());
                this.resizeRectangle.getStyleClass().add((Object)"EmptyFieldRectangle");
            } else {
                this.resizeRectangle.setY(upY);
                this.resizeRectangle.setWidth(this.layoutHelp.dayWidthProperty.get());
                this.resizeRectangle.setHeight((double)emptyRectSize / this.layoutHelp.durationInMSPerPixelProperty.get());
            }
            this.getChildren().add((Object)this.resizeRectangle);
            this.currentPositionRectangle = this.resizeRectangle;
            this.layoutHelp.skinnable.setEmptyFieldRectangle(this.currentPositionRectangle);
            mouseEvent.consume();
            this.dragged = false;
            this.layoutHelp.skinnable.selectedAppointments().clear();
        });
        this.setOnMouseDragged(mouseEvent -> {
            if (this.resizeRectangle == null) {
                return;
            }
            double lHeight = mouseEvent.getScreenY() - NodeUtil.screenY((Node)this.resizeRectangle);
            if (lHeight < 5.0) {
                lHeight = 5.0;
            }
            this.resizeRectangle.setHeight(lHeight);
            mouseEvent.consume();
            this.dragged = true;
        });
        this.setOnMouseReleased(mouseEvent -> {
            this.layoutHelp.skinnable.setCurrentArea(DTMUtil.getAreaNumber(this.layoutHelp.skinnable.controller.getDays().getLocalDate(), (LocalDate)this.localDateObjectProperty.getValue(), DTMMaster.getInstance().getEvent()));
            if (this.resizeRectangle == null) {
                return;
            }
            mouseEvent.consume();
            this.setCursor(Cursor.DEFAULT);
            LocalDateTime lStartDateTime = ((LocalDate)this.localDateObjectProperty.get()).atStartOfDay();
            lStartDateTime = lStartDateTime.plusSeconds((int)(this.resizeRectangle.getY() * this.layoutHelp.durationInMSPerPixelProperty.get() / 1000.0));
            lStartDateTime = this.layoutHelp.roundTimeToNearestMinutes(lStartDateTime, this.cellSize);
            if (!this.dragged) {
                this.layoutHelp.skinnable.setCurrentSelectionDateTime(lStartDateTime);
                this.getChildren().remove((Object)this.resizeRectangle);
                double lY = NodeUtil.snapXY((double)(mouseEvent.getScreenY() - NodeUtil.screenY((Node)this)));
                LocalDateTime clickStartDateTime = ((LocalDate)this.localDateObjectProperty.get()).atStartOfDay().plusSeconds((int)(lY * this.layoutHelp.durationInMSPerPixelProperty.get() / 1000.0));
                LocalDateTime cellStartDateTime = this.layoutHelp.roundTimeUp(clickStartDateTime, this.cellSize);
                int lStartOffsetInMinutes = cellStartDateTime.getHour() * 60 + cellStartDateTime.getMinute();
                double upY = this.layoutHelp.dayHeightProperty.get() / 1440.0 * (double)lStartOffsetInMinutes;
                int emptyRectSize = this.cellSize * 60000;
                if (this.resizeRectangle == null) {
                    this.resizeRectangle = new Rectangle(0.0, upY, this.layoutHelp.dayWidthProperty.get(), (double)emptyRectSize / this.layoutHelp.durationInMSPerPixelProperty.get());
                    this.resizeRectangle.getStyleClass().add((Object)"EmptyFieldRectangle");
                } else {
                    this.resizeRectangle.setY(upY);
                    this.resizeRectangle.setWidth(this.layoutHelp.dayWidthProperty.get());
                    this.resizeRectangle.setHeight((double)emptyRectSize / this.layoutHelp.durationInMSPerPixelProperty.get());
                }
                this.getChildren().add((Object)this.resizeRectangle);
                this.currentPositionRectangle = this.resizeRectangle;
                this.layoutHelp.skinnable.setEmptyFieldRectangle(this.currentPositionRectangle);
                return;
            }
            this.getChildren().remove((Object)this.resizeRectangle);
            LocalDateTime lEndDateTime = lStartDateTime.plusSeconds((int)(this.resizeRectangle.getHeight() * this.layoutHelp.durationInMSPerPixelProperty.get() / 1000.0));
            lEndDateTime = this.layoutHelp.roundTimeToNearestMinutes(lEndDateTime, this.cellSize);
            if (lStartDateTime.until(lEndDateTime, ChronoUnit.MINUTES) <= (long)this.cellSize) {
                double lY = NodeUtil.snapXY((double)(mouseEvent.getScreenY() - NodeUtil.screenY((Node)this)));
                LocalDateTime clickStartDateTime = ((LocalDate)this.localDateObjectProperty.get()).atStartOfDay().plusSeconds((int)(lY * this.layoutHelp.durationInMSPerPixelProperty.get() / 1000.0));
                LocalDateTime cellStartDateTime = this.layoutHelp.roundTimeUp(clickStartDateTime, this.cellSize);
                int lStartOffsetInMinutes = cellStartDateTime.getHour() * 60 + cellStartDateTime.getMinute();
                double upY = this.layoutHelp.dayHeightProperty.get() / 1440.0 * (double)lStartOffsetInMinutes;
                int emptyRectSize = this.cellSize * 60000;
                if (this.resizeRectangle == null) {
                    this.resizeRectangle = new Rectangle(0.0, upY, this.layoutHelp.dayWidthProperty.get(), (double)emptyRectSize / this.layoutHelp.durationInMSPerPixelProperty.get());
                    this.resizeRectangle.getStyleClass().add((Object)"EmptyFieldRectangle");
                } else {
                    this.resizeRectangle.setY(upY);
                    this.resizeRectangle.setWidth(this.layoutHelp.dayWidthProperty.get());
                    this.resizeRectangle.setHeight((double)emptyRectSize / this.layoutHelp.durationInMSPerPixelProperty.get());
                }
                this.getChildren().add((Object)this.resizeRectangle);
                this.currentPositionRectangle = this.resizeRectangle;
                this.layoutHelp.skinnable.setEmptyFieldRectangle(this.currentPositionRectangle);
                this.layoutHelp.skinnable.setCurrentSelectionDateTime(lStartDateTime);
                this.dragged = false;
                return;
            }
            this.resizeRectangle = null;
            Agenda.Appointment lAppointment = null;
            if (this.layoutHelp.skinnable.newAppointmentCallbackProperty().get() != null) {
                lAppointment = (Agenda.Appointment)((Callback)this.layoutHelp.skinnable.newAppointmentCallbackProperty().get()).call((Object)new Agenda.LocalDateTimeRange(lStartDateTime, lEndDateTime));
            }
            if (lAppointment != null) {
                this.layoutHelp.skinnable.controller.dragDroppedItem = (TimetableBean)lAppointment;
                this.layoutHelp.skinnable.controller.add((TimetableBean)lAppointment);
            }
        });
        this.setOnMouseClicked(event -> {
            LocalDateTime clickStartDateTime = this.layoutHelp.skin.convertClickInSceneToDateTime(event.getSceneX(), event.getSceneY());
            this.layoutHelp.skinnable.setCurrentSelectionDateTime(this.layoutHelp.roundTimeUp(clickStartDateTime, this.layoutHelp.skinnable.controller.cellSizeMode));
        });
    }

    private void relayout() {
        int lWholedayCnt = this.wholedayAppointmentBodyPanes.size();
        double lAllFlagpolesWidth = this.layoutHelp.wholedayAppointmentFlagpoleWidthProperty.get() * (double)lWholedayCnt;
        double lDayWidth = this.layoutHelp.dayContentWidthProperty.get();
        double lRemainingWidthForAppointments = lDayWidth - lAllFlagpolesWidth;
        double lNumberOfPixelsPerMinute = this.layoutHelp.dayHeightProperty.get() / 1440.0;
        for (AppointmentAbstractTrackedPane lAppointmentAbstractTrackedPane : this.trackedAppointmentBodyPanes) {
            double lH;
            double lNumberOfTracks = lAppointmentAbstractTrackedPane.clusterOwner.clusterTracks.size();
            double lTrackWidth = lRemainingWidthForAppointments / lNumberOfTracks;
            double lTrackIdx = lAppointmentAbstractTrackedPane.clusterTrackIdx;
            double lX = lAllFlagpolesWidth + lTrackWidth * lTrackIdx;
            lAppointmentAbstractTrackedPane.setLayoutX(NodeUtil.snapXY((double)lX));
            int lStartOffsetInMinutes = lAppointmentAbstractTrackedPane.startDateTime.getHour() * 60 + lAppointmentAbstractTrackedPane.startDateTime.getMinute();
            double lY = lNumberOfPixelsPerMinute * (double)lStartOffsetInMinutes;
            lAppointmentAbstractTrackedPane.setLayoutY(NodeUtil.snapXY((double)lY));
            double lW = lTrackWidth;
            if (lTrackIdx < lNumberOfTracks - 1.0) {
                lW *= 1.75;
            }
            lAppointmentAbstractTrackedPane.setPrefWidth(NodeUtil.snapWH((double)lAppointmentAbstractTrackedPane.getLayoutX(), (double)lW));
            if (lAppointmentAbstractTrackedPane instanceof AppointmentTaskBodyPane) {
                lH = 5.0;
            } else {
                long lHeightInMinutes = lAppointmentAbstractTrackedPane.durationInMS / 1000L / 60L;
                lH = lNumberOfPixelsPerMinute * (double)lHeightInMinutes;
                if (lH < 2.0 * this.layoutHelp.paddingProperty.get()) {
                    lH = 2.0 * this.layoutHelp.paddingProperty.get();
                }
            }
            lAppointmentAbstractTrackedPane.setPrefHeight(NodeUtil.snapWH((double)lAppointmentAbstractTrackedPane.getLayoutY(), (double)lH));
        }
    }

    private void relayout(TimetableBean bean) {
        int lWholedayCnt = this.wholedayAppointmentBodyPanes.size();
        double lAllFlagpolesWidth = this.layoutHelp.wholedayAppointmentFlagpoleWidthProperty.get() * (double)lWholedayCnt;
        double lDayWidth = this.layoutHelp.dayContentWidthProperty.get();
        double lRemainingWidthForAppointments = lDayWidth - lAllFlagpolesWidth;
        double lNumberOfPixelsPerMinute = this.layoutHelp.dayHeightProperty.get() / 1440.0;
        for (AppointmentAbstractTrackedPane lAppointmentAbstractTrackedPane : this.trackedAppointmentBodyPanes) {
            double lH;
            if (bean != null && lAppointmentAbstractTrackedPane.appointment != bean) continue;
            double lNumberOfTracks = lAppointmentAbstractTrackedPane.clusterOwner.clusterTracks.size();
            double lTrackWidth = lRemainingWidthForAppointments / lNumberOfTracks;
            double lTrackIdx = lAppointmentAbstractTrackedPane.clusterTrackIdx;
            double lX = lAllFlagpolesWidth + lTrackWidth * lTrackIdx;
            lAppointmentAbstractTrackedPane.setLayoutX(NodeUtil.snapXY((double)lX));
            int lStartOffsetInMinutes = lAppointmentAbstractTrackedPane.startDateTime.getHour() * 60 + lAppointmentAbstractTrackedPane.startDateTime.getMinute();
            double lY = lNumberOfPixelsPerMinute * (double)lStartOffsetInMinutes;
            lAppointmentAbstractTrackedPane.setLayoutY(NodeUtil.snapXY((double)lY));
            double lW = lTrackWidth;
            if (lTrackIdx < lNumberOfTracks - 1.0) {
                lW *= 1.75;
            }
            lAppointmentAbstractTrackedPane.setPrefWidth(NodeUtil.snapWH((double)lAppointmentAbstractTrackedPane.getLayoutX(), (double)lW));
            if (lAppointmentAbstractTrackedPane instanceof AppointmentTaskBodyPane) {
                lH = 5.0;
            } else {
                long lHeightInMinutes = lAppointmentAbstractTrackedPane.durationInMS / 1000L / 60L;
                lH = lNumberOfPixelsPerMinute * (double)lHeightInMinutes;
                if (lH < 2.0 * this.layoutHelp.paddingProperty.get()) {
                    lH = 2.0 * this.layoutHelp.paddingProperty.get();
                }
            }
            lAppointmentAbstractTrackedPane.setPrefHeight(NodeUtil.snapWH((double)lAppointmentAbstractTrackedPane.getLayoutY(), (double)lH));
        }
    }

    void setupAppointments() {
        this.setupRegularAppointments();
        this.trackedAppointmentBodyPanes.clear();
        this.trackedAppointmentBodyPanes.addAll(this.regularAppointmentBodyPanes);
        List<? extends AppointmentAbstractTrackedPane> determineTracks = AppointmentRegularBodyPane.determineTracks(this.trackedAppointmentBodyPanes);
        this.getChildren().addAll(determineTracks);
        this.relayout();
    }

    void setupAppointments(TimetableBean bean) {
        if (this.setupRegularAppointments(bean)) {
            this.trackedAppointmentBodyPanes.clear();
            this.trackedAppointmentBodyPanes.addAll(this.regularAppointmentBodyPanes);
            List<? extends AppointmentAbstractTrackedPane> determineTracks = AppointmentRegularBodyPane.determineTracks(this.trackedAppointmentBodyPanes, bean);
            this.getChildren().removeAll(determineTracks);
            this.getChildren().addAll(determineTracks);
            this.relayout(bean);
        }
    }

    private void setupWholedayAppointments() {
        this.wholedayAppointments.clear();
        this.wholedayAppointments.addAll(this.allAppointments.collectWholedayFor((LocalDate)this.localDateObjectProperty.get()));
        this.getChildren().removeAll(this.wholedayAppointmentBodyPanes);
        this.wholedayAppointmentBodyPanes.clear();
        int lCnt = 0;
        for (Agenda.Appointment lAppointment : this.wholedayAppointments) {
            AppointmentWholedayBodyPane lAppointmentPane = new AppointmentWholedayBodyPane((LocalDate)this.localDateObjectProperty.get(), lAppointment, this.layoutHelp);
            this.wholedayAppointmentBodyPanes.add(lAppointmentPane);
            lAppointmentPane.setId(((Object)((Object)lAppointmentPane)).getClass().getSimpleName() + String.valueOf(this.localDateObjectProperty.get()) + "/" + lCnt);
            lAppointmentPane.layoutXProperty().bind((ObservableValue)NodeUtil.snapXY((ObservableNumberValue)this.layoutHelp.wholedayAppointmentFlagpoleWidthProperty.multiply(lCnt)));
            lAppointmentPane.setLayoutY(0.0);
            lAppointmentPane.prefWidthProperty().bind((ObservableValue)this.layoutHelp.wholedayAppointmentFlagpoleWidthProperty);
            lAppointmentPane.prefHeightProperty().bind((ObservableValue)this.layoutHelp.dayHeightProperty);
            ++lCnt;
        }
        this.getChildren().addAll(this.wholedayAppointmentBodyPanes);
    }

    private void setupTaskAppointments() {
        this.taskAppointments.clear();
        this.taskAppointments.addAll(this.allAppointments.collectTaskFor((LocalDate)this.localDateObjectProperty.get()));
        this.getChildren().removeAll(this.taskAppointmentBodyPanes);
        this.taskAppointmentBodyPanes.clear();
        int lCnt = 0;
        for (Agenda.Appointment lAppointment : this.taskAppointments) {
            AppointmentTaskBodyPane lAppointmentPane = new AppointmentTaskBodyPane(lAppointment, this.layoutHelp);
            this.taskAppointmentBodyPanes.add(lAppointmentPane);
            lAppointmentPane.setId(((Object)((Object)lAppointmentPane)).getClass().getSimpleName() + String.valueOf(this.localDateObjectProperty.get()) + "/" + lCnt);
            ++lCnt;
        }
    }

    private void setupRegularAppointments() {
        this.regularAppointments.clear();
        this.regularAppointments.addAll(this.allAppointments.collectRegularFor((LocalDate)this.localDateObjectProperty.get()));
        this.getChildren().removeAll(this.regularAppointmentBodyPanes);
        this.regularAppointmentBodyPanes.clear();
        int lCnt = 0;
        for (Agenda.Appointment lAppointment : this.regularAppointments) {
            AppointmentRegularBodyPane lAppointmentPane = new AppointmentRegularBodyPane((LocalDate)this.localDateObjectProperty.get(), lAppointment, this.layoutHelp);
            this.regularAppointmentBodyPanes.add(lAppointmentPane);
            ++lCnt;
        }
    }

    private boolean setupRegularAppointments(TimetableBean bean) {
        boolean somethingToDo = false;
        int areaThis = DTMUtil.getAreaNumber(this.layoutHelp.skinnable.controller.days.getLocalDate(), (LocalDate)this.localDateObjectProperty.get(), DTMMaster.getInstance().getEvent());
        AppointmentRegularBodyPane beanPane = null;
        if (bean != null) {
            for (AppointmentRegularBodyPane appointmentPane : this.regularAppointmentBodyPanes) {
                if (appointmentPane.appointment != bean) continue;
                beanPane = appointmentPane;
                somethingToDo = true;
                break;
            }
            if (beanPane != null) {
                this.getChildren().remove(beanPane);
                this.regularAppointmentBodyPanes.remove((Object)beanPane);
            }
            if (bean.getTatami() == areaThis) {
                AppointmentRegularBodyPane lAppointmentPane = new AppointmentRegularBodyPane((LocalDate)this.localDateObjectProperty.get(), bean, this.layoutHelp);
                this.regularAppointmentBodyPanes.add(lAppointmentPane);
                this.getChildren().add((Object)lAppointmentPane);
                somethingToDo = true;
            }
            beanPane = null;
        } else if ((Integer)this.layoutHelp.skinnable.currentArea().get() == areaThis) {
            this.toDeleteTmp.clear();
            for (AppointmentRegularBodyPane appointmentPane : this.regularAppointmentBodyPanes) {
                if (appointmentPane.appointment == this.layoutHelp.skinnable.controller.deleteItem) {
                    this.toDeleteTmp.add(appointmentPane);
                    this.layoutHelp.skinnable.controller.deleteItem = null;
                    continue;
                }
                appointmentPane.refresh();
            }
            this.regularAppointmentBodyPanes.removeAll(this.toDeleteTmp);
            this.getChildren().removeAll(this.toDeleteTmp);
            if (this.layoutHelp.skinnable.controller.dragDroppedItem != null) {
                AppointmentRegularBodyPane lAppointmentPane = new AppointmentRegularBodyPane((LocalDate)this.localDateObjectProperty.get(), this.layoutHelp.skinnable.controller.dragDroppedItem, this.layoutHelp);
                this.regularAppointmentBodyPanes.add(lAppointmentPane);
                this.getChildren().add((Object)lAppointmentPane);
                this.layoutHelp.skinnable.controller.dragDroppedItem = null;
            }
            somethingToDo = true;
        }
        return somethingToDo;
    }

    LocalDateTime convertClickInSceneToDateTime(double x2, double y2) {
        Rectangle r2 = new Rectangle(NodeUtil.sceneX((Node)this), NodeUtil.sceneY((Node)this), this.getWidth(), this.getHeight());
        if (r2.contains(x2, y2)) {
            LocalDate localDate = (LocalDate)this.localDateObjectProperty.get();
            double lHeightOffset = y2 - r2.getY();
            int ms = (int)(lHeightOffset * this.layoutHelp.durationInMSPerPixelProperty.get());
            LocalDateTime localDateTime = localDate.atStartOfDay().plusSeconds(ms / 1000);
            localDateTime = localDateTime.withNano(1);
            return localDateTime;
        }
        return null;
    }
}

