/*
 * Decompiled with CFR 0.152.
 */
package org.sportdata.set.extension.dtm.util;

import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.logging.Logger;
import javafx.scene.paint.Color;
import org.sportdata.set.extension.dtm.beans.Event;
import org.sportdata.set.extension.dtm.beans.TimetableBean;

public class DTMUtil {
    public static Logger log = Logger.getLogger(DTMUtil.class.getName());
    public static SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy.MM.dd");
    public static SimpleDateFormat standardDateFormatter = new SimpleDateFormat("yyyy-MM-dd");

    public static int calcRepechageEntries(int categoryEntries, int pools) {
        if (categoryEntries <= 4 || pools <= 0) {
            return 0;
        }
        if (categoryEntries == 5 && pools == 1) {
            return 2;
        }
        int repEntries = pools == 1 ? (Math.log(categoryEntries - 1) / Math.log(2.0) == Math.ceil(Math.log(categoryEntries) / Math.log(2.0)) - 1.0 ? (int)((Math.ceil(Math.log(categoryEntries) / Math.log(2.0)) - 1.0) * 2.0 - 1.0) : (int)((Math.ceil(Math.log(categoryEntries) / Math.log(2.0)) - 1.0) * 2.0)) : (int)(Math.ceil(Math.log(categoryEntries) / Math.log(2.0)) - 1.0);
        return repEntries;
    }

    public static int calcPoolwinnerRounds(int pools) {
        if (pools < 4) {
            return 0;
        }
        return pools - 2;
    }

    public static int getTatamiNumber(Connection conn, int vernr, int knr, int type, int pool) {
        String statement = "select * from timetable where vernr=" + vernr + " and knr=" + knr + ";";
        boolean matched = false;
        int tatami = 0;
        try {
            Statement st = conn.createStatement();
            ResultSet rs = st.executeQuery(statement);
            rs.beforeFirst();
            while (rs.next()) {
                TimetableBean ttBean = DTMUtil.generateTimetableBean(rs);
                if (!DTMUtil.matchesTimetableBean(knr, type, pool, ttBean)) continue;
                matched = true;
                tatami = ttBean.getTatami();
                break;
            }
            if (!matched) {
                log.info("No entry found in Timetable for: vernr=" + vernr + " and knr=" + knr + " and type=" + type + " and pool=" + pool);
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        return tatami;
    }

    public static String getTatamiNumberAndTime(Connection conn, int vernr, int knr, int type, int pool) {
        String statement = "select * from timetable where vernr=" + vernr + " and knr=" + knr + ";";
        boolean matched = false;
        Object tatami = "";
        try {
            Statement st = conn.createStatement();
            ResultSet rs = st.executeQuery(statement);
            rs.beforeFirst();
            while (rs.next()) {
                TimetableBean ttBean = DTMUtil.generateTimetableBean(rs);
                if (!DTMUtil.matchesTimetableBean(knr, type, pool, ttBean)) continue;
                matched = true;
                tatami = ttBean.getTatami() + " " + new SimpleDateFormat("HH:mm(yyyy-MM-dd)").format(ttBean.getStarttime());
                break;
            }
            if (!matched) {
                log.info("No entry found in Timetable for: vernr=" + vernr + " and knr=" + knr + " and type=" + type + " and pool=" + pool);
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        return tatami;
    }

    public static int getNumberOfTatamis(Connection conn, int vernr, String date) {
        Date formattedDate = DTMUtil.getFormattedDate(date);
        if (formattedDate == null) {
            return 0;
        }
        String statement = "select tatamis from timetable where vernr=" + vernr + " and date = '" + String.valueOf(formattedDate) + "' LIMIT 1;";
        int tatamis = 0;
        try {
            Statement st = conn.createStatement();
            ResultSet rs = st.executeQuery(statement);
            rs.beforeFirst();
            if (rs.next()) {
                tatamis = rs.getInt("tatamis");
            } else {
                log.info("No schedule data found for day " + String.valueOf(formattedDate) + " of event " + vernr + " !");
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        return tatamis;
    }

    public static ArrayList<TimetableBean> getCategoriesOfTatami(Connection conn, int vernr, String date, int tatami) {
        TimetableBean bean = null;
        boolean beanIsAlreadyInList = false;
        Date formattedDate = DTMUtil.getFormattedDate(date);
        if (formattedDate == null) {
            return null;
        }
        String statement = "select * from timetable where vernr=" + vernr + " and date = '" + String.valueOf(formattedDate) + "' and tatami=" + tatami + " and knr != 0 and type !=5 order by starttime;";
        ArrayList<TimetableBean> list = new ArrayList<TimetableBean>();
        try {
            Statement st = conn.createStatement();
            ResultSet rs = st.executeQuery(statement);
            rs.beforeFirst();
            while (rs.next()) {
                bean = DTMUtil.generateTimetableBean(rs);
                for (TimetableBean tb : list) {
                    if (bean.getId() != tb.getId()) continue;
                    beanIsAlreadyInList = true;
                    break;
                }
                if (!beanIsAlreadyInList) {
                    list.add(bean);
                }
                beanIsAlreadyInList = false;
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        return list;
    }

    public static Date getFormattedDate(String date) {
        Date formattedDate = null;
        try {
            formattedDate = new Date(dateFormatter.parse(date).getTime());
        }
        catch (Exception e2) {
            log.severe("Error when trying to parse date " + date);
            e2.printStackTrace();
            return null;
        }
        return formattedDate;
    }

    public static TimetableBean generateTimetableBean(ResultSet rs) throws Exception {
        boolean edited = rs.getInt("edited") != 0;
        return new TimetableBean(rs.getInt("id"), rs.getInt("vernr"), rs.getDate("date"), rs.getInt("tatamis"), rs.getInt("knr"), rs.getString("catname"), rs.getString("sex"), rs.getInt("type"), rs.getInt("tatami"), rs.getInt("pool"), rs.getInt("pools"), rs.getInt("entries"), rs.getInt("fighttime"), edited, rs.getString("color"), rs.getTimestamp("starttime"), rs.getTimestamp("endtime"), rs.getString("comment"), null, rs.getInt("matchnumber"));
    }

    public static void updateDate(int vernr, String oldDate, String newDate, Connection conn) {
        Date formattedOldDate = null;
        Date formattedNewDate = null;
        try {
            formattedOldDate = new Date(dateFormatter.parse(oldDate).getTime());
            formattedNewDate = new Date(dateFormatter.parse(newDate).getTime());
        }
        catch (Exception e2) {
            log.severe("Error when trying to parse date!");
            e2.printStackTrace();
            return;
        }
        String selectStatement = "select id,date,starttime,endtime from timetable where vernr=" + vernr + " and date='" + formattedOldDate.toString() + "';";
        Object updateStatement = "";
        String starttime = "";
        String endtime = "";
        Object newStarttime = "";
        Object newEndtime = "";
        Statement selectSt = null;
        Statement updateSt = null;
        try {
            selectSt = conn.createStatement();
            updateSt = conn.createStatement();
            ResultSet rs = selectSt.executeQuery(selectStatement);
            while (rs.next()) {
                Integer id = rs.getInt("id");
                starttime = rs.getTimestamp("starttime").toString();
                endtime = rs.getTimestamp("endtime").toString();
                if (starttime.substring(0, 10).equals(endtime.substring(0, 10))) {
                    newStarttime = formattedNewDate.toString() + starttime.substring(10);
                    newEndtime = formattedNewDate.toString() + endtime.substring(10);
                } else {
                    try {
                        Date oldEndtimeDate = new Date(standardDateFormatter.parse(endtime.substring(0, 10)).getTime());
                        Date oldStarttimeDate = new Date(standardDateFormatter.parse(starttime.substring(0, 10)).getTime());
                        long difference = oldEndtimeDate.getTime() - oldStarttimeDate.getTime();
                        Date newEndtimeDate = new Date(formattedNewDate.getTime() + difference);
                        newStarttime = formattedNewDate.toString() + starttime.substring(10);
                        newEndtime = newEndtimeDate.toString() + endtime.substring(10);
                    }
                    catch (Exception e3) {
                        e3.printStackTrace();
                        return;
                    }
                }
                updateStatement = "update timetable set date = '" + formattedNewDate.toString() + "',starttime='" + (String)newStarttime + "',endtime='" + (String)newEndtime + "' where id=" + String.valueOf(id) + ";";
                updateSt.addBatch((String)updateStatement);
            }
            updateSt.executeBatch();
            log.info("Date of event " + vernr + " in DTM timetable updated from '" + oldDate + "' to '" + newDate + "'.");
        }
        catch (SQLException e4) {
            log.severe("An error occured when trying to update the date of event " + vernr + " from '" + oldDate + "' to '" + newDate + "' in DTM timetable!");
            e4.printStackTrace();
        }
    }

    public static boolean matchesTimetableBean(int knr, int type, int pool, TimetableBean ttBean) {
        boolean ret = false;
        if (ttBean.getKnr() != knr) {
            ret = false;
        } else if (ttBean.getType() == 0) {
            ret = true;
        } else {
            switch (type) {
                case 0: {
                    if (ttBean.getType() != 0) {
                        ret = false;
                        break;
                    }
                    ret = true;
                    break;
                }
                case 1: {
                    if (ttBean.getType() != 1) {
                        ret = false;
                        break;
                    }
                    if (ttBean.getPool() == pool) {
                        ret = true;
                        break;
                    }
                    ret = false;
                    break;
                }
                case 2: {
                    if (ttBean.getType() != 2) {
                        ret = false;
                        break;
                    }
                    ret = true;
                    break;
                }
                case 3: {
                    if (ttBean.getType() != 3) {
                        ret = false;
                        break;
                    }
                    if (ttBean.getPool() == pool) {
                        ret = true;
                        break;
                    }
                    ret = false;
                    break;
                }
                case 4: {
                    if (ttBean.getType() != 4) {
                        ret = false;
                        break;
                    }
                    ret = true;
                    break;
                }
                case 6: {
                    if (ttBean.getType() != 6) {
                        ret = false;
                        break;
                    }
                    if (ttBean.getPool() == pool) {
                        ret = true;
                        break;
                    }
                    ret = false;
                    break;
                }
                case 7: {
                    if (ttBean.getType() != 7) {
                        ret = false;
                        break;
                    }
                    if (ttBean.getPool() == pool) {
                        ret = true;
                        break;
                    }
                    ret = false;
                    break;
                }
                case 8: {
                    ret = ttBean.getType() != 8 ? false : ttBean.getPool() == pool;
                }
            }
        }
        return ret;
    }

    public static void deleteDayFromTimetable(int vernr, String day, Connection conn) {
        try {
            Date formattedDate = new Date(dateFormatter.parse(day).getTime());
            String statement = "delete from timetable where vernr=" + vernr + " and date='" + formattedDate.toString() + "';";
            Statement st = conn.createStatement();
            st.executeUpdate(statement);
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public static boolean isTimetableAvailable(int vernr, Connection conn) {
        try {
            String statement = "select * from timetable where vernr=" + vernr + " LIMIT 1 ;";
            Statement st = conn.createStatement();
            ResultSet rs = st.executeQuery(statement);
            return rs.next();
        }
        catch (Exception e2) {
            e2.printStackTrace();
            return true;
        }
    }

    public static String getFormattedTimeHHMMSS(int seconds) {
        if (seconds == -1) {
            return "-1";
        }
        int hours = seconds / 3600;
        int remainder = seconds % 3600;
        int minutes = remainder / 60;
        int secs = remainder % 60;
        return (hours < 10 ? "0" : "") + hours + ":" + (minutes < 10 ? "0" : "") + minutes + ":" + (secs < 10 ? "0" : "") + secs;
    }

    public static boolean validateInputString(String input) {
        String lowInput = input.toLowerCase();
        return !lowInput.contains(";") && !lowInput.contains(",") && !lowInput.contains("(") && !lowInput.contains(")") && !lowInput.contains("delete ") && !lowInput.contains("drop ") && !lowInput.contains("update ") && !lowInput.contains("insert ") && !lowInput.contains("select ") && !lowInput.contains("grant ") && !lowInput.contains("create ") && !lowInput.contains("revoke ") && !lowInput.contains("use ") && !lowInput.contains("connect ") && !lowInput.contains("alter ");
    }

    public static int getAreaNumber(LocalDate date1, LocalDate date2, Event event) {
        LocalDate eventStart = DTMUtil.asLocalDate(event.getVerdatum());
        int difFromEventStart = (int)eventStart.until(date1, ChronoUnit.DAYS);
        LocalDate toDate = date2.minusDays(100000 + difFromEventStart * 30);
        LocalDate tempDate = LocalDate.from(date1);
        long years = tempDate.until(toDate, ChronoUnit.YEARS);
        tempDate = tempDate.plusYears(years);
        long months = tempDate.until(toDate, ChronoUnit.MONTHS);
        tempDate = tempDate.plusMonths(months);
        long days = tempDate.until(toDate, ChronoUnit.DAYS);
        return (int)days + 1;
    }

    public static LocalDateTime getRealLocalDateTime(LocalDate day, LocalDateTime fakeLocalDateTime, Event event) {
        LocalDate eventStart = DTMUtil.asLocalDate(event.getVerdatum());
        int difFromEventStart = (int)eventStart.until(day, ChronoUnit.DAYS);
        int area = DTMUtil.getAreaNumber(day, fakeLocalDateTime.toLocalDate(), event);
        return fakeLocalDateTime.minusDays(100000 + difFromEventStart * 30 + area - 1);
    }

    public static LocalDateTime getFakeLocalDateTime(int area, LocalDateTime realLocalDateTime, Event event) {
        LocalDate eventStart = DTMUtil.asLocalDate(event.getVerdatum());
        int difFromEventStart = (int)eventStart.until(realLocalDateTime.toLocalDate(), ChronoUnit.DAYS);
        return realLocalDateTime.plusDays(100000 + difFromEventStart * 30 + area - 1);
    }

    public static LocalDate getFakeLocalDate(int area, LocalDate realLocalDate, Event event) {
        LocalDate eventStart = DTMUtil.asLocalDate(event.getVerdatum());
        int difFromEventStart = (int)eventStart.until(realLocalDate, ChronoUnit.DAYS);
        return realLocalDate.plusDays(100000 + difFromEventStart * 30 + area - 1);
    }

    public static LocalDate asLocalDate(String date) {
        String isoDate = date.replace(".", "-");
        LocalDate localDate = LocalDate.parse(isoDate, DateTimeFormatter.ISO_LOCAL_DATE);
        return localDate;
    }

    public static Date asDate(LocalDate localDate) {
        return new Date(Date.from(localDate.atStartOfDay().atZone(ZoneId.systemDefault()).toInstant()).getTime());
    }

    public static Date asDate(String date) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy.MM.dd");
        Date d2 = null;
        try {
            d2 = new Date(formatter.parse(date).getTime());
        }
        catch (ParseException e2) {
            e2.printStackTrace();
        }
        return d2;
    }

    public static Date asDate(LocalDateTime localDateTime) {
        return new Date(Date.from(localDateTime.atZone(ZoneId.systemDefault()).toInstant()).getTime());
    }

    public static LocalDate asLocalDate(Date date) {
        return Instant.ofEpochMilli(date.getTime()).atZone(ZoneId.systemDefault()).toLocalDate();
    }

    public static LocalDateTime asLocalDateTime(Date date) {
        return Instant.ofEpochMilli(date.getTime()).atZone(ZoneId.systemDefault()).toLocalDateTime();
    }

    public static String toRGBCode(Color color) {
        return String.format("#%02X%02X%02X", (int)(color.getRed() * 255.0), (int)(color.getGreen() * 255.0), (int)(color.getBlue() * 255.0));
    }

    public static int getCellSize(Integer cellSizeMode) {
        if (cellSizeMode == null) {
            return 9;
        }
        switch (cellSizeMode) {
            case 1: {
                return 40;
            }
            case 5: {
                return 9;
            }
        }
        return 9;
    }

    public static void deleteCorruptEntries(int vernr, Connection conn) {
        try {
            String statement = "delete from timetable where vernr='" + vernr + "' and endtime <= starttime ";
            Statement st = conn.createStatement();
            st.executeUpdate(statement);
            st.close();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public static void deleteCorruptEntries2(int vernr, Connection conn) {
        try {
            String statement = "delete from timetable where vernr='" + vernr + "' and tatami < 1 ";
            Statement st = conn.createStatement();
            st.executeUpdate(statement);
            st.close();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public static void deleteCorruptEntries3(int vernr, Connection conn) {
        try {
            String statement = "DELETE FROM timetable WHERE  vernr='" + vernr + "' AND (CAST(starttime AS DATE) != date OR CAST(endtime AS DATE) != date OR CAST(starttime AS DATE) != CAST(endtime AS DATE)) ;";
            Statement st = conn.createStatement();
            st.executeUpdate(statement);
            st.close();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public static HashSet<Integer> getNumberOfTatamisWithMatchcalling(Connection conn, int vernr, String date) {
        Date formattedDate = DTMUtil.getFormattedDate(date);
        if (formattedDate == null) {
            return new HashSet<Integer>();
        }
        HashSet<Integer> ret = new HashSet<Integer>();
        String statement = "select distinct tatami from timetable where vernr=" + vernr + " and date = '" + String.valueOf(formattedDate) + "' and type=8";
        try {
            Statement st = conn.createStatement();
            ResultSet rs = st.executeQuery(statement);
            rs.beforeFirst();
            while (rs.next()) {
                ret.add(rs.getInt("tatami"));
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        return ret;
    }
}

