/*
 * Decompiled with CFR 0.152.
 */
package org.sportdata.set.extension.dtm.view;

import java.util.Optional;
import javafx.application.Platform;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.image.ImageView;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import org.sportdata.set.extension.dtm.internal.ressource.DTMResource;

public class DTMDialog {
    public Boolean question(Stage stage, String message) {
        return this.question(stage, DTMResource.getResourceString("general.attention"), message);
    }

    public Boolean question(Stage stage, String message1, String message2) {
        Alert dlg = DTMDialog.createAlert(stage, Alert.AlertType.CONFIRMATION, Modality.APPLICATION_MODAL);
        DTMDialog.configureSampleDialog(dlg, message1, null, message2, null, StageStyle.DECORATED);
        dlg.getDialogPane().getButtonTypes().clear();
        dlg.getDialogPane().getButtonTypes().add((Object)ButtonType.YES);
        dlg.getDialogPane().getButtonTypes().add((Object)ButtonType.NO);
        return DTMDialog.showDialog(dlg, false, true);
    }

    public static void inform(Stage stage, String message) {
        DTMDialog.inform(stage, DTMResource.getResourceString("general.attention"), message);
    }

    public static void inform(Stage stage, String message1, String message2) {
        Alert dlg = DTMDialog.createAlert(stage, Alert.AlertType.INFORMATION, Modality.APPLICATION_MODAL);
        DTMDialog.configureSampleDialog(dlg, message1, null, message2, null, StageStyle.DECORATED);
        DTMDialog.showDialog(dlg, false, false);
    }

    public static Boolean confirm(Stage stage, String message) {
        return DTMDialog.confirm(stage, DTMResource.getResourceString("general.attention"), message);
    }

    public static Boolean confirm(Stage stage, String message1, String message2) {
        Alert dlg = DTMDialog.createAlert(stage, Alert.AlertType.CONFIRMATION, Modality.APPLICATION_MODAL);
        DTMDialog.configureSampleDialog(dlg, message1, null, message2, null, StageStyle.DECORATED);
        return DTMDialog.showDialog(dlg, false, true);
    }

    private static Alert createAlert(Stage stage, Alert.AlertType type, Modality modality) {
        Alert dlg = new Alert(type, "", new ButtonType[0]);
        dlg.initModality(modality);
        dlg.initOwner((Window)stage);
        return dlg;
    }

    private static void configureSampleDialog(Dialog<?> dlg, String title, String header, String message, String iconPath, StageStyle style) {
        dlg.setTitle(title);
        dlg.getDialogPane().setContentText(message);
        if (header != null && !header.equals("")) {
            dlg.getDialogPane().setHeaderText(header);
        }
        if (iconPath != null && !iconPath.equals("")) {
            dlg.getDialogPane().setGraphic((Node)new ImageView(iconPath));
        }
        dlg.initStyle(style);
    }

    private static Boolean showDialog(Dialog<?> dlg, Boolean autoClose, Boolean useBlocking) {
        if (autoClose.booleanValue()) {
            new Thread(() -> {
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException e2) {
                    e2.printStackTrace();
                }
                Platform.runLater(() -> dlg.close());
            }).start();
        }
        if (useBlocking.booleanValue()) {
            Optional result = dlg.showAndWait();
            if (result.isPresent() && (result.get() == ButtonType.OK || result.get() == ButtonType.YES)) {
                return true;
            }
            return false;
        }
        dlg.show();
        return true;
    }
}

