/*
 * Decompiled with CFR 0.152.
 */
package org.sportdata.set.extension.dtm.view;

import javafx.collections.MapChangeListener;
import javafx.collections.ObservableMap;
import javafx.scene.Node;
import javafx.scene.control.Tooltip;
import javafx.scene.control.TreeCell;
import javafx.scene.image.ImageView;
import org.sportdata.set.extension.dtm.beans.CategoryTreeBean;
import org.sportdata.set.extension.dtm.beans.DefaultBean;
import org.sportdata.set.extension.dtm.beans.TimetableBean;
import org.sportdata.set.extension.dtm.controller.DefaultsController;
import org.sportdata.set.extension.dtm.internal.ressource.DTMResource;
import org.sportdata.set.extension.dtm.util.DTMUtil;

public class DTMTreeCell
extends TreeCell<CategoryTreeBean> {
    private DefaultsController defaultsController;
    private ObservableMap<String, DefaultBean> fighttimeDefaults;
    private TimetableBean bean;
    private Tooltip tooltip;
    private ObservableMap<CategoryTreeBean, TimetableBean> ttMap;

    public DTMTreeCell() {
    }

    public DTMTreeCell(ObservableMap<CategoryTreeBean, TimetableBean> ttMap, DefaultsController defaultsController, ObservableMap<String, DefaultBean> fighttimeDefaults) {
        this.ttMap = ttMap;
        this.defaultsController = defaultsController;
        this.fighttimeDefaults = fighttimeDefaults;
        ttMap.addListener((MapChangeListener)new MapChangeListener<CategoryTreeBean, TimetableBean>(){

            public void onChanged(MapChangeListener.Change<? extends CategoryTreeBean, ? extends TimetableBean> change) {
                DTMTreeCell.this.updateItem((CategoryTreeBean)DTMTreeCell.this.getItem(), DTMTreeCell.this.isEmpty());
            }
        });
        fighttimeDefaults.addListener((MapChangeListener)new MapChangeListener<String, DefaultBean>(){

            public void onChanged(MapChangeListener.Change<? extends String, ? extends DefaultBean> change) {
                DTMTreeCell.this.updateItem((CategoryTreeBean)DTMTreeCell.this.getItem(), DTMTreeCell.this.isEmpty());
            }
        });
    }

    protected void updateItem(CategoryTreeBean item, boolean empty) {
        super.updateItem((Object)item, empty);
        boolean entriesChanged = false;
        if (empty) {
            this.setText(null);
            this.setGraphic(null);
            this.setStyle("-fx-background:white;");
        } else {
            this.setText(item.getKatbez() + " (" + item.getEntries() + ")");
            this.setGraphic(this.getTreeItem().getGraphic());
            TimetableBean ttBean = (TimetableBean)this.ttMap.get((Object)item);
            if (ttBean != null) {
                this.bean = ttBean;
                this.opacityProperty().set(0.4);
                item.visibleProperty().set(false);
            } else if (item.parentInvisibleProperty().get()) {
                this.bean = null;
                this.opacityProperty().set(0.4);
                item.visibleProperty().set(false);
            } else {
                this.bean = null;
                this.opacityProperty().set(1.0);
                item.visibleProperty().set(true);
            }
            if (item.getType() == 0) {
                if (item.childrenInvisibleProperty().get()) {
                    this.opacityProperty().set(0.4);
                    item.visibleProperty().set(false);
                } else if (item.visibleProperty().get()) {
                    this.opacityProperty().set(1.0);
                }
            }
            if (item.visibleProperty().get()) {
                this.tooltip = new Tooltip(item.getKatbez() + " (" + item.getEntries() + ")\n" + DTMResource.getResourceString("main.tooltip.categorylist.presetmatchtime") + " " + DTMUtil.getFormattedTimeHHMMSS(this.defaultsController.findFighttimeForCategoryTreeBean(this.fighttimeDefaults, item)) + "\n" + DTMResource.getResourceString("main.tooltip.categorylist.calcduration") + " " + DTMUtil.getFormattedTimeHHMMSS(this.calcItemDuration(item.getEntries(), this.defaultsController.findFighttimeForCategoryTreeBean(this.fighttimeDefaults, item), item.getMatches(), item.getType())));
                this.tooltip.setGraphic((Node)new ImageView("/org/sportdata/set/extension/dtm/view/images/new/warning.png"));
                this.setTooltip(this.tooltip);
            } else if (item != null) {
                if (this.bean != null) {
                    String edited = this.bean.isEdited() ? DTMResource.getResourceString("general.edited") : "";
                    entriesChanged = this.bean.getEntries() != item.getEntries();
                    String title = entriesChanged ? DTMResource.getResourceString("main.tooltip.categorylist.entrieschanged") + "\n" + item.getKatbez() + " (" + item.getEntries() + ")" : item.getKatbez() + " (" + item.getEntries() + ")";
                    this.tooltip = new Tooltip(title + "\n" + DTMResource.getResourceString("general.date") + " " + String.valueOf(this.bean.getDate()) + "\n" + DTMResource.getResourceString("general.tatami") + ": " + this.bean.getTatami() + "\n" + DTMResource.getResourceString("general.starttime") + " " + this.bean.getStarttime().toString().substring(11, 16) + "\n" + DTMResource.getResourceString("general.endtime") + " " + this.bean.getEndtime().toString().substring(11, 16) + "\n" + DTMResource.getResourceString("general.duration") + " " + this.bean.getFormattedCatDuration() + edited + "\n" + DTMResource.getResourceString("general.matchtime") + " " + DTMUtil.getFormattedTimeHHMMSS(this.bean.getFighttime()));
                } else {
                    this.tooltip = new Tooltip(item.getKatbez() + " (" + item.getEntries() + ")\n" + DTMResource.getResourceString("main.tooltip.categorylist.presetmatchtime") + " " + DTMUtil.getFormattedTimeHHMMSS(this.defaultsController.findFighttimeForCategoryTreeBean(this.fighttimeDefaults, item)) + "\n" + DTMResource.getResourceString("main.tooltip.categorylist.calcduration") + " " + DTMUtil.getFormattedTimeHHMMSS(this.calcItemDuration(item.getEntries(), this.defaultsController.findFighttimeForCategoryTreeBean(this.fighttimeDefaults, item), item.getMatches(), item.getType())));
                    this.tooltip.setGraphic((Node)new ImageView("/org/sportdata/set/extension/dtm/view/images/new/check.png"));
                }
                this.setTooltip(this.tooltip);
            }
        }
        if (!empty && item != null) {
            if (entriesChanged) {
                this.tooltip.setGraphic((Node)new ImageView("/org/sportdata/set/extension/dtm/view/images/new/inform.png"));
                item.entriesChangedProperty().set(true);
                this.setStyle("-fx-background:#B3CCFF;");
            } else if (this.bean != null) {
                this.tooltip.setGraphic((Node)new ImageView("/org/sportdata/set/extension/dtm/view/images/new/check.png"));
                this.setStyle("-fx-background:white;");
            } else {
                this.setStyle("-fx-background:white;");
            }
        }
    }

    public Integer calcItemDuration(Integer entries, Integer fighttime, Integer matches, Integer itemType) {
        Integer itemDuration = matches * fighttime;
        return itemDuration;
    }
}

