/*
 * Decompiled with CFR 0.152.
 */
package org.sportdata.set.extension.dtm.view;

import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Logger;
import org.sportdata.set.an.b.I;
import org.sportdata.set.an.b.d;
import org.sportdata.set.an.b.h;
import org.sportdata.set.extension.dtm.beans.DTMUtill;
import org.sportdata.set.extension.dtm.beans.DynamicCategoryBean;
import org.sportdata.set.extension.dtm.beans.TimetableBean;
import org.sportdata.set.extension.dtm.internal.beans.DTMMaster;
import org.sportdata.set.extension.dtm.util.DTMUtil;
import org.sportdata.set.g.C;
import org.sportdata.set.g.f;
import org.sportdata.set.g.g;

public class DynamicView {
    private static Logger log;

    public static ArrayList<DynamicCategoryBean> getScheduleStatus(DynamicCategoryBean dynBean, TimetableBean matchingTimetableBean, Connection conn, Timestamp currentTime) {
        log = DTMMaster.getInstance().getLogger();
        currentTime = new Timestamp(System.currentTimeMillis());
        if (dynBean != null) {
            if (!dynBean.isEmptyBean()) {
                return DynamicView.getScheduleStatusFromFilledBean(dynBean, matchingTimetableBean, currentTime, conn);
            }
            return DynamicView.getScheduleStatusFromEmptyBean(dynBean, currentTime, conn);
        }
        return DynamicView.getCurrentScheduledItems(currentTime, dynBean, conn);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static ArrayList getScheduleStatusFromEmptyBean(DynamicCategoryBean dynBean, Timestamp currentTime, Connection conn) {
        TimetableBean ttBean = null;
        TimetableBean matchingTimetableBean = null;
        TimetableBean ttBeanOld = null;
        DynamicCategoryBean returnDynBean = null;
        boolean firstBean = true;
        boolean justShowSchedule = false;
        boolean customItemRunning = false;
        boolean firstTTBeanIsFinished = false;
        boolean lastFinishedAvailable = false;
        boolean partOfParentIsFinished = false;
        String estimatedStarttime = null;
        String scheduledStarttime = null;
        long delayInMillis = 0L;
        long delayInMinutes = 0L;
        long crossTime = 0L;
        ArrayList<DynamicCategoryBean> list = new ArrayList<DynamicCategoryBean>();
        if (dynBean.getLastFinishedCategory() == null) return DynamicView.getCurrentScheduledItems(currentTime, dynBean, conn);
        lastFinishedAvailable = true;
        matchingTimetableBean = DynamicView.getMatchingTimetableBean(dynBean.getLastFinishedCategory(), currentTime, conn);
        if (matchingTimetableBean != null) {
            String statement = "select * from timetable tt where tt.vernr = " + matchingTimetableBean.getVernr() + " and tt.tatami = " + matchingTimetableBean.getTatami() + " and tt.starttime >= '" + String.valueOf(matchingTimetableBean.getStarttime()) + "' and tt.date = '" + String.valueOf(matchingTimetableBean.getDate()) + "' and tt.starttime != tt.endtime order by tt.starttime;";
            ResultSet rs = DynamicView.executeStatement(statement, conn);
            try {
                rs.next();
                ttBean = DTMUtil.generateTimetableBean(rs);
                if (DynamicView.partOfParentIsFinished(dynBean, ttBean)) {
                    if (DynamicView.categoryIsFinished(dynBean.getLastFinishedCategory(), ttBean)) {
                        firstBean = true;
                    } else {
                        delayInMillis = DynamicView.calcDelay1(dynBean.getLastFinishedCategory(), ttBean, currentTime);
                        delayInMinutes = DTMUtill.msToMin(delayInMillis, true);
                        scheduledStarttime = "";
                        estimatedStarttime = "";
                        returnDynBean = DynamicView.generateDynBean(dynBean, ttBean, scheduledStarttime, estimatedStarttime, String.valueOf(delayInMinutes));
                        list.add(returnDynBean);
                        firstBean = false;
                    }
                } else {
                    firstBean = true;
                }
                while (rs.next()) {
                    ttBeanOld = ttBean;
                    ttBean = DTMUtil.generateTimetableBean(rs);
                    if (firstBean) {
                        if (currentTime.after(ttBean.getStarttime())) {
                            if (ttBean.getType() == 5) {
                                delayInMillis = currentTime.after(ttBean.getEndtime()) ? DynamicView.calcDelay3(ttBean, currentTime) : 0L;
                                delayInMinutes = DTMUtill.msToMin(delayInMillis, true);
                                scheduledStarttime = "";
                                estimatedStarttime = "";
                            } else {
                                delayInMillis = DynamicView.calcDelay2(ttBean, currentTime);
                                delayInMinutes = DTMUtill.msToMin(delayInMillis, true);
                                scheduledStarttime = ttBean.getStarttime().toString();
                                estimatedStarttime = DynamicView.calcEstimatedStarttime(delayInMinutes, ttBean).toString();
                            }
                        } else if (ttBean.getStarttime().after(ttBeanOld.getEndtime())) {
                            delayInMillis = 0L;
                            delayInMinutes = 0L;
                            estimatedStarttime = scheduledStarttime = ttBean.getStarttime().toString();
                        } else if (ttBean.getType() == 5) {
                            delayInMillis = currentTime.after(ttBean.getEndtime()) ? DynamicView.calcDelay3(ttBean, currentTime) : 0L;
                            delayInMinutes = DTMUtill.msToMin(delayInMillis, true);
                            scheduledStarttime = "";
                            estimatedStarttime = "";
                        } else {
                            delayInMillis = DynamicView.calcDelay2(ttBean, currentTime);
                            delayInMinutes = DTMUtill.msToMin(delayInMillis, true);
                            scheduledStarttime = ttBean.getStarttime().toString();
                            estimatedStarttime = DynamicView.calcEstimatedStarttime(delayInMinutes, ttBean).toString();
                        }
                        firstBean = false;
                    } else {
                        HashMap<String, String> iterationResult = DynamicView.standardIterationProcess(delayInMinutes, ttBean, ttBeanOld);
                        try {
                            delayInMinutes = Long.parseLong(iterationResult.get("delay"));
                        }
                        catch (Exception e2) {
                            log.severe("Error when parsing a delay String to long.");
                            e2.printStackTrace();
                        }
                        estimatedStarttime = iterationResult.get("estimatedStarttime");
                        scheduledStarttime = ttBean.getStarttime().toString();
                    }
                    returnDynBean = DynamicView.generateDynBean(dynBean, ttBean, scheduledStarttime, estimatedStarttime, String.valueOf(delayInMinutes));
                    if (ttBean.getMatchnumber() > 0) {
                        returnDynBean.setIsmatchcallermatch(true);
                        returnDynBean.setMatchcallermatchid(ttBean.getMatchnumber());
                    }
                    list.add(returnDynBean);
                }
                return list;
            }
            catch (Exception e3) {
                e3.printStackTrace();
                return DynamicView.getCurrentScheduledItems(currentTime, dynBean, conn);
            }
        }
        log.info("ERROR: Received LastFinished-Bean '" + String.valueOf(dynBean.getLastFinishedCategory()) + "' not found in schedule!");
        return DynamicView.getCurrentScheduledItems(currentTime, dynBean, conn);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static ArrayList<DynamicCategoryBean> getScheduleStatusFromFilledBean(DynamicCategoryBean dynBean, TimetableBean matchingTimetableBean, Timestamp currentTime, Connection conn) {
        ArrayList<DynamicCategoryBean> list = new ArrayList<DynamicCategoryBean>();
        TimetableBean ttBean = null;
        TimetableBean ttBeanOld = null;
        DynamicCategoryBean returnDynBean = null;
        boolean matchingTimetableBeanFound = false;
        boolean firstBean = true;
        boolean inPause = false;
        boolean justShowSchedule = false;
        boolean customItemRunning = false;
        boolean firstTTBeanIsFinished = false;
        boolean lastFinishedAvailable = false;
        boolean partOfParentIsFinished = false;
        String estimatedStarttime = null;
        String scheduledStarttime = null;
        long delayInMillis = 0L;
        long delayInMinutes = 0L;
        long crossTime = 0L;
        if (matchingTimetableBean != null) {
            String statement = "select * from timetable tt where tt.vernr = " + matchingTimetableBean.getVernr() + " and tt.tatami = " + matchingTimetableBean.getTatami() + " and tt.starttime >= '" + String.valueOf(matchingTimetableBean.getStarttime()) + "' and tt.date = '" + String.valueOf(matchingTimetableBean.getDate()) + "' and tt.starttime != tt.endtime order by tt.starttime;";
            ResultSet rs = DynamicView.executeStatement(statement, conn);
            try {
                list = new ArrayList();
                while (rs.next()) {
                    ttBeanOld = ttBean;
                    ttBean = DTMUtil.generateTimetableBean(rs);
                    if (firstBean) {
                        delayInMillis = DynamicView.calcDelay1(dynBean, ttBean, currentTime);
                        delayInMinutes = DTMUtill.msToMin(delayInMillis, true);
                        scheduledStarttime = "";
                        estimatedStarttime = "";
                        firstBean = false;
                    } else {
                        HashMap<String, String> iterationResult = DynamicView.standardIterationProcess(delayInMinutes, ttBean, ttBeanOld);
                        try {
                            delayInMinutes = Long.parseLong(iterationResult.get("delay"));
                        }
                        catch (Exception e2) {
                            log.severe("Error when parsing a delay String to long.");
                            e2.printStackTrace();
                        }
                        estimatedStarttime = iterationResult.get("estimatedStarttime");
                        scheduledStarttime = ttBean.getStarttime().toString();
                    }
                    returnDynBean = DynamicView.generateDynBean(dynBean, ttBean, scheduledStarttime, estimatedStarttime, String.valueOf(delayInMinutes));
                    if (ttBean.getMatchnumber() > 0) {
                        returnDynBean.setIsmatchcallermatch(true);
                        returnDynBean.setMatchcallermatchid(ttBean.getMatchnumber());
                    }
                    list.add(returnDynBean);
                }
                return list;
            }
            catch (Exception e3) {
                e3.printStackTrace();
                return DynamicView.getCurrentScheduledItems(currentTime, dynBean, conn);
            }
        }
        log.info("ERROR: Received bean '" + String.valueOf(dynBean) + "' not found in schedule!");
        return DynamicView.getCurrentScheduledItems(currentTime, dynBean, conn);
    }

    private static ArrayList getCurrentScheduledItems(Timestamp currentTime, DynamicCategoryBean bean, Connection conn) {
        ArrayList<DynamicCategoryBean> list = new ArrayList<DynamicCategoryBean>();
        TimetableBean ttBean = null;
        TimetableBean ttBeanOld = null;
        DynamicCategoryBean dynBean = null;
        boolean firstBean = true;
        String estimatedStarttime = null;
        String scheduledStarttime = null;
        String statement = "select * from timetable where tatami = " + bean.getTatami() + " and vernr = " + bean.getVernr() + " and date = '" + String.valueOf(new Date(currentTime.getTime())) + "' and (starttime >= '" + String.valueOf(currentTime) + "' or endtime > '" + String.valueOf(currentTime) + "') and starttime != endtime order by starttime;";
        ResultSet rs = DynamicView.executeStatement(statement, conn);
        try {
            while (rs.next()) {
                ttBeanOld = ttBean;
                ttBean = DTMUtil.generateTimetableBean(rs);
                if (firstBean) {
                    if (currentTime.after(ttBean.getStarttime())) {
                        scheduledStarttime = "";
                        estimatedStarttime = "";
                    } else {
                        estimatedStarttime = scheduledStarttime = ttBean.getStarttime().toString();
                    }
                    firstBean = false;
                } else {
                    HashMap<String, String> iterationResult = DynamicView.standardIterationProcess(0L, ttBean, ttBeanOld);
                    estimatedStarttime = iterationResult.get("estimatedStarttime");
                    scheduledStarttime = ttBean.getStarttime().toString();
                }
                dynBean = DynamicView.generateDynBean(bean, ttBean, scheduledStarttime, estimatedStarttime, "0");
                if (ttBean.getMatchnumber() > 0) {
                    dynBean.setIsmatchcallermatch(true);
                    dynBean.setMatchcallermatchid(ttBean.getMatchnumber());
                }
                list.add(dynBean);
            }
        }
        catch (Exception e2) {
            log.severe("An error occured when trying to get the current event schedule!");
            e2.printStackTrace();
        }
        return list;
    }

    private static boolean categoryIsFinished(DynamicCategoryBean dynBean, TimetableBean ttBean) {
        if (dynBean == null) {
            return false;
        }
        return DTMUtill.matchesTimetableBean(dynBean, ttBean) && (dynBean.getType() == 4 || ttBean.getType() != 0);
    }

    private static HashMap<String, String> standardIterationProcess(long previousDelayInMinutes, TimetableBean ttBean, TimetableBean ttBeanOld) {
        HashMap<String, String> map = new HashMap<String, String>();
        long crossTime = 0L;
        long delayInMinutes = 0L;
        Timestamp estimatedStarttime = ttBean.getStarttime();
        if (previousDelayInMinutes != 0L) {
            if (ttBean.getStarttime().after(ttBeanOld.getEndtime())) {
                crossTime = DynamicView.calcCrossTime(previousDelayInMinutes, ttBeanOld, ttBean);
                if (crossTime != 0L) {
                    delayInMinutes = crossTime;
                    estimatedStarttime = DynamicView.calcEstimatedStarttime(delayInMinutes, ttBean);
                } else {
                    delayInMinutes = 0L;
                    estimatedStarttime = ttBean.getStarttime();
                }
            } else {
                delayInMinutes = previousDelayInMinutes;
                estimatedStarttime = DynamicView.calcEstimatedStarttime(delayInMinutes, ttBean);
            }
        } else {
            delayInMinutes = 0L;
            estimatedStarttime = ttBean.getStarttime();
        }
        map.put("delay", String.valueOf(delayInMinutes));
        map.put("estimatedStarttime", estimatedStarttime.toString());
        return map;
    }

    private static Timestamp calcEstimatedStarttime(long delayInMinutes, TimetableBean ttBean) {
        if (delayInMinutes != 0L) {
            return new Timestamp(ttBean.getStarttime().getTime() + delayInMinutes * 60000L);
        }
        return ttBean.getStarttime();
    }

    private static long calcDelay1(DynamicCategoryBean dynBean, TimetableBean ttBean, Timestamp currentTime) {
        long scheduledTimeLeft = 0L;
        long actualTimeLeft = 0L;
        long delay = 0L;
        scheduledTimeLeft = DTMUtill.timestampDiff(ttBean.getEndtime(), currentTime);
        actualTimeLeft = dynBean.getMatchesLeft() * ttBean.getFighttime() * 1000;
        delay = actualTimeLeft - scheduledTimeLeft;
        return delay;
    }

    private static long calcDelay2(TimetableBean ttBean, Timestamp currentTime) {
        return DTMUtill.timestampDiff(currentTime, ttBean.getStarttime());
    }

    private static long calcDelay3(TimetableBean ttBean, Timestamp currentTime) {
        return DTMUtill.timestampDiff(currentTime, ttBean.getEndtime());
    }

    private static long calcCrossTime(long delayInMinutes, TimetableBean ttBeanOld, TimetableBean ttBean) {
        if (delayInMinutes == 0L) {
            return 0L;
        }
        Timestamp delayedEndtime = new Timestamp(ttBeanOld.getEndtime().getTime() + delayInMinutes * 60000L);
        if (delayedEndtime.after(ttBean.getStarttime())) {
            return DTMUtill.msToMin(DTMUtill.timestampDiff(delayedEndtime, ttBean.getStarttime()), false);
        }
        return 0L;
    }

    private static DynamicCategoryBean generateDynBean(DynamicCategoryBean dynBean, TimetableBean ttBean, String scheduledStarttime, String estimatedStarttime, String delay) {
        return new DynamicCategoryBean(ttBean.getVernr(), ttBean.getKnr(), ttBean.getTatami(), ttBean.toString(), ttBean.getPool(), ttBean.getPools(), dynBean.getRepechageOnOneList(), ttBean.getType(), dynBean.getMatchesLeft(), dynBean.getTotalMatches(), dynBean.getLastFinishedCategory(), scheduledStarttime, estimatedStarttime, delay, dynBean.isEmptyBean(), dynBean.getMatchid(), dynBean.getClientmessage());
    }

    public static TimetableBean getMatchingTimetableBean(DynamicCategoryBean dynBean, Timestamp currentTime, Connection conn) {
        TimetableBean ttBean = null;
        String statement = "select * from timetable where vernr = " + dynBean.getVernr() + " and date = '" + String.valueOf(new Date(currentTime.getTime())) + "' and tatami = " + dynBean.getTatami() + " and knr = " + dynBean.getKnr() + " ORDER BY type DESC ";
        ResultSet rs = DynamicView.executeStatement(statement, conn);
        try {
            while (rs.next()) {
                ttBean = DTMUtil.generateTimetableBean(rs);
                if (!DynamicView.dynBeanMatchesTimetableBean(dynBean, ttBean)) continue;
                try {
                    rs.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return ttBean;
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        return null;
    }

    private static boolean partOfParentIsFinished(DynamicCategoryBean dynBean, TimetableBean ttBean) {
        if (ttBean.getType() != 0 || dynBean.getLastFinishedCategory() == null) {
            return false;
        }
        return ttBean.getKnr() == dynBean.getLastFinishedCategory().getKnr();
    }

    public static boolean dynBeanMatchesTimetableBean(DynamicCategoryBean dynBean, TimetableBean ttBean) {
        boolean ret = false;
        int dynBeanType = dynBean.getType();
        if (dynBean.getKnr() != ttBean.getKnr()) {
            return false;
        }
        if (ttBean.getType() == 0) {
            return true;
        }
        if (ttBean.getType() == 8) {
            if (ttBean.getMatchnumber() > 0) {
                String[] mess = dynBean.getClientmessage().split(";");
                C mcb = I.e(ttBean.getMatchnumber());
                boolean tabletypeok = false;
                if (!(dynBean.getType() != 1 && !mess[0].equals("Draw_Record_Action") || mcb.h() != 0 && mcb.h() != 1)) {
                    tabletypeok = true;
                }
                if (!(dynBean.getType() != 2 && !mess[0].equals("Pool_Winner_Action") || mcb.h() != 3 && mcb.h() != 4)) {
                    tabletypeok = true;
                }
                if ((dynBean.getType() == 3 || mess[0].equals("Repechage_Action")) && mcb.h() == 6) {
                    tabletypeok = true;
                }
                if ((dynBean.getType() == 7 || mess[0].equals("DoubleElimination_Action")) && mcb.h() == 5) {
                    tabletypeok = true;
                }
                if ((dynBean.getType() == 6 || mess[0].equals("Point_List_Action_Match_Finish") || mess[0].equals("Point_List_Action")) && mcb.h() == 7) {
                    tabletypeok = true;
                }
                int pool = 0;
                try {
                    int i2 = 0;
                    while (i2 < mess.length) {
                        if (mess[i2].equals("Pool")) {
                            pool = Integer.parseInt(mess[i2 + 1]);
                            break;
                        }
                        ++i2;
                    }
                }
                catch (NumberFormatException i2) {
                    // empty catch block
                }
                if (tabletypeok && pool > 0 && pool == mcb.c()) {
                    if (mcb.h() == 7) {
                        int i3 = 0;
                        while (i3 < mess.length) {
                            int fieldpos;
                            if (mess[i3].equals("Field") && (fieldpos = Integer.parseInt(mess[i3 + 1])) == mcb.d()) {
                                return true;
                            }
                            ++i3;
                        }
                        return false;
                    }
                    if (dynBean.getClientmessage().indexOf("Posold") > -1) {
                        int i4 = 0;
                        while (i4 < mess.length) {
                            block44: {
                                int fieldpos;
                                block45: {
                                    try {
                                        if (!mess[i4].equals("Posold")) break block44;
                                        fieldpos = Integer.parseInt(mess[i4 + 1]);
                                        if (mcb.h() == 0 || mcb.h() == 3) {
                                            fieldpos += 32;
                                        }
                                        if ((mcb.h() == 0 || mcb.h() == 3 || mcb.h() == 1 || mcb.h() == 4 || mcb.h() == 5) && fieldpos % 2 == 0) {
                                            --fieldpos;
                                        }
                                        if (mcb.h() == 6 && fieldpos % 2 == 1) {
                                            ++fieldpos;
                                        }
                                        if (fieldpos != mcb.e()) break block45;
                                        return true;
                                    }
                                    catch (NumberFormatException e2) {
                                        return false;
                                    }
                                }
                                if (mcb.h() == 0) {
                                    int numcomp;
                                    g catevent = h.a(mcb.b());
                                    f cat = new f();
                                    cat.b(mcb.b());
                                    if ((catevent.l() == 1 || catevent.l() == 2) && (numcomp = d.d(cat, pool)) > 4 && fieldpos - 32 == mcb.e()) {
                                        return true;
                                    }
                                }
                            }
                            ++i4;
                        }
                    }
                }
            }
            return false;
        }
        switch (dynBeanType) {
            case 1: {
                if (ttBean.getType() != 1) {
                    ret = false;
                    break;
                }
                if (ttBean.getPool() == dynBean.getPool()) {
                    ret = true;
                    break;
                }
                ret = false;
                break;
            }
            case 2: {
                if (ttBean.getType() != 2) {
                    ret = false;
                    break;
                }
                ret = true;
                break;
            }
            case 3: {
                if (ttBean.getType() != 3) {
                    ret = false;
                    break;
                }
                if (ttBean.getPool() == dynBean.getPool() || dynBean.getRepechageOnOneList() == 1) {
                    ret = true;
                    break;
                }
                ret = false;
                break;
            }
            case 4: {
                if (ttBean.getType() != 4) {
                    ret = false;
                    break;
                }
                ret = true;
                break;
            }
            case 6: {
                if (ttBean.getType() != 6) {
                    ret = false;
                    break;
                }
                if (ttBean.getPool() == dynBean.getPool()) {
                    ret = true;
                    break;
                }
                ret = false;
                break;
            }
            case 7: {
                ret = ttBean.getType() == 7;
            }
        }
        return ret;
    }

    private static ResultSet executeStatement(String stmt, Connection conn) {
        Statement st = null;
        ResultSet rs = null;
        try {
            st = conn.createStatement();
            rs = st.executeQuery(stmt);
            rs.beforeFirst();
            return rs;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }
}

