/*
 * Decompiled with CFR 0.152.
 */
package org.sportdata.set.extension.dtm.view;

import java.awt.Dimension;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableMap;
import javafx.fxml.FXML;
import javafx.scene.control.Label;
import javafx.scene.control.ListView;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.Separator;
import javafx.scene.control.Slider;
import javafx.scene.control.TitledPane;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.VBox;
import jfxtras.scene.control.LocalTimePicker;
import org.sportdata.set.an.q;
import org.sportdata.set.extension.dtm.beans.CategoryTreeBean;
import org.sportdata.set.extension.dtm.beans.DefaultBean;
import org.sportdata.set.extension.dtm.controller.DTMController;
import org.sportdata.set.extension.dtm.controller.DefaultsController;
import org.sportdata.set.extension.dtm.internal.ressource.DTMResource;
import org.sportdata.set.extension.dtm.view.EndOfDayCalculator;
import org.sportdata.set.g.v;
import org.sportdata.set.utils.f;

public class EndOfDayCalculatorController
extends DTMController {
    public EndOfDayCalculator view;
    public DefaultsController defaultsController;
    public ObservableMap<String, DefaultBean> defaults;
    @FXML
    private FlowPane flowPane;
    @FXML
    private VBox vBox;
    @FXML
    private Slider sliderAreas;
    @FXML
    private TitledPane titledPanePauses;
    @FXML
    private VBox vBoxCategories;
    @FXML
    private TitledPane titledPaneCategories;
    @FXML
    private Label labelEndOfDayTime;
    @FXML
    private TitledPane titledPaneMatchAreas;
    @FXML
    private Slider sliderPauses1;
    @FXML
    private Slider sliderPauses2;
    @FXML
    private Separator separator;
    @FXML
    private BorderPane borderPane;
    @FXML
    private Label labelEndOfDayTitle;
    @FXML
    private Label labelSelectedCategories;
    @FXML
    private Label labelSelectedCategoriesLabel;
    @FXML
    private Label labelPausesBetweenCats;
    @FXML
    private Label labelFullPauses;
    @FXML
    private ListView<CategoryTreeBean> listView;
    @FXML
    private LocalTimePicker localTimeStartTime;
    @FXML
    private TitledPane titledPaneStartTime;

    @FXML
    void initialize() {
        Dimension screenSize = f.c();
        this.borderPane.setPrefHeight((double)screenSize.height * 0.75);
        this.borderPane.setPrefWidth((double)screenSize.width * 0.33);
        this.titledPaneCategories.setText(DTMResource.getResourceString("calculator.title.categories"));
        this.titledPaneMatchAreas.setText(DTMResource.getResourceString("calculator.title.areas"));
        this.titledPanePauses.setText(DTMResource.getResourceString("calculator.title.pauses"));
        this.titledPaneStartTime.setText(DTMResource.getResourceString("calculator.title.starttime"));
        this.labelEndOfDayTitle.setText(DTMResource.getResourceString("calculator.label.endofday"));
        this.labelSelectedCategoriesLabel.setText(DTMResource.getResourceString("calculator.label.selectedcategories"));
        this.labelPausesBetweenCats.setText(DTMResource.getResourceString("calculator.label.pausesbetween"));
        this.labelFullPauses.setText(DTMResource.getResourceString("calculator.label.fullpauses"));
        this.listView.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.listView.getSelectionModel().getSelectedItems().addListener((ListChangeListener)new ListChangeListener<CategoryTreeBean>(){

            public void onChanged(ListChangeListener.Change<? extends CategoryTreeBean> c2) {
                EndOfDayCalculatorController.this.labelSelectedCategories.setText(String.valueOf(EndOfDayCalculatorController.this.listView.getSelectionModel().getSelectedItems().size()));
                EndOfDayCalculatorController.this.calculateEndOfDayTime();
            }
        });
        this.localTimeStartTime.setLocalTime(this.localTimeStartTime.getLocalTime().withHour(0).withMinute(0).withSecond(0));
        this.localTimeStartTime.localTimeProperty().addListener((ChangeListener)new ChangeListener<LocalTime>(){

            public void changed(ObservableValue<? extends LocalTime> observable, LocalTime oldValue, LocalTime newValue) {
                EndOfDayCalculatorController.this.calculateEndOfDayTime();
            }
        });
        this.sliderAreas.valueProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                EndOfDayCalculatorController.this.calculateEndOfDayTime();
            }
        });
        this.sliderPauses1.valueProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                EndOfDayCalculatorController.this.calculateEndOfDayTime();
            }
        });
        this.sliderPauses2.valueProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                EndOfDayCalculatorController.this.calculateEndOfDayTime();
            }
        });
    }

    public void loadMatchtimeDefaults() {
        this.defaultsController = new DefaultsController();
        this.defaultsController.connectDB(q.h());
        this.defaults = this.defaultsController.getFighttimeDefaults(v.a().k());
    }

    public void setupCategoryList(ArrayList<CategoryTreeBean> data1) {
        if (data1 != null) {
            for (CategoryTreeBean i2 : data1) {
                if (i2.getType() != 0) continue;
                this.listView.getItems().add((Object)i2);
            }
        }
    }

    private void calculateEndOfDayTime() {
        LocalTime startTime = this.localTimeStartTime.getLocalTime();
        int maxSeconds = (int)(86400L - startTime.toNanoOfDay() / 1000000000L);
        long matchesDuration = this.calculateCategoryDuration();
        long durationPerArea = (long)((double)matchesDuration / this.sliderAreas.getValue() + this.sliderPauses1.getValue() * 3600.0);
        LocalTime endOfDayTime = startTime.plusSeconds(durationPerArea);
        if (durationPerArea < (long)maxSeconds) {
            this.labelEndOfDayTime.setText(endOfDayTime.format(DateTimeFormatter.ofPattern("HH:mm")));
        } else {
            this.labelEndOfDayTime.setText(DTMResource.getResourceString("calculator.aftermidnight") + " (" + endOfDayTime.format(DateTimeFormatter.ofPattern("HH:mm")) + ")");
        }
    }

    private long calculateCategoryDuration() {
        long dur = 0L;
        for (CategoryTreeBean ctb : this.listView.getSelectionModel().getSelectedItems()) {
            int fighttime = this.defaultsController.findFighttimeForCategoryTreeBean(this.defaults, ctb);
            dur = (long)((double)dur + ((double)(fighttime * ctb.getMatches()) + (double)ctb.getPools() * this.sliderPauses2.getValue() * 60.0));
        }
        return dur;
    }

    public EndOfDayCalculator getView() {
        return this.view;
    }

    public void setView(EndOfDayCalculator view) {
        this.view = view;
    }

    public DefaultsController getDefaultsController() {
        return this.defaultsController;
    }

    public void setDefaultsController(DefaultsController controller) {
        this.defaultsController = controller;
    }

    public ObservableMap<String, DefaultBean> getDefaults() {
        return this.defaults;
    }

    public void setDefaults(ObservableMap<String, DefaultBean> defaults) {
        this.defaults = defaults;
    }
}

