/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.formula.function.datetime;

import java.math.BigDecimal;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import org.pentaho.reporting.libraries.formula.EvaluationException;
import org.pentaho.reporting.libraries.formula.FormulaContext;
import org.pentaho.reporting.libraries.formula.LibFormulaErrorValue;
import org.pentaho.reporting.libraries.formula.LocalizationContext;
import org.pentaho.reporting.libraries.formula.function.Function;
import org.pentaho.reporting.libraries.formula.function.ParameterCallback;
import org.pentaho.reporting.libraries.formula.lvalues.TypeValuePair;
import org.pentaho.reporting.libraries.formula.typing.TypeRegistry;
import org.pentaho.reporting.libraries.formula.typing.coretypes.NumberType;
import org.pentaho.reporting.libraries.formula.util.NumberUtil;

public class DateDifFunction
implements Function {
    public static final String YEARS_CODE = "y";
    public static final String MONTHS_CODE = "m";
    public static final String DAYS_CODE = "d";
    public static final String DAYS_IGNORING_YEARS = "yd";
    public static final String MONTHS_IGNORING_YEARS = "ym";
    public static final String DAYS_IGNORING_MONTHS_YEARS = "md";
    private static final long serialVersionUID = 81013707499607068L;

    @Override
    public String getCanonicalName() {
        return "DATEDIF";
    }

    @Override
    public TypeValuePair evaluate(FormulaContext context, ParameterCallback parameters) throws EvaluationException {
        if (parameters.getParameterCount() != 3) {
            throw EvaluationException.getInstance(LibFormulaErrorValue.ERROR_ARGUMENTS_VALUE);
        }
        TypeRegistry typeRegistry = context.getTypeRegistry();
        String formatCode = typeRegistry.convertToText(parameters.getType(2), parameters.getValue(2));
        if (formatCode == null || "".equals(formatCode)) {
            throw EvaluationException.getInstance(LibFormulaErrorValue.ERROR_INVALID_ARGUMENT_VALUE);
        }
        long days = this.computeDays(parameters, typeRegistry);
        if (DAYS_CODE.equals(formatCode)) {
            return new TypeValuePair(NumberType.GENERIC_NUMBER, new BigDecimal(days));
        }
        Date date1 = typeRegistry.convertToDate(parameters.getType(0), parameters.getValue(0));
        Date date2 = typeRegistry.convertToDate(parameters.getType(1), parameters.getValue(1));
        if (date1 == null || date2 == null) {
            throw EvaluationException.getInstance(LibFormulaErrorValue.ERROR_INVALID_ARGUMENT_VALUE);
        }
        LocalizationContext localizationContext = context.getLocalizationContext();
        TimeZone timeZone = localizationContext.getTimeZone();
        Locale locale = localizationContext.getLocale();
        GregorianCalendar calandar1 = new GregorianCalendar(timeZone, locale);
        calandar1.setTime(this.min(date1, date2));
        GregorianCalendar calandar2 = new GregorianCalendar(timeZone, locale);
        calandar2.setTime(this.max(date1, date2));
        int sign = date1.getTime() < date2.getTime() ? 1 : -1;
        long res = (long)sign * this.computeDateDifference(formatCode, calandar1, calandar2, days);
        return new TypeValuePair(NumberType.GENERIC_NUMBER, new BigDecimal(res));
    }

    protected long computeDays(ParameterCallback parameters, TypeRegistry typeRegistry) throws EvaluationException {
        Number date1 = typeRegistry.convertToNumber(parameters.getType(0), parameters.getValue(0));
        Number date2 = typeRegistry.convertToNumber(parameters.getType(1), parameters.getValue(1));
        BigDecimal dn1 = NumberUtil.performIntRounding(NumberUtil.getAsBigDecimal(date1));
        BigDecimal dn2 = NumberUtil.performIntRounding(NumberUtil.getAsBigDecimal(date2));
        return dn2.longValue() - dn1.longValue();
    }

    protected long computeDateDifference(String formatCode, GregorianCalendar min, GregorianCalendar max, long days) throws EvaluationException {
        if (YEARS_CODE.equals(formatCode)) {
            return this.computeYears(min, max);
        }
        if (MONTHS_CODE.equals(formatCode)) {
            return this.computeMonths(min, max);
        }
        if (DAYS_IGNORING_MONTHS_YEARS.equals(formatCode)) {
            return this.computeMonthDays(min, max);
        }
        if (MONTHS_IGNORING_YEARS.equals(formatCode)) {
            return this.computeYearMonth(min, max);
        }
        if (DAYS_IGNORING_YEARS.equals(formatCode)) {
            return this.computeYearDays(min, max, days);
        }
        throw EvaluationException.getInstance(LibFormulaErrorValue.ERROR_INVALID_ARGUMENT_VALUE);
    }

    private long computeYearDays(GregorianCalendar min, GregorianCalendar max, long dayDiff) {
        int dayMaxDate;
        int year2;
        int year1 = min.get(1);
        if (year1 == (year2 = max.get(1))) {
            return Math.abs(dayDiff);
        }
        int dayMinDate = min.get(6);
        if (dayMinDate <= (dayMaxDate = max.get(6))) {
            return dayMaxDate - dayMinDate;
        }
        int daysInMinYear = min.getActualMaximum(6);
        int daysToEndOfYear = daysInMinYear - dayMinDate;
        return dayMaxDate + daysToEndOfYear;
    }

    private long computeYearMonth(GregorianCalendar min, GregorianCalendar max) {
        return this.computeMonths(min, max) % 12L;
    }

    private long computeMonthDays(GregorianCalendar min, GregorianCalendar max) {
        int dayMax;
        int dayMin = min.get(5);
        if (dayMin <= (dayMax = max.get(5))) {
            return dayMax - dayMin;
        }
        int maxDaysInMonth = max.getActualMaximum(5);
        return maxDaysInMonth + dayMax - dayMin;
    }

    private int addFieldLoop(GregorianCalendar c, GregorianCalendar target, int field) {
        c.set(14, 0);
        c.set(13, 0);
        c.set(12, 0);
        c.set(11, 0);
        target.set(14, 0);
        target.set(13, 0);
        target.set(12, 0);
        target.set(11, 0);
        if (c.getTimeInMillis() == target.getTimeInMillis()) {
            return 0;
        }
        int count = 0;
        while (true) {
            c.add(field, 1);
            if (c.getTimeInMillis() > target.getTimeInMillis()) {
                return count;
            }
            ++count;
        }
    }

    private long computeMonths(GregorianCalendar min, GregorianCalendar max) {
        return this.addFieldLoop(min, max, 2);
    }

    private long computeYears(GregorianCalendar min, GregorianCalendar max) {
        return this.addFieldLoop(min, max, 1);
    }

    private Date min(Date d1, Date d2) {
        if (d1.getTime() < d2.getTime()) {
            return d1;
        }
        return d2;
    }

    private Date max(Date d1, Date d2) {
        if (d1.getTime() >= d2.getTime()) {
            return d1;
        }
        return d2;
    }
}

