/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.extensions.modules.rhino;

import java.net.URL;
import org.pentaho.reporting.engine.classic.core.metadata.ExpressionRegistry;
import org.pentaho.reporting.libraries.base.boot.AbstractModule;
import org.pentaho.reporting.libraries.base.boot.ModuleInitializeException;
import org.pentaho.reporting.libraries.base.boot.SubSystem;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;

public class RhinoModule
extends AbstractModule {
    public RhinoModule() throws ModuleInitializeException {
        this.loadModuleInfo();
    }

    public void initialize(SubSystem subSystem) throws ModuleInitializeException {
        try {
            ClassLoader loader = ObjectUtilities.getClassLoader(((Object)((Object)this)).getClass());
            Class.forName("org.mozilla.javascript.Context", false, loader);
        }
        catch (Exception e) {
            throw new ModuleInitializeException("Unable to load the Rhino scripting framework class. This class is required to execute the RhinoExpressions.");
        }
        URL expressionMetaSource = ObjectUtilities.getResource((String)"org/pentaho/reporting/engine/classic/extensions/modules/rhino/meta-expressions.xml", RhinoModule.class);
        if (expressionMetaSource == null) {
            throw new ModuleInitializeException("Error: Could not find the expression meta-data description file");
        }
        try {
            ExpressionRegistry.getInstance().registerFromXml(expressionMetaSource);
        }
        catch (Exception e) {
            throw new ModuleInitializeException("Error: Could not parse the element meta-data description file", (Throwable)e);
        }
    }
}

