/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.beans.actions.desktop;

import com.install4j.api.Util;
import com.install4j.api.context.Context;
import com.install4j.api.context.InstallerContext;
import com.install4j.api.context.UninstallerContext;
import com.install4j.api.context.UserCanceledException;
import com.install4j.api.windows.RegistryRoot;
import com.install4j.runtime.beans.actions.desktop.AbstractAssociationAction;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.Logger;
import com.install4j.runtime.installer.helper.comm.ExecutionContext;
import com.install4j.runtime.installer.helper.comm.HelperCommunication;
import com.install4j.runtime.installer.helper.comm.actions.RunAction;
import com.install4j.runtime.installer.platform.macos.MacFileSystem;
import com.install4j.runtime.installer.platform.win32.Win32UrlHandler;
import java.io.File;
import java.io.IOException;
import java.util.Objects;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;

public class UrlHandlerAction
extends AbstractAssociationAction {
    private static final String PROP_SCHEME = "extension";
    private String scheme = "";

    public String getScheme() {
        return UrlHandlerAction.replaceVariables(UrlHandlerAction.replaceVariables(this.scheme));
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    @Override
    public boolean install(InstallerContext context) throws UserCanceledException {
        String scheme = this.getUsedScheme();
        if (scheme.trim().isEmpty() || scheme.contains(" ")) {
            Util.logError(this, "invalid scheme: '" + scheme + "'");
            return false;
        }
        try {
            if (InstallerUtil.isWindows()) {
                return this.installWindows(context);
            }
            if (!Util.isWindows() && !Util.isMacOS()) {
                return this.installUnix(context);
            }
            Util.logInfo(this, "Nothing to do");
        }
        catch (Exception e) {
            Util.log(e);
            return false;
        }
        return true;
    }

    private static void setDefaultHandler(final String scheme, final String bundleIdentifier) {
        if (scheme != null && bundleIdentifier != null) {
            HelperCommunication.getInstance().executeAction(ExecutionContext.UNELEVATED, new RunAction(){

                @Override
                protected void run(Context context) throws Exception {
                    MacFileSystem.setDefaultHandlerForURLScheme(scheme, bundleIdentifier);
                }
            });
        }
    }

    private boolean installWindows(InstallerContext context) throws UserCanceledException {
        File executable = this.getExecutableFile(context);
        if (executable == null || !executable.exists()) {
            Util.logError(this, "executable does not exist: " + executable);
            return false;
        }
        this.addRollbackActions(Win32UrlHandler.create(this.getUsedScheme(), executable));
        Properties persistentProperties = this.getPersistentProperties();
        persistentProperties.setProperty(PROP_SCHEME, this.getUsedScheme());
        persistentProperties.setProperty("executable", executable.getAbsolutePath());
        return true;
    }

    @NotNull
    public String getUsedScheme() {
        String usedScheme = this.getScheme();
        if (usedScheme.endsWith(":")) {
            usedScheme = usedScheme.substring(0, usedScheme.length() - 1);
        }
        return usedScheme;
    }

    @Override
    public boolean uninstall(UninstallerContext context) throws UserCanceledException {
        try {
            if (InstallerUtil.isWindows()) {
                Properties persistentProperties = this.getPersistentProperties();
                String scheme = persistentProperties.getProperty(PROP_SCHEME);
                String executablePath = persistentProperties.getProperty("executable");
                if (scheme == null || executablePath == null) {
                    return true;
                }
                File executable = new File(executablePath).getCanonicalFile();
                this.remove(scheme, RegistryRoot.HKEY_CURRENT_USER, executable);
                this.remove(scheme, RegistryRoot.HKEY_CLASSES_ROOT, executable);
            }
        }
        catch (Throwable e) {
            Util.log(e);
        }
        return true;
    }

    private void remove(String scheme, RegistryRoot root, File executable) throws IOException {
        String registeredExecutableName = Win32UrlHandler.getExecutable(scheme, root);
        if (registeredExecutableName != null && Objects.equals(new File(registeredExecutableName).getCanonicalFile(), executable)) {
            Win32UrlHandler.remove(scheme, root);
        }
    }

    private boolean executeForDesktopFile(File desktopFile) throws IOException, UserCanceledException {
        return UrlHandlerAction.addMimeTypeToDesktopFile(desktopFile, "x-scheme-handler/" + this.getUsedScheme());
    }

    private boolean installUnix(InstallerContext context) throws IOException, UserCanceledException {
        File executable = this.getExecutableFile(context);
        if (executable == null || !executable.isFile()) {
            Util.logError(this, "executable does not exist: " + executable);
            return false;
        }
        AbstractAssociationAction.UnixAssociationInfo associationInfo = UrlHandlerAction.getUnixAssociationInfo(executable);
        boolean success = true;
        boolean executedAtLeastOnce = false;
        Logger.getInstance().info(this, "existing desktop files: " + associationInfo.getDesktopFiles());
        for (File desktopFile : associationInfo.getDesktopFiles()) {
            if (!desktopFile.isFile()) continue;
            executedAtLeastOnce = true;
            if (this.executeForDesktopFile(desktopFile)) continue;
            success = false;
        }
        associationInfo.addAction(this, executedAtLeastOnce, this::executeForDesktopFile);
        return success;
    }
}

