/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.helper.content;

import com.install4j.runtime.installer.frontend.GUIHelper;
import com.install4j.runtime.installer.helper.comm.HelperCommunication;
import com.install4j.runtime.installer.helper.content.AbstractHttpConnectionWrapper;
import com.install4j.runtime.installer.helper.content.HttpAuthenticator;
import com.install4j.runtime.installer.helper.content.HttpRequestHandler;
import com.install4j.runtime.installer.helper.content.UserNameAndPassword;
import com.install4j.runtime.installer.platform.win32.WinGuiHelper;
import com.install4j.runtime.installer.platform.win32.wininet.IgnoreCaseString;
import com.install4j.runtime.installer.platform.win32.wininet.WinInet;
import com.install4j.runtime.installer.platform.win32.wininet.WinInetAuthenticator;
import com.install4j.runtime.installer.platform.win32.wininet.WinInetCall;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

public class WinInetCallWrapper
extends AbstractHttpConnectionWrapper {
    private static volatile UserNameAndPassword lastProxyCredentials;
    private static Map<SchemeAndHost, UserNameAndPassword> lastServerCredentials;
    private int mode;
    private boolean followRedirects = true;
    private WinInetCall winInetCall;
    private static volatile WinInet.ProxyConfig proxyConfig;

    public static void setProxyConfig(WinInet.ProxyConfig proxyConfig) {
        WinInetCallWrapper.proxyConfig = proxyConfig;
    }

    public WinInetCallWrapper(URL url, boolean acceptAllCertificates, int mode) {
        super(url, acceptAllCertificates);
        this.mode = mode;
    }

    @Override
    public void connect() throws IOException {
        if (this.winInetCall != null) {
            return;
        }
        String userAgent = this.getRequestHeader("User-Agent", HttpRequestHandler.DEFAULT_USER_AGENT);
        HashMap<IgnoreCaseString, List<String>> usedRequestHeaders = new HashMap<IgnoreCaseString, List<String>>(this.getRequestHeaders().size());
        IgnoreCaseString userAgentKeyName = new IgnoreCaseString("User-Agent");
        for (Map.Entry<IgnoreCaseString, List<String>> entry : this.getRequestHeaders().entrySet()) {
            if (entry.getKey().equals(userAgentKeyName)) continue;
            usedRequestHeaders.put(entry.getKey(), new ArrayList(entry.getValue()));
        }
        WinInetAuthenticator authenticator = this.createAuthenticator(new SchemeAndHost(this.getURL().getProtocol(), this.getURL().getHost()));
        this.winInetCall = WinInet.open(userAgent, this.getURL().toExternalForm(), usedRequestHeaders, this.getRequestMethod(), this.getPostContentLength(), this.isAcceptAllCertificates(), this.getConnectTimeout(), this.getReadTimeout(), this.followRedirects, proxyConfig, authenticator);
    }

    @NotNull
    private WinInetAuthenticator createAuthenticator(SchemeAndHost schemeAndHost) {
        long hwnd = 0L;
        if (this.mode == 1 && !HelperCommunication.getInstance().isElevatedHelper()) {
            hwnd = WinGuiHelper.getHwnd(GUIHelper.getParentWindow());
        }
        WinInetAuthenticator authenticator = new WinInetAuthenticator(hwnd);
        this.setProxySupplier(authenticator);
        this.setServerSupplier(authenticator, schemeAndHost);
        return authenticator;
    }

    private void setProxySupplier(WinInetAuthenticator authenticator) {
        String proxyUser = System.getProperty("proxyAuthUser");
        String proxyPassword = System.getProperty("proxyAuthPassword");
        if (proxyUser != null && !proxyUser.isEmpty() && proxyPassword != null) {
            authenticator.setProxySupplier(() -> new PasswordAuthentication(proxyUser, proxyPassword.toCharArray()));
        } else if (this.mode == 2) {
            authenticator.setProxySupplier(new Supplier<PasswordAuthentication>(){
                boolean first = true;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public PasswordAuthentication get() {
                    try {
                        String password;
                        String user = lastProxyCredentials != null ? lastProxyCredentials.userName : null;
                        String string = password = lastProxyCredentials != null ? lastProxyCredentials.password : null;
                        if (this.first && user != null && password != null) {
                            PasswordAuthentication passwordAuthentication = new PasswordAuthentication(user, password.toCharArray());
                            return passwordAuthentication;
                        }
                        UserNameAndPassword userNameAndPassword = HttpAuthenticator.askForCredentialsConsole(HttpAuthenticator.AuthenticationType.PROXY, null);
                        lastProxyCredentials = userNameAndPassword;
                        PasswordAuthentication passwordAuthentication = userNameAndPassword.toPasswordAuthentication();
                        return passwordAuthentication;
                    }
                    finally {
                        this.first = false;
                    }
                }
            });
        } else if (this.mode == 3) {
            authenticator.setProxySupplier(() -> null);
        }
    }

    private void setServerSupplier(WinInetAuthenticator authenticator, final SchemeAndHost schemeAndHost) {
        String serverUser = System.getProperty("serverAuthUser");
        String serverPassword = System.getProperty("serverAuthPassword");
        if (serverUser != null && !serverUser.isEmpty() && serverPassword != null) {
            authenticator.setServerSupplier(() -> new PasswordAuthentication(serverUser, serverPassword.toCharArray()));
        } else if (this.mode == 2) {
            authenticator.setServerSupplier(new Supplier<PasswordAuthentication>(){
                boolean first = true;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public PasswordAuthentication get() {
                    try {
                        String password;
                        UserNameAndPassword lastCredentials = (UserNameAndPassword)lastServerCredentials.get(schemeAndHost);
                        String user = lastCredentials != null ? lastCredentials.userName : null;
                        String string = password = lastCredentials != null ? lastCredentials.password : null;
                        if (this.first && user != null && password != null) {
                            PasswordAuthentication passwordAuthentication = new PasswordAuthentication(user, password.toCharArray());
                            return passwordAuthentication;
                        }
                        UserNameAndPassword userNameAndPassword = HttpAuthenticator.askForCredentialsConsole(HttpAuthenticator.AuthenticationType.SERVER, schemeAndHost.host);
                        lastServerCredentials.put(schemeAndHost, userNameAndPassword);
                        PasswordAuthentication passwordAuthentication = userNameAndPassword.toPasswordAuthentication();
                        return passwordAuthentication;
                    }
                    finally {
                        this.first = false;
                    }
                }
            });
        } else if (this.mode == 3) {
            authenticator.setServerSupplier(() -> null);
        }
    }

    @Override
    public InputStream getInputStream() throws IOException {
        this.checkConnectedAndFound();
        return this.winInetCall.getInputStream();
    }

    @Override
    public InputStream getErrorStream() throws IOException {
        this.checkConnected();
        return this.winInetCall.getInputStream();
    }

    @Override
    public int getResponseCode() throws IOException {
        this.checkConnected();
        return this.winInetCall.getResponseCode();
    }

    @Override
    public Map<String, List<String>> getHeaderFields() {
        this.checkConnected();
        return this.winInetCall.getAllHeaders();
    }

    @Override
    public String getHeaderField(String key) {
        return this.winInetCall.getLastHeader(key);
    }

    @Override
    public void setFollowRedirects(boolean value) {
        this.followRedirects = value;
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        if (this.winInetCall == null) {
            this.connect();
        }
        return this.winInetCall.getOutputStream();
    }

    @Override
    protected int getConnectTimeout() {
        return this.replaceDefaultTimeout(super.getConnectTimeout());
    }

    @Override
    protected int getReadTimeout() {
        return this.replaceDefaultTimeout(super.getReadTimeout());
    }

    private int replaceDefaultTimeout(int timeout) {
        if (timeout <= 0) {
            return -2;
        }
        return timeout;
    }

    @Override
    public void close() {
        WinInetCall winInetCall = this.winInetCall;
        if (winInetCall != null) {
            winInetCall.close();
        }
    }

    private String getRequestHeader(String key, String defaultValue) {
        List<String> values = this.getRequestHeaders().get(new IgnoreCaseString(key));
        if (values != null && values.size() > 0) {
            return values.get(0);
        }
        return defaultValue;
    }

    @Override
    protected void checkConnected() {
        if (this.winInetCall == null) {
            throw new IllegalStateException();
        }
    }

    static {
        lastServerCredentials = Collections.synchronizedMap(new HashMap());
        proxyConfig = null;
    }

    public static class SchemeAndHost
    implements Serializable {
        private final String scheme;
        private final String host;

        public SchemeAndHost(String scheme, String host) {
            this.scheme = scheme;
            this.host = host;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SchemeAndHost that = (SchemeAndHost)o;
            if (!Objects.equals(this.scheme, that.scheme)) {
                return false;
            }
            return Objects.equals(this.host, that.host);
        }

        public int hashCode() {
            int result = this.scheme != null ? this.scheme.hashCode() : 0;
            result = 31 * result + (this.host != null ? this.host.hashCode() : 0);
            return result;
        }
    }
}

