/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http2.hpack;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.HttpScheme;
import org.eclipse.jetty.http2.hpack.Huffman;
import org.eclipse.jetty.http2.hpack.NBitInteger;
import org.eclipse.jetty.http2.hpack.StaticTableHttpField;
import org.eclipse.jetty.util.ArrayQueue;
import org.eclipse.jetty.util.ArrayTernaryTrie;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.Trie;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class HpackContext {
    public static final Logger LOG = Log.getLogger(HpackContext.class);
    public static final String[][] STATIC_TABLE = new String[][]{{null, null}, {":authority", null}, {":method", "GET"}, {":method", "POST"}, {":path", "/"}, {":path", "/index.html"}, {":scheme", "http"}, {":scheme", "https"}, {":status", "200"}, {":status", "204"}, {":status", "206"}, {":status", "304"}, {":status", "400"}, {":status", "404"}, {":status", "500"}, {"accept-charset", null}, {"accept-encoding", "gzip, deflate"}, {"accept-language", null}, {"accept-ranges", null}, {"accept", null}, {"access-control-allow-origin", null}, {"age", null}, {"allow", null}, {"authorization", null}, {"cache-control", null}, {"content-disposition", null}, {"content-encoding", null}, {"content-language", null}, {"content-length", null}, {"content-location", null}, {"content-range", null}, {"content-type", null}, {"cookie", null}, {"date", null}, {"etag", null}, {"expect", null}, {"expires", null}, {"from", null}, {"host", null}, {"if-match", null}, {"if-modified-since", null}, {"if-none-match", null}, {"if-range", null}, {"if-unmodified-since", null}, {"last-modified", null}, {"link", null}, {"location", null}, {"max-forwards", null}, {"proxy-authenticate", null}, {"proxy-authorization", null}, {"range", null}, {"referer", null}, {"refresh", null}, {"retry-after", null}, {"server", null}, {"set-cookie", null}, {"strict-transport-security", null}, {"transfer-encoding", null}, {"user-agent", null}, {"vary", null}, {"via", null}, {"www-authenticate", null}};
    private static final Map<HttpField, Entry> __staticFieldMap = new HashMap<HttpField, Entry>();
    private static final Trie<StaticEntry> __staticNameMap = new ArrayTernaryTrie<StaticEntry>(true, 512);
    private static final StaticEntry[] __staticTableByHeader = new StaticEntry[HttpHeader.UNKNOWN.ordinal()];
    private static final StaticEntry[] __staticTable = new StaticEntry[STATIC_TABLE.length];
    private int _maxDynamicTableSizeInBytes;
    private int _dynamicTableSizeInBytes;
    private final DynamicTable _dynamicTable;
    private final Map<HttpField, Entry> _fieldMap = new HashMap<HttpField, Entry>();
    private final Map<String, Entry> _nameMap = new HashMap<String, Entry>();

    HpackContext(int maxDynamicTableSize) {
        this._maxDynamicTableSizeInBytes = maxDynamicTableSize;
        int guesstimateEntries = 10 + maxDynamicTableSize / 52;
        this._dynamicTable = new DynamicTable(guesstimateEntries, guesstimateEntries + 10);
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("HdrTbl[%x] created max=%d", this.hashCode(), maxDynamicTableSize), new Object[0]);
        }
    }

    public void resize(int newMaxDynamicTableSize) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("HdrTbl[%x] resized max=%d->%d", this.hashCode(), this._maxDynamicTableSizeInBytes, newMaxDynamicTableSize), new Object[0]);
        }
        this._maxDynamicTableSizeInBytes = newMaxDynamicTableSize;
        int guesstimateEntries = 10 + newMaxDynamicTableSize / 52;
        this.evict();
        this._dynamicTable.resizeUnsafe(guesstimateEntries);
    }

    public Entry get(HttpField field) {
        Entry entry = this._fieldMap.get(field);
        if (entry == null) {
            entry = __staticFieldMap.get(field);
        }
        return entry;
    }

    public Entry get(String name) {
        Entry entry = __staticNameMap.get(name);
        if (entry != null) {
            return entry;
        }
        return this._nameMap.get(StringUtil.asciiToLowerCase(name));
    }

    public Entry get(int index) {
        if (index < __staticTable.length) {
            return __staticTable[index];
        }
        int d = this._dynamicTable.size() - index + __staticTable.length - 1;
        if (d >= 0) {
            return (Entry)this._dynamicTable.getUnsafe(d);
        }
        return null;
    }

    public Entry get(HttpHeader header) {
        StaticEntry e = __staticTableByHeader[header.ordinal()];
        if (e == null) {
            return this.get(header.asString());
        }
        return e;
    }

    public static Entry getStatic(HttpHeader header) {
        return __staticTableByHeader[header.ordinal()];
    }

    public Entry add(HttpField field) {
        int slot = this._dynamicTable.getNextSlotUnsafe();
        Entry entry = new Entry(slot, field);
        int size = entry.getSize();
        if (size > this._maxDynamicTableSizeInBytes) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("HdrTbl[%x] !added size %d>%d", this.hashCode(), size, this._maxDynamicTableSizeInBytes), new Object[0]);
            }
            return null;
        }
        this._dynamicTableSizeInBytes += size;
        this._dynamicTable.addUnsafe(entry);
        this._fieldMap.put(field, entry);
        this._nameMap.put(StringUtil.asciiToLowerCase(field.getName()), entry);
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("HdrTbl[%x] added %s", this.hashCode(), entry), new Object[0]);
        }
        this.evict();
        return entry;
    }

    public int size() {
        return this._dynamicTable.size();
    }

    public int getDynamicTableSize() {
        return this._dynamicTableSizeInBytes;
    }

    public int getMaxDynamicTableSize() {
        return this._maxDynamicTableSizeInBytes;
    }

    public int index(Entry entry) {
        if (entry._slot < 0) {
            return 0;
        }
        if (entry.isStatic()) {
            return entry._slot;
        }
        return this._dynamicTable.index(entry) + __staticTable.length - 1;
    }

    public static int staticIndex(HttpHeader header) {
        if (header == null) {
            return 0;
        }
        Entry entry = __staticNameMap.get(header.asString());
        if (entry == null) {
            return 0;
        }
        return entry.getSlot();
    }

    private void evict() {
        while (this._dynamicTableSizeInBytes > this._maxDynamicTableSizeInBytes) {
            Entry entry = (Entry)this._dynamicTable.pollUnsafe();
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("HdrTbl[%x] evict %s", this.hashCode(), entry), new Object[0]);
            }
            this._dynamicTableSizeInBytes -= entry.getSize();
            entry._slot = -1;
            this._fieldMap.remove(entry.getHttpField());
            String lc = StringUtil.asciiToLowerCase(entry.getHttpField().getName());
            if (entry != this._nameMap.get(lc)) continue;
            this._nameMap.remove(lc);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("HdrTbl[%x] entries=%d, size=%d, max=%d", this.hashCode(), this._dynamicTable.size(), this._dynamicTableSizeInBytes, this._maxDynamicTableSizeInBytes), new Object[0]);
        }
    }

    public String toString() {
        return String.format("HpackContext@%x{entries=%d,size=%d,max=%d}", this.hashCode(), this._dynamicTable.size(), this._dynamicTableSizeInBytes, this._maxDynamicTableSizeInBytes);
    }

    static {
        HashSet<String> added = new HashSet<String>();
        for (int i = 1; i < STATIC_TABLE.length; ++i) {
            StaticEntry entry = null;
            String name = STATIC_TABLE[i][0];
            String value = STATIC_TABLE[i][1];
            HttpHeader header = HttpHeader.CACHE.get(name);
            if (header != null && value != null) {
                switch (header) {
                    case C_METHOD: {
                        HttpMethod method = HttpMethod.CACHE.get(value);
                        if (method == null) break;
                        entry = new StaticEntry(i, new StaticTableHttpField(header, name, value, (Object)method));
                        break;
                    }
                    case C_SCHEME: {
                        HttpScheme scheme = HttpScheme.CACHE.get(value);
                        if (scheme == null) break;
                        entry = new StaticEntry(i, new StaticTableHttpField(header, name, value, (Object)scheme));
                        break;
                    }
                    case C_STATUS: {
                        entry = new StaticEntry(i, new StaticTableHttpField(header, name, value, Integer.valueOf(value)));
                        break;
                    }
                }
            }
            if (entry == null) {
                entry = new StaticEntry(i, header == null ? new HttpField(STATIC_TABLE[i][0], value) : new HttpField(header, name, value));
            }
            HpackContext.__staticTable[i] = entry;
            if (entry._field.getValue() != null) {
                __staticFieldMap.put(entry._field, entry);
            }
            if (added.contains(entry._field.getName())) continue;
            added.add(entry._field.getName());
            __staticNameMap.put(entry._field.getName(), entry);
            if (__staticNameMap.get(entry._field.getName()) != null) continue;
            throw new IllegalStateException("name trie too small");
        }
        for (HttpHeader h : HttpHeader.values()) {
            StaticEntry entry = __staticNameMap.get(h.asString());
            if (entry == null) continue;
            HpackContext.__staticTableByHeader[h.ordinal()] = entry;
        }
    }

    public static class StaticEntry
    extends Entry {
        private final byte[] _huffmanValue;
        private final byte _encodedField;

        StaticEntry(int index, HttpField field) {
            super(index, field);
            String value = field.getValue();
            if (value != null && value.length() > 0) {
                int huffmanLen = Huffman.octetsNeeded(value);
                int lenLen = NBitInteger.octectsNeeded(7, huffmanLen);
                this._huffmanValue = new byte[1 + lenLen + huffmanLen];
                ByteBuffer buffer = ByteBuffer.wrap(this._huffmanValue);
                buffer.put((byte)-128);
                NBitInteger.encode(buffer, 7, huffmanLen);
                Huffman.encode(buffer, value);
            } else {
                this._huffmanValue = null;
            }
            this._encodedField = (byte)(0x80 | index);
        }

        @Override
        public boolean isStatic() {
            return true;
        }

        @Override
        public byte[] getStaticHuffmanValue() {
            return this._huffmanValue;
        }

        public byte getEncodedField() {
            return this._encodedField;
        }
    }

    public static class Entry {
        final HttpField _field;
        int _slot;

        Entry() {
            this._slot = 0;
            this._field = null;
        }

        Entry(int index, String name, String value) {
            this._slot = index;
            this._field = new HttpField(name, value);
        }

        Entry(int slot, HttpField field) {
            this._slot = slot;
            this._field = field;
        }

        public int getSize() {
            return 32 + this._field.getName().length() + this._field.getValue().length();
        }

        public HttpField getHttpField() {
            return this._field;
        }

        public boolean isStatic() {
            return false;
        }

        public byte[] getStaticHuffmanValue() {
            return null;
        }

        public int getSlot() {
            return this._slot;
        }

        public String toString() {
            return String.format("{%s,%d,%s,%x}", this.isStatic() ? "S" : "D", this._slot, this._field, this.hashCode());
        }
    }

    private class DynamicTable
    extends ArrayQueue<Entry> {
        private DynamicTable(int initCapacity, int growBy) {
            super(initCapacity, growBy);
        }

        @Override
        protected void resizeUnsafe(int newCapacity) {
            super.resizeUnsafe(newCapacity);
            for (int s = 0; s < this._nextSlot; ++s) {
                ((Entry)this._elements[s])._slot = s;
            }
        }

        @Override
        public boolean enqueue(Entry e) {
            return super.enqueue(e);
        }

        @Override
        public Entry dequeue() {
            return (Entry)super.dequeue();
        }

        private int index(Entry entry) {
            return entry._slot >= this._nextE ? this._size - entry._slot + this._nextE : this._nextSlot - entry._slot;
        }
    }
}

