/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http2.server;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.Executor;
import org.eclipse.jetty.http.BadMessageException;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.MetaData;
import org.eclipse.jetty.http2.HTTP2Connection;
import org.eclipse.jetty.http2.ISession;
import org.eclipse.jetty.http2.IStream;
import org.eclipse.jetty.http2.api.server.ServerSessionListener;
import org.eclipse.jetty.http2.frames.DataFrame;
import org.eclipse.jetty.http2.frames.Frame;
import org.eclipse.jetty.http2.frames.HeadersFrame;
import org.eclipse.jetty.http2.frames.PrefaceFrame;
import org.eclipse.jetty.http2.frames.SettingsFrame;
import org.eclipse.jetty.http2.parser.ServerParser;
import org.eclipse.jetty.http2.parser.SettingsBodyParser;
import org.eclipse.jetty.http2.server.HttpChannelOverHTTP2;
import org.eclipse.jetty.http2.server.HttpTransportOverHTTP2;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.util.B64Code;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.ConcurrentArrayQueue;
import org.eclipse.jetty.util.TypeUtil;

public class HTTP2ServerConnection
extends HTTP2Connection
implements Connection.UpgradeTo {
    private final Queue<HttpChannelOverHTTP2> channels = new ConcurrentArrayQueue<HttpChannelOverHTTP2>();
    private final ServerSessionListener listener;
    private final HttpConfiguration httpConfig;
    private final List<Frame> upgradeFrames = new ArrayList<Frame>();

    public HTTP2ServerConnection(ByteBufferPool byteBufferPool, Executor executor, EndPoint endPoint, HttpConfiguration httpConfig, ServerParser parser, ISession session, int inputBufferSize, ServerSessionListener listener) {
        super(byteBufferPool, executor, endPoint, parser, session, inputBufferSize);
        this.listener = listener;
        this.httpConfig = httpConfig;
    }

    @Override
    protected ServerParser getParser() {
        return (ServerParser)super.getParser();
    }

    @Override
    public void onUpgradeTo(ByteBuffer buffer) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("HTTP2 onUpgradeTo {} {}", this, BufferUtil.toDetailString(buffer));
        }
        this.setInputBuffer(buffer);
    }

    @Override
    public void onOpen() {
        this.notifyAccept(this.getSession());
        for (Frame frame : this.upgradeFrames) {
            this.getSession().onFrame(frame);
        }
        super.onOpen();
    }

    private void notifyAccept(ISession session) {
        try {
            this.listener.onAccept(session);
        }
        catch (Throwable x) {
            LOG.info("Failure while notifying listener " + this.listener, x);
        }
    }

    public void onNewStream(Connector connector, IStream stream, HeadersFrame frame) {
        HttpChannelOverHTTP2 channel;
        Runnable task;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Processing {} on {}", frame, stream);
        }
        if ((task = (channel = this.provideHttpChannel(connector, stream)).onRequest(frame)) != null) {
            this.offerTask(task, false);
        }
    }

    public void onData(IStream stream, DataFrame frame, Callback callback) {
        HttpChannelOverHTTP2 channel;
        Runnable task;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Processing {} on {}", frame, stream);
        }
        if ((task = (channel = (HttpChannelOverHTTP2)stream.getAttribute(IStream.CHANNEL_ATTRIBUTE)).requestContent(frame, callback)) != null) {
            this.offerTask(task, false);
        }
    }

    public void push(Connector connector, IStream stream, MetaData.Request request) {
        HttpChannelOverHTTP2 channel;
        Runnable task;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Processing push {} on {}", request, stream);
        }
        if ((task = (channel = this.provideHttpChannel(connector, stream)).onPushRequest(request)) != null) {
            this.offerTask(task, true);
        }
    }

    private HttpChannelOverHTTP2 provideHttpChannel(Connector connector, IStream stream) {
        HttpChannelOverHTTP2 channel = this.channels.poll();
        if (channel != null) {
            channel.getHttpTransport().setStream(stream);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Recycling channel {} for {}", channel, this);
            }
        } else {
            HttpTransportOverHTTP2 transport = new HttpTransportOverHTTP2(connector, this);
            transport.setStream(stream);
            channel = new ServerHttpChannelOverHTTP2(connector, this.httpConfig, this.getEndPoint(), transport);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Creating channel {} for {}", channel, this);
            }
        }
        stream.setAttribute(IStream.CHANNEL_ATTRIBUTE, channel);
        return channel;
    }

    public boolean upgrade(MetaData.Request request) {
        if (HttpMethod.PRI.is(request.getMethod())) {
            this.getParser().directUpgrade();
        } else {
            SettingsFrame settingsFrame;
            HttpField settingsField = request.getFields().getField(HttpHeader.HTTP2_SETTINGS);
            if (settingsField == null) {
                throw new BadMessageException("Missing " + (Object)((Object)HttpHeader.HTTP2_SETTINGS) + " header");
            }
            String value = settingsField.getValue();
            byte[] settings = B64Code.decodeRFC4648URL(value == null ? "" : value);
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} settings {}", this, TypeUtil.toHexString(settings));
            }
            if ((settingsFrame = SettingsBodyParser.parseBody(BufferUtil.toBuffer(settings))) == null) {
                LOG.warn("Invalid {} header value: {}", new Object[]{HttpHeader.HTTP2_SETTINGS, value});
                throw new BadMessageException();
            }
            this.getParser().standardUpgrade();
            this.upgradeFrames.add(new PrefaceFrame());
            this.upgradeFrames.add(settingsFrame);
            this.upgradeFrames.add(new HeadersFrame(1, request, null, true));
        }
        return true;
    }

    private class ServerHttpChannelOverHTTP2
    extends HttpChannelOverHTTP2 {
        public ServerHttpChannelOverHTTP2(Connector connector, HttpConfiguration configuration, EndPoint endPoint, HttpTransportOverHTTP2 transport) {
            super(connector, configuration, endPoint, transport);
        }

        @Override
        public void onCompleted() {
            super.onCompleted();
            this.recycle();
            HTTP2ServerConnection.this.channels.offer(this);
        }
    }
}

