/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.quickstart;

import java.io.File;
import java.net.URI;
import java.net.URL;
import java.nio.file.Path;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.resource.Resource;

public class AttributeNormalizer {
    private static final Logger LOG = Log.getLogger(AttributeNormalizer.class);
    private final Path _warPath;
    private final Path _jettyBasePath;
    private final Path _jettyHomePath;
    private final Path _userHomePath;
    private final Path _userDirPath;

    public AttributeNormalizer(Resource baseResource) {
        try {
            this._warPath = baseResource == null ? null : baseResource.getFile().toPath();
            this._jettyBasePath = AttributeNormalizer.systemPath("jetty.base");
            this._jettyHomePath = AttributeNormalizer.systemPath("jetty.home");
            this._userHomePath = AttributeNormalizer.systemPath("user.home");
            this._userDirPath = AttributeNormalizer.systemPath("user.dir");
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static Path systemPath(String property) throws Exception {
        String p = System.getProperty(property);
        if (p != null) {
            return new File(p).getAbsoluteFile().getCanonicalFile().toPath();
        }
        return null;
    }

    public String normalize(Object o) {
        try {
            URI uri = null;
            if (o instanceof URI) {
                uri = (URI)o;
            } else if (o instanceof URL) {
                uri = ((URL)o).toURI();
            } else if (o instanceof File) {
                uri = ((File)o).toURI();
            } else {
                String s = o.toString();
                uri = new URI(s);
                if (uri.getScheme() == null) {
                    return s;
                }
            }
            if ("jar".equalsIgnoreCase(uri.getScheme())) {
                String raw = uri.getRawSchemeSpecificPart();
                int bang = raw.indexOf("!/");
                String normal = this.normalize(raw.substring(0, bang));
                String suffix = raw.substring(bang);
                return "jar:" + normal + suffix;
            }
            if ("file".equalsIgnoreCase(uri.getScheme())) {
                return "file:" + this.normalizePath(new File(uri).toPath());
            }
        }
        catch (Exception e) {
            LOG.warn(e);
        }
        return String.valueOf(o);
    }

    public String normalizePath(Path path) {
        if (this._warPath != null && path.startsWith(this._warPath)) {
            return URIUtil.addPaths("${WAR}", this._warPath.relativize(path).toString());
        }
        if (this._jettyBasePath != null && path.startsWith(this._jettyBasePath)) {
            return URIUtil.addPaths("${jetty.base}", this._jettyBasePath.relativize(path).toString());
        }
        if (this._jettyHomePath != null && path.startsWith(this._jettyHomePath)) {
            return URIUtil.addPaths("${jetty.home}", this._jettyHomePath.relativize(path).toString());
        }
        if (this._userHomePath != null && path.startsWith(this._userHomePath)) {
            return URIUtil.addPaths("${user.home}", this._userHomePath.relativize(path).toString());
        }
        if (this._userDirPath != null && path.startsWith(this._userDirPath)) {
            return URIUtil.addPaths("${user.dir}", this._userDirPath.relativize(path).toString());
        }
        return path.toString();
    }

    public String expand(String s) {
        String prop;
        int i = s.indexOf("${");
        if (i < 0) {
            return s;
        }
        int e = s.indexOf(125, i + 3);
        switch (prop = s.substring(i + 2, e)) {
            case "WAR": {
                return s.substring(0, i) + this._warPath + this.expand(s.substring(e + 1));
            }
            case "jetty.base": {
                return s.substring(0, i) + this._jettyBasePath + this.expand(s.substring(e + 1));
            }
            case "jetty.home": {
                return s.substring(0, i) + this._jettyHomePath + this.expand(s.substring(e + 1));
            }
            case "user.home": {
                return s.substring(0, i) + this._userHomePath + this.expand(s.substring(e + 1));
            }
            case "user.dir": {
                return s.substring(0, i) + this._userDirPath + this.expand(s.substring(e + 1));
            }
        }
        return s;
    }
}

