/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.quickstart;

import org.eclipse.jetty.quickstart.QuickStartWebApp;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.resource.JarResource;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.xml.XmlConfiguration;

public class PreconfigureQuickStartWar {
    private static final Logger LOG = Log.getLogger(PreconfigureQuickStartWar.class);
    static final boolean ORIGIN = LOG.isDebugEnabled();

    public static void main(String ... args) throws Exception {
        Resource war = null;
        Resource dir = null;
        Resource xml = null;
        switch (args.length) {
            case 0: {
                PreconfigureQuickStartWar.error("No WAR file or directory given");
                break;
            }
            case 1: {
                dir = Resource.newResource(args[0]);
                break;
            }
            case 2: {
                war = Resource.newResource(args[0]);
                if (war.isDirectory()) {
                    dir = war;
                    war = null;
                    xml = Resource.newResource(args[1]);
                    break;
                }
                dir = Resource.newResource(args[1]);
                break;
            }
            case 3: {
                war = Resource.newResource(args[0]);
                dir = Resource.newResource(args[1]);
                xml = Resource.newResource(args[2]);
                break;
            }
            default: {
                PreconfigureQuickStartWar.error("Too many args");
            }
        }
        PreconfigureQuickStartWar.preconfigure(war, dir, xml);
    }

    public static void preconfigure(Resource war, Resource dir, Resource xml) throws Exception {
        if (war != null) {
            if (war.isDirectory()) {
                PreconfigureQuickStartWar.error("war file is directory");
            }
            if (!dir.exists()) {
                dir.getFile().mkdirs();
            }
            JarResource.newJarResource(war).copyTo(dir.getFile());
        }
        Server server = new Server();
        QuickStartWebApp webapp = new QuickStartWebApp();
        if (xml != null) {
            if (xml.isDirectory() || !xml.toString().toLowerCase().endsWith(".xml")) {
                PreconfigureQuickStartWar.error("Bad context.xml: " + xml);
            }
            XmlConfiguration xmlConfiguration = new XmlConfiguration(xml.getURL());
            xmlConfiguration.configure(webapp);
        }
        webapp.setResourceBase(dir.getFile().getAbsolutePath());
        webapp.setPreconfigure(true);
        server.setHandler(webapp);
        server.start();
        server.stop();
    }

    private static void error(String message) {
        System.err.println("ERROR: " + message);
        System.err.println("Usage: java -jar PreconfigureQuickStartWar.jar <war-directory>");
        System.err.println("       java -jar PreconfigureQuickStartWar.jar <war-directory> <context-xml-file>");
        System.err.println("       java -jar PreconfigureQuickStartWar.jar <war-file> <target-war-directory>");
        System.err.println("       java -jar PreconfigureQuickStartWar.jar <war-file> <target-war-directory> <context-xml-file>");
        System.exit(1);
    }
}

