/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.quickstart;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.jetty.annotations.ServletContainerInitializersStarter;
import org.eclipse.jetty.plus.annotation.ContainerInitializer;
import org.eclipse.jetty.quickstart.AttributeNormalizer;
import org.eclipse.jetty.util.QuotedStringTokenizer;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceCollection;
import org.eclipse.jetty.webapp.Descriptor;
import org.eclipse.jetty.webapp.IterativeDescriptorProcessor;
import org.eclipse.jetty.webapp.WebAppContext;
import org.eclipse.jetty.xml.XmlParser;

public class QuickStartDescriptorProcessor
extends IterativeDescriptorProcessor {
    public QuickStartDescriptorProcessor() {
        try {
            this.registerVisitor("context-param", this.getClass().getMethod("visitContextParam", __signature));
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void start(WebAppContext context, Descriptor descriptor) {
    }

    @Override
    public void end(WebAppContext context, Descriptor descriptor) {
    }

    public void visitContextParam(WebAppContext context, Descriptor descriptor, XmlParser.Node node) throws Exception {
        String name = node.getString("param-name", false, true);
        String value = node.getString("param-value", false, true);
        ArrayList<String> values = new ArrayList<String>();
        switch (name) {
            case "javax.servlet.context.orderedLibs": 
            case "org.eclipse.jetty.containerInitializers": 
            case "org.eclipse.jetty.tlds": 
            case "org.eclipse.jetty.resources": {
                context.removeAttribute(name);
                QuotedStringTokenizer tok = new QuotedStringTokenizer(value, ",");
                while (tok.hasMoreElements()) {
                    values.add(tok.nextToken().trim());
                }
                break;
            }
            default: {
                values.add(value);
            }
        }
        AttributeNormalizer normalizer = new AttributeNormalizer(context.getBaseResource());
        switch (name) {
            case "javax.servlet.context.orderedLibs": {
                ArrayList<String> libs = new ArrayList<String>();
                Object o = context.getAttribute("javax.servlet.context.orderedLibs");
                if (o instanceof Collection) {
                    libs.addAll((Collection)o);
                }
                libs.addAll(values);
                if (libs.size() <= 0) break;
                context.setAttribute("javax.servlet.context.orderedLibs", libs);
                break;
            }
            case "org.eclipse.jetty.containerInitializers": {
                for (String i : values) {
                    this.visitContainerInitializer(context, new ContainerInitializer(Thread.currentThread().getContextClassLoader(), i));
                }
                break;
            }
            case "org.eclipse.jetty.tlds": {
                ArrayList<URL> tlds = new ArrayList<URL>();
                Object o = context.getAttribute("org.eclipse.jetty.tlds");
                if (o instanceof Collection) {
                    tlds.addAll((Collection)o);
                }
                for (String i : values) {
                    Resource r = Resource.newResource(normalizer.expand(i));
                    if (r.exists()) {
                        tlds.add(r.getURI().toURL());
                        continue;
                    }
                    throw new IllegalArgumentException("TLD not found: " + r);
                }
                if (tlds.size() <= 0) break;
                context.setAttribute("org.eclipse.jetty.tlds", tlds);
                break;
            }
            case "org.eclipse.jetty.resources": {
                for (String i : values) {
                    Resource r = Resource.newResource(normalizer.expand(i));
                    if (r.exists()) {
                        this.visitMetaInfResource(context, r);
                        continue;
                    }
                    throw new IllegalArgumentException("Resource not found: " + r);
                }
                break;
            }
        }
    }

    public void visitContainerInitializer(WebAppContext context, ContainerInitializer containerInitializer) {
        if (containerInitializer == null) {
            return;
        }
        ArrayList<ContainerInitializer> containerInitializers = (ArrayList<ContainerInitializer>)context.getAttribute("org.eclipse.jetty.containerInitializers");
        if (containerInitializers == null) {
            containerInitializers = new ArrayList<ContainerInitializer>();
            context.setAttribute("org.eclipse.jetty.containerInitializers", containerInitializers);
        }
        containerInitializers.add(containerInitializer);
        ServletContainerInitializersStarter starter = (ServletContainerInitializersStarter)context.getAttribute("org.eclipse.jetty.containerInitializerStarter");
        if (starter == null) {
            starter = new ServletContainerInitializersStarter(context);
            context.setAttribute("org.eclipse.jetty.containerInitializerStarter", starter);
            context.addBean((Object)starter, true);
        }
    }

    public void visitMetaInfResource(WebAppContext context, Resource dir) {
        HashSet<Resource> metaInfResources = (HashSet<Resource>)context.getAttribute("org.eclipse.jetty.resources");
        if (metaInfResources == null) {
            metaInfResources = new HashSet<Resource>();
            context.setAttribute("org.eclipse.jetty.resources", metaInfResources);
        }
        metaInfResources.add(dir);
        Resource[] collection = new Resource[metaInfResources.size() + 1];
        int i = 0;
        collection[i++] = context.getBaseResource();
        for (Resource resource : metaInfResources) {
            collection[i++] = resource;
        }
        context.setBaseResource(new ResourceCollection(collection));
    }
}

